# バッチ設計書 13-build-go.sh

## 概要

本ドキュメントは、KubernetesプロジェクトにおけるGoバイナリビルドスクリプト（build-go.sh）の設計について記述する。Kubernetesコンポーネントのコンパイルを実行するためのビルドバッチの仕様を定義する。

### 本バッチの処理概要

build-go.shは、Kubernetesプロジェクトの全Goバイナリをコンパイルするためのシェルスクリプトである。現在は`make all`コマンドへのリダイレクトラッパーとして機能する。

**業務上の目的・背景**：Kubernetesプロジェクトの開発・リリースプロセスにおいて、各コンポーネント（kubelet、kube-apiserver等）のGoバイナリをコンパイルする必要がある。本スクリプトは歴史的な互換性のために残されたリダイレクトスクリプトであり、実際のビルドロジックはMakefileに移行されている。開発者が従来のコマンド体系を使用してビルドを実行できるようにするための互換性レイヤーを提供する。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプラインからの呼び出し時に実行される。

**主要な処理内容**：
1. KUBE_ROOTの決定（スクリプトの配置ディレクトリから相対パスで算出）
2. 引数のヘルプメッセージ構築（WHAT引数の解析）
3. `make all`コマンドへの同等性を示すメッセージの出力
4. `make --no-print-directory -C "${KUBE_ROOT}" all WHAT="$*"` の実行

**前後の処理との関連**：本スクリプトはMakefileのallターゲットを呼び出す。ビルド成果物はクロスプラットフォームビルド（No.14 build-cross.sh）やテスト実行（No.15 test-go.sh）の前提条件となる。

**影響範囲**：ビルド成果物（_output/go/bin/配下のバイナリ）、開発者のローカル環境およびCI/CD環境。

## バッチ種別

ビルド処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発者の手動実行またはCI/CD） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | Goツールチェインがインストール済みであること |
| Make | GNU makeが利用可能であること |
| ソースコード | Kubernetesリポジトリがクローン済みであること |

### 実行可否判定

スクリプト冒頭の`set -o errexit/nounset/pipefail`によりエラー時は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| WHAT | 文字列（位置引数） | No | 空文字列（全コンポーネント） | ビルド対象のディレクトリ名。例：cmd/kubelet |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Goソースコード | .goファイル | Kubernetesプロジェクトのソースコード |
| Makefile | Makefile | ビルドルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| _output/go/bin/ | バイナリファイル | コンパイル済みの実行可能ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | コンポーネント名（kubelet、kube-apiserver等） |
| 出力先 | _output/go/bin/ |
| 文字コード | 該当なし（バイナリ） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. KUBE_ROOTの算出
   └─ スクリプト配置ディレクトリの親ディレクトリ
2. 引数処理
   └─ 位置引数があればWHAT変数としてARGHELPに設定
3. リダイレクトメッセージ出力
   └─ "NOTE: $0 has been replaced by 'make' or 'make all'"
4. makeコマンド実行
   └─ make --no-print-directory -C "${KUBE_ROOT}" all WHAT="$*"
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[KUBE_ROOT算出]
    B --> C{引数あり?}
    C -->|Yes| D[ARGHELP設定]
    C -->|No| E[ARGHELP空]
    D --> F[リダイレクトメッセージ出力]
    E --> F
    F --> G[make all WHAT実行]
    G --> H{ビルド成功?}
    H -->|Yes| I[スクリプト終了（正常）]
    H -->|No| J[スクリプト終了（エラー）]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ビルドエラー | Goコンパイルエラー | ソースコードの修正 |
| 1 | 環境エラー | Go/makeが未インストール | 開発環境のセットアップ |
| 2 | 引数エラー | 不正なWHAT指定 | 正しいパッケージパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ビルドエラー発生時はエラーメッセージを確認し、ソースコードまたは環境の問題を修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド実行 |
| 目標処理時間 | 環境依存（数分〜数十分） |
| メモリ使用量上限 | Goコンパイラに依存 |

## 排他制御

同一ディレクトリでの同時ビルドは推奨されない。makeのファイルロック機構に依存。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | スクリプト開始時 | リダイレクトメッセージ（make allへの移行案内） |
| ビルドログ | ビルド中 | Goコンパイラの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド成否 | 終了コード != 0 | CI/CDシステム |

## 備考

- 本スクリプトは「vestigial redirection」（残存リダイレクト）であり、実際のビルドロジックはMakefile（`hack/make-rules/`配下）に移行済み
- 新しいビルドロジックを追加する場合は本スクリプトではなくMakefileに追加すること
- 使用例: `hack/build-go.sh WHAT=cmd/kubelet`
- ソースコード: `hack/build-go.sh`
