# バッチ設計書 14-build-cross.sh

## 概要

本ドキュメントは、Kubernetesプロジェクトにおけるクロスプラットフォームビルドスクリプト（build-cross.sh）の設計について記述する。複数のOS・アーキテクチャ向けにバイナリをビルドするバッチの仕様を定義する。

### 本バッチの処理概要

build-cross.shは、Kubernetesプロジェクトのバイナリを複数のプラットフォーム（OS/アーキテクチャ）向けにクロスコンパイルするためのシェルスクリプトである。現在は`make cross`コマンドへのリダイレクトラッパーとして機能する。

**業務上の目的・背景**：Kubernetesはlinux/amd64、linux/arm64、windows/amd64等の複数プラットフォームで動作する必要がある。リリースプロセスにおいて、全対象プラットフォーム向けのバイナリを一括でビルドする必要があり、本スクリプトはそのクロスコンパイルバッチを提供する。歴史的な互換性のために残されたリダイレクトスクリプトであり、実際のビルドロジックは`hack/make-rules/cross.sh`に移行されている。

**バッチの実行タイミング**：リリースビルド時、またはCI/CDパイプラインでのクロスコンパイル時に実行される。

**主要な処理内容**：
1. KUBE_ROOTの決定（スクリプトの配置ディレクトリから相対パスで算出）
2. `make cross`コマンドへの同等性を示すメッセージの出力
3. `make --no-print-directory -C "${KUBE_ROOT}" cross` の実行

**前後の処理との関連**：build-go.sh（No.13）による単一プラットフォームビルドの延長として、全対象プラットフォーム向けにビルドを拡張する。ビルド成果物はリリースパッケージングやコンテナイメージ構築で使用される。

**影響範囲**：全対象プラットフォーム向けのビルド成果物、リリースアーティファクト。

## バッチ種別

ビルド処理（クロスコンパイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリースビルド時またはCI/CD） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | クロスコンパイル対応のGoツールチェインがインストール済みであること |
| Make | GNU makeが利用可能であること |
| ソースコード | Kubernetesリポジトリがクローン済みであること |

### 実行可否判定

スクリプト冒頭の`set -o errexit/nounset/pipefail`によりエラー時は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトは引数を受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Goソースコード | .goファイル | Kubernetesプロジェクトのソースコード |
| Makefile | Makefile | クロスビルドルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| _output/ | バイナリファイル | 各プラットフォーム向けのコンパイル済みバイナリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | コンポーネント名（プラットフォーム別サブディレクトリ） |
| 出力先 | _output/配下（プラットフォーム別） |
| 文字コード | 該当なし（バイナリ） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. KUBE_ROOTの算出
   └─ スクリプト配置ディレクトリの親ディレクトリ
2. リダイレクトメッセージ出力
   └─ "NOTE: $0 has been replaced by 'make cross'"
3. makeコマンド実行
   └─ make --no-print-directory -C "${KUBE_ROOT}" cross
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[KUBE_ROOT算出]
    B --> C[リダイレクトメッセージ出力]
    C --> D[make cross実行]
    D --> E{ビルド成功?}
    E -->|Yes| F[スクリプト終了（正常）]
    E -->|No| G[スクリプト終了（エラー）]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ビルドエラー | Goクロスコンパイルエラー | ソースコードの修正、ビルド環境の確認 |
| 1 | 環境エラー | Go/makeが未インストール | 開発環境のセットアップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ビルドエラー発生時はエラーメッセージを確認し、ソースコードまたは環境の問題を修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のクロスビルド実行 |
| 目標処理時間 | 環境依存（数十分〜数時間） |
| メモリ使用量上限 | Goコンパイラに依存 |

## 排他制御

同一ディレクトリでの同時ビルドは推奨されない。makeのファイルロック機構に依存。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | スクリプト開始時 | リダイレクトメッセージ（make crossへの移行案内） |
| ビルドログ | ビルド中 | Goコンパイラの出力（プラットフォーム別） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド成否 | 終了コード != 0 | CI/CDシステム |

## 備考

- 本スクリプトは「vestigial redirection」（残存リダイレクト）であり、実際のビルドロジックは`hack/make-rules/cross.sh`に移行済み
- 新しいビルドロジックを追加する場合は本スクリプトではなくMakefileに追加すること
- build-go.sh（No.13）と異なり、WHAT引数による部分ビルドは受け付けない
- ソースコード: `hack/build-cross.sh`
