# バッチ設計書 15-test-go.sh

## 概要

本ドキュメントは、KubernetesプロジェクトにおけるGoユニットテスト実行スクリプト（test-go.sh）の設計について記述する。プロジェクト全体のテストスイートをバッチ実行するための仕様を定義する。

### 本バッチの処理概要

test-go.shは、Kubernetesプロジェクトの全*_test.goファイルを対象としたユニットテストを一括実行するためのシェルスクリプトである。現在は`make test`コマンドへのリダイレクトラッパーとして機能する。

**業務上の目的・背景**：Kubernetesプロジェクトの品質保証において、全Goパッケージのユニットテストを一括実行する仕組みが必要である。開発者がコード変更後にテストを実行して回帰を検出する、またはCI/CDパイプラインでの自動テストに使用される。本スクリプトは歴史的な互換性のために残されたリダイレクトスクリプトであり、実際のテストロジックはMakefileのtestターゲットに移行されている。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプラインからの呼び出し時に実行される。PR提出前の検証として実行されることが多い。

**主要な処理内容**：
1. KUBE_ROOTの決定（スクリプトの配置ディレクトリから相対パスで算出）
2. 引数のヘルプメッセージ構築（WHAT引数の解析）
3. `make test`コマンドへの同等性を示すメッセージの出力
4. `make --no-print-directory -C "${KUBE_ROOT}" test WHAT="$*"` の実行

**前後の処理との関連**：build-go.sh（No.13）によるビルドが成功した状態で実行されることが前提。verify-all.sh（No.16）による静的検証と合わせて品質検証プロセスを構成する。

**影響範囲**：テスト結果の出力、CI/CDパイプラインの成否判定。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発者の手動実行またはCI/CD） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | Goツールチェインがインストール済みであること |
| Make | GNU makeが利用可能であること |
| ソースコード | Kubernetesリポジトリがクローン済みであること |

### 実行可否判定

スクリプト冒頭の`set -o errexit/nounset/pipefail`によりエラー時は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| WHAT | 文字列（位置引数） | No | 空文字列（全パッケージ） | テスト対象のディレクトリ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *_test.goファイル | .goファイル | Goテストファイル |
| Makefile | Makefile | テスト実行ルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行結果（PASS/FAIL） |
| 終了コード | 整数 | 0: 全テスト成功、非0: テスト失敗あり |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

## 処理フロー

### 処理シーケンス

```
1. KUBE_ROOTの算出
   └─ スクリプト配置ディレクトリの親ディレクトリ
2. 引数処理
   └─ 位置引数があればWHAT変数としてARGHELPに設定
3. リダイレクトメッセージ出力
   └─ "NOTE: $0 has been replaced by 'make test'"
4. makeコマンド実行
   └─ make --no-print-directory -C "${KUBE_ROOT}" test WHAT="$*"
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[KUBE_ROOT算出]
    B --> C{引数あり?}
    C -->|Yes| D[ARGHELP設定]
    C -->|No| E[ARGHELP空]
    D --> F[リダイレクトメッセージ出力]
    E --> F
    F --> G[make test WHAT実行]
    G --> H{テスト成功?}
    H -->|Yes| I[スクリプト終了（正常）]
    H -->|No| J[スクリプト終了（エラー）]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | ユニットテストのアサーション失敗 | テスト失敗箇所のコード修正 |
| 1 | コンパイルエラー | テストコードのコンパイル失敗 | ソースコードの修正 |
| 1 | 環境エラー | Go/makeが未インストール | 開発環境のセットアップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

テスト失敗時は失敗したテストケースの出力を確認し、該当するソースコードを修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト全体のテストスイート |
| 目標処理時間 | 環境依存（数分〜数十分） |
| メモリ使用量上限 | Goテストランナーに依存 |

## 排他制御

同一環境での同時テスト実行は推奨されない。テスト間でポート番号等のリソース競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | スクリプト開始時 | リダイレクトメッセージ（make testへの移行案内） |
| テストログ | テスト中 | 各テストケースの実行結果（PASS/FAIL） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト成否 | 終了コード != 0 | CI/CDシステム |

## 備考

- 本スクリプトは「vestigial redirection」（残存リダイレクト）であり、実際のテストロジックはMakefileのtestターゲットに移行済み
- 新しいテストロジックを追加する場合は本スクリプトではなくMakefileに追加すること
- 使用例: `hack/test-go.sh` または `make test`
- ソースコード: `hack/test-go.sh`
