# バッチ設計書 16-verify-all.sh

## 概要

本ドキュメントは、Kubernetesプロジェクトにおける全検証スクリプトの一括実行バッチ（verify-all.sh）の設計について記述する。コードフォーマット・ライセンス・インポート・生成コード等の各種検証をバッチ実行するための仕様を定義する。

### 本バッチの処理概要

verify-all.shは、Kubernetesプロジェクトの各種検証スクリプトを一括実行するためのシェルスクリプトである。現在は`make verify`コマンドへのリダイレクトラッパーとして機能する。

**業務上の目的・背景**：Kubernetesプロジェクトでは、コード品質を維持するために多数の検証スクリプト（gofmt、golint、ライセンスヘッダー確認、生成コードの整合性確認等）が用意されている。PR（Pull Request）提出前にこれらの検証を一括実行することで、コード品質の基準を満たしていることを確認する。本スクリプトは歴史的な互換性のために残されたリダイレクトスクリプトであり、実際の検証ロジックはMakefileのverifyターゲットに移行されている。

**バッチの実行タイミング**：PR提出前の検証として開発者が手動実行、またはCI/CDパイプラインからの自動実行。

**主要な処理内容**：
1. KUBE_ROOTの決定（スクリプトの配置ディレクトリから相対パスで算出）
2. 環境変数KUBE_VERIFY_GIT_BRANCHからBRANCH引数の構築
3. `make verify`コマンドへの同等性を示すメッセージの出力
4. `make --no-print-directory -C "${KUBE_ROOT}" verify BRANCH="${KUBE_VERIFY_GIT_BRANCH:-}"` の実行

**前後の処理との関連**：verify-all.shで検証エラーが検出された場合、update-all.sh（No.17）を実行して自動生成ファイルを更新することでエラーを解消できる場合がある。テスト実行（No.15 test-go.sh）と合わせてPR提出前の品質検証プロセスを構成する。

**影響範囲**：検証結果の出力、CI/CDパイプラインの成否判定。

## バッチ種別

検証処理（静的解析・整合性チェック）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR提出前またはCI/CD） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | Goツールチェインがインストール済みであること |
| Make | GNU makeが利用可能であること |
| ソースコード | Kubernetesリポジトリがクローン済みであること |
| Git | gitコマンドが利用可能であること（BRANCH指定時） |

### 実行可否判定

スクリプト冒頭の`set -o errexit/nounset/pipefail`によりエラー時は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| KUBE_VERIFY_GIT_BRANCH | 環境変数 | No | 空文字列 | 検証対象のGitブランチ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Goソースコード | .goファイル | 検証対象のソースコード |
| 生成ファイル | 各種 | 自動生成コード・設定ファイル |
| Makefile | Makefile | 検証ルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各検証スクリプトの実行結果 |
| 標準エラー出力 | テキスト | 検証エラーの詳細 |
| 終了コード | 整数 | 0: 全検証成功、非0: 検証失敗あり |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

## 処理フロー

### 処理シーケンス

```
1. KUBE_ROOTの算出
   └─ スクリプト配置ディレクトリの親ディレクトリ
2. BRANCH引数の構築
   └─ KUBE_VERIFY_GIT_BRANCHが設定されていればBRANCH変数に反映
3. リダイレクトメッセージ出力
   └─ "NOTE: ${BASH_SOURCE[0]} has been replaced by 'make verify'"
4. makeコマンド実行
   └─ make --no-print-directory -C "${KUBE_ROOT}" verify BRANCH="${KUBE_VERIFY_GIT_BRANCH:-}"
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[KUBE_ROOT算出]
    B --> C{KUBE_VERIFY_GIT_BRANCH設定?}
    C -->|Yes| D[ARGHELP=BRANCH設定]
    C -->|No| E[ARGHELP空]
    D --> F[リダイレクトメッセージ出力]
    E --> F
    F --> G[make verify BRANCH実行]
    G --> H{全検証成功?}
    H -->|Yes| I[スクリプト終了（正常）]
    H -->|No| J[スクリプト終了（エラー）]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検証失敗 | いずれかの検証スクリプトが失敗 | エラーメッセージに従い修正、またはupdate-all.shを実行 |
| 1 | 環境エラー | Go/makeが未インストール | 開発環境のセットアップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

検証失敗時はエラーメッセージを確認し、自動生成ファイルの不整合であればupdate-all.sh（No.17）を実行、コードフォーマットの問題であればgofmtを実行して再検証する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全検証スクリプトの一括実行 |
| 目標処理時間 | 環境依存（数分〜数十分） |
| メモリ使用量上限 | 個々の検証ツールに依存 |

## 排他制御

同一環境での同時実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | スクリプト開始時 | リダイレクトメッセージ（make verifyへの移行案内） |
| 検証ログ | 検証中 | 各検証スクリプトの実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 検証成否 | 終了コード != 0 | CI/CDシステム |

## 備考

- 本スクリプトは「vestigial redirection」（残存リダイレクト）であり、実際の検証ロジックはMakefileのverifyターゲットに移行済み
- PR提出前に`hack/verify-all.sh`を実行し、失敗した場合は`hack/update-all.sh`を実行して修正することが推奨される
- 環境変数KUBE_VERIFY_GIT_BRANCHでブランチを指定し、差分検証を行うことが可能
- ソースコード: `hack/verify-all.sh`
