# バッチ設計書 17-update-all.sh

## 概要

本ドキュメントは、Kubernetesプロジェクトにおける全自動生成ファイルの一括更新スクリプト（update-all.sh）の設計について記述する。コード生成・フォーマット・ベンダー更新等をバッチ実行するための仕様を定義する。

### 本バッチの処理概要

update-all.shは、Kubernetesプロジェクトの全自動生成ファイルを一括更新するためのシェルスクリプトである。現在は`make update`コマンドへのリダイレクトラッパーとして機能する。

**業務上の目的・背景**：Kubernetesプロジェクトでは、APIリソースの型定義変更に伴うdeepcopy関数、conversion関数、defaulter関数、クライアントコード等の自動生成ファイルが多数存在する。これらを手動で更新することは現実的ではないため、一括更新バッチが必要である。verify-all.sh（No.16）で検出された自動生成ファイルの不整合を解消するために使用される。本スクリプトは歴史的な互換性のために残されたリダイレクトスクリプトであり、実際の更新ロジックは`hack/make-rules/update.sh`に移行されている。

**バッチの実行タイミング**：verify-all.sh実行後にエラーが検出された場合、またはAPI型定義変更後に手動で実行される。

**主要な処理内容**：
1. KUBE_ROOTの決定（スクリプトの配置ディレクトリから相対パスで算出）
2. `make update`コマンドへの同等性を示すメッセージの出力
3. `make --no-print-directory -C "${KUBE_ROOT}" update` の実行

**前後の処理との関連**：verify-all.sh（No.16）で検出された問題を修正するために実行される。update-codegen.sh（No.18）、update-generated-docs.sh（No.19）、update-openapi-spec.sh（No.20）等の個別更新スクリプトを内包する上位バッチである。

**影響範囲**：プロジェクト内の全自動生成ファイル（zz_generated.*.go、生成ドキュメント、vendor等）。

## バッチ種別

一括更新処理（コード生成・フォーマット）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（API変更後またはverify失敗後） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | Goツールチェインがインストール済みであること |
| Make | GNU makeが利用可能であること |
| ソースコード | Kubernetesリポジトリがクローン済みであること |

### 実行可否判定

スクリプト冒頭の`set -o errexit/nounset/pipefail`によりエラー時は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトは引数を受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Goソースコード | .goファイル | 型定義等のソースコード |
| Makefile | Makefile | 更新ルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 各種生成ファイル | .goファイル等 | 自動生成されたコード・設定ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | zz_generated.*.go等（生成ツール依存） |
| 出力先 | プロジェクト内各ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. KUBE_ROOTの算出
   └─ スクリプト配置ディレクトリの親ディレクトリ
2. リダイレクトメッセージ出力
   └─ "NOTE: ${BASH_SOURCE[0]} has been replaced by 'make update'"
3. makeコマンド実行
   └─ make --no-print-directory -C "${KUBE_ROOT}" update
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[KUBE_ROOT算出]
    B --> C[リダイレクトメッセージ出力]
    C --> D[make update実行]
    D --> E{更新成功?}
    E -->|Yes| F[スクリプト終了（正常）]
    E -->|No| G[スクリプト終了（エラー）]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 生成エラー | コード生成ツールの実行失敗 | エラーメッセージを確認し、ソースコードまたは環境を修正 |
| 1 | 環境エラー | Go/makeが未インストール | 開発環境のセットアップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

エラー発生時はエラーメッセージを確認し、個別の更新スクリプト（update-codegen.sh等）を直接実行して問題を特定する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル書き換え） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（git resetで復元可能） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全自動生成ファイルの一括更新 |
| 目標処理時間 | 環境依存（数十分〜1時間以上） |
| メモリ使用量上限 | 各生成ツールに依存 |

## 排他制御

同一環境での同時実行は推奨されない。生成ファイルの競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | スクリプト開始時 | リダイレクトメッセージ（make updateへの移行案内） |
| 生成ログ | 生成中 | 各生成ツールの実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 更新成否 | 終了コード != 0 | CI/CDシステム |

## 備考

- 本スクリプトは「vestigial redirection」（残存リダイレクト）であり、実際の更新ロジックは`hack/make-rules/update.sh`に移行済み
- verify-all.sh（No.16）で失敗した場合にupdate-all.shを実行して自動生成ファイルを更新することが推奨される
- 引数を受け付けないため、全更新処理が一括実行される
- ソースコード: `hack/update-all.sh`
