# バッチ設計書 19-update-generated-docs.sh

## 概要

本ドキュメントは、KubernetesプロジェクトにおけるAPI・CLIドキュメントの自動生成スクリプト（update-generated-docs.sh）の設計について記述する。各Kubernetesコンポーネントのドキュメント（ユーザーガイド、管理者ドキュメント、manページ、YAML参照）を自動生成するバッチの仕様を定義する。

### 本バッチの処理概要

update-generated-docs.shは、KubernetesのAPI・CLIドキュメントを自動生成するシェルスクリプトである。専用のドキュメント生成ツール（gendocs、genkubedocs、genman、genyaml）をビルド・実行し、各コンポーネントのドキュメントを一時ディレクトリに生成した後、リポジトリにコピーする。

**業務上の目的・背景**：Kubernetesプロジェクトでは、kubectlコマンドのユーザーガイド、各コンポーネント（kube-apiserver、kube-controller-manager、kube-proxy、kube-scheduler、kubelet、kubeadm）の管理者向けドキュメント、manページ、YAML参照を自動生成する必要がある。コード変更に伴うドキュメントの不整合を防ぎ、常に最新のコマンドラインオプション等が反映されたドキュメントを提供する。

**バッチの実行タイミング**：ドキュメントのエクスポート直前に手動実行される。自動チェックインは意図されていない。

**主要な処理内容**：
1. Go環境のセットアップと一時ディレクトリの作成
2. ドキュメント生成ツール（gendocs、genkubedocs、genman、genyaml）のビルド
3. kubectlユーザーガイドの生成（gendocs）
4. 各コンポーネントの管理者ドキュメント生成（genkubedocs）
5. 各コンポーネントのmanページ生成（genman）
6. kubectl YAML参照の生成（genyaml）
7. 生成ファイル一覧の作成（docs/.generated_docs）
8. 既存の生成済みドキュメントの削除
9. 新規生成ドキュメントのリポジトリへのコピー

**前後の処理との関連**：update-codegen.sh（No.18）によるコード生成が完了した状態で実行されることが望ましい。update-all.sh（No.17）から呼び出される可能性がある。

**影響範囲**：docs/配下のユーザーガイド、管理者ドキュメント、manページ、YAML参照ファイル。

## バッチ種別

ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメントエクスポート前） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | Goツールチェインがインストール済みであること |
| ソースコード | Kubernetesリポジトリがクローン済みであること |

### 実行可否判定

スクリプト冒頭の`set -o errexit/nounset/pipefail`によりエラー時は即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトは引数を受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| cmd/gendocs | Goソースコード | kubectlドキュメント生成ツール |
| cmd/genkubedocs | Goソースコード | コンポーネントドキュメント生成ツール |
| cmd/genman | Goソースコード | manページ生成ツール |
| cmd/genyaml | Goソースコード | YAML参照生成ツール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/user-guide/kubectl/ | Markdownファイル | kubectlユーザーガイド |
| docs/admin/ | Markdownファイル | 各コンポーネント管理者ドキュメント |
| docs/man/man1/ | manページ | 各コンポーネントのmanページ |
| docs/yaml/kubectl/ | YAMLファイル | kubectl YAML参照 |
| docs/.generated_docs | テキスト | 生成ファイル一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | コンポーネント名に基づく（例: kube-apiserver.md） |
| 出力先 | docs/配下の各サブディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境セットアップ
   ├─ kube::golang::setup_env でGo環境初期化
   └─ kube::util::ensure-temp-dir で一時ディレクトリ作成
2. ドキュメント生成ツールのビルド
   └─ GOPROXY=off go install gendocs/genkubedocs/genman/genyaml
3. 一時ディレクトリにドキュメント生成（generate_docs関数）
   ├─ docs/user-guide/kubectl/ にkubectlドキュメント
   ├─ docs/admin/ にコンポーネントドキュメント（6コンポーネント）
   ├─ docs/man/man1/ にmanページ（7コンポーネント）
   ├─ docs/yaml/kubectl/ にYAML参照
   └─ docs/.generated_docs に生成ファイル一覧
4. 既存の生成済みドキュメント削除（remove_generated_docs関数）
   └─ docs/.generated_docsに記載されたファイルを全削除
5. 新規生成ドキュメントのコピー
   └─ 一時ディレクトリからKUBE_ROOTへコピー（dotglobで隠しファイルも含む）
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[Go環境セットアップ]
    B --> C[一時ディレクトリ作成]
    C --> D[生成ツールのビルド]
    D --> E[一時ディレクトリにドキュメント生成]
    E --> F[既存生成ドキュメント削除]
    F --> G[新規ドキュメントをリポジトリにコピー]
    G --> H[スクリプト終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ツールビルドエラー | gendocs等のコンパイル失敗 | Go環境の確認 |
| 1 | 生成エラー | ドキュメント生成実行時のエラー | コンポーネントのソースコード確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

エラー発生時はエラーメッセージを確認し、該当するドキュメント生成ツールの問題を特定して修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 一時ディレクトリでの生成→既存削除→コピーの一連の流れ |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（git resetで復元可能） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全コンポーネントのドキュメント生成 |
| 目標処理時間 | 環境依存（数分） |
| メモリ使用量上限 | 生成ツールに依存 |

## 排他制御

同一環境での同時実行は推奨されない。docs/配下のファイル書き換えで競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 生成ログ | 各ツール実行時 | 各生成ツールの実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 生成成否 | 終了コード != 0 | CI/CDシステム |

## 備考

- スクリプトコメントに「自動実行を意図しない」旨が記載されており、ドキュメントエクスポート直前に手動実行することが想定されている
- 生成対象コンポーネント一覧:
  - genkubedocs: kube-apiserver, kube-controller-manager, kube-proxy, kube-scheduler, kubelet, kubeadm
  - genman: 上記6コンポーネント + kubectl
- shopt -s dotglob でdocs/.generated_docsを含む隠しファイルもコピー対象とする
- 一時ディレクトリで生成→既存削除→コピーの戦略により、生成失敗時にも既存ドキュメントが保持される
- ソースコード: `hack/update-generated-docs.sh`
