# バッチ設計書 22-ginkgo-e2e.sh

## 概要

本ドキュメントは、Kubernetesプロジェクトにおけるginkgo-e2e.sh（Ginkgoフレームワークを使用したE2Eテスト実行スクリプト）のバッチ設計書である。Kubernetesクラスタに対する統合テストをバッチ実行する仕様を定義する。

### 本バッチの処理概要

本バッチは、Ginkgoテストフレームワークを使用してKubernetesクラスタのEnd-to-End（E2E）テストを一括実行するスクリプトである。

**業務上の目的・背景**：Kubernetesの品質保証において、クラスタ全体の統合動作を検証するE2Eテストは不可欠である。コンポーネント間の連携、API仕様への適合性、マルチクラウドプロバイダー対応を含む幅広いテストシナリオを自動化し、リグレッションの早期検出と品質の継続的な保証を行う。CI/CD環境（Prow等）での自動実行や、Kubernetes適合性テスト（Conformance Test）の実行基盤として使用される。

**バッチの実行タイミング**：随時実行。PR提出時のCIパイプライン、定期的なナイトリービルド、リリース前の適合性テスト実行時、または開発者による手動テスト実行時に使用される。

**主要な処理内容**：
1. Ginkgoバイナリとe2e.testバイナリの検出
2. 環境変数に基づくテスト設定の構成（並列実行、カラー出力、タイムアウト等）
3. クラウドプロバイダー固有のセットアップ（GCE/GKE/Azure対応）
4. kubeconfig/マスターURL/認証情報の検出と設定
5. Ginkgo CLIまたはデバッグツール（delve/gdb）によるe2e.testバイナリの実行
6. テスト結果のレポート生成（JUnit XML, Ginkgo JSON）
7. SIGTERMシグナルハンドリングによるグレースフルシャットダウン

**前後の処理との関連**：前提として、e2e.testバイナリとginkgoバイナリがビルド済みであること（`make WHAT=test/e2e/e2e.test`）。テスト対象のKubernetesクラスタが稼働中であること。後続処理としてテスト結果の収集・報告（CI/CDパイプラインによる）がある。

**影響範囲**：テスト対象のKubernetesクラスタ上のリソース（テスト中に作成・削除されるPod、Service等）。テスト結果レポートの出力先ディレクトリ。

## バッチ種別

E2Eテスト実行 / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意（CI環境では自動トリガー） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン（Prow等） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ginkgoバイナリ | リリースビルドの一部としてビルドされたginkgoバイナリが存在すること |
| e2e.testバイナリ | e2e.testバイナリがビルド済みであること（デバッグ利用時はDBG=1でビルド） |
| Kubernetesクラスタ | テスト対象のクラスタが稼働中であること |
| kubeconfig | クラスタへのアクセス用kubeconfigが設定されていること |
| クラウドプロバイダー設定 | KUBERNETES_PROVIDERが適切に設定されていること（GCE/GKE/Azure等） |

### 実行可否判定

- 適合性テスト（KUBERNETES_CONFORMANCE_TEST設定時）の場合は、kubeconfigからマスターURLを検出し、クラスタ固有のセットアップをスキップする。
- Azureプロバイダーの場合、CLOUD_CONFIGが設定されていなければエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GINKGO_PARALLEL | 環境変数 | No | `n` | `y`設定で並列実行を有効化 |
| GINKGO_PARALLEL_NODES | 環境変数 | No | 25（race検出時10） | 並列実行ノード数 |
| GINKGO_TIMEOUT | 環境変数 | No | `24h` | テストタイムアウト |
| GINKGO_NO_COLOR | 環境変数 | No | 端末接続時`n`、非接続時`y` | カラー出力の無効化 |
| GINKGO_SILENCE_SKIPS | 環境変数 | No | `y` | スキップテストの非表示 |
| GINKGO_FORCE_NEWLINES | 環境変数 | No | CI時`y`、非CI時`n` | 各テストマーカー後の改行 |
| GINKGO_POLL_PROGRESS_AFTER | 環境変数 | No | `60m` | 進捗レポート開始までの時間 |
| GINKGO_POLL_PROGRESS_INTERVAL | 環境変数 | No | `5m` | 進捗レポートの間隔 |
| GINKGO_UNTIL_IT_FAILS | 環境変数 | No | 未設定 | `true`設定で失敗するまで繰り返し実行 |
| CONFORMANCE_TEST_SKIP_REGEX | 環境変数 | No | 未設定 | スキップするテストの正規表現パターン |
| E2E_TEST_DEBUG_TOOL | 環境変数 | No | 未設定 | デバッグツール（`delve`または`gdb`） |
| KUBERNETES_PROVIDER | 環境変数 | No | 環境依存 | クラウドプロバイダー種別 |
| KUBERNETES_CONFORMANCE_TEST | 環境変数 | No | 未設定 | 適合性テストモード有効化 |
| E2E_REPORT_DIR | 環境変数 | No | 未設定 | テスト結果レポート出力ディレクトリ |
| E2E_REPORT_PREFIX | 環境変数 | No | 未設定 | テスト結果レポートファイル名プレフィックス |
| NUM_NODES | 環境変数 | No | 未設定 | クラスタのノード数 |
| CLOUD_CONFIG | 環境変数 | No | `""` | クラウド設定ファイルパス（Azure必須） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| kubeconfig | YAML | Kubernetesクラスタ接続設定 |
| e2e.test | バイナリ | コンパイル済みE2Eテストスイート |
| ginkgo | バイナリ | Ginkgoテストランナー |
| cluster/common.sh | シェルスクリプト | 共通クラスタユーティリティ |
| cluster/kube-util.sh | シェルスクリプト | クラウドプロバイダー固有ユーティリティ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト実行ログ・結果サマリー |
| ${E2E_REPORT_DIR}/ginkgo/ | JSON/XML | Ginkgo形式テスト結果（--report-complete-ginkgo/--report-complete-junit） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Ginkgoフレームワークの命名規則に準拠 |
| 出力先 | `${E2E_REPORT_DIR}`配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（JSON/XML形式） |

## 処理フロー

### 処理シーケンス

```
1. バイナリ検出
   └─ ginkgo, e2e.testバイナリの検索（kube::util::find-binary）
2. 環境変数設定
   └─ GINKGO_PARALLEL, GINKGO_NO_COLOR等のデフォルト値適用
3. クラウドプロバイダーセットアップ
   ├─ 適合性テスト: kubeconfigからマスター検出
   └─ 通常テスト: prepare-e2e, detect-master実行
4. ノードインスタンスグループ設定
   └─ GCE: MIG検出、GKE: detect-node-instance-groups
5. Ginkgoオプション構築
   └─ タイムアウト、並列ノード数、スキップパターン等
6. 実行プログラム選択
   ├─ ginkgo（デフォルト）
   ├─ delve（デバッグ）
   └─ gdb（デバッグ）
7. シグナルハンドラ設定
   └─ SIGTERM/SIGINTのキャッチとGinkgoプロセスへの転送
8. テスト実行
   └─ e2e.testバイナリの実行（バックグラウンドプロセス）
9. 結果待機
   └─ Ginkgo CLIプロセスのwait
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ginkgo/e2e.testバイナリ検出]
    B --> C{適合性テスト?}
    C -->|Yes| D[kubeconfigからマスター検出]
    C -->|No| E[クラウドプロバイダーセットアップ]
    D --> F[Ginkgoオプション構築]
    E --> F
    F --> G{Azure?}
    G -->|Yes, CLOUD_CONFIG未設定| ERR[エラー終了]
    G -->|No/設定済| H[実行プログラム選択]
    H --> I[シグナルハンドラ設定]
    I --> J[e2e.testバイナリ実行]
    J --> K[プロセス完了待機]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接操作しない。テスト対象のKubernetesクラスタのetcdに対して、テストケースの実行に伴うリソース作成・削除が間接的に発生する。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| E2Eテスト実行 | Kubernetes API（etcd） | CREATE/DELETE | テストケースによるリソースの作成・削除 |

### テーブル別操作詳細

該当なし（データベース直接操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 設定エラー | Azure環境でCLOUD_CONFIGが未設定 | CLOUD_CONFIG環境変数を設定 |
| exit 1 | バイナリ不在 | ginkgoまたはe2e.testバイナリが見つからない | `make WHAT=test/e2e/e2e.test`でビルド |
| exit 1 | デバッグツールエラー | サポートされていないE2E_TEST_DEBUG_TOOLの値 | `delve`または`gdb`を指定 |
| 非0 | テスト失敗 | E2Eテストケースの失敗 | テスト結果レポートを確認し原因を特定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（GINKGO_UNTIL_IT_FAILS=true時は失敗まで繰り返し） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

テスト失敗時はE2E_REPORT_DIR配下のレポートファイル（JUnit XML, Ginkgo JSON）を確認する。SIGTERMによるタイムアウト時は、最後の進捗レポートに中断されたテストの実行時間が記録される。Ginkgo CLIプロセスへのシグナル転送により、テスト結果が可能な限り収集される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（テスト実行バッチ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千テストケース（Kubernetes E2Eテストスイート全体） |
| 目標処理時間 | 最大24時間（GINKGO_TIMEOUTデフォルト値） |
| メモリ使用量上限 | 並列実行時はノード数に比例（race検出時は10ノードに制限） |

## 排他制御

本スクリプトは同一Kubernetesクラスタに対して複数同時実行が可能だが、テストケース間のリソース競合が発生する可能性がある。Ginkgo CLIプロセスはジョブコントロール（`set -m`）により独自のプロセスグループで実行され、シグナルがプロセスグループ全体に配信される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | セットアップ時 | プロバイダー情報、設定パラメータ |
| 進捗ログ | テスト実行中 | Ginkgoの進捗レポート（GINKGO_POLL_PROGRESS_INTERVAL間隔） |
| 終了ログ | テスト完了時 | テスト結果サマリー |
| エラーログ | エラー/タイムアウト時 | シグナル受信メッセージ、中断されたテスト情報 |
| コマンドトレース | CI環境（GINKGO_SHOW_COMMAND=true） | 実行コマンドの詳細（`set -x`） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト実行時間 | 24時間（GINKGO_TIMEOUT） | CI/CDパイプライン |
| テスト失敗数 | 1件以上 | CI/CDパイプラインのテスト結果通知 |
| プロセスタイムアウト | Prowジョブタイムアウト | ProwダッシュボードSIGTERMハンドリング |

## 備考

- Ginkgo V2ではデフォルトタイムアウトが24hから1hに短縮されたため、本スクリプトでは後方互換性のため明示的に`--timeout=24h`を設定している。
- デバッグツール（delve/gdb）使用時は、e2e.testバイナリを`make DBG=1 WHAT=test/e2e/e2e.test`でビルドする必要がある。
- SIGTERMハンドリングはCI環境（CI=true時）でデフォルト有効となり、Prowのタイムアウト時にも最終進捗レポートが出力される。
- `--report-complete-ginkgo`と`--report-complete-junit`により、テスト結果の完全なダンプがE2E_REPORT_DIR/ginkgo/に生成される。
