# バッチ設計書 23-e2e-node-test.sh

## 概要

本ドキュメントは、Kubernetesプロジェクトにおけるe2e-node-test.sh（ノードレベルE2Eテスト実行スクリプト）のバッチ設計書である。kubelet等のノードコンポーネントの統合テストをバッチ実行する仕様を定義する。

### 本バッチの処理概要

本バッチは、Kubernetesのノードレベルコンポーネント（kubelet等）に対するEnd-to-End（E2E）テストを実行するスクリプトである。ローカル実行とリモート実行（GCE/SSH）の両方をサポートする。

**業務上の目的・背景**：Kubernetesのノードコンポーネント（特にkubelet）は、Pod管理・コンテナランタイム連携・リソース管理等の核心機能を担っている。これらのコンポーネントの品質保証には、実際のノード上での統合テストが必要である。本バッチは、ローカルマシン上での開発時テスト、GCEインスタンス上でのリモートテスト、SSH接続によるリモートテストの3モードを提供し、ノードコンポーネントの品質を継続的に検証する。なお、本スクリプトは`hack/e2e-node-test.sh`としてはリダイレクトスクリプトであり、実際の処理は`make test-e2e-node`（`hack/make-rules/test-e2e-node.sh`）に委譲される。

**バッチの実行タイミング**：随時実行（手動/CI）。ノードコンポーネントの変更時、PR提出時のCI検証、または定期的なリグレッションテストとして実行される。

**主要な処理内容**：
1. テストパラメータの環境変数からの読み取りとデフォルト値の適用
2. Ginkgoテストフラグの構成（並列度、フォーカス/スキップパターン、ラベルフィルタ等）
3. アーティファクトディレクトリの作成
4. コンテナランタイムエンドポイントの設定
5. 実行モードに応じたテスト実行
   - ローカル: `test/e2e_node/runner/local/run_local.go`の実行
   - リモート（GCE）: GCEインスタンスの検出/作成と`test/e2e_node/runner/remote/run_remote.go`の実行
   - リモート（SSH）: SSH接続による`run_remote.go`の実行
6. テスト結果のアーティファクトディレクトリへの出力

**前後の処理との関連**：`hack/e2e-node-test.sh`は`make test-e2e-node`へのリダイレクトスクリプトである。実質的な処理は`hack/make-rules/test-e2e-node.sh`が担当する。前提としてGoビルド環境が整備されていること。GCEリモート実行時は`gcloud`CLIが設定済みであること。

**影響範囲**：テスト実行対象のノード上のkubelet、コンテナランタイム。GCEリモート実行時はGCEインスタンスの作成・削除。テストアーティファクト出力先ディレクトリ。

## バッチ種別

E2Eテスト実行 / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意（CI環境では自動トリガー） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Go環境 | Goランタイムがインストールされ、PATHに含まれていること |
| make | Makeが利用可能であること（e2e-node-test.shからmake呼び出し） |
| sudo | ローカル実行時はsudo権限が必要（GCE/AWS以外の環境） |
| gcloud | リモートGCE実行時はgcloud CLIが設定済みであること |
| コンテナランタイム | containerdが稼働していること（デフォルト: `unix:///run/containerd/containerd.sock`） |

### 実行可否判定

- リモートGCE実行時: GCEゾーン・プロジェクトの取得に失敗した場合はエラー終了する。
- リモートGCE実行時にHOSTS/IMAGES/IMAGE_CONFIG_FILEのいずれも未設定の場合、cos-betaイメージが自動選択される。
- デバッグツール使用時はREMOTE=falseのみサポート（REMOTE=trueでデバッグツール指定時はエラー終了）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| FOCUS | 環境変数 | No | `""` | テストフォーカスの正規表現パターン |
| SKIP | 環境変数 | No | `\[Flaky\]\|\[Slow\]\|\[Serial\]` | テストスキップの正規表現パターン（LABEL_FILTER設定時は空） |
| LABEL_FILTER | 環境変数 | No | `""` | Ginkgoラベルフィルタ |
| PARALLELISM | 環境変数 | No | `8` | 並列実行数 |
| REMOTE | 環境変数 | No | `false` | リモート実行フラグ |
| REMOTE_MODE | 環境変数 | No | `gce` | リモート実行モード（`gce`/`ssh`） |
| CONTAINER_RUNTIME_ENDPOINT | 環境変数 | No | `unix:///run/containerd/containerd.sock` | コンテナランタイムエンドポイント |
| IMAGE_SERVICE_ENDPOINT | 環境変数 | No | `""` | イメージサービスエンドポイント |
| ARTIFACTS | 環境変数 | No | `/tmp/_artifacts/$(date +%y%m%dT%H%M%S)` | テストアーティファクト出力先 |
| RUN_UNTIL_FAILURE | 環境変数 | No | `false` | 失敗まで繰り返し実行 |
| TEST_ARGS | 環境変数 | No | `""` | 追加テスト引数 |
| PREPULL_IMAGES | 環境変数 | No | `false` | イメージプリプル有効化 |
| SSH_USER | 環境変数 | No | `${USER}` | SSH接続ユーザー |
| SSH_KEY | 環境変数 | No | `""` | SSH秘密鍵パス |
| SSH_OPTIONS | 環境変数 | No | `""` | SSH追加オプション |
| KUBELET_CONFIG_FILE | 環境変数 | No | `test/e2e_node/jenkins/default-kubelet-config.yaml` | kubelet設定ファイル |
| E2E_TEST_DEBUG_TOOL | 環境変数 | No | `""` | デバッグツール（delve/gdb、ローカルのみ） |
| IMAGES | 環境変数 | No | `""` | GCEイメージ名（リモートGCE） |
| HOSTS | 環境変数 | No | `""` | 既存ホスト名（リモートGCE） |
| IMAGE_PROJECT | 環境変数 | No | `cos-cloud` | GCEイメージプロジェクト |
| ZONE | 環境変数 | No | gcloud設定値 | GCEゾーン |
| INSTANCE_PREFIX | 環境変数 | No | `test` | GCEインスタンス名プレフィックス |
| CLEANUP | 環境変数 | No | `true` | テスト後のクリーンアップ有効化 |
| DELETE_INSTANCES | 環境変数 | No | `false` | テスト後のインスタンス削除 |
| TIMEOUT | 環境変数 | No | 未設定 | テストタイムアウト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/e2e_node/runner/remote/run_remote.go | Goソース | リモートテストランナー |
| test/e2e_node/runner/local/run_local.go | Goソース | ローカルテストランナー |
| test/e2e_node/jenkins/default-kubelet-config.yaml | YAML | デフォルトkubelet設定 |
| test/e2e_node/jenkins/gci-init.yaml | YAML | GCIインスタンス初期化設定（リモートGCE） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${ARTIFACTS}/ | 各種 | テストアーティファクト（ログ、junit.xml等） |
| ${ARTIFACTS}/build-log.txt | テキスト | ビルド・テスト実行ログ（tee出力） |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | build-log.txt, junit.xml等 |
| 出力先 | `${ARTIFACTS}`ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境セットアップ（hack/e2e-node-test.sh）
   └─ make test-e2e-nodeへのリダイレクト
2. Go環境セットアップ（hack/make-rules/test-e2e-node.sh）
   └─ kube::golang::setup_env、環境変数の読み取り
3. Ginkgoフラグ構成
   └─ タイムアウト(24h)、並列度、フォーカス/スキップパターン、ラベルフィルタ
4. アーティファクトディレクトリ作成
   └─ ${ARTIFACTS}ディレクトリの作成
5. テスト引数構成
   └─ コンテナランタイム、イメージサービス、DNS等の設定
6. 実行モード分岐
   ├─ リモートGCE: GCEインスタンス検出/作成→run_remote.go実行
   ├─ リモートSSH: run_remote.go（SSHモード）実行
   └─ ローカル: sudo認証確認→run_local.go実行
7. テスト結果出力
   └─ ビルドログのtee出力、アーティファクト保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[make test-e2e-node呼び出し]
    B --> C[Go環境セットアップ]
    C --> D[Ginkgoフラグ構成]
    D --> E[アーティファクトディレクトリ作成]
    E --> F{実行モード判定}
    F -->|REMOTE=true, MODE=gce| G[GCEゾーン・プロジェクト取得]
    F -->|REMOTE=true, MODE=ssh| H[SSH接続設定]
    F -->|REMOTE=false| I[sudo認証確認]
    G --> G1{ゾーン取得成功?}
    G1 -->|No| ERR1[エラー終了]
    G1 -->|Yes| G2[GCEインスタンス検出/再利用]
    G2 --> G3[run_remote.go実行]
    H --> H1[run_remote.go SSHモード実行]
    I --> I1[run_local.go実行]
    G3 --> J[テスト結果出力]
    H1 --> J
    I1 --> J
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接操作しない。テスト実行時にノード上のkubeletを介してローカルのリソース操作が発生する。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| ノードE2Eテスト | ノードローカルリソース | CREATE/DELETE | テストケースによるPod等のリソース操作 |

### テーブル別操作詳細

該当なし（データベース直接操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 設定エラー | REMOTE=true時にデバッグツールを指定 | REMOTE=falseで実行するか、デバッグツール指定を解除 |
| exit 1 | GCE設定エラー | gcloud compute/zoneが取得できない | `gcloud config set compute/zone`で設定 |
| exit 1 | GCE設定エラー | gcloudプロジェクトが取得できない | `gcloud config set project`で設定 |
| exit 1 | sudo認証エラー | ローカル実行でsudo認証に失敗 | sudo権限を確保して再実行 |
| 非0 | テスト失敗 | ノードE2Eテストケースの失敗 | アーティファクトディレクトリのログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（RUN_UNTIL_FAILURE=true時は失敗まで繰り返し） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

テスト失敗時は`${ARTIFACTS}/build-log.txt`および`${ARTIFACTS}`ディレクトリ内のテストアーティファクトを確認する。GCEリモート実行時にCLEANUP=trueが設定されている場合、テストインスタンスは自動的にクリーンアップされる。DELETE_INSTANCES=trueの場合はインスタンスも削除される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（テスト実行バッチ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ノードコンポーネント関連テストケース（数百件） |
| 目標処理時間 | 24時間以内（Ginkgoタイムアウト） |
| メモリ使用量上限 | 並列度8（デフォルト）に応じたリソース使用量 |

## 排他制御

ローカル実行時は同一ノード上で1つのみ実行可能（kubeletの排他制御の制約）。リモートGCE実行時は、既存インスタンスの検出・再利用メカニズムにより、同一プレフィックス・イメージの重複作成を防止する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | リモートGCE実行時 | プロジェクト、イメージプロジェクト、ゾーン、イメージ/ホスト、テスト引数、Ginkgoフラグ等の設定情報 |
| 進捗ログ | テスト実行中 | Ginkgoフレームワークの進捗出力 |
| ビルドログ | 全処理 | `${ARTIFACTS}/build-log.txt`への`tee`出力 |
| エラーログ | エラー発生時 | 設定エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト実行時間 | TIMEOUT設定値またはGinkgoタイムアウト | CI/CDパイプライン |
| テスト失敗数 | 1件以上 | CI/CDパイプラインのテスト結果通知 |
| GCEインスタンス残存 | CLEANUP/DELETE_INSTANCES設定に依存 | GCPコンソール/コスト監視 |

## 備考

- `hack/e2e-node-test.sh`は`make test-e2e-node`へのリダイレクトスクリプトであり、実質的な処理は`hack/make-rules/test-e2e-node.sh`に記述されている。
- デフォルトのSKIPパターン（`\[Flaky\]\|\[Slow\]\|\[Serial\]`）は、LABEL_FILTERが設定された場合は無効になる。
- GCEリモート実行時、指定イメージに対応するインスタンスが既に存在する場合は再利用され、新規インスタンスの作成は行われない。
- ローカル実行時、GCE/AWS環境ではsudo認証のプロンプトがスキップされる（メタデータサーバーへのping応答で判定）。
- コンテナランタイムのデフォルトはcontainerd（`unix:///run/containerd/containerd.sock`）である。
