---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Job Registry（Storage）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/registry/batch/job/storage/storage.go` - JobStorage構造体、NewStorage/NewREST関数
- E-02: `pkg/registry/batch/job/strategy.go` - job.Strategy、job.StatusStrategy
- E-03: `pkg/registry/batch/cronjob/storage/storage.go` - 比較参照用CronJobストレージ
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobStorage構造体はJobとStatusの2つのRESTストレージを持つ | E-01 (L38-41) | ○ |
| C-02 | NewStorageはNewRESTを呼び出してJobStorage構造体を生成する | E-01 (L44-54) | ○ |
| C-03 | REST構造体はgenericregistry.Storeを埋め込む | E-01 (L60-62) | ○ |
| C-04 | NewRESTはetcdバックエンドのRESTStorage/StatusRESTを返す | E-01 (L65-90) | ○ |
| C-05 | Storeの設定にjob.Strategy（Create/Update/Delete/ResetFields）を使用 | E-01 (L73-76) | ○ |
| C-06 | Delete時にPropagationPolicy未指定の場合に警告メッセージを出力 | E-01 (L56-57, L100-110) | ○ |
| C-07 | DeleteCollectionも同様の警告メッセージロジックを持つ | E-01 (L112-121) | ○ |
| C-08 | CategoriesProvider("all")を実装 | E-01 (L93-98) | ○ |
| C-09 | StatusRESTはメインStoreとストレージを共有 | E-01 (L85-89, L134-137) | ○ |
| C-10 | StatusRESTのUpdateはforceAllowCreate=falseを強制 | E-01 (L145-149) | ○ |
| C-11 | StatusRESTはGet/Update/GetResetFields/ConvertToTableを実装 | E-01 (L140-158) | ○ |
| C-12 | PredicateFuncにjob.MatchJobを使用 | E-01 (L69) | ○ |
| C-13 | DefaultQualifiedResourceは"jobs"、SingularQualifiedResourceは"job" | E-01 (L70-71) | ○ |
| C-14 | StatusStoreのUpdateStrategy/ResetFieldsStrategyはjob.StatusStrategy | E-01 (L86-87) | ○ |
| C-15 | StoreOptionsにAttrFunc: job.GetAttrsを設定 | E-01 (L80) | ○ |
| C-16 | TableConvertorにprinterstorage.TableConvertorを設定 | E-01 (L78) | ○ |
| C-17 | deleteOptionWarningsメッセージの内容 | E-01 (L56-57) | ○ |
| C-18 | パフォーマンス要件（数千RPS、数ミリ秒〜数十ミリ秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値はソースコードに明示されていない。API Serverの一般的な性能特性から推定した値である。
  - 候補：Kubernetes SLO/SLI文書 / ベンチマークテスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の大部分はソースコードから直接読み取れる内容
- 1: 中リスク - パフォーマンス要件は実環境での計測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Delete時のOrphanDependents警告ロジックが正確に記述されているか
- [ ] StatusRESTのforceAllowCreate=false仕様が正しいか
- [ ] パフォーマンス要件の数値が実運用環境と乖離していないか
