---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-CronJob Registry（Storage）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/registry/batch/cronjob/storage/storage.go` - REST構造体、NewREST関数、StatusREST
- E-02: `pkg/registry/batch/cronjob/strategy.go` - cronjob.Strategy、cronJobStrategy構造体
- E-03: `pkg/registry/batch/job/storage/storage.go` - 比較参照用Jobストレージ
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REST構造体はgenericregistry.Storeを埋め込む | E-01 (L36-38) | ○ |
| C-02 | NewRESTはetcdバックエンドのREST/StatusRESTを返す | E-01 (L41-65) | ○ |
| C-03 | Storeの設定にcronjob.Strategy（Create/Update/Delete/ResetFields）を使用 | E-01 (L48-51) | ○ |
| C-04 | DefaultQualifiedResourceは"cronjobs"、SingularQualifiedResourceは"cronjob" | E-01 (L45-46) | ○ |
| C-05 | CategoriesProvider("all")を実装 | E-01 (L67, L71-73) | ○ |
| C-06 | ShortNamesProvider("cj")を実装 | E-01 (L68, L76-78) | ○ |
| C-07 | StatusRESTはメインStoreとストレージを共有 | E-01 (L60-64, L91-94) | ○ |
| C-08 | StatusRESTのUpdateはforceAllowCreate=falseを強制 | E-01 (L102-106) | ○ |
| C-09 | StatusRESTはGet/Update/GetResetFields/ConvertToTableを実装 | E-01 (L97-115) | ○ |
| C-10 | StatusStoreのUpdateStrategy/ResetFieldsStrategyはcronjob.StatusStrategy | E-01 (L61-62) | ○ |
| C-11 | Delete/DeleteCollectionのオーバーライドは行っていない | E-01（オーバーライドメソッドなし）, E-03（比較） | ○ |
| C-12 | NewFunc/NewListFuncはCronJob/CronJobListを返す | E-01 (L43-44) | ○ |
| C-13 | TableConvertorにprinterstorage.TableConvertorを設定 | E-01 (L53) | ○ |
| C-14 | cronjob.StrategyはlegacyschemeとSimpleNameGeneratorを使用 | E-02 (L43-49) | ○ |
| C-15 | StoreOptionsにAttrFuncの設定がない（Jobとの差異） | E-01 (L55), E-03 (L80) | ○ |
| C-16 | パフォーマンス要件（数ミリ秒〜数十ミリ秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値はソースコードに明示されていない。API Serverの一般的な性能特性から推定した値である。
  - 候補：Kubernetes SLO/SLI文書 / ベンチマークテスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の大部分はソースコードから直接読み取れる内容
- 1: 中リスク - パフォーマンス要件は実環境での計測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CronJobストレージがJobストレージとの差異（Delete未オーバーライド、ShortNames追加）が正確に記述されているか
- [ ] StatusRESTのforceAllowCreate=false仕様が正しいか
- [ ] StoreOptionsにAttrFuncが含まれていないことの影響が確認されているか
