---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：22-ginkgo-e2e.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **テストケース数「数千」**：正確な数はテストスイートの内容に依存
  2. **レポート出力の詳細形式**：Ginkgoフレームワーク側の仕様に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `hack/ginkgo-e2e.sh`（行1-296）
- E-02: `hack/lib/init.sh`（行1-50）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行23）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ginkgoとe2e.testバイナリをkube::util::find-binaryで検出する | E-01（行29-30） | ○ |
| C-02 | GINKGO_PARALLELのデフォルト値はn | E-01（行34） | ○ |
| C-03 | GINKGO_SILENCE_SKIPSのデフォルト値はy | E-01（行35） | ○ |
| C-04 | GINKGO_NO_COLORは端末接続時n、非接続時y | E-01（行45） | ○ |
| C-05 | タイムアウトのデフォルト値は24h | E-01（行144） | ○ |
| C-06 | 適合性テスト時はkubeconfigからマスターURLを検出する | E-01（行75-83） | ○ |
| C-07 | 通常テスト時はprepare-e2eとdetect-masterを実行する | E-01（行85-89） | ○ |
| C-08 | Azure環境でCLOUD_CONFIG未設定時にエラー終了する | E-01（行126-131） | ○ |
| C-09 | GCE環境でset_num_migsによりノードインスタンスグループを設定する | E-01（行105-116） | ○ |
| C-10 | GKE環境でdetect-node-instance-groupsを呼び出す | E-01（行121-124） | ○ |
| C-11 | 並列実行時はrace検出有効時10ノード、通常時25ノード | E-01（行181-194） | ○ |
| C-12 | E2E_TEST_DEBUG_TOOLでdelve/gdb/ginkgoを切替可能 | E-01（行178-200） | ○ |
| C-13 | --report-complete-ginkgoと--report-complete-junitを設定する | E-01（行214） | ○ |
| C-14 | SIGTERMハンドラがGinkgoプロセスグループにシグナルを転送する | E-01（行228-248） | ○ |
| C-15 | CI環境でSIGTERM/SIGINTハンドリングがデフォルト有効 | E-01（行249-257） | ○ |
| C-16 | set -mでジョブコントロールを有効化しプロセスグループで実行する | E-01（行255） | ○ |
| C-17 | e2e.testをバックグラウンドで実行しwaitで待機する | E-01（行264-295） | ○ |
| C-18 | GINKGO_SHOW_COMMANDがCI時trueでset -xが有効になる | E-01（行262） | ○ |
| C-19 | --poll-progress-afterのデフォルトは60m | E-01（行137） | ○ |
| C-20 | --poll-progress-intervalのデフォルトは5m | E-01（行138） | ○ |
| C-21 | 想定テストケース数は数千件 | **根拠なし** | △ |
| C-22 | Ginkgo V2ではデフォルトタイムアウトが1hに短縮された | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21: テストケース数はテストスイートの内容に依存するため、ソースコードから正確な件数を導出できない。スクリプト自体にはテストケース数に関する情報は含まれていない。
  - 候補：test/e2eディレクトリ内のテストファイル一覧 / CIジョブの実行結果 / Kubernetesリリースノート
- C-22: Ginkgo V2のタイムアウト変更に関するコメントはスクリプト内（行142-143）に記載されているが、Ginkgo V2の公式ドキュメントとの照合が推奨される。
  - 候補：Ginkgo V2公式ドキュメント / github.com/onsi/ginkgo CHANGELOG

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 環境変数のデフォルト値やフラグ設定はソースコードから直接確認可能
- 1: 中リスク - クラウドプロバイダー固有の動作（GCE/GKE/Azure）はcluster/配下のスクリプトに依存するため、完全な検証には追加ファイルの参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータ一覧がソースコードの環境変数参照と網羅的に対応しているか確認
- [ ] クラウドプロバイダー固有の処理（GCE/GKE/Azure）が正確に記述されているか確認
- [ ] シグナルハンドリングの動作がCI環境（Prow）の実際の挙動と整合しているか確認
- [ ] Ginkgo V2のタイムアウト仕様が公式ドキュメントと一致しているか確認
