---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 133
  claims_with_evidence: 128
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：cmd-kube-controller-manager 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：128 / 133、根拠なし：5
- 優先レビュー（高）
  1. **UT-KCM-072 (Validate不正クラウドプロバイダ)**: Validate内部のクラウドプロバイダ検証ロジックの詳細が外部パッケージ依存のため根拠不足
  2. **UT-KCM-073 (Validate不正IPAMアロケータ)**: CIDRAllocatorType検証の具体的なエラーメッセージが外部パッケージ依存
  3. **UT-KCM-074 (Config生成)**: Config()メソッドの全体フローが複数の外部依存を含むため完全検証が困難
  4. **UT-KCM-082 (空文字列CIDR)**: validateCIDRsの空文字列入力時の具体的な挙動はnet.ParseCIDR依存
  5. **UT-KCM-133 (命名規則検証)**: 全定数が正規表現パターンに合致するかの完全検証は定数値一覧の網羅的確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cmd/kube-controller-manager/app/controllermanager.go` - メインコントローラマネージャファイル（NewControllerManagerCommand, ResyncPeriod, ControllerContext, readCA, createClientBuilders, filteredControllerDescriptors, BuildControllers）
- E-02: `cmd/kube-controller-manager/app/controller_descriptor.go` - ControllerDescriptor型定義とメソッド群（Name, GetControllerConstructor, GetRequiredFeatureGates, GetAliases, IsDisabledByDefault, IsCloudProviderController, RequiresSpecialHandling, BuildController, KnownControllers, ControllerAliases, ControllersDisabledByDefault, NewControllerDescriptors）
- E-03: `cmd/kube-controller-manager/app/controller_utils.go` - controllerLoop, runFuncSlice, concurrentRun, newControllerLoop
- E-04: `cmd/kube-controller-manager/app/options/options.go` - KubeControllerManagerOptions（NewKubeControllerManagerOptions, NewDefaultComponentConfig, Flags, ApplyTo, Validate, Config）
- E-05: `cmd/kube-controller-manager/app/config/config.go` - Config, CompletedConfig, Complete()
- E-06: `cmd/kube-controller-manager/app/core.go` - validateCIDRs, processCIDRs, setNodeCIDRMaskSizes, garbageCollectorController, 各コントローラDescriptor関数
- E-07: `cmd/kube-controller-manager/app/certificates.go` - anySpecificFilesSet, areXxxSignerFilesSpecified, getXxxSignerFiles, clusterTrustBundlesAvailable, getKubeAPIServerCAFileContents
- E-08: `cmd/kube-controller-manager/app/service_accounts.go` - newServiceAccountTokenControllerDescriptor, newServiceAccountTokenController
- E-09: `cmd/kube-controller-manager/app/bootstrap.go` - newBootstrapSignerControllerDescriptor, newTokenCleanerControllerDescriptor
- E-10: `cmd/kube-controller-manager/names/controller_names.go` - コントローラ名定数群
- E-11: `cmd/kube-controller-manager/app/apps.go` - newDaemonSetControllerDescriptor, newStatefulSetControllerDescriptor, newReplicaSetControllerDescriptor, newDeploymentControllerDescriptor
- E-12: `cmd/kube-controller-manager/app/batch.go` - newJobControllerDescriptor, newCronJobControllerDescriptor
- E-13: `cmd/kube-controller-manager/app/policy.go` - newDisruptionControllerDescriptor
- E-14: `cmd/kube-controller-manager/app/rbac.go` - newClusterRoleAggregrationControllerDescriptor
- E-15: `cmd/kube-controller-manager/app/discovery.go` - newEndpointSliceControllerDescriptor, newEndpointSliceMirroringControllerDescriptor
- E-16: `cmd/kube-controller-manager/app/autoscaling.go` - newHorizontalPodAutoscalerControllerDescriptor
- E-17: `cmd/kube-controller-manager/app/networking.go` - newServiceCIDRsControllerDescriptor
- E-18: `cmd/kube-controller-manager/app/validatingadmissionpolicystatus.go` - newValidatingAdmissionPolicyStatusControllerDescriptor
- E-19: `cmd/kube-controller-manager/app/storageversionmigrator.go` - newStorageVersionMigratorControllerDescriptor, newSVMController

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-KCM-001: NewControllerManagerCommandがcobraコマンドを生成 | E-01 | ○ |
| C-02 | UT-KCM-002: Useフィールドがkube-controller-manager | E-01 | ○ |
| C-03 | UT-KCM-003: 引数が渡された場合エラー | E-01 | ○ |
| C-04 | UT-KCM-004: 空引数でエラーなし | E-01 | ○ |
| C-05 | UT-KCM-005: ResyncPeriodがMinResyncPeriod以上 | E-01 | ○ |
| C-06 | UT-KCM-006: MinResyncPeriod=0で0が返る | E-01 | ○ |
| C-07 | UT-KCM-007: IsControllerEnabledが有効コントローラでtrue | E-01 | ○ |
| C-08 | UT-KCM-008: デフォルト無効コントローラがfalse | E-01 | ○ |
| C-09 | UT-KCM-009: 明示有効化でtrue | E-01 | ○ |
| C-10 | UT-KCM-010: NewClientConfigが設定を返却 | E-01 | ○ |
| C-11 | UT-KCM-011: NewClientConfigのエラーラッピング | E-01 | ○ |
| C-12 | UT-KCM-012: NewClientがクライアントを返却 | E-01 | ○ |
| C-13 | UT-KCM-013: NewClientのエラーラッピング | E-01 | ○ |
| C-14 | UT-KCM-014: readCAが有効CAを読み取る | E-01 | ○ |
| C-15 | UT-KCM-015: readCAでファイル不在エラー | E-01 | ○ |
| C-16 | UT-KCM-016: readCAで不正PEMエラー | E-01 | ○ |
| C-17 | UT-KCM-017: SA認証無効時のビルダー同一性 | E-01 | ○ |
| C-18 | UT-KCM-018: SA認証有効時のDynamicClientBuilder | E-01 | ○ |
| C-19 | UT-KCM-019: filteredControllerDescriptorsのフィルタ | E-01 | ○ |
| C-20 | UT-KCM-020: 空マップのフィルタ | E-01 | ○ |
| C-21 | UT-KCM-021: 全不一致フィルタ | E-01 | ○ |
| C-22 | UT-KCM-022: BuildControllers正常構築 | E-01 | ○ |
| C-23 | UT-KCM-023: SA Token Controller優先構築 | E-01 | ○ |
| C-24 | UT-KCM-024: RequiresSpecialHandlingスキップ | E-01 | ○ |
| C-25 | UT-KCM-025: 無効コントローラスキップ | E-01 | ○ |
| C-26 | UT-KCM-026: 構築エラー伝播 | E-01 | ○ |
| C-27 | UT-KCM-027: ヘルスチェック登録 | E-01 | ○ |
| C-28 | UT-KCM-028: デバッグハンドラ登録 | E-01 | ○ |
| C-29 | UT-KCM-029: カスタムヘルスチェック登録 | E-01 | ○ |
| C-30 | UT-KCM-030: ControllerDescriptor.Name() | E-02 | ○ |
| C-31 | UT-KCM-031: GetControllerConstructor() | E-02 | ○ |
| C-32 | UT-KCM-032: GetRequiredFeatureGatesコピー返却 | E-02 | ○ |
| C-33 | UT-KCM-033: GetRequiredFeatureGates防御的コピー | E-02 | ○ |
| C-34 | UT-KCM-034: GetAliasesコピー返却 | E-02 | ○ |
| C-35 | UT-KCM-035: GetAliases防御的コピー | E-02 | ○ |
| C-36 | UT-KCM-036: IsDisabledByDefault true | E-02 | ○ |
| C-37 | UT-KCM-037: IsDisabledByDefault false | E-02 | ○ |
| C-38 | UT-KCM-038: IsCloudProviderController | E-02 | ○ |
| C-39 | UT-KCM-039: RequiresSpecialHandling | E-02 | ○ |
| C-40 | UT-KCM-040: BuildControllerフィーチャーゲート有効 | E-02 | ○ |
| C-41 | UT-KCM-041: BuildControllerフィーチャーゲート無効 | E-02 | ○ |
| C-42 | UT-KCM-042: BuildControllerクラウドプロバイダスキップ | E-02 | ○ |
| C-43 | UT-KCM-043: KnownControllersソート | E-02 | ○ |
| C-44 | UT-KCM-044: KnownControllers件数 | E-02 | ○ |
| C-45 | UT-KCM-045: ControllerAliases | E-02 | ○ |
| C-46 | UT-KCM-046: エイリアス競合チェック | E-02 | ○ |
| C-47 | UT-KCM-047: ControllersDisabledByDefaultソート | E-02 | ○ |
| C-48 | UT-KCM-048: デフォルト無効にbootstrap/tokenが含まれる | E-02, E-09 | ○ |
| C-49 | UT-KCM-049: NewControllerDescriptors登録 | E-02 | ○ |
| C-50 | UT-KCM-050: 全DescriptorのConstructor非nil | E-02 | ○ |
| C-51 | UT-KCM-051: エイリアス重複なし | E-02 | ○ |
| C-52 | UT-KCM-052: controllerLoop.Name() | E-03 | ○ |
| C-53 | UT-KCM-053: controllerLoop.Run() | E-03 | ○ |
| C-54 | UT-KCM-054: newControllerLoop | E-03 | ○ |
| C-55 | UT-KCM-055: concurrentRun並行実行 | E-03 | ○ |
| C-56 | UT-KCM-056: concurrentRun空 | E-03 | ○ |
| C-57 | UT-KCM-057: runFuncSlice.Run WaitGroup | E-03 | ○ |
| C-58 | UT-KCM-058: NewKubeControllerManagerOptions | E-04 | ○ |
| C-59 | UT-KCM-059: BindPort | E-04 | ○ |
| C-60 | UT-KCM-060: LeaderElection.ResourceName | E-04 | ○ |
| C-61 | UT-KCM-061: LeaderElection.ResourceNamespace | E-04 | ○ |
| C-62 | UT-KCM-062: ControllerShutdownTimeout | E-04 | ○ |
| C-63 | UT-KCM-063: GCIgnoredResources | E-04 | ○ |
| C-64 | UT-KCM-064: RemoteKubeConfigFileOptional | E-04 | ○ |
| C-65 | UT-KCM-065: NewDefaultComponentConfig | E-04 | ○ |
| C-66 | UT-KCM-066: Flags全フラグセット | E-04 | ○ |
| C-67 | UT-KCM-067: controller-shutdown-timeoutフラグ | E-04 | ○ |
| C-68 | UT-KCM-068: miscフラグ | E-04 | ○ |
| C-69 | UT-KCM-069: ApplyTo正常 | E-04 | ○ |
| C-70 | UT-KCM-070: ApplyToタイムアウト反映 | E-04 | ○ |
| C-71 | UT-KCM-071: Validate成功 | E-04 | ○ |
| C-72 | UT-KCM-072: Validate不正クラウドプロバイダ | E-04 | △ |
| C-73 | UT-KCM-073: Validate不正IPAMアロケータ | E-04 | △ |
| C-74 | UT-KCM-074: Config生成 | E-04 | △ |
| C-75 | UT-KCM-075: Flagz設定 | E-04 | ○ |
| C-76 | UT-KCM-076: Config.Complete() | E-05 | ○ |
| C-77 | UT-KCM-077: validateCIDRs単一IPv4 | E-06 | ○ |
| C-78 | UT-KCM-078: validateCIDRsデュアルスタック | E-06 | ○ |
| C-79 | UT-KCM-079: validateCIDRs不正CIDR | E-06 | ○ |
| C-80 | UT-KCM-080: validateCIDRs3CIDR超過 | E-06 | ○ |
| C-81 | UT-KCM-081: validateCIDRs非デュアルスタック | E-06 | ○ |
| C-82 | UT-KCM-082: validateCIDRs空文字列 | E-06 | △ |
| C-83 | UT-KCM-083: processCIDRs単一CIDR | E-06 | ○ |
| C-84 | UT-KCM-084: processCIDRsデュアルスタック | E-06 | ○ |
| C-85 | UT-KCM-085: processCIDRs不正CIDR | E-06 | ○ |
| C-86 | UT-KCM-086: setNodeCIDRMaskSizesデフォルトDS | E-06 | ○ |
| C-87 | UT-KCM-087: setNodeCIDRMaskSizesカスタムIPv4 DS | E-06 | ○ |
| C-88 | UT-KCM-088: setNodeCIDRMaskSizesカスタムIPv6 DS | E-06 | ○ |
| C-89 | UT-KCM-089: setNodeCIDRMaskSizes DS非互換 | E-06 | ○ |
| C-90 | UT-KCM-090: setNodeCIDRMaskSizes単一IPv4 | E-06 | ○ |
| C-91 | UT-KCM-091: setNodeCIDRMaskSizes競合 | E-06 | ○ |
| C-92 | UT-KCM-092: setNodeCIDRMaskSizes IPv6でIPv4指定 | E-06 | ○ |
| C-93 | UT-KCM-093: setNodeCIDRMaskSizes IPv4でIPv6指定 | E-06 | ○ |
| C-94 | UT-KCM-094: setNodeCIDRMaskSizesデフォルトIPv6 | E-06 | ○ |
| C-95 | UT-KCM-095: setNodeCIDRMaskSizesデフォルトIPv4 | E-06 | ○ |
| C-96 | UT-KCM-096: anySpecificFilesSet true | E-07 | ○ |
| C-97 | UT-KCM-097: anySpecificFilesSet false | E-07 | ○ |
| C-98 | UT-KCM-098: areKubeletServingSignerFilesSpecified true | E-07 | ○ |
| C-99 | UT-KCM-099: areKubeletServingSignerFilesSpecified false | E-07 | ○ |
| C-100 | UT-KCM-100: areKubeletClientSignerFilesSpecified | E-07 | ○ |
| C-101 | UT-KCM-101: areKubeAPIServerClientSignerFilesSpecified | E-07 | ○ |
| C-102 | UT-KCM-102: areLegacyUnknownSignerFilesSpecified | E-07 | ○ |
| C-103 | UT-KCM-103: getKubeletServingSignerFilesフォールバック | E-07 | ○ |
| C-104 | UT-KCM-104: getKubeletServingSignerFiles個別 | E-07 | ○ |
| C-105 | UT-KCM-105: getKubeletClientSignerFiles | E-07 | ○ |
| C-106 | UT-KCM-106: getKubeAPIServerClientSignerFiles | E-07 | ○ |
| C-107 | UT-KCM-107: getLegacyUnknownSignerFiles | E-07 | ○ |
| C-108 | UT-KCM-108: clusterTrustBundlesAvailable true | E-07 | ○ |
| C-109 | UT-KCM-109: clusterTrustBundlesAvailable false | E-07 | ○ |
| C-110 | UT-KCM-110: clusterTrustBundlesAvailable NotFound | E-07 | ○ |
| C-111 | UT-KCM-111: getKubeAPIServerCAFileContentsフォールバック | E-07 | ○ |
| C-112 | UT-KCM-112: getKubeAPIServerCAFileContentsファイル | E-07 | ○ |
| C-113 | UT-KCM-113: getKubeAPIServerCAFileContentsエラー | E-07 | ○ |
| C-114 | UT-KCM-114: SA Token Controller特別処理フラグ | E-08 | ○ |
| C-115 | UT-KCM-115: SA Token Controllerエイリアス | E-08 | ○ |
| C-116 | UT-KCM-116: SA Token Controller名前 | E-08 | ○ |
| C-117 | UT-KCM-117: BootstrapSigner無効デフォルト | E-09 | ○ |
| C-118 | UT-KCM-118: TokenCleaner無効デフォルト | E-09 | ○ |
| C-119 | UT-KCM-119: GCコントローラ名 | E-06 | ○ |
| C-120 | UT-KCM-120: SELinuxWarning無効デフォルト | E-06 | ○ |
| C-121 | UT-KCM-121: SELinuxWarning必須フィーチャーゲート | E-06 | ○ |
| C-122 | UT-KCM-122: TaintEviction必須フィーチャーゲート | E-06 | ○ |
| C-123 | UT-KCM-123: DeviceTaintEviction必須フィーチャーゲート | E-06 | ○ |
| C-124 | UT-KCM-124: ResourceClaim必須フィーチャーゲート | E-06 | ○ |
| C-125 | UT-KCM-125: VACProtection必須フィーチャーゲート | E-06 | ○ |
| C-126 | UT-KCM-126: StorageVersionGC必須フィーチャーゲート | E-06 | ○ |
| C-127 | UT-KCM-127: ServiceLBクラウドプロバイダフラグ | E-06 | ○ |
| C-128 | UT-KCM-128: CloudNodeLifecycleクラウドプロバイダフラグ | E-06 | ○ |
| C-129 | UT-KCM-129: NodeRouteクラウドプロバイダフラグ | E-06 | ○ |
| C-130 | UT-KCM-130: ServiceAccountTokenController定数値 | E-10 | ○ |
| C-131 | UT-KCM-131: GarbageCollectorController定数値 | E-10 | ○ |
| C-132 | UT-KCM-132: DeploymentController定数値 | E-10 | ○ |
| C-133 | UT-KCM-133: 全定数命名規則 | E-10 | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-KCM-072, UT-KCM-073**: Validate()メソッド内のクラウドプロバイダ検証とCIDRAllocatorType検証は外部パッケージ（controller-manager/pkg）に委譲されており、具体的なエラーメッセージの検証にはそのパッケージのソースコード確認が必要
  - 候補：`staging/src/k8s.io/controller-manager/` / `pkg/controller/apis/config/validation/`
- **UT-KCM-074**: Config()メソッドはSecureServing, Authentication, AuthorizationなどAPIサーバ基盤の設定を含み、完全なテストには複数の外部設定モックが必要
  - 候補：`staging/src/k8s.io/apiserver/pkg/server/` / `staging/src/k8s.io/controller-manager/`
- **UT-KCM-082**: validateCIDRsに空文字列を渡した場合の挙動はnet.ParseCIDRの実装に依存。エラーになると推測されるが、validateCIDRs自体のソースコードでは空文字列の明示的チェックは確認されていない
  - 候補：Go標準ライブラリ `net` パッケージ
- **UT-KCM-133**: 全定数の命名規則が正規表現パターンに合致するかは、controller_names.goの全定数を網羅的に検証する必要がある。一部の定数名は確認済みだが全数検証には至っていない
  - 候補：`cmd/kube-controller-manager/names/controller_names.go` の全定数

## 5) リスクフラグ（レビュー観点）
- 0: CIDR関連テスト（UT-KCM-077〜095）は実装コードから直接導出されており低リスク
- 0: ControllerDescriptorアクセサテスト（UT-KCM-030〜039）は単純なゲッターで低リスク
- 1: Options関連テスト（UT-KCM-058〜075）はデフォルト値の変更に影響されるため中リスク
- 1: Validate関連テスト（UT-KCM-071〜073）は外部パッケージの検証ロジック依存のため中リスク
- 0: 証明書署名ファイル関連テスト（UT-KCM-096〜113）はソースコードから直接導出され低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] Validate()メソッドの不正クラウドプロバイダ検証が外部パッケージの実装と整合しているか確認（C-72）
- [ ] validateCIDRsに空文字列を渡した場合の実際の挙動を確認（C-82）
- [ ] NewControllerDescriptors()で登録されるコントローラの総数が最新のソースコードと一致しているか確認
- [ ] setNodeCIDRMaskSizesのデフォルト値（IPv4=24, IPv6=64）が実装と一致しているか確認
- [ ] 全定数名が命名規則に従っているか、controller_names.goを目視確認（C-133）
