---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 136
  claims_with_evidence: 131
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：cmd-kube-proxy 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：131 / 136、根拠なし：5
- 優先レビュー（高）
  1. **C-041 (createClient InClusterConfig)**: InClusterConfig呼び出しの挙動は環境依存であり、テスト環境では実行不可の可能性
  2. **C-076 (loadConfig lenientフォールバック)**: strict decodingエラーを発生させる入力データの具体例がコードからは直接特定しにくい
  3. **C-078 (loadConfig lenientフォールバック失敗)**: lenient decodingも失敗するケースの具体的データ構成がスキーマ内部仕様に依存
  4. **C-099 (initWatcher)**: FSWatcher の内部実装はfilesystemパッケージに依存
  5. **C-129 (initForOS Windows Service)**: Windows service.InitService の内部動作はモジュール外に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cmd/kube-proxy/proxy.go` - mainエントリポイント（L29-33）
- E-02: `cmd/kube-proxy/app/server.go` - NewProxyCommand関数（L98-157）
- E-03: `cmd/kube-proxy/app/server.go` - ProxyServer構造体（L161-178）
- E-04: `cmd/kube-proxy/app/server.go` - newProxyServer関数（L181-283）
- E-05: `cmd/kube-proxy/app/server.go` - checkBadConfig関数（L286-313）
- E-06: `cmd/kube-proxy/app/server.go` - checkBadIPConfig関数（L319-375）
- E-07: `cmd/kube-proxy/app/server.go` - badCIDRs関数（L378-388）
- E-08: `cmd/kube-proxy/app/server.go` - badBindAddress関数（L392-400）
- E-09: `cmd/kube-proxy/app/server.go` - createClient関数（L404-434）
- E-10: `cmd/kube-proxy/app/server.go` - serveHealthz関数（L436-457）
- E-11: `cmd/kube-proxy/app/server.go` - serveMetrics関数（L459-522）
- E-12: `cmd/kube-proxy/app/server.go` - ProxyServer.Run関数（L526-636）
- E-13: `cmd/kube-proxy/app/server.go` - birthCry関数（L638-640）
- E-14: `cmd/kube-proxy/app/server.go` - detectNodeIPs関数（L655-693）
- E-15: `cmd/kube-proxy/app/options.go` - Options構造体（L51-95）
- E-16: `cmd/kube-proxy/app/options.go` - AddFlags関数（L98-179）
- E-17: `cmd/kube-proxy/app/options.go` - newKubeProxyConfiguration関数（L182-191）
- E-18: `cmd/kube-proxy/app/options.go` - NewOptions関数（L194-202）
- E-19: `cmd/kube-proxy/app/options.go` - Complete関数（L205-255）
- E-20: `cmd/kube-proxy/app/options.go` - copyLogsFromFlags関数（L263-288）
- E-21: `cmd/kube-proxy/app/options.go` - initWatcher関数（L291-303）
- E-22: `cmd/kube-proxy/app/options.go` - eventHandler関数（L305-312）
- E-23: `cmd/kube-proxy/app/options.go` - errorHandler関数（L314-316）
- E-24: `cmd/kube-proxy/app/options.go` - processHostnameOverrideFlag関数（L319-330）
- E-25: `cmd/kube-proxy/app/options.go` - processV1Alpha1Flags関数（L333-349）
- E-26: `cmd/kube-proxy/app/options.go` - Validate関数（L352-358）
- E-27: `cmd/kube-proxy/app/options.go` - Run関数（L361-384）
- E-28: `cmd/kube-proxy/app/options.go` - runLoop関数（L388-405）
- E-29: `cmd/kube-proxy/app/options.go` - writeConfigFile関数（L407-435）
- E-30: `cmd/kube-proxy/app/options.go` - addressFromDeprecatedFlags関数（L441-446）
- E-31: `cmd/kube-proxy/app/options.go` - newLenientSchemeAndCodecs関数（L450-460）
- E-32: `cmd/kube-proxy/app/options.go` - loadConfigFromFile関数（L464-471）
- E-33: `cmd/kube-proxy/app/options.go` - loadConfig関数（L474-506）
- E-34: `cmd/kube-proxy/app/server_linux.go` - platformApplyDefaults関数（L46-61）
- E-35: `cmd/kube-proxy/app/server_linux.go` - platformSetup関数（L66-72）
- E-36: `cmd/kube-proxy/app/server_linux.go` - isIPTablesBased関数（L75-77）
- E-37: `cmd/kube-proxy/app/server_linux.go` - platformCheckSupported関数（L81-118）
- E-38: `cmd/kube-proxy/app/server_linux.go` - createProxier関数（L121-290）
- E-39: `cmd/kube-proxy/app/server_linux.go` - getLocalDetectors関数（L292-330）
- E-40: `cmd/kube-proxy/app/server_linux.go` - platformCleanup関数（L336-354）
- E-41: `cmd/kube-proxy/app/server_windows.go` - platformApplyDefaults関数（L40-47）
- E-42: `cmd/kube-proxy/app/server_windows.go` - platformSetup関数（L52-60）
- E-43: `cmd/kube-proxy/app/server_windows.go` - platformCheckSupported関数（L64-80）
- E-44: `cmd/kube-proxy/app/server_windows.go` - createProxier関数（L83-120）
- E-45: `cmd/kube-proxy/app/server_windows.go` - platformCleanup関数（L123-128）
- E-46: `cmd/kube-proxy/app/server_other.go` - 全関数（L34-60）
- E-47: `cmd/kube-proxy/app/init_linux.go` - initForOS関数（L25-27）
- E-48: `cmd/kube-proxy/app/init_other.go` - initForOS関数（L28-30）
- E-49: `cmd/kube-proxy/app/init_windows.go` - initForOS関数（L31-36）
- E-50: `cmd/kube-proxy/app/init_windows.go` - addOSFlags関数（L38-45）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | NewProxyCommandがcobra.Commandを返す | E-02 | ○ |
| C-002 | 引数なしでエラーなし | E-02 (L140-147) | ○ |
| C-003 | 引数ありでエラー | E-02 (L140-147) | ○ |
| C-004 | 空文字列引数でエラーなし（len(arg)==0） | E-02 (L142) | ○ |
| C-005 | rawNodeIPs空でデフォルトIP | E-14 (L657-661) | ○ |
| C-006 | IPv4アドレス1つでprimaryFamily=IPv4 | E-14 (L663-667) | ○ |
| C-007 | IPv6アドレス1つでprimaryFamily=IPv6 | E-14 (L663-667) | ○ |
| C-008 | デュアルスタックIP検出(IPv4先) | E-14 (L668-676) | ○ |
| C-009 | デュアルスタックIP検出(IPv6先) | E-14 (L663-676) | ○ |
| C-010 | bindAddressでprimaryFamily上書き(IPv6) | E-14 (L679-687) | ○ |
| C-011 | bindAddressでprimaryFamily上書き(IPv4) | E-14 (L679-687) | ○ |
| C-012 | bindAddress 0.0.0.0で上書きされない | E-14 (L680) | ○ |
| C-013 | bindAddress ::で上書きされない | E-14 (L680) | ○ |
| C-014 | 空rawNodeIPs+空bindAddressのフォールバック | E-14 (L657-661) | ○ |
| C-015 | ループバックIP時に警告ログ出力 | E-14 (L689-691) | ○ |
| C-016 | NodePortAddresses未設定で警告 | E-05 (L304-305) | ○ |
| C-017 | NodePortAddresses設定済みでエラーなし | E-05 | ○ |
| C-018 | デュアルスタックでNodePortAddresses片方のみ | E-05 (L306-307) | ○ |
| C-019 | NodePortAddressesにプライマリファミリ不在 | E-05 (L308-309) | ○ |
| C-020 | 正しいIP設定でエラーなし | E-06 | ○ |
| C-021 | ClusterCIDRs誤りIPファミリ(ClusterCIDRモード)でfatal | E-06 (L336-342) | ○ |
| C-022 | ClusterCIDRs誤り(デュアルスタック時非致命的) | E-06 (L338) | ○ |
| C-023 | podCIDRs誤りIPファミリ(NodeCIDRモード)でfatal | E-06 (L344-350) | ○ |
| C-024 | HealthzBindAddress誤りIPファミリ | E-06 (L363-365) | ○ |
| C-025 | MetricsBindAddress誤りIPファミリ | E-06 (L366-368) | ○ |
| C-026 | デュアルスタック時BindAddressスキップ | E-06 (L358) | ○ |
| C-027 | ExcludeCIDRs誤りIPファミリ(シングルスタック) | E-06 (L359-361) | ○ |
| C-028 | ExcludeCIDRs(デュアルスタック時寛容) | E-06 (L358) | ○ |
| C-029 | SourceVip誤りIPファミリ | E-06 (L352-354) | ○ |
| C-030 | badCIDRs空リストでfalse | E-07 (L379-381) | ○ |
| C-031 | badCIDRs全誤りファミリでtrue | E-07 (L382-387) | ○ |
| C-032 | badCIDRs混在でfalse | E-07 (L383-384) | ○ |
| C-033 | badCIDRs単一正CIDRでfalse | E-07 | ○ |
| C-034 | badCIDRs複数誤りCIDRでtrue | E-07 (L382-387) | ○ |
| C-035 | badBindAddress正ファミリでfalse | E-08 | ○ |
| C-036 | badBindAddress誤ファミリでtrue | E-08 (L394-396) | ○ |
| C-037 | badBindAddress unspecifiedでfalse | E-08 (L395) | ○ |
| C-038 | badBindAddress空文字列でfalse | E-08 (L393) | ○ |
| C-039 | badBindAddressホスト未指定でfalse | E-08 (L393) | ○ |
| C-040 | badBindAddress IPv6 unspecifiedでfalse | E-08 (L395) | ○ |
| C-041 | createClient InClusterConfig | E-09 (L409-411) | △ |
| C-042 | createClient kubeconfig | E-09 (L414-417) | ○ |
| C-043 | createClient masterOverride | E-09 (L417) | ○ |
| C-044 | createClient QPS/Burst反映 | E-09 (L423-426) | ○ |
| C-045 | createClient ContentType反映 | E-09 (L423-424) | ○ |
| C-046 | createClient不正kubeconfigパス | E-09 (L419-421) | ○ |
| C-047 | serveHealthz nilの場合 | E-10 (L438-439) | ○ |
| C-048 | serveMetrics空bindAddress | E-11 (L460-462) | ○ |
| C-049 | serveMetricsサーバー起動 | E-11 (L464-522) | ○ |
| C-050 | serveMetrics profiling有効 | E-11 (L476-479) | ○ |
| C-051 | birthCryイベント記録 | E-13 | ○ |
| C-052 | NewOptionsデフォルト値初期化 | E-18 | ○ |
| C-053 | newKubeProxyConfigurationデフォルト生成 | E-17 | ○ |
| C-054 | AddFlagsがフラグを登録 | E-16 | ○ |
| C-055 | 非推奨フラグのマーク | E-16 (L174, L176) | ○ |
| C-056 | Complete ConfigFile未指定時 | E-19 (L206-209) | ○ |
| C-057 | Complete ConfigFile指定時 | E-19 (L212-229) | ○ |
| C-058 | Complete 存在しないConfigFile | E-19 (L213-216) | ○ |
| C-059 | Complete FeatureGates設定 | E-19 (L240-241) | ○ |
| C-060 | Complete 不正FeatureGatesエラー | E-19 (L240-241) | ○ |
| C-061 | Complete hostnameOverride処理 | E-19 (L236-238) | ○ |
| C-062 | Validate正常系 | E-26 | ○ |
| C-063 | Validate異常系 | E-26 | ○ |
| C-064 | processHostnameOverrideFlag設定あり | E-24 (L321-327) | ○ |
| C-065 | processHostnameOverrideFlag空 | E-24 (L321) | ○ |
| C-066 | processHostnameOverrideFlagスペースのみ | E-24 (L323-325) | ○ |
| C-067 | processHostnameOverrideFlagトリム | E-24 (L322) | ○ |
| C-068 | processV1Alpha1Flags iptables-sync-period | E-25 (L334-336) | ○ |
| C-069 | processV1Alpha1Flags iptables-min-sync-period | E-25 (L337-339) | ○ |
| C-070 | processV1Alpha1Flags ipvs-sync-period | E-25 (L340-342) | ○ |
| C-071 | processV1Alpha1Flags ipvs-min-sync-period | E-25 (L343-345) | ○ |
| C-072 | processV1Alpha1Flags IPVSモードでiptables無視 | E-25 (L334) | ○ |
| C-073 | processV1Alpha1Flags cluster-cidr | E-25 (L346-348) | ○ |
| C-074 | loadConfig正常系 | E-33 (L476) | ○ |
| C-075 | loadConfig不正データ | E-33 (L481-482) | ○ |
| C-076 | loadConfig lenientフォールバック | E-33 (L485-498) | △ |
| C-077 | loadConfig型不一致 | E-33 (L501-503) | ○ |
| C-078 | loadConfig lenientフォールバック失敗 | E-33 (L491-494) | △ |
| C-079 | loadConfigFromFile正常系 | E-32 | ○ |
| C-080 | loadConfigFromFile不正ファイル | E-32 (L465-468) | ○ |
| C-081 | addressFromDeprecatedFlags port=0 | E-30 (L442-443) | ○ |
| C-082 | addressFromDeprecatedFlags port>0 | E-30 (L445) | ○ |
| C-083 | addressFromDeprecatedFlags既存ポート | E-30 | ○ |
| C-084 | newLenientSchemeAndCodecs正常 | E-31 | ○ |
| C-085 | writeConfigFile正常 | E-29 | ○ |
| C-086 | writeConfigFile書き込み不可 | E-29 (L416-418) | ○ |
| C-087 | Run WriteConfigTo設定時 | E-27 (L363-365) | ○ |
| C-088 | Run CleanupAndExit | E-27 (L367-370) | ○ |
| C-089 | Run InitAndExit | E-27 (L378-380) | ○ |
| C-090 | runLoop watcher.Run呼び出し | E-28 (L389-391) | ○ |
| C-091 | runLoop proxyServerエラー伝播 | E-28 (L394-397) | ○ |
| C-092 | eventHandler Writeイベント | E-22 (L306-309) | ○ |
| C-093 | eventHandler Renameイベント | E-22 (L306-309) | ○ |
| C-094 | eventHandler その他イベント | E-22 (L311) | ○ |
| C-095 | errorHandler | E-23 | ○ |
| C-096 | copyLogsFromFlags変更フラグコピー | E-20 (L269-284) | ○ |
| C-097 | copyLogsFromFlags未変更スキップ | E-20 (L278-280) | ○ |
| C-098 | copyLogsFromFlags vmodule結合 | E-20 (L266-286) | ○ |
| C-099 | initWatcher正常 | E-21 | △ |
| C-100 | initWatcher不正パス | E-21 (L297-300) | ○ |
| C-101 | platformApplyDefaults Linux Mode空->iptables | E-34 (L47-49) | ○ |
| C-102 | platformApplyDefaults Linux Mode既設定保持 | E-34 (L47) | ○ |
| C-103 | platformApplyDefaults Linux nftables NodePort | E-34 (L52-54) | ○ |
| C-104 | platformApplyDefaults Linux nftables NodePort既設定保持 | E-34 (L52) | ○ |
| C-105 | platformApplyDefaults Linux DetectLocalMode空 | E-34 (L56-59) | ○ |
| C-106 | isIPTablesBased iptables->true | E-36 | ○ |
| C-107 | isIPTablesBased ipvs->true | E-36 | ○ |
| C-108 | isIPTablesBased nftables->false | E-36 | ○ |
| C-109 | isIPTablesBased 空文字列->false | E-36 | ○ |
| C-110 | getLocalDetectors ClusterCIDR | E-39 (L299-305) | ○ |
| C-111 | getLocalDetectors NodeCIDR | E-39 (L307-313) | ○ |
| C-112 | getLocalDetectors BridgeInterface | E-39 (L315-318) | ○ |
| C-113 | getLocalDetectors InterfaceNamePrefix | E-39 (L320-323) | ○ |
| C-114 | getLocalDetectors デフォルト | E-39 (L325-327) | ○ |
| C-115 | getLocalDetectors デュアルスタック | E-39 (L300-301) | ○ |
| C-116 | getLocalDetectors プライマリCIDR不在 | E-39 (L303-305) | ○ |
| C-117 | platformCleanup cleanupAndExit=true全モード | E-40 (L340-348) | ○ |
| C-118 | platformCleanup nftablesモード切替 | E-40 (L340-343) | ○ |
| C-119 | platformCleanup iptablesモード切替 | E-40 (L346-348) | ○ |
| C-120 | platformCleanupエラー | E-40 (L350-353) | ○ |
| C-121 | platformApplyDefaults Windows Mode空->kernelspace | E-41 (L41-43) | ○ |
| C-122 | platformApplyDefaults Windows RootHnsEndpointName空 | E-41 (L44-46) | ○ |
| C-123 | platformSetup Windows IPv4 | E-42 (L54-55) | ○ |
| C-124 | platformSetup Windows IPv6 | E-42 (L56-58) | ○ |
| C-125 | platformCleanup Windows cleanupAndExit=true | E-45 (L124-126) | ○ |
| C-126 | platformCleanup Windows cleanupAndExit=false | E-45 (L127) | ○ |
| C-127 | createProxier Windows initOnly=true | E-44 (L84-86) | ○ |
| C-128 | initForOS Windows false | E-49 (L31-36) | ○ |
| C-129 | initForOS Windows true (service.InitService) | E-49 (L33) | △ |
| C-130 | initForOS Linux | E-47 (L25-27) | ○ |
| C-131 | initForOS other | E-48 (L28-30) | ○ |
| C-132 | addOSFlags Windows | E-50 | ○ |
| C-133 | platformSetup other->unsupportedError | E-46 | ○ |
| C-134 | platformCheckSupported other->unsupportedError | E-46 | ○ |
| C-135 | createProxier other->unsupportedError | E-46 | ○ |
| C-136 | platformCleanup other->unsupportedError | E-46 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-041 (createClient InClusterConfig)**: `rest.InClusterConfig()` は実行環境（Pod内）に依存するため、ユニットテストではモック化が必要。実際のクラスタ接続テストは統合テストの範囲。
  - 候補：rest.InClusterConfig / 環境変数KUBERNETES_SERVICE_HOST
- **C-076 (loadConfig lenientフォールバック)**: strict decodingエラーを発生させつつlenient decodingで成功するテストデータの具体例は、proxyconfigscheme内部のバリデーション仕様に依存する。テスト実装時には実際のスキーマ定義を参照して具体的な入力データを生成する必要がある。
  - 候補：proxyconfigscheme / serializer.DisableStrict / v1alpha1スキーマ定義
- **C-078 (loadConfig lenientフォールバック失敗)**: lenient decodingも失敗するケースは、strictでもlenientでもデコードできないデータの具体的構成がスキーマ内部仕様に依存する。エラーメッセージは元のstrictエラーが返される点に注意。
  - 候補：proxyconfigscheme / serializer仕様
- **C-099 (initWatcher)**: FSWatcher の Init/AddWatch の詳細動作は `pkg/util/filesystem` パッケージに依存。ファイルシステムの監視動作の正確なテストには実ファイルまたはモックが必要。
  - 候補：filesystem.NewFsnotifyWatcher / fsnotify ライブラリ
- **C-129 (initForOS Windows Service)**: `service.InitService` の詳細実装は `pkg/windows/service` パッケージに存在し、モジュール外の依存。Windows環境でのみテスト可能。
  - 候補：pkg/windows/service パッケージ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - badCIDRs, badBindAddress, addressFromDeprecatedFlags, isIPTablesBased 等の純粋関数は入出力が明確でテスト容易
- 0: 低リスク - detectNodeIPs は外部依存なしでテスト可能
- 0: 低リスク - processHostnameOverrideFlag, processV1Alpha1Flags は状態がOptionsに限定されテスト容易
- 1: 中リスク - checkBadConfig, checkBadIPConfig はProxyServer構造体の状態に依存するが、テスト用構造体を構築可能
- 1: 中リスク - loadConfig はスキーマ定義に依存するが、テスト用YAMLデータで検証可能
- 1: 中リスク - Linux固有コード（server_linux.go）はビルドタグ制約があり、テスト実行環境がLinuxである必要がある
- 1: 中リスク - Windows固有コード（server_windows.go）はWindows環境でのみテスト可能
- 2: 高リスク - createClient, newProxyServer はKubernetesクラスタ/APIサーバへの接続が必要で、モック化なしではテスト困難
- 2: 高リスク - serveHealthz, serveMetrics はHTTPサーバーを起動するため、ポート競合やgoroutineリークに注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] detectNodeIPs のテストケース（C-005〜C-015）がIPv4/IPv6/デュアルスタック/bindAddressの全パターンを網羅しているか
- [ ] checkBadConfig / checkBadIPConfig のテストケース（C-016〜C-029）がfatal/非fatalの区別を正しく検証しているか
- [ ] processHostnameOverrideFlag のテストケース（C-064〜C-067）が小文字変換・トリム・空白バリデーションを網羅しているか
- [ ] processV1Alpha1Flags のテストケース（C-068〜C-073）が全フラグ種別とモード条件分岐を網羅しているか
- [ ] loadConfig のlenientフォールバック（C-076, C-078）のテストデータが実際のスキーマ仕様と整合しているか
- [ ] プラットフォーム固有テスト（Linux/Windows/Other）がビルドタグを考慮した実行計画になっているか
- [ ] createClient（C-041〜C-046）のInClusterConfigテストに適切なモック/スタブが用意されるか
- [ ] getLocalDetectors（C-110〜C-116）が全DetectLocalModeの分岐を網羅しているか
- [ ] platformCleanup（C-117〜C-120）が全モード組み合わせとエラーケースを網羅しているか
