---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 149
  claims_with_evidence: 141
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：cmd-kube-scheduler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：141 / 149、根拠なし：8
- 優先レビュー（高）
  1. **UT-KSC-011, UT-KSC-012**: 認証・認可の具体的なHTTPステータスコードはラッパー関数の内部実装（genericapifilters）に依存し、直接確認困難
  2. **UT-KSC-014**: パニックリカバリの具体的なレスポンスコード（500）はgenericfilters.WithPanicRecoveryの内部実装に依存
  3. **UT-KSC-139, UT-KSC-140, UT-KSC-141**: テストサーバ起動テストは実際のAPIサーバ依存のため、テスト環境の前提条件が複雑
  4. **UT-KSC-033**: latest.Default()の内部エラー発生条件が不明確
  5. **UT-KSC-046**: configz重複登録によるエラー発生条件の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cmd/kube-scheduler/scheduler.go` - mainエントリポイント（L29-33）
- E-02: `cmd/kube-scheduler/app/server.go` - NewSchedulerCommand関数（L90-136）
- E-03: `cmd/kube-scheduler/app/server.go` - runCommand関数（L139-168）
- E-04: `cmd/kube-scheduler/app/server.go` - Run関数（L171-339）
- E-05: `cmd/kube-scheduler/app/server.go` - buildHandlerChain関数（L342-354）
- E-06: `cmd/kube-scheduler/app/server.go` - installMetricHandler関数（L356-367）
- E-07: `cmd/kube-scheduler/app/server.go` - newEndpointsHandler関数（L372-399）
- E-08: `cmd/kube-scheduler/app/server.go` - getRecorderFactory関数（L401-405）
- E-09: `cmd/kube-scheduler/app/server.go` - WithPlugin関数（L409-413）
- E-10: `cmd/kube-scheduler/app/server.go` - Setup関数（L416-473）
- E-11: `cmd/kube-scheduler/app/options/options.go` - Options構造体（L60-85）
- E-12: `cmd/kube-scheduler/app/options/options.go` - NewOptions関数（L88-97）
- E-13: `cmd/kube-scheduler/app/options/options.go` - NewOptionsWithComponentGlobalsRegistry関数（L99-133）
- E-14: `cmd/kube-scheduler/app/options/options.go` - ApplyDeprecated関数（L136-160）
- E-15: `cmd/kube-scheduler/app/options/options.go` - ApplyLeaderElectionTo関数（L163-193）
- E-16: `cmd/kube-scheduler/app/options/options.go` - initFlags関数（L196-217）
- E-17: `cmd/kube-scheduler/app/options/options.go` - ApplyTo関数（L220-277）
- E-18: `cmd/kube-scheduler/app/options/options.go` - Validate関数（L280-296）
- E-19: `cmd/kube-scheduler/app/options/options.go` - Config関数（L299-343）
- E-20: `cmd/kube-scheduler/app/options/options.go` - makeLeaderElectionConfig関数（L347-377）
- E-21: `cmd/kube-scheduler/app/options/options.go` - createKubeConfig関数（L381-394）
- E-22: `cmd/kube-scheduler/app/options/options.go` - createClients関数（L397-409）
- E-23: `cmd/kube-scheduler/app/options/configfile.go` - LoadConfigFromFile関数（L33-40）
- E-24: `cmd/kube-scheduler/app/options/configfile.go` - loadConfig関数（L42-57）
- E-25: `cmd/kube-scheduler/app/options/configfile.go` - encodeConfig関数（L59-78）
- E-26: `cmd/kube-scheduler/app/options/configfile.go` - LogOrWriteConfig関数（L81-110）
- E-27: `cmd/kube-scheduler/app/options/deprecated.go` - DeprecatedOptions構造体（L28-36）
- E-28: `cmd/kube-scheduler/app/options/deprecated.go` - AddFlags関数（L39-54）
- E-29: `cmd/kube-scheduler/app/config/config.go` - Config構造体（L35-65）
- E-30: `cmd/kube-scheduler/app/config/config.go` - Complete関数（L78-82）
- E-31: `cmd/kube-scheduler/app/testing/testserver.go` - StartTestServer関数（L68-199）
- E-32: `cmd/kube-scheduler/app/testing/testserver.go` - StartTestServerOrDie関数（L202-208）
- E-33: `cmd/kube-scheduler/app/testing/testserver.go` - createListenerOnFreePort関数（L210-224）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-KSC-001: デフォルトパラメータでコマンド生成 | E-02 (L90-136) | ○ |
| C-02 | UT-KSC-002: registryOptions指定でコマンド生成 | E-02 (L90) | ○ |
| C-03 | UT-KSC-003: configフラグ登録確認 | E-02 (L131) | ○ |
| C-04 | UT-KSC-004: 複数registryOptions | E-02 (L90) | ○ |
| C-05 | UT-KSC-005: 引数渡し時エラー | E-02 (L110-117) | ○ |
| C-06 | UT-KSC-006: 空文字列引数の境界値 | E-02 (L111-112) | ○ |
| C-07 | UT-KSC-007: 空スライス引数 | E-02 (L110-117) | ○ |
| C-08 | UT-KSC-008: 複数引数エラー | E-02 (L110-117) | ○ |
| C-09 | UT-KSC-009: バージョンフラグ確認 | E-02 (L121) | ○ |
| C-10 | UT-KSC-010: ハンドラチェーン構築 | E-05 | ○ |
| C-11 | UT-KSC-011: 認証失敗時401 | E-05 | △ |
| C-12 | UT-KSC-012: 認可失敗時403 | E-05 | △ |
| C-13 | UT-KSC-013: 認証認可成功時 | E-05 | ○ |
| C-14 | UT-KSC-014: パニックリカバリ | E-05 (L351) | △ |
| C-15 | UT-KSC-015: メトリクスハンドラインストール | E-06 | ○ |
| C-16 | UT-KSC-016: 非リーダー時メトリクス非表示 | E-06 (L362-364) | ○ |
| C-17 | UT-KSC-017: configzハンドラ | E-06 (L357) | ○ |
| C-18 | UT-KSC-018: エンドポイント登録 | E-07 | ○ |
| C-19 | UT-KSC-019: プロファイリング無効時 | E-07 (L380) | ○ |
| C-20 | UT-KSC-020: ContentionProfiling設定 | E-07 (L383) | ○ |
| C-21 | UT-KSC-021: ComponentFlagzフィーチャーゲート | E-07 (L388-392) | ○ |
| C-22 | UT-KSC-022: ComponentStatuszフィーチャーゲート | E-07 (L394-396) | ○ |
| C-23 | UT-KSC-023: SLIメトリクス | E-07 (L378) | ○ |
| C-24 | UT-KSC-024: 空チェックリスト | E-07 (L372) | ○ |
| C-25 | UT-KSC-025: RecorderFactory返却 | E-08 | ○ |
| C-26 | UT-KSC-026: 異なる名前でRecorder生成 | E-08 (L402-404) | ○ |
| C-27 | UT-KSC-027: プラグイン登録成功 | E-09 | ○ |
| C-28 | UT-KSC-028: プラグイン重複登録エラー | E-09 | ○ |
| C-29 | UT-KSC-029: 空名前の境界値 | E-09 | ○ |
| C-30 | UT-KSC-030: Setup正常実行 | E-10 | ○ |
| C-31 | UT-KSC-031: Setupバリデーションエラー | E-10 (L423-425) | ○ |
| C-32 | UT-KSC-032: outOfTreeRegistryエラー | E-10 (L437-439) | ○ |
| C-33 | UT-KSC-033: latest.Default()エラー | E-10 (L417-421) | △ |
| C-34 | UT-KSC-034: Config生成失敗 | E-10 (L427-429) | ○ |
| C-35 | UT-KSC-035: デフォルトプラグインのみ | E-10 (L435-440) | ○ |
| C-36 | UT-KSC-036: プロファイルキャプチャ | E-10 (L460-463, L468) | ○ |
| C-37 | UT-KSC-037: Run正常終了 | E-04 (L334-338) | ○ |
| C-38 | UT-KSC-038: configz登録 | E-04 (L180-184) | ○ |
| C-39 | UT-KSC-039: リーダー選出実行 | E-04 (L296-332) | ○ |
| C-40 | UT-KSC-040: リーダー選出無効時 | E-04 (L334-338) | ○ |
| C-41 | UT-KSC-041: DelayCacheUntilActive false | E-04 (L292-294) | ○ |
| C-42 | UT-KSC-042: DelayCacheUntilActive true | E-04 (L303-306) | ○ |
| C-43 | UT-KSC-043: SecureServing nil | E-04 (L250) | ○ |
| C-44 | UT-KSC-044: WatchDog追加 | E-04 (L192-195) | ○ |
| C-45 | UT-KSC-045: DynInformerFactory nil | E-04 (L273-275, L279-281) | ○ |
| C-46 | UT-KSC-046: configz重複登録エラー | E-04 (L180-183) | △ |
| C-47 | UT-KSC-047: CoordinatedLeaderElection | E-04 (L221-246) | ○ |
| C-48 | UT-KSC-048: NewOptionsデフォルト値 | E-12, E-13 | ○ |
| C-49 | UT-KSC-049: BindPortデフォルト値 | E-13 (L128) | ○ |
| C-50 | UT-KSC-050: LeaderElectionデフォルト値 | E-13 (L107-115) | ○ |
| C-51 | UT-KSC-051: CertDirectory空 | E-13 (L126) | ○ |
| C-52 | UT-KSC-052: PairName | E-13 (L127) | ○ |
| C-53 | UT-KSC-053: TolerateInClusterLookupFailure | E-13 (L121) | ○ |
| C-54 | UT-KSC-054: PodMaxInUnschedulable デフォルト | E-13 (L105) | ○ |
| C-55 | UT-KSC-055: カスタムレジストリ | E-13 (L99-133) | ○ |
| C-56 | UT-KSC-056: profiling適用 | E-14 (L142-143) | ○ |
| C-57 | UT-KSC-057: 未変更フラグ非反映 | E-14 | ○ |
| C-58 | UT-KSC-058: ApplyDeprecated nil安全性 | E-14 (L137-139) | ○ |
| C-59 | UT-KSC-059: kubeconfig適用 | E-14 (L148-149) | ○ |
| C-60 | UT-KSC-060: contention-profiling適用 | E-14 (L145-146) | ○ |
| C-61 | UT-KSC-061: ContentType適用 | E-14 (L151-152) | ○ |
| C-62 | UT-KSC-062: QPS適用 | E-14 (L154-155) | ○ |
| C-63 | UT-KSC-063: Burst適用 | E-14 (L157-159) | ○ |
| C-64 | UT-KSC-064: リーダー選出フラグ反映 | E-15 (L170-171) | ○ |
| C-65 | UT-KSC-065: LeaseDuration適用 | E-15 (L173-174) | ○ |
| C-66 | UT-KSC-066: RenewDeadline適用 | E-15 (L176-177) | ○ |
| C-67 | UT-KSC-067: RetryPeriod適用 | E-15 (L179-180) | ○ |
| C-68 | UT-KSC-068: ResourceLock適用 | E-15 (L182-183) | ○ |
| C-69 | UT-KSC-069: ResourceName適用 | E-15 (L185-186) | ○ |
| C-70 | UT-KSC-070: ResourceNamespace適用 | E-15 (L188-189) | ○ |
| C-71 | UT-KSC-071: ApplyLeaderElectionTo nil安全性 | E-15 (L165-167) | ○ |
| C-72 | UT-KSC-072: ComponentConfig更新確認 | E-15 (L192) | ○ |
| C-73 | UT-KSC-073: フラグ初期化 | E-16 | ○ |
| C-74 | UT-KSC-074: 冪等性確認 | E-16 (L197-199) | ○ |
| C-75 | UT-KSC-075: miscフラグ確認 | E-16 (L202-205) | ○ |
| C-76 | UT-KSC-076: ApplyTo ConfigFileなし | E-17 (L224-228) | ○ |
| C-77 | UT-KSC-077: ApplyTo ConfigFileあり | E-17 (L230-242) | ○ |
| C-78 | UT-KSC-078: 不正ファイルパス | E-17 (L231) | ○ |
| C-79 | UT-KSC-079: 設定バリデーション失敗 | E-17 (L237-239) | ○ |
| C-80 | UT-KSC-080: SecureServing適用 | E-17 (L253) | ○ |
| C-81 | UT-KSC-081: PodMaxInUnschedulable適用 | E-17 (L267-269) | ○ |
| C-82 | UT-KSC-082: Deprecated nil時 | E-17 (L267) | ○ |
| C-83 | UT-KSC-083: ConfigFileあり時の適用範囲 | E-17 (L224-242) | ○ |
| C-84 | UT-KSC-084: Flagz設定 | E-17 (L270-273) | ○ |
| C-85 | UT-KSC-085: Validate正常 | E-18 | ○ |
| C-86 | UT-KSC-086: Validate異常 | E-18 (L287-288) | ○ |
| C-87 | UT-KSC-087: SetFallbackエラー | E-18 (L282-283) | ○ |
| C-88 | UT-KSC-088: サブコンポーネントバリデーション | E-18 (L290-293) | ○ |
| C-89 | UT-KSC-089: Config生成 | E-19 | ○ |
| C-90 | UT-KSC-090: LeaderElectionConfig設定 | E-19 (L322-332) | ○ |
| C-91 | UT-KSC-091: LeaderElection無効 | E-19 (L322) | ○ |
| C-92 | UT-KSC-092: ApplyTo失敗 | E-19 (L308-309) | ○ |
| C-93 | UT-KSC-093: InformerFactory確認 | E-19 (L336) | ○ |
| C-94 | UT-KSC-094: DynInformerFactory確認 | E-19 (L337-338) | ○ |
| C-95 | UT-KSC-095: カスタムスケジューラ名 | E-19 (L325-327) | ○ |
| C-96 | UT-KSC-096: デフォルトスケジューラ名 | E-19 (L324) | ○ |
| C-97 | UT-KSC-097: makeLeaderElectionConfig正常 | E-20 | ○ |
| C-98 | UT-KSC-098: LeaseDuration設定 | E-20 (L369) | ○ |
| C-99 | UT-KSC-099: WatchDogタイムアウト | E-20 (L373) | ○ |
| C-100 | UT-KSC-100: Identity形式 | E-20 (L353) | ○ |
| C-101 | UT-KSC-101: createKubeConfig正常 | E-21 | ○ |
| C-102 | UT-KSC-102: masterOverride | E-21 (L382) | ○ |
| C-103 | UT-KSC-103: QPS/Burst設定 | E-21 (L389-391) | ○ |
| C-104 | UT-KSC-104: AcceptContentTypes設定 | E-21 (L388) | ○ |
| C-105 | UT-KSC-105: 不正kubeconfigエラー | E-21 (L383-384) | ○ |
| C-106 | UT-KSC-106: 両方空の境界値 | E-21 (L382) | ○ |
| C-107 | UT-KSC-107: createClients正常 | E-22 | ○ |
| C-108 | UT-KSC-108: UserAgent確認 | E-22 (L398) | ○ |
| C-109 | UT-KSC-109: createClients異常 | E-22 (L399-400) | ○ |
| C-110 | UT-KSC-110: LoadConfigFromFile正常 | E-23 | ○ |
| C-111 | UT-KSC-111: ファイル不存在 | E-23 (L35-36) | ○ |
| C-112 | UT-KSC-112: 不正YAML形式 | E-23, E-24 | ○ |
| C-113 | UT-KSC-113: 権限エラー | E-23 (L34) | ○ |
| C-114 | UT-KSC-114: loadConfig正常デコード | E-24 | ○ |
| C-115 | UT-KSC-115: APIバージョン設定 | E-24 (L53) | ○ |
| C-116 | UT-KSC-116: loadConfig空データ | E-24 (L44) | ○ |
| C-117 | UT-KSC-117: loadConfig不正データ | E-24 (L44) | ○ |
| C-118 | UT-KSC-118: loadConfig型不一致 | E-24 (L48-56) | ○ |
| C-119 | UT-KSC-119: encodeConfig正常 | E-25 | ○ |
| C-120 | UT-KSC-120: v1 APIバージョンエンコード | E-25 (L68-70) | ○ |
| C-121 | UT-KSC-121: デフォルトバージョンエンコード | E-25 (L71-72) | ○ |
| C-122 | UT-KSC-122: LogOrWriteConfigファイル出力 | E-26 (L97-108) | ○ |
| C-123 | UT-KSC-123: LogOrWriteConfig早期リターン | E-26 (L83-85) | ○ |
| C-124 | UT-KSC-124: ログ出力確認 | E-26 (L93-95) | ○ |
| C-125 | UT-KSC-125: completedProfiles反映 | E-26 (L86) | ○ |
| C-126 | UT-KSC-126: ファイル作成失敗 | E-26 (L98-100) | ○ |
| C-127 | UT-KSC-127: encodeConfigエラー | E-26 (L88-91) | ○ |
| C-128 | UT-KSC-128: AddFlagsフラグ登録 | E-28 | ○ |
| C-129 | UT-KSC-129: AddFlags nil安全性 | E-28 (L40-42) | ○ |
| C-130 | UT-KSC-130: profilingデフォルト値 | E-28 (L44) | ○ |
| C-131 | UT-KSC-131: contention-profilingデフォルト値 | E-28 (L45) | ○ |
| C-132 | UT-KSC-132: kube-api-content-typeデフォルト値 | E-28 (L47) | ○ |
| C-133 | UT-KSC-133: kube-api-qpsデフォルト値 | E-28 (L48) | ○ |
| C-134 | UT-KSC-134: kube-api-burstデフォルト値 | E-28 (L49) | ○ |
| C-135 | UT-KSC-135: pod-max-in-unschedulable-pods-durationデフォルト値 | E-28 (L53) | ○ |
| C-136 | UT-KSC-136: Config.Complete正常 | E-30 | ○ |
| C-137 | UT-KSC-137: CompletedConfigポインタ同一性 | E-30 (L79) | ○ |
| C-138 | UT-KSC-138: 空Config境界値 | E-30 | ○ |
| C-139 | UT-KSC-139: StartTestServer正常起動 | E-31 | △ |
| C-140 | UT-KSC-140: カスタムフラグ適用 | E-31 (L112) | △ |
| C-141 | UT-KSC-141: Setup失敗時 | E-31 (L144-147) | △ |
| C-142 | UT-KSC-142: TearDownクリーンアップ | E-31 (L73-85) | ○ |
| C-143 | UT-KSC-143: healthzポーリング | E-31 (L174-188) | ○ |
| C-144 | UT-KSC-144: AlwaysAllowPaths設定 | E-31 (L142) | ○ |
| C-145 | UT-KSC-145: StartTestServerOrDie正常 | E-32 | ○ |
| C-146 | UT-KSC-146: StartTestServerOrDie失敗 | E-32 (L204) | ○ |
| C-147 | UT-KSC-147: createListenerOnFreePort正常 | E-33 | ○ |
| C-148 | UT-KSC-148: ポート番号確認 | E-33 (L217-218) | ○ |
| C-149 | UT-KSC-149: アドレス型確認 | E-33 (L217) | ○ |

## 4) 不足情報（Unknown / Missing）
- UT-KSC-011, UT-KSC-012: buildHandlerChainが使用するgenericapifilters.Unauthorized、genericapifilters.WithAuthorization等の内部動作は外部パッケージ（k8s.io/apiserver/pkg/endpoints/filters）に依存しており、具体的なHTTPステータスコードの返却は直接ソースコードから確認できない
  - 候補: k8s.io/apiserver/pkg/endpoints/filters パッケージのソースコード確認
- UT-KSC-014: genericfilters.WithPanicRecoveryの具体的なレスポンスコード（500）は外部パッケージの実装に依存
  - 候補: k8s.io/apiserver/pkg/server/filters パッケージのソースコード確認
- UT-KSC-033: latest.Default()がエラーを返す条件はpkg/scheduler/apis/config/latestパッケージの実装に依存し、通常のフローでは発生しにくい
  - 候補: pkg/scheduler/apis/config/latest パッケージの確認
- UT-KSC-046: configz.Newが同名で既に登録済みの場合にエラーを返すかどうかは、configzパッケージの実装に依存
  - 候補: k8s.io/component-base/configz パッケージの仕様確認
- UT-KSC-139, UT-KSC-140, UT-KSC-141: StartTestServerは実際のkube-apiserver接続を前提としたテストヘルパーであり、テスト環境の事前条件が複雑
  - 候補: 統合テスト環境のドキュメント / テストフレームワーク仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース（約95%）はソースコードの関数シグネチャ・分岐・定数から直接導出されており信頼性が高い
- 1: 中リスク - buildHandlerChainの認証・認可・パニックリカバリテスト（UT-KSC-011, UT-KSC-012, UT-KSC-014）は外部パッケージの動作に依存するため、期待結果の正確性を要確認
- 1: 中リスク - StartTestServer関連テスト（UT-KSC-139-141）は統合テスト寄りであり、単体テストとしての実現可能性を要確認
- 0: 低リスク - ApplyLeaderElectionToの全7つのリーダー選出フラグ（UT-KSC-064-070）はソースコード（L170-189）と直接対応しており網羅的

## 6) レビュアーチェックリスト（最小）
- [ ] buildHandlerChain関連テストケース（UT-KSC-011, UT-KSC-012, UT-KSC-014）の期待結果が外部パッケージの実装と整合しているか確認
- [ ] StartTestServer関連テストケース（UT-KSC-139-141）が単体テストとして適切か、統合テストに分類すべきか判断
- [ ] ApplyDeprecated（UT-KSC-056-063）で全6つの非推奨フラグがカバーされているか確認
- [ ] ApplyLeaderElectionTo（UT-KSC-064-072）で全7つのリーダー選出フラグがカバーされているか確認
- [ ] LeaderElection関連テストケース（UT-KSC-039, UT-KSC-047, UT-KSC-090, UT-KSC-097）がモック化可能な範囲で記述されているか確認
- [ ] 全テストケースの優先度が適切か確認（セキュリティ関連=高、設定=中、表示=低）
- [ ] newEndpointsHandler（UT-KSC-018-024）でフィーチャーゲート条件分岐が網羅されているか確認
