---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 111
  claims_with_evidence: 108
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：cmd-kubelet 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：108 / 111、根拠なし：3
- 優先レビュー（高）
  1. **UT-CKL-027 (makeEventRecorder EventSink開始)**：EventBroadcasterの内部動作は外部ライブラリに依存するため、テスト観点の正確性は要確認
  2. **UT-CKL-056 (newTracerProvider 有効設定)**：TracerProviderの具体的な設定値はOTLPエクスポーター依存のため確認困難
  3. **UT-CKL-042 (InitializeTLS TLS1.3 CipherSuites)**：TLS1.3時のCipherSuites無視のログ出力はソースコードから確認できるが、テストでの検証方法に注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cmd/kubelet/app/server.go` - NewKubeletCommand関数（L139-326）
- E-02: `cmd/kubelet/app/server.go` - mergeKubeletConfigurations関数（L335-397）
- E-03: `cmd/kubelet/app/server.go` - newFlagSetWithGlobals関数（L401-408）
- E-04: `cmd/kubelet/app/server.go` - newFakeFlagSet関数（L412-419）
- E-05: `cmd/kubelet/app/server.go` - kubeletConfigFlagPrecedence関数（L425-448）
- E-06: `cmd/kubelet/app/server.go` - loadConfigFile関数（L450-479）
- E-07: `cmd/kubelet/app/server.go` - loadDropinConfigFileIntoJSON関数（L481-493）
- E-08: `cmd/kubelet/app/server.go` - setConfigz関数（L555-566）
- E-09: `cmd/kubelet/app/server.go` - initConfigz関数（L568-580）
- E-10: `cmd/kubelet/app/server.go` - makeEventRecorder関数（L583-597）
- E-11: `cmd/kubelet/app/server.go` - getReservedCPUs関数（L599-619）
- E-12: `cmd/kubelet/app/server.go` - updateDialer関数（L1069-1076）
- E-13: `cmd/kubelet/app/server.go` - kubeClientConfigOverrides関数（L1110-1115）
- E-14: `cmd/kubelet/app/server.go` - setContentTypeForClient関数（L1203-1214）
- E-15: `cmd/kubelet/app/server.go` - InitializeTLS関数（L1119-1199）
- E-16: `cmd/kubelet/app/server.go` - parseResourceList関数（L1343-1365）
- E-17: `cmd/kubelet/app/server.go` - newTracerProvider関数（L1367-1386）
- E-18: `cmd/kubelet/app/server.go` - getCgroupDriverFromCRI関数（L1388-1437）
- E-19: `cmd/kubelet/app/auth.go` - BuildAuth関数（L43-67）
- E-20: `cmd/kubelet/app/auth.go` - BuildAuthn関数（L70-114）
- E-21: `cmd/kubelet/app/auth.go` - BuildAuthz関数（L117-141）
- E-22: `cmd/kubelet/app/plugins.go` - ProbeVolumePlugins関数（L46-71）
- E-23: `cmd/kubelet/app/plugins.go` - GetDynamicPluginProber関数（L76-78）
- E-24: `cmd/kubelet/app/init_windows.go` - getPriorityValue関数（L38-48）
- E-25: `cmd/kubelet/app/server_others.go` - checkPermissions関数（L27-34）
- E-26: `cmd/kubelet/app/server_linux.go` - watchForLockfileContention関数（L26-49）
- E-27: `cmd/kubelet/app/server_unsupported.go` - watchForLockfileContention関数（L26-28）
- E-28: `cmd/kubelet/app/options/options.go` - NewKubeletFlags関数（L137-147）
- E-29: `cmd/kubelet/app/options/options.go` - ValidateKubeletFlags関数（L150-176）
- E-30: `cmd/kubelet/app/options/options.go` - isKubernetesLabel関数（L178-187）
- E-31: `cmd/kubelet/app/options/options.go` - getLabelNamespace関数（L189-194）
- E-32: `cmd/kubelet/app/options/options.go` - NewKubeletConfiguration関数（L197-210）
- E-33: `cmd/kubelet/app/options/options.go` - applyLegacyDefaults関数（L215-224）
- E-34: `cmd/kubelet/app/options/options.go` - NewKubeletServer関数（L234-243）
- E-35: `cmd/kubelet/app/options/options.go` - ValidateKubeletServer関数（L246-255）
- E-36: `cmd/kubelet/app/options/globalflags.go` - normalize関数（L44-46）
- E-37: `cmd/kubelet/app/options/globalflags.go` - register関数（L49-57）
- E-38: `cmd/kubelet/app/options/globalflags.go` - AddGlobalFlags関数（L35-40）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NewKubeletCommandがcobraコマンドを返却する | E-01 | ○ |
| C-02 | UseフィールドがComponentKubelet定数で設定される | E-01 | ○ |
| C-03 | helpフラグがFlagSetに登録される | E-01 | ○ |
| C-04 | mergeKubeletConfigurationsが単一confファイルをマージする | E-02 | ○ |
| C-05 | 複数confファイルがレキシカル順で処理される | E-02 | ○ |
| C-06 | .conf以外のファイルがskippedFilesに追加される | E-02 | ○ |
| C-07 | 不正JSONのdrop-inファイルでエラーが返る | E-02 | ○ |
| C-08 | apiVersion/kind未指定でエラーが返る | E-02 | ○ |
| C-09 | 不明GVKでエラーが返る | E-02 | ○ |
| C-10 | 空ディレクトリで元の設定が維持される | E-02 | ○ |
| C-11 | newFlagSetWithGlobalsがグローバルフラグを含むFlagSetを返す | E-03 | ○ |
| C-12 | newFakeFlagSetが同じフラグ名のFlagSetを生成する | E-04 | ○ |
| C-13 | FakeFlagSetのSetがnoopである | E-04 | ○ |
| C-14 | kubeletConfigFlagPrecedenceがフラグで設定を上書きする | E-05 | ○ |
| C-15 | FeatureGatesがマージされる | E-05 | ○ |
| C-16 | 不正フラグでエラーが返る | E-05 | ○ |
| C-17 | loadConfigFileが有効ファイルからConfigを返す | E-06 | ○ |
| C-18 | EvictionHard nilでデフォルト値が設定される | E-06 | ○ |
| C-19 | MergeDefaultEvictionSettingsでマージされる | E-06 | ○ |
| C-20 | 存在しないファイルでエラーが返る | E-06 | ○ |
| C-21 | loadDropinConfigFileIntoJSONがJSON+GVKを返す | E-07 | ○ |
| C-22 | 存在しないファイルでエラーが返る | E-07 | ○ |
| C-23 | setConfigzがconfigzに設定を反映する | E-08 | ○ |
| C-24 | initConfigzがkubeletconfigを初期化する | E-09 | ○ |
| C-25 | makeEventRecorderがnil時に新Recorderを設定する | E-10 | ○ |
| C-26 | 設定済みRecorderが変更されない | E-10 | ○ |
| C-27 | EventClient設定時にSinkが開始される | E-10 | △ |
| C-28 | getReservedCPUsが空文字列で空CPUSetを返す | E-11 | ○ |
| C-29 | 有効CPU範囲で正しいCPUSetが返る | E-11 | ○ |
| C-30 | 範囲外CPUでエラーが返る | E-11 | ○ |
| C-31 | 不正CPU形式でエラーが返る | E-11 | ○ |
| C-32 | updateDialerがDialerを設定する | E-12 | ○ |
| C-33 | Transport設定済みでエラーが返る | E-12 | ○ |
| C-34 | Dial設定済みでエラーが返る | E-12 | ○ |
| C-35 | kubeClientConfigOverridesがQPS/Burstを設定する | E-13 | ○ |
| C-36 | protobufでAcceptContentTypesが設定される | E-14 | ○ |
| C-37 | JSONでAcceptContentTypesが変更されない | E-14 | ○ |
| C-38 | 空contentTypeで変更なし | E-14 | ○ |
| C-39 | TLS未指定で自己署名証明書が生成される | E-15 | ○ |
| C-40 | 指定TLS証明書が使用される | E-15 | ○ |
| C-41 | ClientCAFile指定でClientCAsが設定される | E-15 | ○ |
| C-42 | TLS1.3でCipherSuites警告が出る | E-15 | △ |
| C-43 | 不正CipherSuitesでエラー | E-15 | ○ |
| C-44 | 不正TLSMinVersionでエラー | E-15 | ○ |
| C-45 | 不正ClientCAFileでエラー | E-15 | ○ |
| C-46 | CPUリソースがパースされる | E-16 | ○ |
| C-47 | メモリリソースがパースされる | E-16 | ○ |
| C-48 | ephemeral-storageがパースされる | E-16 | ○ |
| C-49 | 複数リソースが同時にパースされる | E-16 | ○ |
| C-50 | 空マップでnilが返る | E-16 | ○ |
| C-51 | nilマップでnilが返る | E-16 | ○ |
| C-52 | 未サポートリソースでエラー | E-16 | ○ |
| C-53 | 不正Quantity値でエラー | E-16 | ○ |
| C-54 | 負値でエラー | E-16 | ○ |
| C-55 | Tracing nil でnoopProvider | E-17 | ○ |
| C-56 | 有効Tracing設定でProvider生成 | E-17 | △ |
| C-57 | CRI systemdでCgroupDriver設定 | E-18 | ○ |
| C-58 | CRI cgroupfsでCgroupDriver設定 | E-18 | ○ |
| C-59 | CRI Unimplementedでフォールバック | E-18 | ○ |
| C-60 | LinuxConfig nilでnil返却 | E-18 | ○ |
| C-61 | 不明cgroup driverでエラー | E-18 | ○ |
| C-62 | リトライ後エラー | E-18 | ○ |
| C-63 | BuildAuthがAuthInterfaceを返す | E-19 | ○ |
| C-64 | nil clientでtokenClient/sarClientがnil | E-19 | ○ |
| C-65 | X509 CAファイルでDynamicCAContent作成 | E-20 | ○ |
| C-66 | Webhook認証でTokenAccessReviewClient設定 | E-20 | ○ |
| C-67 | Webhook認証+nil clientでエラー | E-20 | ○ |
| C-68 | Anonymous認証の反映 | E-20 | ○ |
| C-69 | AlwaysAllowモードの動作 | E-21 | ○ |
| C-70 | Webhookモードの動作 | E-21 | ○ |
| C-71 | Webhook+nil clientでエラー | E-21 | ○ |
| C-72 | 空モードでエラー | E-21 | ○ |
| C-73 | 不明モードでエラー | E-21 | ○ |
| C-74 | デフォルトプラグインが含まれる | E-22 | ○ |
| C-75 | ImageVolume有効でimageプラグイン含む | E-22 | ○ |
| C-76 | ImageVolume無効でimageプラグイン含まない | E-22 | ○ |
| C-77 | GetDynamicPluginProberが返る | E-23 | ○ |
| C-78 | getPriorityValueが有効値を返す | E-24 | ○ |
| C-79 | HIGH_PRIORITY_CLASSで正しい値 | E-24 | ○ |
| C-80 | 不明クラスで0が返る | E-24 | ○ |
| C-81 | 空文字で0が返る | E-24 | ○ |
| C-82 | root(uid=0)でnil | E-25 | ○ |
| C-83 | 非rootでエラー | E-25 | ○ |
| C-84 | 有効パスでinotifyウォッチャー設定 | E-26 | ○ |
| C-85 | 存在しないパスでエラー | E-26 | ○ |
| C-86 | 非Linuxでエラー | E-27 | ○ |
| C-87 | NewKubeletFlagsのデフォルト値 | E-28 | ○ |
| C-88 | NodeLabelsの空マップ初期化 | E-28 | ○ |
| C-89 | 有効ラベルでnil | E-29 | ○ |
| C-90 | 不明kubernetes.ioラベルでエラー | E-29 | ○ |
| C-91 | 不正ラベルキーでエラー | E-29 | ○ |
| C-92 | 不正ラベル値でエラー | E-29 | ○ |
| C-93 | 空ラベルでnil | E-29 | ○ |
| C-94 | kubernetes.ioラベルでtrue | E-30 | ○ |
| C-95 | k8s.ioラベルでtrue | E-30 | ○ |
| C-96 | サブドメイン付きでtrue | E-30 | ○ |
| C-97 | 非kubernetesラベルでfalse | E-30 | ○ |
| C-98 | 名前空間なしでfalse | E-30 | ○ |
| C-99 | 名前空間抽出 | E-31 | ○ |
| C-100 | 名前空間なしで空文字 | E-31 | ○ |
| C-101 | NewKubeletConfigurationのデフォルト | E-32 | ○ |
| C-102 | applyLegacyDefaultsのデフォルト値 | E-33 | ○ |
| C-103 | NewKubeletServerの生成 | E-34 | ○ |
| C-104 | ValidateKubeletServerの正常系 | E-35 | ○ |
| C-105 | ValidateKubeletServerの異常系 | E-35 | ○ |
| C-106 | normalizeのアンダースコア変換 | E-36 | ○ |
| C-107 | normalizeの変換不要入力 | E-36 | ○ |
| C-108 | normalizeの空文字列 | E-36 | ○ |
| C-109 | registerのフラグ登録 | E-37 | ○ |
| C-110 | registerの存在しないフラグでpanic | E-37 | ○ |
| C-111 | AddGlobalFlagsのフラグ追加 | E-38 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-27: makeEventRecorderでEventBroadcasterのSink開始動作は、`record.NewBroadcaster`および`StartRecordingToSink`の内部実装に依存する。テストでは副作用の検証が必要
  - 候補：client-goのrecordパッケージのテストを参照 / モック化によるSink開始の確認
- C-42: TLS1.3時のCipherSuites警告はログ出力のみであり、テストでのキャプチャ方法を要検討
  - 候補：klogのテスト出力キャプチャ / TLSConfig構造体の検証
- C-56: newTracerProviderの有効設定テストは、OTLPエクスポーターへの接続が必要なため、単体テストでの完全な検証が困難
  - 候補：モックサーバーの利用 / TracerProvider型の検証のみ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの制御フロー・エラーメッセージを直接根拠としており信頼性が高い
- 1: 中リスク - セキュリティ関連（TLS初期化、認証・認可）のテストケースは入力パターンの網羅性を要確認
- 0: 低リスク - Windows固有の関数（getPriorityValue, initForOS）はプラットフォーム依存のためビルドタグによる分離テストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] TLS関連テスト（UT-CKL-039〜045）の入力パターンが実運用シナリオを網羅しているか
- [ ] 認証・認可テスト（UT-CKL-063〜073）のモード組み合わせが十分か
- [ ] parseResourceList（UT-CKL-046〜054）のリソース種別がKubernetes仕様と一致しているか（PIDsリソース含む）
- [ ] getCgroupDriverFromCRI（UT-CKL-057〜062）のリトライロジックがCRIランタイムの実動作と整合しているか
- [ ] mergeKubeletConfigurations（UT-CKL-004〜010）のJSON Merge Patchの動作がRFC 7386と一致しているか
- [ ] Windows固有テスト（UT-CKL-078〜081）がWindowsビルドでのみ実行されることを確認
