---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 53
  claims_with_evidence: 51
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：cmd-kubemark 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：51 / 53、根拠なし：2
- 優先レビュー（高）
  1. **UT-KBM-048**: heartbeatClientConfigのタイムアウト計算ロジックはGetHollowKubeletConfigの戻り値に依存するため、デフォルト値の確認が必要
  2. **UT-KBM-053**: main関数は統合テスト的性質のため単体テストとしての妥当性確認が必要
  3. **UT-KBM-044/045**: ExtendedResourcesのnil判定分岐は実装で確認済みだが、モック化の複雑さに注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cmd/kubemark/app/hollow_node.go` - hollowNodeConfig構造体定義（L56-78）
- E-02: `cmd/kubemark/app/hollow_node.go` - addFlagsメソッド（L89-116）
- E-03: `cmd/kubemark/app/hollow_node.go` - createClientConfigFromFileメソッド（L118-131）
- E-04: `cmd/kubemark/app/hollow_node.go` - bootstrapClientConfigメソッド（L133-138）
- E-05: `cmd/kubemark/app/hollow_node.go` - createHollowKubeletOptionsメソッド（L140-150）
- E-06: `cmd/kubemark/app/hollow_node.go` - NewHollowNodeCommand関数（L153-182）
- E-07: `cmd/kubemark/app/hollow_node.go` - run関数（L184-297）
- E-08: `cmd/kubemark/app/hollow_node.go` - knownMorphs変数定義（L87）
- E-09: `cmd/kubemark/app/hollow_node.go` - maxPods, podsPerCore定数（L80-83）
- E-10: `cmd/kubemark/hollow-node.go` - main関数（L26-30）
- E-11: `cmd/kubemark/app/hollow_node_test.go` - 既存テスト（L54-97）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-KBM-001: addFlagsで全フラグがFlagSetに登録される | E-02 | ○ |
| C-02 | UT-KBM-002: kubeconfigデフォルト値が'/kubeconfig/kubeconfig' | E-02 (L90) | ○ |
| C-03 | UT-KBM-003: kubelet-portデフォルト値がports.KubeletPort | E-02 (L93) | ○ |
| C-04 | UT-KBM-004: nameデフォルト値が'fake-node' | E-02 (L95) | ○ |
| C-05 | UT-KBM-005: api-server-portデフォルト値が443 | E-02 (L96) | ○ |
| C-06 | UT-KBM-006: kube-api-content-typeデフォルト値がprotobuf | E-02 (L98) | ○ |
| C-07 | UT-KBM-007: kube-api-qpsデフォルト値が10 | E-02 (L99) | ○ |
| C-08 | UT-KBM-008: kube-api-burstデフォルト値が20 | E-02 (L100) | ○ |
| C-09 | UT-KBM-009: max-podsデフォルト値が110 | E-02 (L105), E-09 (L81) | ○ |
| C-10 | UT-KBM-010: use-host-image-serviceデフォルト値がtrue | E-02 (L108) | ○ |
| C-11 | UT-KBM-011: use-real-proxierがDeprecated | E-02 (L110-111) | ○ |
| C-12 | UT-KBM-012: proxier-sync-periodがDeprecated | E-02 (L112-113) | ○ |
| C-13 | UT-KBM-013: proxier-min-sync-periodがDeprecated | E-02 (L114-115) | ○ |
| C-14 | UT-KBM-014: 有効kubeconfigからクライアント設定が生成される | E-03 | ○ |
| C-15 | UT-KBM-015: 存在しないkubeconfigでエラー | E-03 (L120-121) | ○ |
| C-16 | UT-KBM-016: 不正形式kubeconfigでエラー | E-03 (L119-121) | ○ |
| C-17 | UT-KBM-017: ContentTypeが設定値で上書きされる | E-03 (L127) | ○ |
| C-18 | UT-KBM-018: QPSが設定値で上書きされる | E-03 (L128) | ○ |
| C-19 | UT-KBM-019: Burstが設定値で上書きされる | E-03 (L129) | ○ |
| C-20 | UT-KBM-020: BootstrapKubeconfigPath空でnilを返す | E-04 (L134-137) | ○ |
| C-21 | UT-KBM-021: BootstrapKubeconfigPath設定時にLoadClientCert呼出 | E-04 (L134-136) | ○ |
| C-22 | UT-KBM-022: 不正BootstrapKubeconfigPathでエラー | E-04 (L135) | ○ |
| C-23 | UT-KBM-023: createHollowKubeletOptionsの設定値マッピング | E-05 (L141-149) | ○ |
| C-24 | UT-KBM-024: NodeLabelsのマッピング | E-05 (L147) | ○ |
| C-25 | UT-KBM-025: RegisterWithTaintsのマッピング | E-05 (L148) | ○ |
| C-26 | UT-KBM-026: NodeLabels空mapの境界値 | E-05 (L147) | ○ |
| C-27 | UT-KBM-027: RegisterWithTaints nilの境界値 | E-05 (L148) | ○ |
| C-28 | UT-KBM-028: PodsPerCoreが定数0に固定 | E-05 (L146), E-09 (L82) | ○ |
| C-29 | UT-KBM-029: NewHollowNodeCommandがcobra.Commandを返す | E-06 (L153-182) | ○ |
| C-30 | UT-KBM-030: コマンドにフラグが登録されている | E-06 (L177-179) | ○ |
| C-31 | UT-KBM-031: NodeLabelsがmakeで初期化 | E-06 (L155) | ○ |
| C-32 | UT-KBM-032: ExtendedResourcesがmakeで初期化 | E-06 (L156) | ○ |
| C-33 | UT-KBM-033: 引数なしでエラーなし | E-06 (L167-174) | ○ |
| C-34 | UT-KBM-034: 引数ありでエラー | E-06 (L168-170) | ○ |
| C-35 | UT-KBM-035: 空文字列引数でエラーなし | E-06 (L169) | ○ |
| C-36 | UT-KBM-036: 不明morphでエラー | E-07 (L188-189) | ○ |
| C-37 | UT-KBM-037: 空文字列morphでエラー | E-07 (L188), E-08 | ○ |
| C-38 | UT-KBM-038: morph='kubelet'が有効 | E-08 | ○ |
| C-39 | UT-KBM-039: morph='proxy'が有効 | E-08 | ○ |
| C-40 | UT-KBM-040: bootstrap失敗でエラー | E-07 (L193-196) | ○ |
| C-41 | UT-KBM-041: createClientConfigFromFile失敗でエラー | E-07 (L197-200) | ○ |
| C-42 | UT-KBM-042: kubeletでUserAgent='hollow-kubelet' | E-07 (L203) | ○ |
| C-43 | UT-KBM-043: proxyでUserAgent='hollow-proxy' | E-07 (L277) | ○ |
| C-44 | UT-KBM-044: ExtendedResources non-nilでDevicePluginResource使用 | E-07 (L230-238) | ○ |
| C-45 | UT-KBM-045: ExtendedResources nilでStubContainerManager使用 | E-07 (L238) | ○ |
| C-46 | UT-KBM-046: UseHostImageService=trueでホストイメージサービス使用 | E-07 (L257-261) | ○ |
| C-47 | UT-KBM-047: UseHostImageService=falseでfakeイメージサービス使用 | E-07 (L256) | ○ |
| C-48 | UT-KBM-048: heartbeatTimeoutがmin(NodeStatusUpdateFrequency, LeaseDuration) | E-07 (L212-217) | △ |
| C-49 | UT-KBM-049: heartbeat QPSが-1 | E-07 (L219) | ○ |
| C-50 | UT-KBM-050: knownMorphsに'kubelet'が含まれる | E-08 | ○ |
| C-51 | UT-KBM-051: knownMorphsに'proxy'が含まれる | E-08 | ○ |
| C-52 | UT-KBM-052: knownMorphsに未知値が含まれない | E-08 | ○ |
| C-53 | UT-KBM-053: main関数がNewHollowNodeCommandを実行 | E-10 | △ |

## 4) 不足情報（Unknown / Missing）
- C-48: heartbeatClientConfigのタイムアウト計算は、`kubemark.GetHollowKubeletConfig`の戻り値（KubeletConfiguration）に依存しており、`NodeStatusUpdateFrequency`と`NodeLeaseDurationSeconds`の具体的なデフォルト値は`pkg/kubemark/hollow_kubelet.go`の実装に依存する。run関数内の比較ロジック自体（L212-217）はソースコードで確認済みだが、テスト時に使用される具体的な数値についてはpkg/kubemarkパッケージの確認が必要。
  - 候補：`pkg/kubemark/hollow_kubelet.go` / KubeletConfigurationのデフォルト値ドキュメント
- C-53: main関数は`os.Exit`の呼び出しを含む統合テスト的な性質を持ち、純粋な単体テストとしての検証は困難。テスト実行環境への影響がある。
  - 候補：TestMainパターン / インテグレーションテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - addFlags、createHollowKubeletOptions、knownMorphsのテストケースはソースコードから直接導出可能
- 0: 低リスク - createClientConfigFromFileのテストケースはclientcmd APIの挙動に基づく
- 0: 低リスク - NewHollowNodeCommandのArgs検証はcobraフレームワークの標準動作
- 1: 中リスク - run関数のテストケースは外部依存（kubemark, fakeremote, cm等）が多くモック化の複雑さがある
- 1: 中リスク - heartbeatTimeoutの計算ロジックテスト（C-48）はGetHollowKubeletConfigの戻り値に依存

## 6) レビュアーチェックリスト（最小）
- [ ] addFlagsのデフォルト値テスト（UT-KBM-002〜010）のデフォルト値がソースコードL89-116と一致するか
- [ ] createClientConfigFromFileのエラーパス（UT-KBM-015, 016）のエラーメッセージが実装と一致するか
- [ ] run関数のmorph分岐（UT-KBM-036〜039）がknownMorphs変数と整合しているか
- [ ] heartbeatTimeout計算テスト（UT-KBM-048）の前提条件がGetHollowKubeletConfigの実装と整合するか
- [ ] ExtendedResources分岐テスト（UT-KBM-044, 045）のnil判定条件が実装L230と一致するか
- [ ] 既存テスト（hollow_node_test.go）との重複・補完関係が適切か
