---
generated_at: 2026-02-02 19:10:00
metrics:
  claims_total: 176
  claims_with_evidence: 176
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：pkg-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：176 / 176、根拠なし：0
- 優先レビュー（高）
  1. **フィーチャーゲート依存のテストケース**：フィーチャーゲートの有効/無効状態によりテスト結果が異なるため、テスト環境の設定を確認する必要がある
  2. **DropDisabled系関数のテストケース**：多数のフィーチャーゲートに依存しており、組み合わせのカバレッジが十分か確認が必要
  3. **ServiceCIDR関連のテストケース**：外部依存（ServiceCIDRLister）のモック設定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/api/pod/util.go` - Pod関連ユーティリティ関数群（VisitContainers, GetPodCondition, UpdatePodCondition, DropDisabledFields等）
- E-02: `pkg/api/pod/warnings.go` - Pod警告生成関数群（GetWarningsForPod, warningsForOverlappingVirtualPaths等）
- E-03: `pkg/api/service/util.go` - Service関連ユーティリティ関数群（IsAllowAll, GetLoadBalancerSourceRanges, ExternallyAccessible等）
- E-04: `pkg/api/service/warnings.go` - Service警告生成関数群（GetWarningsForService, isHeadlessService）
- E-05: `pkg/api/persistentvolume/util.go` - PV関連ユーティリティ関数群（DropDisabledSpecFields, GetWarningsForPersistentVolume）
- E-06: `pkg/api/persistentvolumeclaim/util.go` - PVC関連ユーティリティ関数群（DropDisabledFields, EnforceDataSourceBackwardsCompatibility, NormalizeDataSources等）
- E-07: `pkg/api/node/util.go` - Node関連ユーティリティ関数群（GetNodeLabelDeprecatedMessage, GetWarningsForNodeSelector等）
- E-08: `pkg/api/storage/util.go` - Storage関連警告関数群（GetWarningsForStorageClass, GetWarningsForCSIStorageCapacity）
- E-09: `pkg/api/servicecidr/servicecidr.go` - ServiceCIDR関連関数群（PrefixContainsIP, IPToAddr, broadcastAddress等）
- E-10: `pkg/api/resourceclaimspec/util.go` - ResourceClaimSpec関連関数群（DropDisabledFields, DRAAdminAccessFeatureInUse等）
- E-11: `pkg/api/job/warnings.go` - Job警告生成関数群（WarningsForJobSpec）
- E-12: `pkg/api/v1/pod/util.go` - v1 Pod関連ユーティリティ関数群（GetContainerStatus, IsPodAvailable, ContainerShouldRestart等）
- E-13: `pkg/api/v1/endpoints/util.go` - v1 Endpoints関連関数群（RepackSubsets, LessEndpointAddress, SortSubsets）
- E-14: `pkg/api/v1/persistentvolume/util.go` - v1 PV関連関数群（VisitPVSecretNames）
- E-15: `pkg/api/v1/service/util.go` - v1 Service関連関数群（ExternalPolicyLocal, InternalPolicyLocal等）
- E-16: `pkg/api/v1/resource/helpers.go` - v1 Resource関連ヘルパー関数群（GetResourceRequest, ExtractContainerResourceValue等）
- E-17: `pkg/api/legacyscheme/scheme.go` - レガシースキーム定義（変数宣言のみ、テスト対象外）
- E-18: `pkg/api/endpoints/testing/make.go` - テストヘルパー関数群（MakeEndpoints, MakeEndpointAddress, MakeEndpointPort）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VisitContainers: 全コンテナタイプを訪問し完了する | E-01 (L64-71) | ○ |
| C-02 | VisitContainers: マスク指定でフィルタリング | E-01 (L77-97) | ○ |
| C-03 | VisitContainers: visitorがfalseで短絡 | E-01 (L66-67) | ○ |
| C-04 | VisitContainers: 空コンテナで正常終了 | E-01 (L64-71) | ○ |
| C-05 | ContainerIter: Init, Main, Ephemeral順の反復 | E-01 (L75-99) | ○ |
| C-06 | VisitPodSecretNames: ImagePullSecretsの訪問 | E-01 (L119-125) | ○ |
| C-07 | VisitPodSecretNames: 環境変数経由のシークレット | E-01 (L186-202) | ○ |
| C-08 | VisitPodSecretNames: 各ボリュームタイプのシークレット | E-01 (L129-182) | ○ |
| C-09 | VisitPodSecretNames: 短絡動作 | E-01 (L122-123) | ○ |
| C-10 | VisitPodSecretNames: 参照なしでtrue | E-01 (L119-183) | ○ |
| C-11 | VisitPodConfigmapNames: ConfigMapボリューム訪問 | E-01 (L208-232) | ○ |
| C-12 | VisitPodConfigmapNames: 環境変数経由のConfigMap | E-01 (L234-250) | ○ |
| C-13 | VisitPodConfigmapNames: 参照なしでtrue | E-01 (L208-232) | ○ |
| C-14 | IsPodReady: Ready=Trueでtrue | E-01 (L253-255) | ○ |
| C-15 | IsPodReady: Ready=Falseでfalse | E-01 (L253-261) | ○ |
| C-16 | IsPodReady: 条件なしでfalse | E-01 (L258-261) | ○ |
| C-17 | GetPodCondition: 条件の取得 | E-01 (L272-282) | ○ |
| C-18 | GetPodCondition: nilでの処理 | E-01 (L273-275) | ○ |
| C-19 | GetPodCondition: 条件不在 | E-01 (L276-281) | ○ |
| C-20 | UpdatePodCondition: 新規追加 | E-01 (L287-296) | ○ |
| C-21 | UpdatePodCondition: ステータス変更 | E-01 (L297-310) | ○ |
| C-22 | UpdatePodCondition: 変更なし | E-01 (L302-310) | ○ |
| C-23 | IsRestartableInitContainer: Always=true | E-01 (L1547-1552) | ○ |
| C-24 | IsRestartableInitContainer: nil=false | E-01 (L1548-1549) | ○ |
| C-25 | IsRestartableInitContainer: nil container=false | E-01 (L1548) | ○ |
| C-26 | ApparmorFieldForAnnotation: unconfined変換 | E-01 (L1777-1778) | ○ |
| C-27 | ApparmorFieldForAnnotation: runtime/default変換 | E-01 (L1781-1782) | ○ |
| C-28 | ApparmorFieldForAnnotation: localhost変換 | E-01 (L1785-1793) | ○ |
| C-29 | ApparmorFieldForAnnotation: 不明値=nil | E-01 (L1797) | ○ |
| C-30 | ApparmorFieldForAnnotation: 空プロファイル=nil | E-01 (L1787-1793) | ○ |
| C-31 | HasAPIObjectReference: ServiceAccountName | E-01 (L1703-1704) | ○ |
| C-32 | HasAPIObjectReference: シークレット参照 | E-01 (L1707-1711) | ○ |
| C-33 | HasAPIObjectReference: 参照なし | E-01 (L1771) | ○ |
| C-34 | GetValidationOptionsFromPodSpecAndMeta: デフォルトオプション | E-01 (L411-496) | ○ |
| C-35 | GetValidationOptionsFromPodSpecAndMeta: 後方互換性 | E-01 (L447-488) | ○ |
| C-36 | GetValidationOptionsFromPodTemplate: テンプレート経由 | E-01 (L660-674) | ○ |
| C-37 | GetValidationOptionsFromPodTemplate: nil処理 | E-01 (L661-673) | ○ |
| C-38 | DropDisabledTemplateFields: フィールド削除 | E-01 (L676-694) | ○ |
| C-39 | DropDisabledTemplateFields: 後方互換性 | E-01 (L689-693) | ○ |
| C-40 | DropDisabledPodFields: フィールド削除 | E-01 (L698-719) | ○ |
| C-41 | DropDisabledPodFields: nil処理 | E-01 (L707-718) | ○ |
| C-42 | GetWarningsForPod: 非推奨ラベル警告 | E-02 (L89-97) | ○ |
| C-43 | GetWarningsForPod: 非推奨アノテーション | E-02 (L128-140) | ○ |
| C-44 | GetWarningsForPod: 非推奨ボリューム | E-02 (L143-178) | ○ |
| C-45 | GetWarningsForPod: 警告なし | E-02 (L89-378) | ○ |
| C-46 | GetWarningsForPod: nil=nil | E-02 (L38-41) | ○ |
| C-47 | GetWarningsForPodTemplate: テンプレート警告 | E-02 (L54-68) | ○ |
| C-48 | GetWarningsForPodTemplate: nil=nil | E-02 (L55-57) | ○ |
| C-49 | warningsForOverlappingVirtualPaths: 重複パス検出 | E-02 (L415-501) | ○ |
| C-50 | warningsForOverlappingVirtualPaths: 重複なし | E-02 (L415-501) | ○ |
| C-51 | checkForOverlap: 完全一致 | E-02 (L552-573) | ○ |
| C-52 | checkForOverlap: プレフィックス重複 | E-02 (L566-569) | ○ |
| C-53 | checkForOverlap: 空パス | E-02 (L555-556) | ○ |
| C-54 | IsAllowAll: 全許可判定 | E-03 (L32-39) | ○ |
| C-55 | IsAllowAll: 非全許可判定 | E-03 (L32-39) | ○ |
| C-56 | IsAllowAll: 空セット | E-03 (L32-39) | ○ |
| C-57 | GetLoadBalancerSourceRanges: Spec | E-03 (L44-68) | ○ |
| C-58 | GetLoadBalancerSourceRanges: アノテーション | E-03 (L55-66) | ○ |
| C-59 | GetLoadBalancerSourceRanges: デフォルト | E-03 (L58-59) | ○ |
| C-60 | GetLoadBalancerSourceRanges: 不正CIDR | E-03 (L52-53) | ○ |
| C-61 | ExternallyAccessible: LoadBalancer | E-03 (L71-75) | ○ |
| C-62 | ExternallyAccessible: NodePort | E-03 (L72) | ○ |
| C-63 | ExternallyAccessible: ClusterIP+ExternalIPs | E-03 (L74) | ○ |
| C-64 | ExternallyAccessible: ClusterIPのみ | E-03 (L74) | ○ |
| C-65 | RequestsOnlyLocalTraffic: LB+Local | E-03 (L78-85) | ○ |
| C-66 | RequestsOnlyLocalTraffic: ClusterIP | E-03 (L79-81) | ○ |
| C-67 | NeedsHealthCheck: LB+Local | E-03 (L88-93) | ○ |
| C-68 | NeedsHealthCheck: 非LB | E-03 (L89-91) | ○ |
| C-69 | GetWarningsForService: 非推奨アノテーション | E-04 (L34-36) | ○ |
| C-70 | GetWarningsForService: ヘッドレス警告 | E-04 (L44-54) | ○ |
| C-71 | GetWarningsForService: nil=nil | E-04 (L29-31) | ○ |
| C-72 | GetWarningsForService: ExternalName+ExternalIPs | E-04 (L68-70) | ○ |
| C-73 | GetWarningsForService: 非推奨trafficDistribution | E-04 (L72-80) | ○ |
| C-74 | DropDisabledSpecFields(PV): フィールド削除 | E-05 (L32-38) | ○ |
| C-75 | DropDisabledSpecFields(PV): 後方互換性 | E-05 (L34-35) | ○ |
| C-76 | GetWarningsForPersistentVolume: 非推奨アノテーション | E-05 (L65-69) | ○ |
| C-77 | GetWarningsForPersistentVolume: Recycle | E-05 (L71-73) | ○ |
| C-78 | GetWarningsForPersistentVolume: nil=nil | E-05 (L41-43) | ○ |
| C-79 | DropDisabledFields(PVC): VolumeAttributesClass | E-06 (L37-44) | ○ |
| C-80 | DropDisabledFields(PVC): AnyVolumeDataSource | E-06 (L46-52) | ○ |
| C-81 | EnforceDataSourceBackwardsCompatibility: 不正DS削除 | E-06 (L76-99) | ○ |
| C-82 | EnforceDataSourceBackwardsCompatibility: PVC保持 | E-06 (L96-98) | ○ |
| C-83 | NormalizeDataSources: DS->DSRef同期 | E-06 (L162-190) | ○ |
| C-84 | NormalizeDataSources: DSRef->DS同期 | E-06 (L177-189) | ○ |
| C-85 | GetWarningsForPersistentVolumeClaim: 非推奨アノテーション | E-06 (L192-212) | ○ |
| C-86 | GetWarningsForPersistentVolumeClaim: nil=nil | E-06 (L195-197) | ○ |
| C-87 | GetWarningsForPersistentVolumeClaimSpec: 分数バイト値 | E-06 (L214-229) | ○ |
| C-88 | DropDisabledFieldsFromStatus(PVC): VolumeAttributesClass | E-06 (L54-74) | ○ |
| C-89 | GetNodeLabelDeprecatedMessage: 非推奨ラベル | E-07 (L42-45) | ○ |
| C-90 | GetNodeLabelDeprecatedMessage: 非非推奨ラベル | E-07 (L42-45) | ○ |
| C-91 | GetWarningsForRuntimeClass: 非推奨ラベル警告 | E-07 (L47-60) | ○ |
| C-92 | GetWarningsForRuntimeClass: nil=空 | E-07 (L50) | ○ |
| C-93 | GetWarningsForNodeSelector: MatchExpressions警告 | E-07 (L64-92) | ○ |
| C-94 | GetWarningsForNodeSelector: nil=nil | E-07 (L65-67) | ○ |
| C-95 | GetWarningsForNodeSelectorTerm: 非推奨ラベル | E-07 (L95-125) | ○ |
| C-96 | GetWarningsForNodeSelectorTerm: ラベル値検証 | E-07 (L110-122) | ○ |
| C-97 | GetWarningsForStorageClass: 非推奨ラベル | E-08 (L27-42) | ○ |
| C-98 | GetWarningsForStorageClass: nil=空 | E-08 (L30) | ○ |
| C-99 | GetWarningsForCSIStorageCapacity: 非推奨ラベル | E-08 (L44-49) | ○ |
| C-100 | GetWarningsForCSIStorageCapacity: nil=nil | E-08 (L45-48) | ○ |
| C-101 | PrefixContainsIP: 包含判定 | E-09 (L100-113) | ○ |
| C-102 | PrefixContainsIP: ネットワークアドレス除外 | E-09 (L102-103) | ○ |
| C-103 | PrefixContainsIP: ブロードキャスト除外 | E-09 (L106-110) | ○ |
| C-104 | PrefixContainsIP: 範囲外 | E-09 (L112) | ○ |
| C-105 | PrefixContainsIP: IPv6 | E-09 (L100-113) | ○ |
| C-106 | IPToAddr: IPv4変換 | E-09 (L146-158) | ○ |
| C-107 | IPToAddr: IPv6変換 | E-09 (L146-158) | ○ |
| C-108 | IPToAddr: nil=空Addr | E-09 (L151-157) | ○ |
| C-109 | DropDisabledFields(RCS): DRAPrioritizedList無効時FirstAvailable削除 | E-10 (L75-86) | ○ |
| C-110 | DropDisabledFields(RCS): DRADeviceTaints無効時Tolerations削除 | E-10 (L40-54) | ○ |
| C-111 | DropDisabledFields(RCS): 後方互換性 | E-10 (L79-81) | ○ |
| C-112 | DRAAdminAccessFeatureInUse: AdminAccess設定=true | E-10 (L117-129) | ○ |
| C-113 | DRAAdminAccessFeatureInUse: nil=false | E-10 (L118-120) | ○ |
| C-114 | DRAConsumableCapacityFeatureInUse: DistinctAttribute=true | E-10 (L154-177) | ○ |
| C-115 | DRAConsumableCapacityFeatureInUse: nil=false | E-10 (L155-157) | ○ |
| C-116 | WarningsForJobSpec: 高Completions+高Parallelism警告 | E-11 (L36-52) | ○ |
| C-117 | WarningsForJobSpec: 閾値以下で警告なし | E-11 (L41) | ○ |
| C-118 | v1 VisitContainers: 全コンテナ訪問 | E-12 (L72-79) | ○ |
| C-119 | v1 VisitPodSecretNames: シークレット訪問 | E-12 (L113-179) | ○ |
| C-120 | v1 VisitPodConfigmapNames: ConfigMap訪問 | E-12 (L181-238) | ○ |
| C-121 | GetContainerStatus: 存在する名前 | E-12 (L251-258) | ○ |
| C-122 | GetContainerStatus: 不在の名前 | E-12 (L251-258) | ○ |
| C-123 | GetExistingContainerStatus: 存在する名前 | E-12 (L260-268) | ○ |
| C-124 | GetIndexOfContainerStatus: 存在する名前 | E-12 (L269-276) | ○ |
| C-125 | GetIndexOfContainerStatus: 不在の名前 | E-12 (L269-276) | ○ |
| C-126 | IsPodAvailable: Ready+minReadySeconds=0 | E-12 (L283-294) | ○ |
| C-127 | IsPodAvailable: minReadySeconds経過後 | E-12 (L290) | ○ |
| C-128 | IsPodAvailable: minReadySeconds未経過 | E-12 (L290) | ○ |
| C-129 | IsPodAvailable: NotReady | E-12 (L284-286) | ○ |
| C-130 | IsPodTerminal: Failed | E-12 (L302-304) | ○ |
| C-131 | IsPodTerminal: Succeeded | E-12 (L307-309) | ○ |
| C-132 | IsPodTerminal: Running | E-12 (L307-309) | ○ |
| C-133 | IsPodPhaseTerminal: 各Phase判定 | E-12 (L307-309) | ○ |
| C-134 | v1 IsRestartableInitContainer: Always=true | E-12 (L392-397) | ○ |
| C-135 | IsContainerRestartable: Container=Always | E-12 (L403-413) | ○ |
| C-136 | IsContainerRestartable: Container=Never | E-12 (L410) | ○ |
| C-137 | IsContainerRestartable: Podレベルフォールバック | E-12 (L412) | ○ |
| C-138 | ContainerShouldRestart: Always+exit=0 | E-12 (L449-451) | ○ |
| C-139 | ContainerShouldRestart: OnFailure+exit=1 | E-12 (L441) | ○ |
| C-140 | ContainerShouldRestart: OnFailure+exit=0 | E-12 (L441) | ○ |
| C-141 | ContainerShouldRestart: Podレベルフォールバック | E-12 (L449-451) | ○ |
| C-142 | FindMatchingContainerRestartRule: In match | E-12 (L465-489) | ○ |
| C-143 | FindMatchingContainerRestartRule: NotIn match | E-12 (L478-480) | ○ |
| C-144 | FindMatchingContainerRestartRule: マッチなし | E-12 (L488) | ○ |
| C-145 | AllContainersCouldRestart: RestartAllContainersあり | E-12 (L494-513) | ○ |
| C-146 | AllContainersCouldRestart: nil=false | E-12 (L495-497) | ○ |
| C-147 | CalculatePodStatusObservedGeneration: 既存ObservedGeneration | E-12 (L521-526) | ○ |
| C-148 | CalculatePodConditionObservedGeneration: FG有効時 | E-12 (L534-547) | ○ |
| C-149 | CalculatePodConditionObservedGeneration: nil=0 | E-12 (L535-537) | ○ |
| C-150 | v1 UpdatePodCondition: 新規追加 | E-12 (L340-362) | ○ |
| C-151 | v1 GetPodConditionFromList: 条件取得 | E-12 (L316-327) | ○ |
| C-152 | v1 GetPodConditionFromList: nilリスト | E-12 (L316-327) | ○ |
| C-153 | IsContainersReadyConditionTrue: True判定 | E-12 (L375-381) | ○ |
| C-154 | RepackSubsets: 重複統合 | E-13 (L35-87) | ○ |
| C-155 | RepackSubsets: 空入力 | E-13 (L35-87) | ○ |
| C-156 | RepackSubsets: ポートなし | E-13 (L41-43) | ○ |
| C-157 | LessEndpointAddress: IP比較 | E-13 (L176-188) | ○ |
| C-158 | LessEndpointAddress: UID比較 | E-13 (L187) | ○ |
| C-159 | LessEndpointAddress: nil TargetRef | E-13 (L180-185) | ○ |
| C-160 | SortSubsets: ソート | E-13 (L192-201) | ○ |
| C-161 | VisitPVSecretNames: CSI参照 | E-14 (L128-155) | ○ |
| C-162 | VisitPVSecretNames: AzureFile名前空間 | E-14 (L51-61) | ○ |
| C-163 | VisitPVSecretNames: 参照なし | E-14 (L47-157) | ○ |
| C-164 | v1 IsAllowAll: 全許可 | E-15 (L32-39) | ○ |
| C-165 | v1 GetLoadBalancerSourceRanges: Spec | E-15 (L44-68) | ○ |
| C-166 | ExternalPolicyLocal: LB+Local | E-15 (L78-83) | ○ |
| C-167 | InternalPolicyLocal: Local | E-15 (L86-91) | ○ |
| C-168 | InternalPolicyLocal: nil | E-15 (L87-89) | ○ |
| C-169 | v1 NeedsHealthCheck: LB+Local | E-15 (L94-99) | ○ |
| C-170 | GetResourceRequestQuantity: CPU DecimalSI | E-16 (L33-61) | ○ |
| C-171 | GetResourceRequestQuantity: Memory BinarySI | E-16 (L39) | ○ |
| C-172 | GetResourceRequestQuantity: Overhead加算 | E-16 (L50-57) | ○ |
| C-173 | GetResourceRequest: Pods=1 | E-16 (L64-76) | ○ |
| C-174 | GetResourceRequest: CPU MilliValue | E-16 (L71-73) | ○ |
| C-175 | ExtractContainerResourceValue: limits.cpu | E-16 (L114-115) | ○ |
| C-176 | ExtractContainerResourceValue: requests.memory | E-16 (L121-122) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースにソースコード上の根拠あり。根拠不足の項目はなし。
- ただし、以下の点は実際のテスト実装時に確認が必要：
  - フィーチャーゲートの組み合わせテスト（DropDisabled系関数で多数のフィーチャーゲートが関係）
  - ServiceCIDR関連関数のモック設定（外部依存のServiceCIDRLister）
  - テストヘルパー関数（endpoints/testing/make.go）のテスト優先度の妥当性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの関数シグネチャと分岐ロジックから直接導出
- 1: 中リスク - フィーチャーゲート依存のテストケースは、テスト実行環境のフィーチャーゲート設定に依存する。実際のテスト実装時にフィーチャーゲートのモック/設定が必要
- 0: 低リスク - OverlapsPrefix, ContainsPrefix, ContainsAddress等のServiceCIDR関数はListerインターフェースのモックが必要だが、テスト対象から除外済み（外部依存が大きいため、PrefixContainsIPとIPToAddrのみテスト対象とした）

## 6) レビュアーチェックリスト（最小）
- [ ] 各サブパッケージ（pod, service, persistentvolume, persistentvolumeclaim, node, storage, servicecidr, resourceclaimspec, job, v1/pod, v1/endpoints, v1/persistentvolume, v1/service, v1/resource, endpoints/testing）の主要public関数がテストケースに含まれているか
- [ ] 正常系・異常系・境界値の各観点が適切にカバーされているか
- [ ] フィーチャーゲート依存のテストケースに対して、テスト環境でのフィーチャーゲート設定方法が明確か
- [ ] nil入力に対するテストケースが各関数に含まれているか
- [ ] legacyscheme/scheme.goが変数宣言のみでテスト対象外としたことが妥当か
- [ ] testing/サブパッケージ内のテストヘルパー（fuzzer.go, conversion.go等）がテスト対象外としたことが妥当か
