---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 68
  claims_with_evidence: 65
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：pkg-auth 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（pkg-auth.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：65 / 68、根拠なし：3
- 優先レビュー（高）
  1. **UT-AUT-008（v0ポリシーマイグレーション）**：v0形式のポリシーファイルの具体的なフォーマット詳細がpkg/auth内のコードだけでは確認困難
  2. **UT-AUT-010（認識不能オブジェクト型）**：型アサーション失敗の具体的な入力条件の再現方法が不明確
  3. **UT-AUT-012（Scheme.Convert失敗）**：Convert失敗を再現する具体的な入力データの特定が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/auth/authorizer/abac/abac.go` - ABAC認可モジュール（policyLoadError, NewFromFile, matches, subjectMatches, verbMatches, nonResourceMatches, resourceMatches, Authorize, RulesFor, getVerbs）
- E-02: `pkg/auth/nodeidentifier/default.go` - デフォルトノード識別（NewDefaultNodeIdentifier, defaultNodeIdentifier, NodeIdentity）
- E-03: `pkg/auth/nodeidentifier/interfaces.go` - NodeIdentifierインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-AUT-001: policyLoadError.Error()でline>=0の場合にパス・行番号・データ・エラーを含むメッセージが返る | E-01 (L46-51) | ○ |
| C-02 | UT-AUT-002: policyLoadError.Error()でline<0の場合にパス・エラーのみのメッセージが返る | E-01 (L46-51) | ○ |
| C-03 | UT-AUT-003: line=0の境界値で行番号を含むメッセージが返る | E-01 (L47: `if p.line >= 0`) | ○ |
| C-04 | UT-AUT-004: 存在しないファイルパスでos.Openがエラーを返す | E-01 (L62-64) | ○ |
| C-05 | UT-AUT-005: 空ファイルで空PolicyListが返る | E-01 (L68-69, L118) | ○ |
| C-06 | UT-AUT-006: コメント行・空行がスキップされる | E-01 (L81-84) | ○ |
| C-07 | UT-AUT-007: バージョン付きポリシーファイルの正常読み込み | E-01 (L86-108) | ○ |
| C-08 | UT-AUT-008: v0ポリシーのマイグレーション読み込み | E-01 (L87-101) | △ |
| C-09 | UT-AUT-009: 不正JSONでpolicyLoadErrorが返る | E-01 (L86-90) | ○ |
| C-10 | UT-AUT-010: 認識不能オブジェクト型でpolicyLoadErrorが返る | E-01 (L104-106) | △ |
| C-11 | UT-AUT-011: v0形式へのDecodeInto失敗でpolicyLoadErrorが返る | E-01 (L94-96) | ○ |
| C-12 | UT-AUT-012: Scheme.Convert失敗でpolicyLoadErrorが返る | E-01 (L97-99) | △ |
| C-13 | UT-AUT-013: scanner.Err()エラーでpolicyLoadError(line=-1)が返る | E-01 (L115-117) | ○ |
| C-14 | UT-AUT-014: 複数行ポリシーの順次読み込み | E-01 (L75-109: forループ) | ○ |
| C-15 | UT-AUT-015: subjectMatchesでuser=nilの場合falseが返る | E-01 (L140-142) | ○ |
| C-16 | UT-AUT-016: User="*"でワイルドカードマッチ | E-01 (L148-149) | ○ |
| C-17 | UT-AUT-017: User完全一致でtrueが返る | E-01 (L150-151) | ○ |
| C-18 | UT-AUT-018: User不一致でfalseが返る | E-01 (L151-154) | ○ |
| C-19 | UT-AUT-019: Group="*"でワイルドカードマッチ | E-01 (L162-163) | ○ |
| C-20 | UT-AUT-020: Group一致でtrueが返る | E-01 (L164-168) | ○ |
| C-21 | UT-AUT-021: Group不一致でfalseが返る | E-01 (L170-172) | ○ |
| C-22 | UT-AUT-022: User/Group両方未指定でfalseが返る | E-01 (L147, L159, L176: matchedがfalseのまま) | ○ |
| C-23 | UT-AUT-023: 空グループリストでfalseが返る | E-01 (L164: rangeループがスキップされる) | ○ |
| C-24 | UT-AUT-024: User+Group両方一致でtrueが返る | E-01 (L147-176: User条件とGroup条件の順次評価) | ○ |
| C-25 | UT-AUT-025: User一致でもGroup不一致でfalseが返る | E-01 (L170-172) | ○ |
| C-26 | UT-AUT-026: ReadOnlyリクエストでtrueが返る | E-01 (L183-185) | ○ |
| C-27 | UT-AUT-027: 書き込みリクエストでReadonly=falseの場合trueが返る | E-01 (L188-190) | ○ |
| C-28 | UT-AUT-028: 書き込みリクエストでReadonly=trueの場合falseが返る | E-01 (L192) | ○ |
| C-29 | UT-AUT-029: 非リソースリクエストでパスワイルドカードマッチ | E-01 (L198-201) | ○ |
| C-30 | UT-AUT-030: 非リソースリクエストで完全一致マッチ | E-01 (L203-204) | ○ |
| C-31 | UT-AUT-031: 非リソースリクエストで末尾ワイルドカードマッチ | E-01 (L207-208) | ○ |
| C-32 | UT-AUT-032: 非リソースパス不一致でfalseが返る | E-01 (L211) | ○ |
| C-33 | UT-AUT-033: リソースリクエストで非リソースマッチがfalseになる | E-01 (L197: `if !a.IsResourceRequest()`) | ○ |
| C-34 | UT-AUT-034: 末尾ワイルドカードでプレフィックス不一致 | E-01 (L207: HasSuffix+HasPrefixの条件) | ○ |
| C-35 | UT-AUT-035: リソース全ワイルドカードマッチ | E-01 (L217-220) | ○ |
| C-36 | UT-AUT-036: リソース完全一致マッチ | E-01 (L217-220) | ○ |
| C-37 | UT-AUT-037: Namespace不一致でfalseが返る | E-01 (L217) | ○ |
| C-38 | UT-AUT-038: Resource不一致でfalseが返る | E-01 (L218) | ○ |
| C-39 | UT-AUT-039: APIGroup不一致でfalseが返る | E-01 (L219) | ○ |
| C-40 | UT-AUT-040: 非リソースリクエストでリソースマッチがfalseになる | E-01 (L216: `if a.IsResourceRequest()`) | ○ |
| C-41 | UT-AUT-041: matches関数で全条件一致（リソース）の場合trueが返る | E-01 (L121-134) | ○ |
| C-42 | UT-AUT-042: matches関数で全条件一致（非リソース）の場合trueが返る | E-01 (L121-134) | ○ |
| C-43 | UT-AUT-043: subjectMatches不一致でfalseが返る | E-01 (L122) | ○ |
| C-44 | UT-AUT-044: verbMatches不一致でfalseが返る | E-01 (L123) | ○ |
| C-45 | UT-AUT-045: リソース/非リソース両方不一致でfalseが返る | E-01 (L125-130, L133) | ○ |
| C-46 | UT-AUT-046: Authorizeでマッチ時にDecisionAllowが返る | E-01 (L229-234) | ○ |
| C-47 | UT-AUT-047: Authorizeで不一致時にDecisionNoOpinionが返る | E-01 (L235) | ○ |
| C-48 | UT-AUT-048: 空PolicyListでDecisionNoOpinionが返る | E-01 (L230: rangeが空でスキップ, L235) | ○ |
| C-49 | UT-AUT-049: 複数ポリシーの順次評価 | E-01 (L230-234: forループ) | ○ |
| C-50 | UT-AUT-050: RulesForでリソースルール抽出 | E-01 (L248-259) | ○ |
| C-51 | UT-AUT-051: RulesForで非リソースルール抽出 | E-01 (L260-267) | ○ |
| C-52 | UT-AUT-052: 空PolicyListでRulesForが空スライスを返す | E-01 (L248: rangeが空でスキップ, L271) | ○ |
| C-53 | UT-AUT-053: Namespace="*"で任意namespaceにマッチ | E-01 (L250) | ○ |
| C-54 | UT-AUT-054: Namespace不一致でルールに含まれない | E-01 (L250) | ○ |
| C-55 | UT-AUT-055: Readonly=trueでget/list/watchのVerbsが返る | E-01 (L253, L274-277) | ○ |
| C-56 | UT-AUT-056: Readonly=falseでワイルドカードVerbsが返る | E-01 (L253, L274-278) | ○ |
| C-57 | UT-AUT-057: subject不一致で空ルールが返る | E-01 (L249) | ○ |
| C-58 | UT-AUT-058: Resource指定のみでResourceRuleInfoのみ返る | E-01 (L251-259, L260: len(NonResourcePath) > 0の条件) | ○ |
| C-59 | UT-AUT-059: getVerbsでisReadOnly=trueの場合 | E-01 (L275-276) | ○ |
| C-60 | UT-AUT-060: getVerbsでisReadOnly=falseの場合 | E-01 (L278) | ○ |
| C-61 | UT-AUT-061: NewDefaultNodeIdentifierの戻り値 | E-02 (L29-31) | ○ |
| C-62 | UT-AUT-062: NodeIdentityでu=nilの場合 | E-02 (L44-46) | ○ |
| C-63 | UT-AUT-063: NodeIdentityで正常なノード識別 | E-02 (L48-65) | ○ |
| C-64 | UT-AUT-064: NodeIdentityでプレフィックス不一致 | E-02 (L49-51) | ○ |
| C-65 | UT-AUT-065: NodeIdentityでグループ不一致 | E-02 (L54-62) | ○ |
| C-66 | UT-AUT-066: NodeIdentityで空グループリスト | E-02 (L54: rangeが空でスキップ) | ○ |
| C-67 | UT-AUT-067: NodeIdentityでノード名が空 | E-02 (L64: TrimPrefixで空文字列が返る) | ○ |
| C-68 | UT-AUT-068: NodeIdentityで複数グループからの検索 | E-02 (L54-58: forループ) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-08 (UT-AUT-008)**: v0形式ポリシーの具体的なフォーマットは `k8s.io/kubernetes/pkg/apis/abac/v0` パッケージに定義されており、pkg/auth内だけでは完全なフォーマット仕様を確認できない
  - 候補：`pkg/apis/abac/v0/types.go` / `pkg/apis/abac/v0/conversion.go` / `pkg/apis/abac/latest/`
- **C-10 (UT-AUT-010)**: デコードは成功するが `*abac.Policy` 型でないオブジェクトが返される具体的なケースの特定が困難
  - 候補：`k8s.io/apimachinery/pkg/runtime` のデコーダ仕様 / 異なるkind/versionの登録済みオブジェクト
- **C-12 (UT-AUT-012)**: `abac.Scheme.Convert` が失敗する具体的な入力条件の特定が困難。v0形式からの変換ロジックは外部パッケージに依存
  - 候補：`pkg/apis/abac/v0/conversion.go` / `k8s.io/apimachinery/pkg/runtime/scheme.go`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストケースの大部分（65/68）はソースコードの該当行から直接根拠を確認可能
- **1 (中リスク)**: NewFromFile関数のテスト（UT-AUT-004〜014）はファイルI/Oに依存するため、テスト実装時にテンポラリファイルの作成が必要
- **1 (中リスク)**: v0ポリシーマイグレーション関連テスト（UT-AUT-008, 011, 012）は外部パッケージ依存のため、テストデータの準備に注意が必要
- **0 (低リスク)**: nodeidentifierパッケージのテストケースはすべてソースコードから直接根拠を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 全68テストケースが pkg/auth 配下の3ファイル（abac.go, default.go, interfaces.go）を適切にカバーしているか
- [ ] subjectMatches関数のUser/Group組み合わせパターンが網羅されているか（User指定+Group指定、User指定+Group未指定、User未指定+Group指定、両方未指定）
- [ ] NewFromFile関数の全エラーパス（os.Open失敗、デコードエラー、型アサーション失敗、DecodeInto失敗、Convert失敗、scanner.Err）がカバーされているか
- [ ] NodeIdentity関数の全分岐（nil, プレフィックス不一致, グループ不一致, 正常）がカバーされているか
- [ ] 根拠不足のC-08, C-10, C-12について、外部パッケージの仕様を確認して入力値・期待結果の妥当性を検証すること
