---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 27
  claims_with_evidence: 25
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：pkg-certauthorization 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：25 / 27、根拠なし：2
- 優先レビュー（高）
  1. **C-25 (UT-CRT-025)**：空文字列signerNameの場合のstrings.Split結果は推測に基づく
  2. **C-26 (UT-CRT-026)**：スラッシュのみsignerNameの場合のstrings.Split結果は推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/certauthorization/certauthorization.go` - IsAuthorizedForSignerName関数定義（L34-57）
- E-02: `pkg/certauthorization/certauthorization.go` - buildAttributes関数定義（L59-69）
- E-03: `pkg/certauthorization/certauthorization.go` - buildWildcardAttributes関数定義（L71-75）
- E-04: `pkg/certauthorization/certauthorization.go` - import文（L19-26）: authorizer.Authorizer, user.Info, strings パッケージの使用
- E-05: `pkg/certauthorization/certauthorization.go` - IsAuthorizedForSignerName関数のGoDoc（L28-33）: ワイルドカード認可の仕様説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | signerNameに対してAllow権限がある場合にtrueが返る | E-01 (L38, L42) | ○ |
| C-02 | 明示DenyでもワイルドカードAllowでtrueが返る | E-01 (L47-53), E-05 | ○ |
| C-03 | 両方Denyでfalseが返る | E-01 (L56) | ○ |
| C-04 | 第1段階エラーでワイルドカードチェックにフォールバック | E-01 (L39-40, L47) | ○ |
| C-05 | 両方エラーでfalseが返る（安全側に倒す） | E-01 (L39-40, L50-51, L56) | ○ |
| C-06 | DecisionNoOpinionでワイルドカードに進む | E-01 (L38-43: switchでDecisionAllowのみtrue) | ○ |
| C-07 | 異なるverb（approve）での認可チェック | E-01 (L36: verbを引数として受け取る) | ○ |
| C-08 | スラッシュなしsignerNameのワイルドカード動作 | E-03 (L72: strings.Split) | ○ |
| C-09 | 複数スラッシュsignerNameのワイルドカード動作 | E-03 (L72-73: parts[0]を使用) | ○ |
| C-10 | 完全一致Allowの場合Authorizerが1回のみ呼ばれる | E-01 (L42: return true で早期リターン) | ○ |
| C-11 | ワイルドカードチェックでエラーの場合falseが返る | E-01 (L50-51, L56) | ○ |
| C-12 | Authorizerに渡されるAttributesのsignerNameが正しい | E-01 (L36-47), E-02, E-03 | ○ |
| C-13 | buildAttributesが正しいAttributesRecordを構築 | E-02 (L60-68) | ○ |
| C-14 | APIGroupがcertificates.k8s.ioであること | E-02 (L64) | ○ |
| C-15 | Resourceがsignersであること | E-02 (L66) | ○ |
| C-16 | ResourceRequestがtrueであること | E-02 (L67) | ○ |
| C-17 | APIVersionが*であること | E-02 (L65) | ○ |
| C-18 | user.Infoが正しくAttributesに設定される | E-02 (L61: User: info) | ○ |
| C-19 | 空文字列signerNameでのbuildAttributes | E-02 (L63: Nameにそのまま設定) | ○ |
| C-20 | 空文字列verbでのbuildAttributes | E-02 (L62: Verbにそのまま設定) | ○ |
| C-21 | kubernetes.io/kube-apiserver-clientのワイルドカード化 | E-03 (L72-74) | ○ |
| C-22 | example.com/my-signerのワイルドカード化 | E-03 (L72-74) | ○ |
| C-23 | スラッシュなしsignerNameのワイルドカードAttributes | E-03 (L72: Splitの結果parts[0]が全体) | ○ |
| C-24 | 複数スラッシュのワイルドカードAttributes | E-03 (L72-73: parts[0]が最初のスラッシュ前) | ○ |
| C-25 | 空文字列signerNameのワイルドカードAttributes結果が"/*" | E-03 | △ |
| C-26 | スラッシュのみsignerNameのワイルドカードAttributes結果が"/*" | E-03 | △ |
| C-27 | ワイルドカード版でもAPIGroup/Resource/ResourceRequestが同一 | E-03 (L74: buildAttributesを呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-25, C-26: 空文字列やスラッシュのみの入力に対する`strings.Split`の動作結果は、Go標準ライブラリの仕様に基づく推測です。`strings.Split("", "/")`は`[""]`を返し、`strings.Split("/", "/")`は`["", ""]`を返すため、いずれも`parts[0]`は`""`となり、結果は`"/*"`になると推測されます。ただし、実際のコード実行による検証は行っていません。
  - 候補：Go標準ライブラリのstrings.Splitドキュメント / 実行テストによる検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュール全体が1ファイル・3関数と小規模であり、ロジックが明確
- 0: 低リスク - buildAttributesは固定値の設定のみであり、テスト観点は網羅的
- 1: 中リスク - 境界値（空文字列、スラッシュのみ）のテストケースは推測に基づくため、実行検証が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] IsAuthorizedForSignerNameの正常系・異常系・境界値が網羅されているか確認
- [ ] authz.Authorizeのモック戦略（Allow/Deny/Error/NoOpinion）が適切か確認
- [ ] buildWildcardAttributesの境界値（空文字列、スラッシュなし、複数スラッシュ）が妥当か確認
- [ ] 空文字列・スラッシュのみの入力に対するstrings.Splitの実際の動作を検証
- [ ] テストケースの優先度（高/中/低）が適切か確認
- [ ] user.Infoの引き渡しテスト（C-18）が十分な属性をカバーしているか確認
