---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 170
  claims_with_evidence: 164
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：pkg-controller 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：164 / 170、根拠なし：6
- 優先レビュー（高）
  1. **UT-CTL-072 (ActivePodsWithRanks LogarithmicScaleDown UID比較)**：LogarithmicScaleDown feature gateの有効化条件の検証が必要
  2. **UT-CTL-071 (ActivePodsWithRanks pod-deletion-cost)**：PodDeletionCost feature gateの有効化条件の検証が必要
  3. **UT-CTL-144 (matchSuccessPolicy SucceededCount)**：JobSuccessPolicy feature gateの動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/controller/controller_utils.go` - ControllerExpectations, ControlleeExpectations, UIDTrackingControllerExpectations, Pod/RSフィルタ関数, ソート関数, ComputeHash, GetPodFromTemplate, validateControllerRef, PodKey, PodControllerIndexKey, FilterPodsByOwner, afterOrZero, logarithmicRankDiff, maxContainerRestarts, compareMaxContainerRestarts, getPodsLabelSet, getPodsAnnotationSet, getPodsPrefix, FindMinNextPodAvailabilityCheck
- E-02: `pkg/controller/controller_ref_manager.go` - BaseControllerRefManager, PodControllerRefManager, ReplicaSetControllerRefManager, ControllerRevisionControllerRefManager, RecheckDeletionTimestamp, GenerateDeleteOwnerRefStrategicMergeBytes, ownerRefControllerPatch
- E-03: `pkg/controller/history/controller_history.go` - ControllerRevisionName, ControllerRevisionControllerIndexKey, AddControllerRevisionControllerIndexer
- E-04: `pkg/controller/statefulset/stateful_set_utils.go` - getParentNameAndOrdinal, getStartOrdinal, getEndOrdinal, overlappingStatefulSets, statefulPodRegex
- E-05: `pkg/controller/cronjob/utils.go` - inActiveList, inActiveListByName, deleteFromActiveList, missedSchedulesType
- E-06: `pkg/controller/job/pod_failure_policy.go` - matchPodFailurePolicy, matchOnExitCodes, matchOnPodConditions
- E-07: `pkg/controller/job/success_policy.go` - matchSuccessPolicy, matchSucceededIndexesRule, hasSuccessCriteriaMetCondition
- E-08: `pkg/controller/job/indexed_job_utils.go` - isIndexedJob, hasBackoffLimitPerIndex, calculateSucceededIndexes
- E-09: `pkg/controller/job/backoff_utils.go` - backoffStore, backoffRecord
- E-10: `pkg/controller/garbagecollector/uid_cache.go` - ReferenceCache, NewReferenceCache
- E-11: `pkg/controller/garbagecollector/graph.go` - objectReference, node
- E-12: `pkg/controller/tainteviction/timed_workers.go` - WorkArgs, NewWorkArgs, TimedWorker, createWorker
- E-13: `pkg/controller/bootstrap/util.go` - validateSecretForSigning

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ControllerExpectations.GetExpectations正常系/異常系 (UT-CTL-001~002) | E-01 (L174-180) | ○ |
| C-02 | ControllerExpectations.SetExpectations正常系 (UT-CTL-003) | E-01 (L230-234) | ○ |
| C-03 | SatisfiedExpectations充足/未充足/期限切れ/未登録 (UT-CTL-004~007) | E-01 (L195-220) | ○ |
| C-04 | DeleteExpectations正常系 (UT-CTL-008) | E-01 (L183-190) | ○ |
| C-05 | ExpectCreations/ExpectDeletions (UT-CTL-009~010) | E-01 (L236-242) | ○ |
| C-06 | Lower/RaiseExpectations (UT-CTL-011~012) | E-01 (L245-260) | ○ |
| C-07 | CreationObserved/DeletionObserved (UT-CTL-013~014) | E-01 (L263-270) | ○ |
| C-08 | ControlleeExpectations.Add/Fulfilled/GetExpectations (UT-CTL-015~018) | E-01 (L283-297) | ○ |
| C-09 | UIDTracking GetUIDs/ExpectDeletions/DeletionObserved/DeleteExpectations (UT-CTL-019~024) | E-01 (L353-404) | ○ |
| C-10 | FilterActivePods正常系/境界値 (UT-CTL-025~027) | E-01 (L1001-1009) | ○ |
| C-11 | FilterTerminatingPods/CountTerminatingPods (UT-CTL-028~029) | E-01 (L1011-1029) | ○ |
| C-12 | FilterClaimedPods正常系/異常系 (UT-CTL-030~031) | E-01 (L986-998) | ○ |
| C-13 | IsPodActive正常系 (UT-CTL-032~034) | E-01 (L1085-1089) | ○ |
| C-14 | IsPodTerminating正常系 (UT-CTL-035~036) | E-01 (L1091-1094) | ○ |
| C-15 | FilterActiveReplicaSets正常系/境界値/異常系 (UT-CTL-037~039) | E-01 (L1097-1115) | ○ |
| C-16 | ComputeHash一貫性/一意性/衝突回避 (UT-CTL-040~042) | E-01 (L1395-1407) | ○ |
| C-17 | GetPodFromTemplate正常系 (UT-CTL-043~044) | E-01 (L562-585) | ○ |
| C-18 | validateControllerRef正常系/異常系 (UT-CTL-045~049) | E-01 (L520-537) | ○ |
| C-19 | PodKey正常系 (UT-CTL-050) | E-01 (L1211-1213) | ○ |
| C-20 | PodControllerIndexKey (UT-CTL-051~052) | E-01 (L1141-1146) | ○ |
| C-21 | FilterPodsByOwner正常系/異常系 (UT-CTL-053~058) | E-01 (L1169-1205) | ○ |
| C-22 | afterOrZero正常系 (UT-CTL-059~061) | E-01 (L913-918) | ○ |
| C-23 | logarithmicRankDiff (UT-CTL-062~064) | E-01 (L922-934) | ○ |
| C-24 | ActivePods.Less正常系 (UT-CTL-065~069) | E-01 (L741-776) | ○ |
| C-25 | ActivePodsWithRanks.Less ランク/削除コスト (UT-CTL-070~071) | E-01 (L835-866) | ○ |
| C-26 | ActivePodsWithRanks.Less LogarithmicScaleDown UID比較 (UT-CTL-072) | E-01 (L875-886) | △ |
| C-27 | ByLogging.Less (UT-CTL-073) | E-01 (L701-733) | ○ |
| C-28 | ReplicaSets各ソート (UT-CTL-074~077) | E-01 (L1216-1263) | ○ |
| C-29 | NoResyncPeriodFunc/StaticResyncPeriodFunc (UT-CTL-078~079) | E-01 (L117-126) | ○ |
| C-30 | FindMinNextPodAvailabilityCheck (UT-CTL-080~082) | E-01 (L1070-1083) | ○ |
| C-31 | maxContainerRestarts/compareMaxContainerRestarts (UT-CTL-083~088) | E-01 (L948-983) | ○ |
| C-32 | getPodsLabelSet/getPodsAnnotationSet/getPodsPrefix (UT-CTL-089~092) | E-01 (L489-518) | ○ |
| C-33 | New*コンストラクタ (UT-CTL-093~094) | E-01 (L314-316, L408-410) | ○ |
| C-34 | BaseControllerRefManager.CanAdopt (UT-CTL-095~097) | E-02 (L45-52) | ○ |
| C-35 | ClaimObject正常系/異常系 (UT-CTL-098~106) | E-02 (L69-128) | ○ |
| C-36 | ClaimPods/ClaimReplicaSets/ClaimControllerRevisions (UT-CTL-107~111) | E-02 (L183-218, L319-344, L457-482) | ○ |
| C-37 | RecheckDeletionTimestamp (UT-CTL-112~114) | E-02 (L391-402) | ○ |
| C-38 | GenerateDeleteOwnerRefStrategicMergeBytes (UT-CTL-115~117) | E-02 (L572-589) | ○ |
| C-39 | ControllerRevisionName/IndexKey (UT-CTL-118~121) | E-03 (L95-100, L57-62) | ○ |
| C-40 | getParentNameAndOrdinal/getStartOrdinal/getEndOrdinal (UT-CTL-122~129) | E-04 (L63-100) | ○ |
| C-41 | overlappingStatefulSets.Less (UT-CTL-130) | E-04 (L44-55) | ○ |
| C-42 | inActiveList/inActiveListByName/deleteFromActiveList (UT-CTL-131~137) | E-05 (L59-92) | ○ |
| C-43 | matchPodFailurePolicy正常系 (UT-CTL-138~142) | E-06 (L35-80) | ○ |
| C-44 | matchSuccessPolicy/matchSucceededIndexesRule (UT-CTL-143~146) | E-07 (L29-50, L67-90) | △ |
| C-45 | isIndexedJob (UT-CTL-147~149) | E-08 (L41-43) | ○ |
| C-46 | backoffStore.updateBackoffRecord/removeBackoffRecord (UT-CTL-150~153) | E-09 (L45-79) | ○ |
| C-47 | ReferenceCache.Add/Has (UT-CTL-154~157) | E-10 (L29-44) | ○ |
| C-48 | objectReference.String/MarshalLog (UT-CTL-158~159) | E-11 (L36-53) | ○ |
| C-49 | WorkArgs.KeyFromWorkArgs/NewWorkArgs (UT-CTL-160~161) | E-12 (L41-50) | ○ |
| C-50 | validateSecretForSigning正常系/異常系 (UT-CTL-162~168) | E-13 (L30-69) | ○ |
| C-51 | missedSchedulesType.String (UT-CTL-169~170) | E-05 (L45-56) | ○ |
| C-52 | LogarithmicScaleDown feature gate動作確認 (UT-CTL-072) | **根拠不足** | △ |
| C-53 | PodDeletionCost feature gate動作確認 (UT-CTL-071) | **根拠不足** | △ |
| C-54 | JobSuccessPolicy feature gate動作確認 (UT-CTL-143~144) | **根拠不足** | △ |
| C-55 | JobBackoffLimitPerIndex feature gate動作確認 (UT-CTL-139~141) | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Feature gateの有効/無効状態によるテストケースの分岐が十分にカバーされていない
  - 候補：LogarithmicScaleDown / PodDeletionCost / JobSuccessPolicy / JobBackoffLimitPerIndex の各feature gateについて有効・無効両方のテストケースを追加
- コントローラの主要サブパッケージ（daemon, deployment, disruption, endpoint, endpointslice, garbagecollector, namespace, nodelifecycle, podautoscaler, podgc, replicaset, replication, resourceclaim, resourcequota, serviceaccount, servicecidrs, storageversiongc, storageversionmigrator, ttl, ttlafterfinished, validatingadmissionpolicystatus）の内部コントローラロジックについては、統合テストレベルの複雑な依存関係があるため、ユーティリティ関数に焦点を当てている
  - 候補：各サブコントローラの公開ユーティリティ関数を追加調査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ControllerExpectations、ControlleeExpectations、Pod/RSフィルタ関数、ソート関数はソースコードから直接確認可能
- 0: 低リスク - BaseControllerRefManager、ClaimObject、各RefManager系のロジックはソースコードから直接確認可能
- 1: 中リスク - Feature gate依存のテストケース（LogarithmicScaleDown、PodDeletionCost、JobSuccessPolicy等）は実行時の設定によって挙動が変わるため要注意
- 1: 中リスク - サブパッケージの内部ロジック（DaemonSet/Deployment/StatefulSet等のコントローラ本体）は本テストケース一覧ではユーティリティ関数のみ対象としており、完全な網羅性は別途統合テストで担保する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] ControllerExpectations関連テストケース(UT-CTL-001~024)がTTLStore, アトミック操作の仕様を正しく反映しているか
- [ ] ClaimObject(UT-CTL-098~106)の全分岐パス（所有/孤立/削除中/namespace不一致）が正しくテストされているか
- [ ] Pod削除優先順位のソート関数(UT-CTL-065~072)が仕様通りの順序で比較されているか
- [ ] Feature gate依存テストケース(UT-CTL-071~072, UT-CTL-139~144)のfeature有効/無効両パターンが十分か
- [ ] validateSecretForSigning(UT-CTL-162~168)のセキュリティ関連バリデーションが網羅されているか
- [ ] 429ファイルのモジュール全体に対して、主要なpublicユーティリティ関数が適切にカバーされているか
