---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 165
  claims_with_evidence: 162
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：pkg-controlplane 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 165、根拠なし：3
- 優先レビュー（高）
  1. **C-146 (UT-CPL-146)**: electionNeeded内の最適リーダー判定ロジック - pickBestStrategy/pickBestLeaderの組み合わせパスの完全な網羅には統合テスト参照が必要
  2. **C-149 (UT-CPL-149)**: LeaderElectionTimers構造体 - 単なるデータホルダーであり、テスト対象としての意義が限定的
  3. **C-150 (UT-CPL-150)**: GVRToStorageVersionHash - テストデータ用マップであり、値の正確性はKubernetesバージョンに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/controlplane/instance.go` - Instance, Config, CompletedConfig, Extra構造体定義、Complete(), New(), createEndpointReconciler(), DefaultAPIResourceConfigSource(), StorageProviders()
- E-02: `pkg/controlplane/reconcilers/reconcilers.go` - EndpointReconciler interface, Type, Types, Names()
- E-03: `pkg/controlplane/reconcilers/endpointsadapter.go` - EndpointsAdapter, NewEndpointsAdapter, Get, Create, Update, EnsureEndpointSliceFromEndpoints, endpointSliceFromEndpoints, allAddressesIPv6, setSkipMirrorTrue, getEndpointsFromAddresses, endpointFromAddress
- E-04: `pkg/controlplane/reconcilers/instancecount.go` - masterCountEndpointReconciler, NewMasterCountEndpointReconciler, ReconcileEndpoints, RemoveEndpoints, StopReconciling, checkEndpointSubsetFormat
- E-05: `pkg/controlplane/reconcilers/lease.go` - Leases interface, storageLeases, leaseEndpointReconciler, NewLeaseEndpointReconciler, ReconcileEndpoints, doReconcile, RemoveEndpoints, checkEndpointSubsetFormatWithLease, NewLeases
- E-06: `pkg/controlplane/reconcilers/none.go` - noneEndpointReconciler, NewNoneEndpointReconciler
- E-07: `pkg/controlplane/controller/kubernetesservice/controller.go` - Controller, Config, New, Start, Stop, Run, UpdateKubernetesService, createPortAndServiceSpec, createEndpointPortSpec, checkServiceFormat, getMasterServiceUpdateIfNeeded, CreateOrUpdateMasterServiceIfNeeded
- E-08: `pkg/controlplane/controller/legacytokentracking/controller.go` - Controller, NewController, syncConfigMap, processNext
- E-09: `pkg/controlplane/controller/crdregistration/crdregistration_controller.go` - crdRegistrationController, NewCRDRegistrationController, handleVersionUpdate, enqueueCRD
- E-10: `pkg/controlplane/controller/leaderelection/election.go` - pickBestLeaderOldestEmulationVersion, pickBestStrategy, compare, isLeaseExpired, isLeaseCandidateExpired, validLeaseCandidateForOldestEmulationVersion, getEmulationVersionOrZero, getBinaryVersionOrZero
- E-11: `pkg/controlplane/controller/leaderelection/leaderelection_controller.go` - Controller, NewController, reconcileElectionStep, electionNeeded, listAdmissableCandidates, enqueueCandidate, enqueueLease
- E-12: `pkg/controlplane/controller/leaderelection/leasecandidategc_controller.go` - LeaseCandidateGCController, NewLeaseCandidateGC, gc
- E-13: `pkg/controlplane/controller/apiserverleasegc/gc_controller.go` - Controller, NewAPIServerLeaseGC, isLeaseExpired, gc
- E-14: `pkg/controlplane/controller/clusterauthenticationtrust/cluster_authentication_trust_controller.go` - Controller, NewClusterAuthenticationTrustController, syncConfigMap, combinedClusterAuthenticationInfo, combineUniqueStringSlices, combineCertLists, jsonSerializeStringSlice, jsonDeserializeStringSlice, filterExpiredCerts, encodeCertificates, createNamespaceIfNeeded, writeConfigMap, keyFn, getConfigMapDataFor, getClusterAuthenticationInfoFor
- E-15: `pkg/controlplane/controller/systemnamespaces/system_namespaces_controller.go` - Controller, NewController, sync, createNamespaceIfNeeded
- E-16: `pkg/controlplane/controller/defaultservicecidr/default_servicecidr_controller.go` - Controller, NewController, sync, syncStatus
- E-17: `pkg/controlplane/apiserver/options/options.go` - Options, NewOptions, AddFlags, Complete, ServiceIPRange, completeServiceAccountOptions
- E-18: `pkg/controlplane/apiserver/options/validation.go` - Validate, validateTokenRequest, validateAPIPriorityAndFairness, validateUnknownVersionInteroperabilityProxyFlags, validateCoordinatedLeadershipFlags, validateServiceAccountTokenSigningConfig
- E-19: `pkg/controlplane/apiserver/admission/initializer.go` - PluginInitializer, NewPluginInitializer, Initialize
- E-20: `pkg/controlplane/storageversionhashdata/data.go` - NoStorageVersionHash, GVRToStorageVersionHash
- E-21: `pkg/controlplane/controller/leaderelection/run_with_leaderelection.go` - LeaderElectionTimers, RunWithLeaderElection
- E-22: `pkg/controlplane/apiserver/admission/config.go` - Config, New

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Config.Complete()のデフォルト値設定 | E-01 (instance.go L256-311) | ○ |
| C-002 | PeerEndpointReconcileIntervalのデフォルト | E-01 (instance.go L257-261) | ○ |
| C-003 | ServiceNodePortRange未設定時のフォールバック | E-01 (instance.go L285-292) | ○ |
| C-004 | APIServerServiceIPがServiceIPRangeから算出 | E-01 (instance.go L268-277) | ○ |
| C-005 | New()正常系 | E-01 (instance.go L313-350) | ○ |
| C-006 | New()のKubeletClientConfig空チェック | E-01 (instance.go L317-320) | ○ |
| C-007 | createEndpointReconciler MasterCount | E-01 (instance.go L241-244) | ○ |
| C-008 | createEndpointReconciler Lease | E-01 (instance.go L245-246) | ○ |
| C-009 | createEndpointReconciler None | E-01 (instance.go L247-248) | ○ |
| C-010 | DefaultAPIResourceConfigSource 安定版有効 | E-01 (instance.go L501-511) | ○ |
| C-011 | DefaultAPIResourceConfigSource ベータ版無効 | E-01 (instance.go L501-511) | ○ |
| C-012 | DefaultAPIResourceConfigSource アルファ版無効 | E-01 (instance.go L501-511) | ○ |
| C-013 | StorageProviders | E-01 (instance.go) | ○ |
| C-014 | Types.Names()全タイプ名 | E-02 (reconcilers.go L72-78) | ○ |
| C-015 | Types.Names()空スライス | E-02 (reconcilers.go L72-78) | ○ |
| C-016 | NewEndpointsAdapter | E-03 (endpointsadapter.go L46-51) | ○ |
| C-017 | EndpointsAdapter.Get正常系 | E-03 (endpointsadapter.go L55-57) | ○ |
| C-018 | EndpointsAdapter.Get異常系 | E-03 (endpointsadapter.go L55-57) | ○ |
| C-019 | EndpointsAdapter.Create | E-03 (endpointsadapter.go L62-68) | ○ |
| C-020 | EndpointsAdapter.Update | E-03 (endpointsadapter.go L72-78) | ○ |
| C-021 | EnsureEndpointSlice新規作成 | E-03 (endpointsadapter.go L83-94) | ○ |
| C-022 | EnsureEndpointSlice冪等性 | E-03 (endpointsadapter.go L106-110) | ○ |
| C-023 | EnsureEndpointSliceアドレスタイプ変更 | E-03 (endpointsadapter.go L97-104) | ○ |
| C-024 | endpointSliceFromEndpoints IPv4 | E-03 (endpointsadapter.go L118-147) | ○ |
| C-025 | endpointSliceFromEndpoints空Subsets | E-03 (endpointsadapter.go L128) | ○ |
| C-026 | endpointSliceFromEndpoints IPv6 | E-03 (endpointsadapter.go L138-139) | ○ |
| C-027 | allAddressesIPv6 true | E-03 (endpointsadapter.go L180-192) | ○ |
| C-028 | allAddressesIPv6 混在 | E-03 (endpointsadapter.go L186-188) | ○ |
| C-029 | allAddressesIPv6 空配列 | E-03 (endpointsadapter.go L181-183) | ○ |
| C-030 | setSkipMirrorTrue 未設定 | E-03 (endpointsadapter.go L196-206) | ○ |
| C-031 | setSkipMirrorTrue 設定済み | E-03 (endpointsadapter.go L197-198) | ○ |
| C-032 | getEndpointsFromAddresses | E-03 (endpointsadapter.go L151-162) | ○ |
| C-033 | endpointFromAddress | E-03 (endpointsadapter.go L165-177) | ○ |
| C-034 | NewMasterCountEndpointReconciler | E-04 (instancecount.go L43-48) | ○ |
| C-035 | ReconcileEndpoints新規作成 | E-04 (instancecount.go L84-92) | ○ |
| C-036 | ReconcileEndpoints停止後no-op | E-04 (instancecount.go L66-68) | ○ |
| C-037 | ReconcileEndpointsフォーマット正常時 | E-04 (instancecount.go L111-135) | ○ |
| C-038 | ReconcileEndpoints不正フォーマットリセット | E-04 (instancecount.go L93-110) | ○ |
| C-039 | ReconcileEndpoints IP追加 | E-04 (instancecount.go L111-135) | ○ |
| C-040 | ReconcileEndpoints IP過剰削減 | E-04 (instancecount.go L122-134) | ○ |
| C-041 | RemoveEndpoints正常系 | E-04 (instancecount.go L145-176) | ○ |
| C-042 | RemoveEndpoints NotFound | E-04 (instancecount.go L150-156) | ○ |
| C-043 | RemoveEndpoints空Subsets | E-04 (instancecount.go L158-161) | ○ |
| C-044 | StopReconciling | E-04 (instancecount.go L178-182) | ○ |
| C-045 | checkEndpointSubsetFormat正常 | E-04 (instancecount.go L195-219) | ○ |
| C-046 | checkEndpointSubsetFormat空Subsets | E-04 (instancecount.go L196-198) | ○ |
| C-047 | checkEndpointSubsetFormat複数Subsets | E-04 (instancecount.go L196-198) | ○ |
| C-048 | checkEndpointSubsetFormat reconcilePorts=false | E-04 (instancecount.go L200-211) | ○ |
| C-049 | checkEndpointSubsetFormat境界値count一致 | E-04 (instancecount.go L212-217) | ○ |
| C-050 | checkEndpointSubsetFormat境界値count超過 | E-04 (instancecount.go L212-217) | ○ |
| C-051 | NewLeases | E-05 (lease.go L60-68) | ○ |
| C-052 | storageLeases.ListLeases | E-05 (lease.go L71-93) | ○ |
| C-053 | storageLeases.ListLeases空 | E-05 (lease.go L71-93) | ○ |
| C-054 | storageLeases.UpdateLease | E-05 (lease.go L97-121) | ○ |
| C-055 | storageLeases.RemoveLease | E-05 (lease.go L124-127) | ○ |
| C-056 | NewLeaseEndpointReconciler | E-05 (lease.go L158-163) | ○ |
| C-057 | leaseReconcileEndpoints正常 | E-05 (lease.go L172-190) | ○ |
| C-058 | leaseReconcileEndpoints停止後 | E-05 (lease.go L174-176) | ○ |
| C-059 | doReconcile新規作成 | E-05 (lease.go L194-274) | ○ |
| C-060 | doReconcile空IPエラー | E-05 (lease.go L227-229) | ○ |
| C-061 | doReconcileフォーマット正常時 | E-05 (lease.go L240-260) | ○ |
| C-062 | RemoveEndpoints | E-05 (lease.go L329-339) | ○ |
| C-063 | StopReconciling | E-05 (lease.go L341-343) | ○ |
| C-064 | checkEndpointSubsetFormatWithLease正常 | E-05 (lease.go L284-327) | ○ |
| C-065 | checkEndpointSubsetFormatWithLease空 | E-05 (lease.go L285-287) | ○ |
| C-066 | checkEndpointSubsetFormatWithLease IP数不一致 | E-05 (lease.go L303-306) | ○ |
| C-067 | checkEndpointSubsetFormatWithLease 重複IP | E-05 (lease.go L308-324) | ○ |
| C-068 | NewNoneEndpointReconciler | E-06 (none.go L31-33) | ○ |
| C-069 | noneReconcileEndpoints | E-06 (none.go L36-38) | ○ |
| C-070 | noneRemoveEndpoints | E-06 (none.go L41-43) | ○ |
| C-071 | NewAPIServerLeaseGC | E-13 (gc_controller.go L51-70) | ○ |
| C-072 | apiserverleasegc isLeaseExpired有効 | E-13 (gc_controller.go L143-151) | ○ |
| C-073 | apiserverleasegc isLeaseExpired期限切れ | E-13 (gc_controller.go L143-151) | ○ |
| C-074 | apiserverleasegc isLeaseExpired RenewTime=nil | E-13 (gc_controller.go L143-151) | ○ |
| C-075 | apiserverleasegc isLeaseExpired Duration=nil | E-13 (gc_controller.go L143-151) | ○ |
| C-076 | KubernetesService New | E-07 (controller.go) | ○ |
| C-077 | createPortAndServiceSpec ClusterIP | E-07 (controller.go L184-199) | ○ |
| C-078 | createPortAndServiceSpec NodePort | E-07 (controller.go L194-197) | ○ |
| C-079 | createEndpointPortSpec | E-07 (controller.go L202-208) | ○ |
| C-080 | checkServiceFormat正常 | E-07 (controller.go L266-279) | ○ |
| C-081 | checkServiceFormatタイプ不一致 | E-07 (controller.go L267-268) | ○ |
| C-082 | checkServiceFormatポート数不一致 | E-07 (controller.go L270-272) | ○ |
| C-083 | getMasterServiceUpdateIfNeeded更新不要 | E-07 (controller.go L251-261) | ○ |
| C-084 | getMasterServiceUpdateIfNeeded更新必要 | E-07 (controller.go L256-260) | ○ |
| C-085 | pickBestLeaderOldestEmulationVersion | E-10 (election.go L29-40) | ○ |
| C-086 | pickBestLeader空リスト | E-10 (election.go L30-31) | ○ |
| C-087 | pickBestLeader BV比較 | E-10 (election.go L29-40) | ○ |
| C-088 | pickBestStrategy | E-10 (election.go L42-63) | ○ |
| C-089 | pickBestStrategy空 | E-10 (election.go L44-46) | ○ |
| C-090 | pickBestStrategy矛盾 | E-10 (election.go L58-59) | ○ |
| C-091 | validLeaseCandidateForOldestEmulationVersion有効 | E-10 (election.go L65-72) | ○ |
| C-092 | validLeaseCandidateForOldestEmulationVersion不正EV | E-10 (election.go L66-68) | ○ |
| C-093 | validLeaseCandidateForOldestEmulationVersion不正BV | E-10 (election.go L66-68) | ○ |
| C-094 | compare EV比較(lhs優位) | E-10 (election.go L93-109) | ○ |
| C-095 | compare EV比較(rhs優位) | E-10 (election.go L93-109) | ○ |
| C-096 | compare タイムスタンプ比較 | E-10 (election.go L102-108) | ○ |
| C-097 | isLeaseExpired有効 | E-10 (election.go L111-116) | ○ |
| C-098 | isLeaseExpired期限切れ | E-10 (election.go L111-116) | ○ |
| C-099 | isLeaseCandidateExpired有効 | E-10 (election.go L118-122) | ○ |
| C-100 | isLeaseCandidateExpired期限切れ | E-10 (election.go L118-122) | ○ |
| C-101 | isLeaseCandidateExpired RenewTime=nil | E-10 (election.go L118-122) | ○ |
| C-102 | getEmulationVersionOrZero有効 | E-10 (election.go L74-81) | ○ |
| C-103 | getEmulationVersionOrZero無効 | E-10 (election.go L77-79) | ○ |
| C-104 | getBinaryVersionOrZero有効 | E-10 (election.go L83-90) | ○ |
| C-105 | getBinaryVersionOrZero無効 | E-10 (election.go L86-88) | ○ |
| C-106 | legacyTokenTracking NewController | E-08 (controller.go L72-73) | ○ |
| C-107 | syncConfigMap新規作成 | E-08 (controller.go L164-208) | ○ |
| C-108 | syncConfigMap日付有効 | E-08 (controller.go L191-192) | ○ |
| C-109 | syncConfigMap日付不正 | E-08 (controller.go L192-204) | ○ |
| C-110 | syncConfigMapレート制限 | E-08 (controller.go L172-177) | ○ |
| C-111 | systemNamespaces NewController | E-15 (system_namespaces_controller.go L49-59) | ○ |
| C-112 | createNamespaceIfNeeded新規 | E-15 (system_namespaces_controller.go L87-103) | ○ |
| C-113 | createNamespaceIfNeeded既存 | E-15 (system_namespaces_controller.go L88-91) | ○ |
| C-114 | createNamespaceIfNeeded AlreadyExists | E-15 (system_namespaces_controller.go L99-101) | ○ |
| C-115 | defaultservicecidr NewControllerデュアルスタック | E-16 (default_servicecidr_controller.go L54-81) | ○ |
| C-116 | defaultservicecidr NewControllerシングルスタック | E-16 (default_servicecidr_controller.go L66-68) | ○ |
| C-117 | sync新規作成 | E-16 (default_servicecidr_controller.go L169-185) | ○ |
| C-118 | syncデュアルスタック化 | E-16 (default_servicecidr_controller.go L148-156) | ○ |
| C-119 | sync冪等性 | E-16 (default_servicecidr_controller.go L146-161) | ○ |
| C-120 | combinedClusterAuthenticationInfo | E-14 (cluster_authentication_trust_controller.go L222-242) | ○ |
| C-121 | combineUniqueStringSlices | E-14 (cluster_authentication_trust_controller.go L355-380) | ○ |
| C-122 | combineUniqueStringSlices片方nil | E-14 (cluster_authentication_trust_controller.go L355-380) | ○ |
| C-123 | combineCertLists | E-14 (cluster_authentication_trust_controller.go) | ○ |
| C-124 | combineCertLists両nil | E-14 (cluster_authentication_trust_controller.go) | ○ |
| C-125 | filterExpiredCerts | E-14 (cluster_authentication_trust_controller.go L435-446) | ○ |
| C-126 | filterExpiredCerts全期限切れ | E-14 (cluster_authentication_trust_controller.go L435-446) | ○ |
| C-127 | jsonSerializeStringSlice | E-14 (cluster_authentication_trust_controller.go L335-341) | ○ |
| C-128 | jsonDeserializeStringSlice正常 | E-14 (cluster_authentication_trust_controller.go L343-353) | ○ |
| C-129 | jsonDeserializeStringSlice空 | E-14 (cluster_authentication_trust_controller.go L344-346) | ○ |
| C-130 | jsonDeserializeStringSlice不正 | E-14 (cluster_authentication_trust_controller.go L349) | ○ |
| C-131 | getConfigMapDataFor | E-14 (cluster_authentication_trust_controller.go) | ○ |
| C-132 | getClusterAuthenticationInfoFor | E-14 (cluster_authentication_trust_controller.go) | ○ |
| C-133 | encodeCertificates | E-14 (cluster_authentication_trust_controller.go L527-535) | ○ |
| C-134 | keyFn | E-14 (cluster_authentication_trust_controller.go L522-525) | ○ |
| C-135 | NewCRDRegistrationController | E-09 (crdregistration_controller.go L64-107) | ○ |
| C-136 | handleVersionUpdate追加 | E-09 (crdregistration_controller.go L196-228) | ○ |
| C-137 | handleVersionUpdate削除 | E-09 (crdregistration_controller.go L226-227) | ○ |
| C-138 | handleVersionUpdate Served=false | E-09 (crdregistration_controller.go L209) | ○ |
| C-139 | NewOptions | E-17 (options.go L112-141) | ○ |
| C-140 | ServiceIPRange有効CIDR | E-17 (options.go L366-386) | ○ |
| C-141 | ServiceIPRangeデフォルト | E-17 (options.go L368-371) | ○ |
| C-142 | ServiceIPRange小さすぎ | E-17 (options.go L373-376) | ○ |
| C-143 | Validate正常 | E-18 (validation.go L125-144) | ○ |
| C-144 | validateTokenRequest必須フラグ | E-18 (validation.go L34-52) | ○ |
| C-145 | validateAPIPriorityAndFairness矛盾 | E-18 (validation.go L54-72) | ○ |
| C-146 | validateCoordinatedLeadershipFlags LeaseDuration | E-18 (validation.go L113-122) | ○ |
| C-147 | validateCoordinatedLeadershipFlags RenewDeadline | E-18 (validation.go L118-120) | ○ |
| C-148 | NewPluginInitializer | E-19 (initializer.go L35-43) | ○ |
| C-149 | Initialize QuotaConfiguration | E-19 (initializer.go L48-50) | ○ |
| C-150 | Initialize ExcludedAdmissionResources | E-19 (initializer.go L52-54) | ○ |
| C-151 | Config.New PluginInitializer | E-22 (config.go L41-55) | ○ |
| C-152 | NewLeaseCandidateGC | E-12 (leasecandidategc_controller.go L51-60) | ○ |
| C-153 | NewController(leaderelection) | E-11 (leaderelection_controller.go) | ○ |
| C-154 | enqueueCandidate正常 | E-11 (leaderelection_controller.go) | ○ |
| C-155 | enqueueCandidate nil | E-11 (leaderelection_controller.go) | ○ |
| C-156 | enqueueCandidate PingTime未応答 | E-11 (leaderelection_controller.go) | ○ |
| C-157 | enqueueLease | E-11 (leaderelection_controller.go) | ○ |
| C-158 | electionNeeded Lease不存在 | E-11 (leaderelection_controller.go L200-206) | ○ |
| C-159 | electionNeeded Lease期限切れ | E-11 (leaderelection_controller.go L208) | ○ |
| C-160 | electionNeeded HolderIdentity空 | E-11 (leaderelection_controller.go L208) | ○ |
| C-161 | electionNeeded 最適リーダー判定 | E-11 (leaderelection_controller.go L228-234) | △ |
| C-162 | GVRToStorageVersionHash | E-20 (data.go L39-96) | △ |
| C-163 | NoStorageVersionHash | E-20 (data.go L26-35) | ○ |
| C-164 | LeaderElectionTimers構造体 | E-21 (run_with_leaderelection.go L32-36) | △ |
| C-165 | createNamespaceIfNeeded(auth trust) | E-14 (cluster_authentication_trust_controller.go L181-197) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-161: electionNeeded内のpickBestStrategy/pickBestLeaderOldestEmulationVersionの組み合わせロジックの全パスを完全にカバーするには、より詳細なモックが必要
  - 候補：統合テスト / leaderelection_controller_test.goの既存テストを参照
- C-162: GVRToStorageVersionHashはテストデータ用マップであり、値の正確性はKubernetesバージョンに依存
  - 候補：import_known_versions_test.goの既存テストで検証済み
- C-164: LeaderElectionTimers構造体は単なるデータホルダーであり、テスト対象としての意義が限定的
  - 候補：RunWithLeaderElectionの統合テストで間接的にカバー
- storageLeases (C-052, C-053, C-054, C-055): etcdバックエンドへの直接アクセスが必要なため、単体テストではモックが必須
  - 候補：統合テスト / lease_test.goの既存テスト
- RunWithLeaderElection関数はOS依存のHostname取得等があり、単体テストケースの作成が困難
  - 候補：統合テスト / E2Eテスト

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 大部分のテストケース(162/165)はソースコードから直接導出されており、関数シグネチャ・分岐条件が明確
- 1 (中リスク): リーダー選出ロジック(election.go)の組み合わせテストは、実行時の状態依存が大きく、テストケースの入力値・期待結果の精度に注意が必要
- 1 (中リスク): storageLeases系のテストはetcd依存のため、モック設計が正確でないと実行時に乖離が生じる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの対象ファイルパスが実際のソースコードと一致しているか
- [ ] 正常系・異常系・境界値のバランスが各コンポーネントで適切か
- [ ] リーダー選出関連(election.go)のcompare/pickBest系関数のテストケースが十分か
- [ ] Endpointリコンサイラー(instancecount, lease)の状態遷移テストが網羅されているか
- [ ] ServiceIPRange関数の境界値テスト(最小CIDR等)が適切か
- [ ] 優先度の高いテストケース(認証・認可・データ整合性関連)が漏れなく含まれているか
- [ ] clusterauthenticationtrust関連の証明書処理テストが網羅されているか
