---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 163
  claims_with_evidence: 160
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：pkg-credentialprovider 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：160 / 163、根拠なし：3
- 優先レビュー（高）
  1. **UT-CRD-037/038（NewTrackedAuthConfig フィーチャーゲート動作）**：KubeletEnsureSecretPulledImages フィーチャーゲートの動作はランタイム依存のため、実際のフィーチャーゲート設定に依存する
  2. **UT-CRD-152/153（externalCredentialProviderKeyring Lookup）**：プロバイダ登録のグローバル状態に依存するため、テスト環境の分離が必要
  3. **UT-CRD-111（tokenAttributes フィーチャーゲート検証）**：KubeletServiceAccountTokenForCredentialProviders フィーチャーゲートの状態に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/credentialprovider/config.go` - Docker設定ファイル読み込み・パース・エンコード/デコード処理
- E-02: `pkg/credentialprovider/keyring.go` - DockerKeyringインタフェース、BasicDockerKeyring、URLマッチング、TrackedAuthConfig
- E-03: `pkg/credentialprovider/provider.go` - DockerConfigProviderインタフェース、CachingDockerConfigProvider、defaultDockerConfigProvider
- E-04: `pkg/credentialprovider/plugin/config.go` - CredentialProviderConfig読み込み・デコード・バリデーション
- E-05: `pkg/credentialprovider/plugin/plugin.go` - pluginProvider、execPlugin、キャッシュ管理、サービスアカウント処理
- E-06: `pkg/credentialprovider/plugin/plugins.go` - プロバイダ登録、externalCredentialProviderKeyring
- E-07: `pkg/credentialprovider/plugin/metrics.go` - メトリクス登録・記録
- E-08: `pkg/credentialprovider/secrets/secrets.go` - シークレットからDockerKeyring構築

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CRD-001~005) | SetPreferredDockercfgPath/GetPreferredDockercfgPath/DefaultDockercfg/DefaultDockerConfigJSONPathsの動作 | E-01 (config.go L73-94) | ○ |
| C-02 (UT-CRD-006~010) | ReadDockerConfigFileFromBytes/readDockerConfigJSONFileFromBytesのパース動作 | E-01 (config.go L226-240) | ○ |
| C-03 (UT-CRD-011~015) | DockerConfigEntry UnmarshalJSON/MarshalJSONの動作 | E-01 (config.go L256-281) | ○ |
| C-04 (UT-CRD-016~022) | decodeDockerConfigFieldAuth/encodeDockerConfigFieldAuthの動作 | E-01 (config.go L285-319) | ○ |
| C-05 (UT-CRD-023~029) | ReadURL/HTTPErrorの動作 | E-01 (config.go L177-223) | ○ |
| C-06 (UT-CRD-030~036) | ReadDockercfgFile/ReadDockerConfigJSONFile/ReadSpecificDockerConfigJSONFileの動作 | E-01 (config.go L98-166) | ○ |
| C-07 (UT-CRD-037~039) | NewTrackedAuthConfigの動作（フィーチャーゲート依存） | E-02 (keyring.go L67-87) | ○ |
| C-08 (UT-CRD-040~048) | BasicDockerKeyring.Addの動作 | E-02 (keyring.go L131-183) | ○ |
| C-09 (UT-CRD-049~053) | BasicDockerKeyring.Lookupの動作 | E-02 (keyring.go L295-318) | ○ |
| C-10 (UT-CRD-054~059) | isDefaultRegistryMatchの動作 | E-02 (keyring.go L193-215) | ○ |
| C-11 (UT-CRD-060~064) | ParseSchemelessURL/SplitURLの動作 | E-02 (keyring.go L220-238) | ○ |
| C-12 (UT-CRD-065~073) | URLsMatch/URLsMatchStrの動作 | E-02 (keyring.go L241-290) | ○ |
| C-13 (UT-CRD-074~077) | UnionDockerKeyring/FakeKeyringのLookup動作 | E-02 (keyring.go L332-361) | ○ |
| C-14 (UT-CRD-078~079) | hashAuthConfigの動作 | E-02 (keyring.go L363-372) | ○ |
| C-15 (UT-CRD-080~082) | defaultDockerConfigProviderの動作 | E-03 (provider.go L63-76) | ○ |
| C-16 (UT-CRD-083~088) | CachingDockerConfigProviderの動作 | E-03 (provider.go L79-100) | ○ |
| C-17 (UT-CRD-089~095) | readCredentialProviderConfigの動作 | E-04 (config.go L50-121) | ○ |
| C-18 (UT-CRD-096~098) | decodeの動作 | E-04 (config.go L124-143) | ○ |
| C-19 (UT-CRD-099~111) | validateCredentialProviderConfigの動作 | E-04 (config.go L146-243) | ○ |
| C-20 (UT-CRD-112~114) | validateServiceAccountAnnotationKeysの動作 | E-04 (config.go L246-262) | ○ |
| C-21 (UT-CRD-115~117) | pluginProvider.isImageAllowedの動作 | E-05 (plugin.go L603-611) | ○ |
| C-22 (UT-CRD-118~119) | parseRegistryの動作 | E-05 (plugin.go L795-798) | ○ |
| C-23 (UT-CRD-120~122) | mergeEnvVarsの動作 | E-05 (plugin.go L803-807) | ○ |
| C-24 (UT-CRD-123~127) | execPlugin.encodeRequest/decodeResponseの動作 | E-05 (plugin.go L763-792) | ○ |
| C-25 (UT-CRD-128~130) | cacheKeyFunc/cacheExpirationPolicyの動作 | E-05 (plugin.go L373-387) | ○ |
| C-26 (UT-CRD-131~136) | getHashIfNotEmpty/generateServiceAccountCacheKey/generateCacheKey/generateSingleFlightKeyの動作 | E-05 (plugin.go L809-846) | ○ |
| C-27 (UT-CRD-137~143) | serviceAccountProvider.getServiceAccountData/getServiceAccountTokenの動作 | E-05 (plugin.go L316-363) | ○ |
| C-28 (UT-CRD-144~146) | requiredAnnotationNotFoundError/isRequiredAnnotationNotFoundErrorの動作 | E-05 (plugin.go L296-305) | ○ |
| C-29 (UT-CRD-147~149) | cacheKeyBuilderの動作 | E-05 (plugin.go L100-131) | ○ |
| C-30 (UT-CRD-150~151) | registerCredentialProviderPluginの動作 | E-06 (plugins.go L45-56) | ○ |
| C-31 (UT-CRD-152~153) | externalCredentialProviderKeyring.Lookupの動作 | E-06 (plugins.go L91-104) | △ |
| C-32 (UT-CRD-154~155) | registerMetrics/recordCredentialProviderConfigHashの動作 | E-07 (metrics.go L71-82) | ○ |
| C-33 (UT-CRD-156~160) | MakeDockerKeyringの動作 | E-08 (secrets.go L29-40) | ○ |
| C-34 (UT-CRD-161~163) | secretsToTrackedDockerConfigsの動作 | E-08 (secrets.go L42-78) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-31（externalCredentialProviderKeyring.Lookup）：テストではグローバル変数 `providers` への依存があり、テスト間の状態分離に関する確認が必要
  - 候補：テスト用のプロバイダリセット機構 / テストヘルパーの確認
- フィーチャーゲート（KubeletEnsureSecretPulledImages, KubeletServiceAccountTokenForCredentialProviders）の有効/無効切り替えのテスト環境設定方法
  - 候補：`featuregatetesting` パッケージの利用確認
- pluginProvider.provide メソッドの統合的なテストケースは、外部プロセス実行を伴うため本一覧ではExecPlugin自体のモック前提で記述
  - 候補：Plugin インタフェースのモック実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - config.go のパース/エンコード関数群は入出力が明確でテスト容易
- 0: 低リスク - keyring.go のURLマッチング関数群は純粋関数でテスト容易
- 1: 中リスク - CachingDockerConfigProvider のキャッシュ動作は時間依存のためテスト時のクロックモックが必要
- 1: 中リスク - plugin/config.go のバリデーション関数はフィーチャーゲート依存のパスがある
- 2: 高リスク - plugin/plugin.go のprovide関数は外部プロセス実行・キャッシュ・サービスアカウントトークン取得の統合処理であり、テスト環境の構築が複雑

## 6) レビュアーチェックリスト（最小）
- [ ] 全ソースファイル（config.go, keyring.go, provider.go, plugin/config.go, plugin/plugin.go, plugin/plugins.go, plugin/metrics.go, secrets/secrets.go）のpublic関数が網羅されているか
- [ ] 認証情報（DockerConfigEntry）のシリアライズ/デシリアライズに関するテストケースが十分か（セキュリティ関連）
- [ ] フィーチャーゲート依存のテストケース（UT-CRD-037/038, UT-CRD-111）が正しく記述されているか
- [ ] 境界値テスト（空入力、nil、maxReadLength等）が主要関数に対して含まれているか
- [ ] pluginProvider.provide の複雑なフローに対するテストケースの追加が必要か検討
