---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：pkg-generated 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **C-13（v2スキーマ非適用ケース）**：ExtensionV2Schemaが非spec.Schema型である実際のケースがコード上確認できない
  2. **C-15（main関数のエラーハンドリング）**：main関数は直接テスト困難であり、テスト手法の実現性に根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/generated/openapi/zz_generated.openapi.go` - GetOpenAPIDefinitions関数の定義（自動生成コード）
- E-02: `pkg/generated/openapi/openapi_test.go` - 既存テストコード（TestOpenAPIRoundtrip）
- E-03: `pkg/generated/openapi/cmd/models-schema/main.go` - output関数およびmain関数の実装
- E-04: `pkg/generated/doc.go` - パッケージドキュメント
- E-05: `pkg/generated/openapi/doc.go` - openapi パッケージドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetOpenAPIDefinitionsが有効なReferenceCallbackでマップを返す | E-01, E-02 | ○ |
| C-02 | 各エントリにSchemaが含まれる | E-01, E-02 | ○ |
| C-03 | 各スキーマがJSONシリアライズ可能 | E-02 | ○ |
| C-04 | 各スキーマがJSONラウンドトリップ可能 | E-02 | ○ |
| C-05 | ExtensionV2Schemaの埋め込み確認 | E-01, E-02 | ○ |
| C-06 | マップに1つ以上のエントリが含まれる | E-01 | ○ |
| C-07 | コアリソース定義が含まれる | E-01 | ○ |
| C-08 | output関数がエラーなくJSON Swagger文書を生成する | E-03 | ○ |
| C-09 | 出力JSONがSwagger 2.0形式である | E-03 | ○ |
| C-10 | infoフィールドにtitle=Kubernetesが含まれる | E-03 | ○ |
| C-11 | definitionsフィールドが空でない | E-03 | ○ |
| C-12 | v2スキーマ置換ロジックが正しく動作する | E-03 | ○ |
| C-13 | ExtensionV2Schemaが非spec.Schema型の場合にオリジナルが使用される | **根拠不足** | △ |
| C-14 | refFuncの参照形式が正しい | E-03 | ○ |
| C-15 | main関数でoutputエラー時にstderrに出力しexit(1) | **テスト実現性に根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: ExtensionV2Schemaがspec.Schema型以外で設定されるケースが実際のコード中に存在するかどうか確認できていない。自動生成コードの特性上、そのようなケースが存在しない可能性がある
  - 候補：openapi-gen コード生成ツールの仕様確認 / 実際のExtensions内容の全件調査
- C-15: Go言語のmain関数はos.Exit呼び出しを含むため、通常の単体テストでは直接テスト困難。テスト手法としてサブプロセス実行やTestMain利用が必要
  - 候補：exec.Command によるプロセス起動テスト / output関数の単体テストへの集中

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - pkg/generatedは主に自動生成コードで構成されており、手動で記述されたロジックはcmd/models-schema/main.goのoutput関数のみ。テスト対象としての重要度は限定的
- 1: 中リスク - zz_generated.openapi.goは自動生成ファイルであり、コード変更時に再生成される。テストケースが自動生成プロセスの変更に追従できるか注意が必要
- 0: 低リスク - 既存テスト（TestOpenAPIRoundtrip）がラウンドトリップ検証を実施済み。テストケース一覧はその観点を含んでいる

## 6) レビュアーチェックリスト（最小）
- [ ] 自動生成コード（zz_generated.openapi.go）に対するテストケースの粒度が適切か確認
- [ ] output関数のv2スキーマ置換ロジックに関するテストケース（C-12, C-13）の実現可能性を確認
- [ ] main関数のエラーハンドリングテスト（C-15）の実現手法を検討
- [ ] 既存テスト（TestOpenAPIRoundtrip）との重複・差分を確認
- [ ] テストケースの優先度付けが自動生成コードの特性に適しているか確認
