---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 122
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：pkg-kubeapiserver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：122 / 125、根拠なし：3
- 優先レビュー（高）
  1. **UT-KAS-009（EtcdServersOverridesの不正フォーマット）**：パニック発生の具体的挙動はソースコードの解析に基づく推測であり、実行時テストが必要
  2. **UT-KAS-070（AuthorizationConfigurationFileからの変換テスト）**：実際の設定ファイルフォーマットの妥当性を確認する必要あり
  3. **UT-KAS-116（トークンファイル認証テスト）**：Config.New()の複雑な統合動作のため、モック設定の妥当性を確認する必要あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/kubeapiserver/default_storage_factory_builder.go` - DefaultWatchCacheSizes関数、NewStorageFactoryConfig*関数、StorageFactoryConfig構造体、Complete/Newメソッド
- E-02: `pkg/kubeapiserver/options/admission.go` - AdmissionOptions構造体、NewAdmissionOptions/Validate/AddFlags/ApplyTo/computePluginNames関数
- E-03: `pkg/kubeapiserver/options/authentication.go` - BuiltInAuthenticationOptions構造体、With*メソッド群、Validate/ToAuthenticationConfig/ApplyTo/ApplyAuthorization/validateOIDCOptions/loadAuthenticationConfig*関数群
- E-04: `pkg/kubeapiserver/options/authorization.go` - BuiltInAuthorizationOptions構造体、Complete/Validate/AddFlags/ToAuthorizationConfig/buildAuthorizationConfiguration関数群
- E-05: `pkg/kubeapiserver/options/serving.go` - NewSecureServingOptions関数
- E-06: `pkg/kubeapiserver/options/plugins.go` - AllOrderedPlugins変数、RegisterAllAdmissionPlugins/DefaultOffAdmissionPlugins関数
- E-07: `pkg/kubeapiserver/options/options.go` - DefaultServiceNodePortRange/DefaultServiceIPCIDR/DefaultEtcdPathPrefix定数・変数
- E-08: `pkg/kubeapiserver/admission/config.go` - Config構造体、Newメソッド
- E-09: `pkg/kubeapiserver/admission/initializer.go` - PluginInitializer構造体、NewPluginInitializer/Initialize関数
- E-10: `pkg/kubeapiserver/admission/exclusion/resources.go` - included/excluded変数、Included/Excluded関数
- E-11: `pkg/kubeapiserver/authorizer/modes/modes.go` - 認可モード定数、AuthorizationModeChoices変数、IsValidAuthorizationMode関数
- E-12: `pkg/kubeapiserver/authorizer/config.go` - Config構造体、New/GetNameForAuthorizerMode/LoadAndValidateFile/LoadAndValidateData関数
- E-13: `pkg/kubeapiserver/authorizer/reload.go` - reloadableAuthorizerResolver構造体、Authorize/RulesFor/newForConfig/runReload/checkFileメソッド
- E-14: `pkg/kubeapiserver/authenticator/config.go` - Config構造体、New/newAuthenticatorFromTokenFile/newLegacyServiceAccountAuthenticator/newServiceAccountAuthenticator/newWebhookTokenAuthenticator関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DefaultWatchCacheSizesがevents/events.k8s.ioのキャッシュ0のmapを返す | E-01 (L57-62) | ○ |
| C-02 | NewStorageFactoryConfigが非nilのStorageFactoryConfigを返す | E-01 (L65-67) | ○ |
| C-03 | NewStorageFactoryConfigEffectiveVersionがSerializer等を設定する | E-01 (L70-98) | ○ |
| C-04 | ResourceEncodingOverridesにleasecandidates等が含まれる | E-01 (L71-91) | ○ |
| C-05 | Complete()がEtcdOptionsの値を適用する | E-01 (L113-118) | ○ |
| C-06 | completedStorageFactoryConfig.New()がDefaultStorageFactoryを生成する | E-01 (L129-160) | ○ |
| C-07 | CohabitatingResourcesが正しく設定される | E-01 (L139-147) | ○ |
| C-08 | EtcdServersOverridesがパースされる | E-01 (L148-158) | ○ |
| C-09 | 不正フォーマットのEtcdServersOverridesでパニックする可能性がある | E-01 (L149-154) | △ |
| C-10 | NewAdmissionOptionsが正しく初期化される | E-02 (L56-68) | ○ |
| C-11 | Validate正常系で空エラーを返す | E-02 (L91-111) | ○ |
| C-12 | PluginNamesとEnablePluginsの排他エラー | E-02 (L96-99) | ○ |
| C-13 | 未登録プラグインエラー | E-02 (L101-106) | ○ |
| C-14 | nilレシーバーのValidateがnilを返す | E-02 (L92-94) | ○ |
| C-15 | AddFlagsでadmission-controlフラグが登録される | E-02 (L76-84) | ○ |
| C-16 | nil AddFlagsの安全性 | E-02 (L72-74) | ○ |
| C-17 | ApplyToでPluginNames変換が行われる | E-02 (L128-131) | ○ |
| C-18 | nil ApplyToがnilを返す | E-02 (L124-126) | ○ |
| C-19 | computePluginNamesが正しくenabled/disabledを返す | E-02 (L137-138) | ○ |
| C-20 | 空のexplicitlyEnabledで全て無効化 | E-02 (L137-138) | ○ |
| C-21 | NewBuiltInAuthenticationOptionsのデフォルト値 | E-03 (L166-171) | ○ |
| C-22 | WithAllで全サブオプション初期化 | E-03 (L174-184) | ○ |
| C-23 | WithAnonymousでAllow=true | E-03 (L187-192) | ○ |
| C-24 | WithOIDCのデフォルト値 | E-03 (L207-213) | ○ |
| C-25 | WithServiceAccountsのデフォルト値 | E-03 (L222-230) | ○ |
| C-26 | WithWebHookのデフォルト値 | E-03 (L239-246) | ○ |
| C-27 | Validate正常系 | E-03 (L249-325) | ○ |
| C-28 | 空issuerエラー | E-03 (L267-270) | ○ |
| C-29 | issuer重複エラー | E-03 (L271-274) | ○ |
| C-30 | 不正URL issuerエラー | E-03 (L261-265) | ○ |
| C-31 | 未設定issuerエラー | E-03 (L280-282) | ○ |
| C-32 | 未設定key-file/signing-endpointエラー | E-03 (L283-285) | ○ |
| C-33 | 不正JWKS URIエラー | E-03 (L290-292) | ○ |
| C-34 | httpスキームJWKS URIエラー | E-03 (L292-294) | ○ |
| C-35 | WebHook RetryBackoff Steps<=0エラー | E-03 (L299-302) | ○ |
| C-36 | nilレシーバーValidateがnilを返す | E-03 (L250-252) | ○ |
| C-37 | certificatesOverlap: 重複ありでtrue | E-03 (L329-338) | ○ |
| C-38 | certificatesOverlap: 重複なしでfalse | E-03 (L329-338) | ○ |
| C-39 | certificatesOverlap: 空リストでfalse | E-03 (L329-338) | ○ |
| C-40 | ToAuthenticationConfig正常系 | E-03 (L492-668) | ○ |
| C-41 | nil ToAuthenticationConfigが空Configを返す | E-03 (L493-495) | ○ |
| C-42 | OIDCプレフィックス自動設定 | E-03 (L533-539) | ○ |
| C-43 | OIDCプレフィックス"-"で無効化 | E-03 (L540-543) | ○ |
| C-44 | Anonymous排他エラー | E-03 (L592-594) | ○ |
| C-45 | KeyFiles/ExternalPublicKeysGetter排他エラー | E-03 (L623-624) | ○ |
| C-46 | AlwaysAllowでAnonymous無効化 | E-03 (L833-844) | ○ |
| C-47 | RBAC非干渉 | E-03 (L840-843) | ○ |
| C-48 | nil ApplyAuthorizationの安全性 | E-03 (L834-836) | ○ |
| C-49 | AuthenticationConfigFile+OIDCフラグ排他 | E-03 (L870-873) | ○ |
| C-50 | OIDCフラグIssuerURL/ClientID必須 | E-03 (L855-858) | ○ |
| C-51 | loadAuthenticationConfigFromData正常系 | E-03 (L902-920) | ○ |
| C-52 | 空データエラー | E-03 (L903-905) | ○ |
| C-53 | 不正データデコードエラー | E-03 (L907-909) | ○ |
| C-54 | NewBuiltInAuthorizationOptionsデフォルト値 | E-04 (L74-82) | ○ |
| C-55 | Complete: 空ModesでAlwaysAllow設定 | E-04 (L85-94) | ○ |
| C-56 | Complete: 既存Modes保持 | E-04 (L90-91) | ○ |
| C-57 | nil Completeがnilを返す | E-04 (L86-88) | ○ |
| C-58 | Validate正常系(RBAC) | E-04 (L97-158) | ○ |
| C-59 | 空Modesエラー | E-04 (L124-126) | ○ |
| C-60 | 不正モードエラー | E-04 (L130-132) | ○ |
| C-61 | ABAC PolicyFile必須 | E-04 (L133-135) | ○ |
| C-62 | Webhook ConfigFile必須 | E-04 (L136-138) | ○ |
| C-63 | PolicyFile without ABACエラー | E-04 (L141-143) | ○ |
| C-64 | WebhookConfigFile without Webhookエラー | E-04 (L145-147) | ○ |
| C-65 | 重複モードエラー | E-04 (L149-151) | ○ |
| C-66 | WebhookRetryBackoff Steps<=0エラー | E-04 (L153-155) | ○ |
| C-67 | AuthorizationConfigFile+レガシーフラグ排他 | E-04 (L108-111) | ○ |
| C-68 | nil Validateがnilを返す | E-04 (L98-100) | ○ |
| C-69 | ToAuthorizationConfig: レガシーフラグ変換 | E-04 (L208-250) | ○ |
| C-70 | ToAuthorizationConfig: 設定ファイル変換 | E-04 (L224-233) | △ |
| C-71 | nil ToAuthorizationConfigがnilを返す | E-04 (L209-211) | ○ |
| C-72 | buildAuthorizationConfiguration: RBAC変換 | E-04 (L253-291) | ○ |
| C-73 | buildAuthorizationConfiguration: Webhook変換 | E-04 (L262-281) | ○ |
| C-74 | buildAuthorizationConfiguration: 重複エラー | E-04 (L256-258) | ○ |
| C-75 | NewSecureServingOptionsデフォルト値 | E-05 (L27-38) | ○ |
| C-76 | RegisterAllAdmissionPlugins登録 | E-06 (L122-155) | ○ |
| C-77 | DefaultOffAdmissionPlugins返却 | E-06 (L158-186) | ○ |
| C-78 | AlwaysAdmitがデフォルトオフ | E-06 (L159-183) | ○ |
| C-79 | DefaultServiceNodePortRange値 | E-07 (L27) | ○ |
| C-80 | DefaultServiceIPCIDR値 | E-07 (L30) | ○ |
| C-81 | DefaultEtcdPathPrefix値 | E-07 (L33) | ○ |
| C-82 | Config.New()がPluginInitializerリストを返す | E-08 (L27-29) | ○ |
| C-83 | NewPluginInitializerが非nilを返す | E-09 (L32-34) | ○ |
| C-84 | Initialize安全性 | E-09 (L38) | ○ |
| C-85 | Includedリスト内容 | E-10 (L30-41) | ○ |
| C-86 | Includedがコピーを返す | E-10 (L58-60) | ○ |
| C-87 | Excludedリスト内容 | E-10 (L45-54) | ○ |
| C-88 | Excludedがコピーを返す | E-10 (L64-66) | ○ |
| C-89 | IsValidAuthorizationMode: AlwaysAllowでtrue | E-11 (L40-42) | ○ |
| C-90 | IsValidAuthorizationMode: RBACでtrue | E-11 (L40-42) | ○ |
| C-91 | IsValidAuthorizationMode: Nodeでtrue | E-11 (L40-42) | ○ |
| C-92 | IsValidAuthorizationMode: Invalidでfalse | E-11 (L40-42) | ○ |
| C-93 | IsValidAuthorizationMode: 空文字でfalse | E-11 (L40-42) | ○ |
| C-94 | AuthorizationModeChoicesに6モード含まれる | E-11 (L37) | ○ |
| C-95 | GetNameForAuthorizerMode: RBACをrbacに変換 | E-12 (L169-171) | ○ |
| C-96 | GetNameForAuthorizerMode: AlwaysAllowをalwaysallowに変換 | E-12 (L169-171) | ○ |
| C-97 | GetNameForAuthorizerMode: 空文字で空文字 | E-12 (L169-171) | ○ |
| C-98 | LoadAndValidateFile正常系 | E-12 (L173-183) | ○ |
| C-99 | LoadAndValidateFile: 存在しないファイルエラー | E-12 (L174-177) | ○ |
| C-100 | LoadAndValidateData正常系 | E-12 (L185-226) | ○ |
| C-101 | LoadAndValidateData: 不正データエラー | E-12 (L187-190) | ○ |
| C-102 | LoadAndValidateData: 認可名不整合エラー | E-12 (L210-214) | ○ |
| C-103 | LoadAndValidateData: 必須タイプ欠落エラー | E-12 (L217-219) | ○ |
| C-104 | Config.New正常系 | E-12 (L82-162) | ○ |
| C-105 | Config.New: 空Authorizersエラー | E-12 (L83-85) | ○ |
| C-106 | Authorize委任 | E-13 (L78-80) | ○ |
| C-107 | RulesFor委任 | E-13 (L82-84) | ○ |
| C-108 | newForConfig: AlwaysAllow | E-13 (L110-113) | ○ |
| C-109 | newForConfig: AlwaysDeny | E-13 (L114-117) | ○ |
| C-110 | newForConfig: 空Authorizersエラー | E-13 (L88-90) | ○ |
| C-111 | newForConfig: Nodeなしエラー | E-13 (L105-107) | ○ |
| C-112 | newForConfig: ABACなしエラー | E-13 (L119-121) | ○ |
| C-113 | newForConfig: RBACなしエラー | E-13 (L169-171) | ○ |
| C-114 | newForConfig: 未知モードエラー | E-13 (L174-176) | ○ |
| C-115 | newForConfig: WebhookRetryBackoff nilエラー | E-13 (L125-127) | ○ |
| C-116 | Config.New: TokenAuthFile認証 | E-14 (L107-249) | △ |
| C-117 | Config.New: 匿名認証有効化 | E-14 (L232-233) | ○ |
| C-118 | Config.New: 認証なしでnil返却 | E-14 (L235) | ○ |
| C-119 | newAuthenticatorFromTokenFile正常系 | E-14 (L370-377) | ○ |
| C-120 | newAuthenticatorFromTokenFile: 存在しないファイル | E-14 (L371-373) | ○ |
| C-121 | newLegacyServiceAccountAuthenticator正常系 | E-14 (L380-391) | ○ |
| C-122 | newLegacyServiceAccountAuthenticator: nil publicKeysGetter | E-14 (L381-383) | ○ |
| C-123 | newServiceAccountAuthenticator正常系 | E-14 (L394-400) | ○ |
| C-124 | newServiceAccountAuthenticator: nil publicKeysGetter | E-14 (L395-397) | ○ |
| C-125 | newWebhookTokenAuthenticator: nil RetryBackoff | E-14 (L403-405) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-09: EtcdServersOverridesの不正フォーマットによるパニック挙動は、ソースコードの`strings.Split`結果に対するインデックスアクセスの解析に基づく推測。実際のGo runtimeでのパニック挙動は実行テストで確認が必要。
  - 候補：Goランタイムテスト / パニックリカバリテスト
- C-70: AuthorizationConfigurationFileからの変換は、有効な設定ファイルの実在が前提。テスト用のフィクスチャファイルの準備が必要。
  - 候補：テスト用AuthorizationConfigurationファイル / testdataディレクトリ
- C-116: Config.New()はTokenAuthFileを含む複雑な統合処理。正確なテストにはCSV形式トークンファイルのモックが必要。
  - 候補：テスト用トークンCSVファイル / モック設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - options/options.go のデフォルト値定数テスト（UT-KAS-079〜081）は単純な値確認のため低リスク
- 0: 低リスク - admission/initializer.goとadmission/config.goは現在空の実装であり低リスク
- 1: 中リスク - EtcdServersOverridesのパース処理（UT-KAS-008,009）は入力バリデーションが不足しており、不正入力でパニックの可能性
- 1: 中リスク - 認証設定ファイルのリロード処理（authentication.go ApplyTo内のgoroutine）は並行処理を含むため、テストが困難
- 2: 高リスク - 認証・認可のバリデーション（UT-KAS-027〜050, 058〜068）はセキュリティに直結するため高リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 認証バリデーション（UT-KAS-027〜050）の異常系テストケースが、ソースコードの全条件分岐をカバーしているか
- [ ] 認可バリデーション（UT-KAS-058〜068）の異常系テストケースが、ソースコードの全条件分岐をカバーしているか
- [ ] セキュリティ関連テスト（証明書重複検出、排他フラグ検証）が十分な境界値をカバーしているか
- [ ] EtcdServersOverridesの不正入力テスト（UT-KAS-009）のパニック挙動が正しいか
- [ ] AuthorizationConfiguration/AuthenticationConfigurationのファイルロードテストに適切なフィクスチャが用意されるか
- [ ] reloadableAuthorizerResolverのnewForConfigで全認可モード（AlwaysAllow, AlwaysDeny, Node, ABAC, RBAC, Webhook, Unknown）がテストされているか
