---
generated_at: 2026-02-02 23:00:00
metrics:
  claims_total: 46
  claims_with_evidence: 41
  claims_without_evidence: 5
confidence_derived: 0.89
---

# 根拠レポート：pkg-kubectl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：41 / 46、根拠なし：5
- 優先レビュー（高）
  1. **UT-KCT-028（tryConvertの空versionsスライス）**：versionsが空の場合のlast変数初期値（nil）による戻り値の推定
  2. **UT-KCT-039（未登録オブジェクトのruntime.Unknownエンコード）**：NotRegisteredError分岐内のruntime.Encode動作の推定
  3. **UT-KCT-032（forceList=trueの単一Info）**：asVersionedObjectのforceListフラグ動作の推定
  4. **UT-KCT-044（未登録オブジェクトのエンコード失敗）**：runtime.Encodeのエラーパスの推定
  5. **UT-KCT-046（extensions API優先度）**：import順序によるスキーマ登録優先度の推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/kubectl/cmd/convert/convert.go` - ConvertOptions構造体定義（L65-78）
- E-02: `pkg/kubectl/cmd/convert/convert.go` - NewConvertOptions関数（L80-86）
- E-03: `pkg/kubectl/cmd/convert/convert.go` - NewCmdConvert関数（L90-112）
- E-04: `pkg/kubectl/cmd/convert/convert.go` - Complete メソッド（L115-138）
- E-05: `pkg/kubectl/cmd/convert/convert.go` - RunConvert メソッド（L141-190）
- E-06: `pkg/kubectl/cmd/convert/convert.go` - asVersionedObject関数（L196-229）
- E-07: `pkg/kubectl/cmd/convert/convert.go` - asVersionedObjects関数（L234-280）
- E-08: `pkg/kubectl/cmd/convert/convert.go` - tryConvert関数（L284-298）
- E-09: `pkg/kubectl/cmd/convert/convert_test.go` - TestConvertObject テスト（L42-112）
- E-10: `pkg/kubectl/cmd/convert/import_known_versions.go` - APIグループインポート（L22-49）
- E-11: `pkg/kubectl/cmd/convert/import_known_versions_test.go` - TestKnownVersions テスト（L30-61）
- E-12: `pkg/kubectl/doc.go` - パッケージドキュメント（L17-21）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NewConvertOptionsが有効なIOStreamsでConvertOptionsを生成する | E-02 | ○ |
| C-02 | PrintFlagsのデフォルト出力がyamlである | E-02 | ○ |
| C-03 | localフラグのデフォルト値がtrue | E-02 | ○ |
| C-04 | NewCmdConvertがcobra.Commandを正しく生成する | E-03 | ○ |
| C-05 | localフラグがデフォルトでtrueとして登録されている | E-02, E-03 | ○ |
| C-06 | output-versionフラグが定義されている | E-03 | ○ |
| C-07 | filenameフラグが定義されている | E-03 | ○ |
| C-08 | Completeが有効なFactory/Commandで初期化を完了する | E-04 | ○ |
| C-09 | filenameもkustomizeも未指定時にCompleteがエラーを返す | E-04 | ○ |
| C-10 | Namespaceが正しく取得される | E-04 | ○ |
| C-11 | builderが正しく設定される | E-04 | ○ |
| C-12 | validatorが正しく設定される | E-04 | ○ |
| C-13 | Printerが正しく生成される | E-04 | ○ |
| C-14 | apps/v1 Deploymentのextensions/v1beta1への変換 | E-05, E-09 | ○ |
| C-15 | extensions/v1beta1 Deploymentのapps/v1beta2への変換 | E-05, E-09 | ○ |
| C-16 | v1beta1 Ingressリソースの変換 | E-05, E-09 | ○ |
| C-17 | 複数リソース（ServiceとIngress）の一括変換 | E-05, E-09 | ○ |
| C-18 | infosが0件の場合に"no objects passed to convert"エラー | E-05 | ○ |
| C-19 | 不正なOutputVersion指定時のParseGroupVersionエラー | E-05 | ○ |
| C-20 | OutputVersion未指定時のlatestバージョン変換 | E-05 | ○ |
| C-21 | localモードでAPIサーバーへの通信が発生しない | E-05, E-09 | ○ |
| C-22 | 非localモードでvalidatorが呼び出される | E-05 | ○ |
| C-23 | 非localモードでvalidatorエラー時にエラーが伝播する | E-05 | ○ |
| C-24 | YAML形式で出力される | E-02, E-05 | ○ |
| C-25 | tryConvertが有効なオブジェクトとバージョンで変換成功 | E-08 | ○ |
| C-26 | 空GroupVersion指定時に元オブジェクトがそのまま返る | E-08 | ○ |
| C-27 | 全バージョン変換失敗時にlastエラーが返る | E-08 | ○ |
| C-28 | versionsが空スライスの場合の戻り値 | E-08 | △ |
| C-29 | 複数バージョンの2番目で変換成功するフォールバック | E-08 | ○ |
| C-30 | バージョンリストが1件の場合の動作 | E-08 | ○ |
| C-31 | 単一InfoオブジェクトがList以外で返却される | E-06 | ○ |
| C-32 | forceList=trueで単一InfoがListとして返却される | E-06 | △ |
| C-33 | 複数InfoオブジェクトがListとして返却される | E-06 | ○ |
| C-34 | specifiedOutputVersion空時のデフォルトv1でのList変換 | E-06 | ○ |
| C-35 | asVersionedObjectsエラー時のエラー伝播 | E-06 | ○ |
| C-36 | actualVersionとspecifiedOutputVersionが異なる場合のログ出力 | E-06 | ○ |
| C-37 | asVersionedObjectsの基本変換動作 | E-07 | ○ |
| C-38 | Info.Objectがnilの場合のスキップ処理 | E-07 | ○ |
| C-39 | スキーマ未登録オブジェクトのruntime.Unknownへのフォールバック | E-07 | △ |
| C-40 | NotRegisteredError時の警告出力と処理続行 | E-07 | ○ |
| C-41 | NotRegisteredError以外のエラー時のエラー返却 | E-07 | ○ |
| C-42 | infosが空スライスの場合に空結果が返る | E-07 | ○ |
| C-43 | specifiedOutputVersion空時のObjectKindsによるバージョン決定 | E-07 | ○ |
| C-44 | 未登録オブジェクトのエンコード失敗時のエラー返却 | E-07 | △ |
| C-45 | 全APIグループがlegacyschemeに登録されている | E-10, E-11 | ○ |
| C-46 | extensions APIの優先度（最後にインポート） | E-10 | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: tryConvertのversionsが空スライスの場合、forループが実行されずlast=nilのまま(nil, nil)が返る動作はコードから推定可能だが、明示的なテストやドキュメントはない
  - 候補：tryConvertの単体テスト / Goのfor-rangeの空スライス挙動
- C-32: forceList=trueかつlen(objects)==1の場合のコードパスは明確だが、統合テストでのカバレッジは確認できていない
  - 候補：asVersionedObjectの単体テスト
- C-39: NotRegisteredErrorによるJSONエンコードフォールバックのパスは、実行時の具体的なオブジェクト型に依存する
  - 候補：asVersionedObjectsの単体テスト / runtime.Encodeのドキュメント
- C-44: runtime.Encodeがエラーを返す条件は、エンコーダの実装とオブジェクトの型に依存するため、具体的なエラーケースの特定が困難
  - 候補：runtime.Encodeの実装詳細 / エンコーダのテストケース
- C-46: Goのimport順序がscheme登録の優先度に影響する仕組みはコメント（L47）に記載があるが、その動作の検証は間接的
  - 候補：import_known_versions_test.go / Kubernetes issue #112682

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NewConvertOptions/NewCmdConvertのコンストラクタ系テスト（C-01〜C-07）は直接的なコード根拠あり
- 0: 低リスク - Completeメソッドの正常系・異常系テスト（C-08〜C-13）はコードの分岐と直接対応
- 0: 低リスク - 既存テストで確認済みの変換テスト（C-14〜C-17）
- 0: 低リスク - RunConvertの基本的なエラーハンドリング（C-18〜C-24）はコードの分岐と直接対応
- 1: 中リスク - tryConvertの境界値テスト（C-28）は推定に基づく
- 1: 中リスク - 未登録オブジェクトのフォールバック（C-39, C-44）は実行時依存の動作
- 1: 中リスク - extensions APIのimport順序（C-46）は間接的な根拠のみ
- 0: 低リスク - APIグループ登録テスト（C-45）は既存テストTestKnownVersionsで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] tryConvertにversions空スライスを渡した場合の(nil, nil)戻り値が意図した動作か確認
- [ ] forceList=trueの単一オブジェクト変換パスが実際のユースケースで使用されるか確認
- [ ] 未登録オブジェクトのruntime.Unknownへのフォールバックが全てのAPIバージョンで正しく動作するか確認
- [ ] runtime.Encodeのエラーパスが実際のオブジェクト型で再現可能か確認
- [ ] extensions APIのimport順序による優先度制御が将来のAPIグループ追加時にも維持されるか確認
- [ ] テストケースの入力値に記載したYAMLファイルパスが実在するテストフィクスチャと一致するか確認
