---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 93
  claims_with_evidence: 91
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：pkg-kubemark 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：91 / 93、根拠なし：2
- 優先レビュー（高）
  1. **C-68 (volumePlugins プラグイン種別)**: 各ProbeVolumePlugins()が返すプラグイン数は実装依存であり、コード上のappend呼び出し12回と実際の返却数は異なる可能性がある
  2. **C-91 (runNodeCreation ゴルーチン終了)**: ゴルーチンの終了を外部から直接検証する方法が実装依存であり、テスト手法の工夫が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/kubemark/controller.go` - KubemarkController構造体定義（L48-56）
- E-02: `pkg/kubemark/controller.go` - externalCluster構造体定義（L61-67）
- E-03: `pkg/kubemark/controller.go` - kubemarkCluster構造体定義（L73-79）
- E-04: `pkg/kubemark/controller.go` - NewKubemarkController関数（L83-113）
- E-05: `pkg/kubemark/controller.go` - WaitForCacheSync関数（L116-121）
- E-06: `pkg/kubemark/controller.go` - Run関数（L125-134）
- E-07: `pkg/kubemark/controller.go` - GetNodeNamesForNodeGroup関数（L137-148）
- E-08: `pkg/kubemark/controller.go` - GetNodeGroupSize関数（L151-158）
- E-09: `pkg/kubemark/controller.go` - GetNodeGroupTargetSize関数（L162-170）
- E-10: `pkg/kubemark/controller.go` - SetNodeGroupSize関数（L173-206）
- E-11: `pkg/kubemark/controller.go` - GetNodeGroupForNode関数（L210-220）
- E-12: `pkg/kubemark/controller.go` - addNodeToNodeGroup関数（L222-237）
- E-13: `pkg/kubemark/controller.go` - RemoveNodeFromNodeGroup関数（L239-265）
- E-14: `pkg/kubemark/controller.go` - getReplicationControllerByName関数（L267-278）
- E-15: `pkg/kubemark/controller.go` - getPodByName関数（L280-291）
- E-16: `pkg/kubemark/controller.go` - getNodeNameForPod関数（L293-304）
- E-17: `pkg/kubemark/controller.go` - getNodeTemplate関数（L309-333）
- E-18: `pkg/kubemark/controller.go` - runNodeCreation関数（L335-351）
- E-19: `pkg/kubemark/controller.go` - kubemarkCluster.getHollowNodeName関数（L353-363）
- E-20: `pkg/kubemark/controller.go` - kubemarkCluster.removeUnneededNodes関数（L365-385）
- E-21: `pkg/kubemark/controller.go` - kubemarkCluster.markNodeForDeletion関数（L387-391）
- E-22: `pkg/kubemark/controller.go` - newReplicationControllerInformer関数（L393-396）
- E-23: `pkg/kubemark/controller.go` - newPodInformer関数（L398-401）
- E-24: `pkg/kubemark/controller.go` - 定数定義 namespaceKubemark, nodeGroupLabel, numRetries=3（L39-43）
- E-25: `pkg/kubemark/hollow_kubelet.go` - HollowKubelet構造体定義（L62-66）
- E-26: `pkg/kubemark/hollow_kubelet.go` - volumePlugins関数（L68-83）
- E-27: `pkg/kubemark/hollow_kubelet.go` - NewHollowKubelet関数（L85-120）
- E-28: `pkg/kubemark/hollow_kubelet.go` - HollowKubelet.Run関数（L123-131）
- E-29: `pkg/kubemark/hollow_kubelet.go` - HollowKubeletOptions構造体定義（L134-142）
- E-30: `pkg/kubemark/hollow_kubelet.go` - GetHollowKubeletConfig関数（L146-210）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NewKubemarkControllerが有効なクライアントでKubemarkControllerを返す | E-04 | ○ |
| C-02 | 内部フィールド（createNodeQueue, nodeGroupQueueSize, rand）が正しく初期化される | E-04 | ○ |
| C-03 | externalClusterのフィールド（client, rcLister, podLister等）が正しく設定される | E-02, E-04 | ○ |
| C-04 | kubemarkClusterのフィールド（client, nodeLister, nodesToDelete等）が正しく設定される | E-03, E-04 | ○ |
| C-05 | WaitForCacheSyncが全キャッシュ同期済みでtrueを返す | E-05 | ○ |
| C-06 | WaitForCacheSyncがタイムアウト時falseを返す | E-05 | ○ |
| C-07 | GetNodeNamesForNodeGroupが対象ラベル付きPod名一覧を返す | E-07 | ○ |
| C-08 | GetNodeNamesForNodeGroupがPod0件で空スライスを返す | E-07 | ○ |
| C-09 | GetNodeNamesForNodeGroupがPod1件で1件スライスを返す | E-07 | ○ |
| C-10 | GetNodeNamesForNodeGroupがpodListerエラー時にエラー伝播する | E-07 | ○ |
| C-11 | GetNodeGroupSizeがRC数を返す | E-08 | ○ |
| C-12 | GetNodeGroupSizeがRC0件で0を返す | E-08 | ○ |
| C-13 | GetNodeGroupSizeがrcListerエラー時にエラー伝播する | E-08 | ○ |
| C-14 | GetNodeGroupTargetSizeが現在サイズ+キューサイズを返す | E-09 | ○ |
| C-15 | GetNodeGroupTargetSizeがキュー空時に現在サイズのみ返す | E-09 | ○ |
| C-16 | GetNodeGroupTargetSizeが内部エラー時にエラー伝播する | E-09 | ○ |
| C-17 | SetNodeGroupSizeがサイズ増加時にキューにメッセージ追加する | E-10 | ○ |
| C-18 | SetNodeGroupSizeがサイズ減少時にノード削除する | E-10 | ○ |
| C-19 | SetNodeGroupSizeがサイズ不変時に何もしない | E-10 | ○ |
| C-20 | SetNodeGroupSizeが削除ノード数超過時にエラーを返す | E-10 | ○ |
| C-21 | SetNodeGroupSizeが内部エラー時にエラー伝播する | E-10 | ○ |
| C-22 | SetNodeGroupSizeがスケールダウン中のRemoveNodeFromNodeGroupエラーを伝播する | E-10 | ○ |
| C-23 | GetNodeGroupForNodeがノードグループ名を返す | E-11 | ○ |
| C-24 | GetNodeGroupForNodeが存在しないノードでエラーを返す | E-11 | ○ |
| C-25 | GetNodeGroupForNodeがラベル欠損時にエラーを返す | E-11 | ○ |
| C-26 | addNodeToNodeGroupがRCを作成する | E-12 | ○ |
| C-27 | addNodeToNodeGroupが正しいラベルを設定する | E-12 | ○ |
| C-28 | addNodeToNodeGroupがSpec.Template.LabelsとLabelsを一致させる | E-12 | ○ |
| C-29 | addNodeToNodeGroupがDeepCopyを使い元テンプレートを変更しない | E-12 | ○ |
| C-30 | addNodeToNodeGroupが3回失敗でエラーを返す | E-12, E-24 | ○ |
| C-31 | addNodeToNodeGroupが2回失敗後3回目で成功する | E-12, E-24 | ○ |
| C-32 | addNodeToNodeGroupが初回失敗後2回目で成功する | E-12, E-24 | ○ |
| C-33 | RemoveNodeFromNodeGroupが正常にRC削除しマーク付与する | E-13 | ○ |
| C-34 | RemoveNodeFromNodeGroupがDeletePropagationForegroundを使用する | E-13 | ○ |
| C-35 | RemoveNodeFromNodeGroupが存在しないノードでnilを返す | E-13 | ○ |
| C-36 | RemoveNodeFromNodeGroupがグループ不一致でエラーを返す | E-13 | ○ |
| C-37 | RemoveNodeFromNodeGroupが3回失敗でエラーを返す | E-13, E-24 | ○ |
| C-38 | getReplicationControllerByNameが指定名のRCを返す | E-14 | ○ |
| C-39 | getReplicationControllerByNameが未検出時nilを返す | E-14 | ○ |
| C-40 | getReplicationControllerByNameがリスターエラー時nilを返す | E-14 | ○ |
| C-41 | getReplicationControllerByNameが複数RC存在時に最初の一致を返す | E-14 | ○ |
| C-42 | getPodByNameが指定名のPodを返す | E-15 | ○ |
| C-43 | getPodByNameが未検出時nilを返す | E-15 | ○ |
| C-44 | getPodByNameがリスターエラー時nilを返す | E-15 | ○ |
| C-45 | getNodeNameForPodがnameラベルを返す | E-16 | ○ |
| C-46 | getNodeNameForPodが未検出時エラーを返す | E-16 | ○ |
| C-47 | getNodeNameForPodがリスターエラー時エラー伝播する | E-16 | ○ |
| C-48 | getNodeTemplateがReplicas=1, Namespace=kubemark, Selector=nilのテンプレートを返す | E-17, E-24 | ○ |
| C-49 | getNodeTemplateのSpec.TemplateがオリジナルRCのSpec.Templateと一致する | E-17 | ○ |
| C-50 | getNodeTemplateがhollow node未存在時エラーを返す | E-17 | ○ |
| C-51 | getNodeTemplateがgetNodeNameForPodエラー時エラー伝播する | E-17 | ○ |
| C-52 | getNodeTemplateがRC未検出時エラーを返す | E-17 | ○ |
| C-53 | getHollowNodeNameがnodeGroupLabel付きノード名を返す | E-19 | ○ |
| C-54 | getHollowNodeNameが複数ノード存在時に最初のノード名を返す | E-19 | ○ |
| C-55 | getHollowNodeNameがhollow node0件でエラーを返す | E-19 | ○ |
| C-56 | getHollowNodeNameがリスターエラー時エラー伝播する | E-19 | ○ |
| C-57 | removeUnneededNodesがNotReady+削除マーク済みノードを削除する | E-20 | ○ |
| C-58 | removeUnneededNodesがReady状態ノードを削除しない | E-20 | ○ |
| C-59 | removeUnneededNodesが削除マークなしNotReadyノードを削除しない | E-20 | ○ |
| C-60 | removeUnneededNodesが削除マークfalseのNotReadyノードを削除しない | E-20 | ○ |
| C-61 | removeUnneededNodesが非Node型オブジェクトで何もしない | E-20 | ○ |
| C-62 | removeUnneededNodesがDelete APIエラー時panicせずログ出力する | E-20 | ○ |
| C-63 | removeUnneededNodesがNodeReady条件なしの場合何もしない | E-20 | ○ |
| C-64 | markNodeForDeletionがノード名をtrueで登録する | E-21 | ○ |
| C-65 | markNodeForDeletionが再マークで上書きする | E-21 | ○ |
| C-66 | newReplicationControllerInformerがSharedIndexInformerを返す | E-22 | ○ |
| C-67 | newPodInformerがSharedIndexInformerを返す | E-23 | ○ |
| C-68 | volumePluginsが12種類のプラグイン（emptydir等）を含むスライスを返す | E-26 | △ |
| C-69 | volumePluginsが空でないスライスを返す | E-26 | ○ |
| C-70 | NewHollowKubeletが非nilのHollowKubeletを返す | E-27 | ○ |
| C-71 | NewHollowKubeletがKubeletDepsフィールドを正しく設定する | E-27 | ○ |
| C-72 | NewHollowKubeletがTLSOptions=nilに設定する | E-27 | ○ |
| C-73 | NewHollowKubeletがFakeコンポーネント（FakeOS, FakeMounter等）を設定する | E-27 | ○ |
| C-74 | NewHollowKubeletがKubeletFlagsとConfigをそのまま引き渡す | E-27 | ○ |
| C-75 | GetHollowKubeletConfigがKubeletFlagsとConfigを返す | E-30 | ○ |
| C-76 | GetHollowKubeletConfigがNodeNameをHostnameOverrideに反映する | E-30 | ○ |
| C-77 | GetHollowKubeletConfigがPort設定を反映する | E-30 | ○ |
| C-78 | GetHollowKubeletConfigがMaxPods/PodsPerCoreを反映する | E-30 | ○ |
| C-79 | GetHollowKubeletConfigがProviderIDをkubemark://形式で設定する | E-30 | ○ |
| C-80 | GetHollowKubeletConfigがNodeLabelsを反映する | E-30 | ○ |
| C-81 | GetHollowKubeletConfigがRegisterWithTaintsを反映する | E-30 | ○ |
| C-82 | GetHollowKubeletConfigがデフォルト値を正しく設定する | E-30 | ○ |
| C-83 | GetHollowKubeletConfigが一時ディレクトリを作成する | E-30 | ○ |
| C-84 | GetHollowKubeletConfigが時間関連デフォルト設定を正しく設定する | E-30 | ○ |
| C-85 | GetHollowKubeletConfigがGC関連デフォルト設定を正しく設定する | E-30 | ○ |
| C-86 | GetHollowKubeletConfigがMaxPods=0で正しく設定する | E-30 | ○ |
| C-87 | GetHollowKubeletConfigが空NodeLabelsで正しく動作する | E-30 | ○ |
| C-88 | GetHollowKubeletConfigがnil Taintsで正しく動作する | E-30 | ○ |
| C-89 | GetHollowKubeletConfigが空ノード名でProviderIDを正しく設定する | E-30 | ○ |
| C-90 | runNodeCreationがキューからノードを追加する | E-18 | ○ |
| C-91 | runNodeCreationがstopチャネルクローズで終了する | E-18 | △ |
| C-92 | runNodeCreationが失敗時にキューサイズを保持する | E-18 | ○ |
| C-93 | runNodeCreationが複数メッセージを順次処理する | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-68: volumePluginsが返すプラグイン種別はコード上のappend呼び出し（12回）から推定しているが、各ProbeVolumePlugins()が複数プラグインを返す可能性があり、実際の返却スライス長は実行時に確認が必要
  - 候補：各ProbeVolumePlugins()の戻り値を個別に確認 / テスト実行時に実数確認
- C-91: runNodeCreationのゴルーチン終了確認は、select文のstopケース（L347-348）から論理的に導出しているが、ゴルーチン終了を外部から直接テストする方法は実装に依存する
  - 候補：チャネル+WaitGroupでのゴルーチン終了待ち / タイムアウト付き検証

## 5) リスクフラグ（レビュー観点）
- 0: controller.goの各メソッドはリスター/クライアントのモック化により単体テスト可能（低リスク）
- 1: volumePluginsのプラグイン数は各プラグインライブラリの実装変更で変動する可能性あり（中リスク）
- 1: Run関数はklog.Fatalを使用しており、テスト時にプロセス終了を回避する工夫が必要（中リスク）
- 0: GetHollowKubeletConfigは副作用（一時ディレクトリ作成）があるため、テスト後のクリーンアップに注意（低リスク）
- 1: runNodeCreation内のゴルーチン制御はテスト設計上の工夫が必要（中リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがcontroller.goの全publicメソッド（NewKubemarkController, WaitForCacheSync, Run, GetNodeNamesForNodeGroup, GetNodeGroupSize, GetNodeGroupTargetSize, SetNodeGroupSize, GetNodeGroupForNode, RemoveNodeFromNodeGroup）をカバーしているか
- [ ] テストケースがhollow_kubelet.goの全public関数/メソッド（NewHollowKubelet, Run, GetHollowKubeletConfig）をカバーしているか
- [ ] 各メソッドの正常系・異常系・境界値が適切にカバーされているか
- [ ] numRetries=3のリトライロジック（addNodeToNodeGroup, RemoveNodeFromNodeGroup）のテストケースが含まれているか
- [ ] removeUnneededNodesの条件分岐（NodeReady状態、削除マーク有無、マークfalse）が網羅されているか
- [ ] volumePluginsの返却プラグイン種別が実際のコードと一致しているか確認
- [ ] SetNodeGroupSizeのスケールアップ/スケールダウン/変更なしの3パターンが網羅されているか
