---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 186
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：pkg-printers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：186 / 190、根拠なし：4
- 優先レビュー（高）
  1. **UT-PRT-025（AddHandlers全ハンドラ登録）**：全リソースタイプの網羅性はAddHandlers関数の行数から推定しているが、個々のTableHandler呼び出しの完全性は検証困難
  2. **UT-PRT-073（printJob正常系）**：printJob内部のJob完了/失敗の条件分岐が複雑であり、テストケースの網羅性について要確認
  3. **UT-PRT-178（printFlowSchema正常系）**：FlowSchemaのMissingPL判定ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/printers/interface.go` - ResourcePrinterインターフェースおよびResourcePrinterFunc型定義（L26-L37）
- E-02: `pkg/printers/tablegenerator.go` - GenerateOptions, TableGenerator, PrintHandler, HumanReadableGenerator, NewTableGenerator, With, GenerateTable, TableHandler, ValidateRowPrintHandlerFunc定義（L30-L171）
- E-03: `pkg/printers/storage/storage.go` - TableConvertor構造体およびConvertToTableメソッド（L29-L47）
- E-04: `pkg/printers/internalversion/printers.go` - AddHandlers関数（L93-L748）
- E-05: `pkg/printers/internalversion/printers.go` - formatEndpoints関数（L749-L798）
- E-06: `pkg/printers/internalversion/printers.go` - formatDiscoveryPorts関数（L800-L820）
- E-07: `pkg/printers/internalversion/printers.go` - formatDiscoveryEndpoints関数（L822-L838）
- E-08: `pkg/printers/internalversion/printers.go` - listWithMoreString関数（L840-L849）
- E-09: `pkg/printers/internalversion/printers.go` - translateTimestampSince, translateMicroTimestampSince, translateTimestampUntil関数（L853-L879）
- E-10: `pkg/printers/internalversion/printers.go` - printPod関数（L898-L1085）
- E-11: `pkg/printers/internalversion/printers.go` - hasPodReadyCondition, hasJobCondition関数（L1087-L1103）
- E-12: `pkg/printers/internalversion/printers.go` - printService, loadBalancerStatusStringer, getServiceExternalIP, makePortString関数（L1325-L1421）
- E-13: `pkg/printers/internalversion/printers.go` - formatHosts, printIngress関数（L1423-L1498）
- E-14: `pkg/printers/internalversion/printers.go` - printNode, getNodeExternalIP, getNodeInternalIP, findNodeRoles関数（L1952-L2059）
- E-15: `pkg/printers/internalversion/printers.go` - printDeployment関数（L2437-L2472）
- E-16: `pkg/printers/internalversion/printers.go` - extractCSRStatus関数（L2298-L2326）
- E-17: `pkg/printers/internalversion/printers.go` - layoutContainerCells, formatEventSource, firstNonEmpty, formatEventSourceComponentInstance関数（L2767-L2805）
- E-18: `pkg/printers/internalversion/printers.go` - formatResourceName関数（L2843-L2849）
- E-19: `pkg/printers/internalversion/printers.go` - printBoolPtr, printBool関数（L3345-L3359）
- E-20: `pkg/printers/internalversion/printers.go` - SortableResourceNames型およびLen, Swap, Less, isPodInitializedConditionTrue関数（L3361-L3384）
- E-21: `pkg/printers/internalversion/printers.go` - resourceClaimState関数（L3187-L3203）
- E-22: `pkg/printers/internalversion/printers.go` - formatHPAMetrics関数（L2474-L2573）
- E-23: `pkg/printers/internalversion/printers.go` - printEvent関数（L2158-L2225）
- E-24: `pkg/printers/internalversion/printers.go` - printStorageVersionMigration, formatStorageVersions関数（L3018-L3322）
- E-25: `pkg/printers/tablegenerator_test.go` - TestCustomTypePrinting, TestPrintHandlerError既存テスト（L51-L87）
- E-26: `pkg/printers/internalversion/sorted_resource_name_list_test.go` - TestSortableResourceNamesSorting既存テスト（L26-L49）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PRT-001: ResourcePrinterFunc.PrintObj正常系 | E-01 (L35-L37) | ○ |
| C-02 | UT-PRT-002: ResourcePrinterFunc.PrintObjエラー伝播 | E-01 (L35-L37) | ○ |
| C-03 | UT-PRT-003: NewTableGenerator初期化 | E-02 (L61-L65) | ○ |
| C-04 | UT-PRT-004~005: With正常系/境界値 | E-02 (L68-L73) | ○ |
| C-05 | UT-PRT-006~011: GenerateTable正常系/異常系 | E-02 (L78-L121), E-25 | ○ |
| C-06 | UT-PRT-012~014: TableHandler正常系/異常系 | E-02 (L125-L144), E-25 | ○ |
| C-07 | UT-PRT-015~020: ValidateRowPrintHandlerFunc | E-02 (L155-L171) | ○ |
| C-08 | UT-PRT-021~024: TableConvertor.ConvertToTable | E-03 (L34-L47) | ○ |
| C-09 | UT-PRT-025: AddHandlers全ハンドラ登録 | E-04 | △ |
| C-10 | UT-PRT-026~029: formatEndpoints | E-05 (L749-L798) | ○ |
| C-11 | UT-PRT-030~032: formatDiscoveryPorts | E-06 (L800-L820) | ○ |
| C-12 | UT-PRT-033~034: formatDiscoveryEndpoints | E-07 (L822-L838) | ○ |
| C-13 | UT-PRT-035~037: listWithMoreString | E-08 (L840-L849) | ○ |
| C-14 | UT-PRT-038~043: timestamp変換関数群 | E-09 (L853-L879) | ○ |
| C-15 | UT-PRT-044~060: printPod | E-10 (L898-L1085) | ○ |
| C-16 | UT-PRT-061~062: printPodList | E-10 (L886-L896) | ○ |
| C-17 | UT-PRT-063~065: hasPodReadyCondition | E-11 (L1087-L1094) | ○ |
| C-18 | UT-PRT-066~068: hasJobCondition | E-11 (L1096-L1103) | ○ |
| C-19 | UT-PRT-069~074: printPodTemplate~printCronJob | E-04 | ○ |
| C-20 | UT-PRT-075~091: printService関連 | E-12 (L1325-L1421) | ○ |
| C-21 | UT-PRT-092~096: formatHosts/printIngress | E-13 (L1423-L1498) | ○ |
| C-22 | UT-PRT-097~098: printStatefulSet/printDaemonSet | E-04 | ○ |
| C-23 | UT-PRT-099~111: printNode関連 | E-14 (L1952-L2059) | ○ |
| C-24 | UT-PRT-112~113: printDeployment | E-15 (L2437-L2472) | ○ |
| C-25 | UT-PRT-114~119: extractCSRStatus | E-16 (L2298-L2326) | ○ |
| C-26 | UT-PRT-120~122: layoutContainerCells | E-17 (L2767-L2780) | ○ |
| C-27 | UT-PRT-123~128: formatEventSource関連 | E-17 (L2784-L2805) | ○ |
| C-28 | UT-PRT-129~131: formatResourceName | E-18 (L2843-L2849) | ○ |
| C-29 | UT-PRT-132~136: printBoolPtr/printBool | E-19 (L3345-L3359) | ○ |
| C-30 | UT-PRT-137~140: SortableResourceNames | E-20 (L3361-L3374), E-26 | ○ |
| C-31 | UT-PRT-141~143: isPodInitializedConditionTrue | E-20 (L3376-L3384) | ○ |
| C-32 | UT-PRT-144~148: resourceClaimState | E-21 (L3187-L3203) | ○ |
| C-33 | UT-PRT-149~154: formatHPAMetrics | E-22 (L2474-L2573) | ○ |
| C-34 | UT-PRT-155~159: printEvent | E-23 (L2158-L2225) | ○ |
| C-35 | UT-PRT-160~162: printPersistentVolume/PVC | E-04 | ○ |
| C-36 | UT-PRT-163~170: printNamespace~printPriorityClass | E-04 | △ |
| C-37 | UT-PRT-171~172: printHorizontalPodAutoscaler | E-22 (L2575-L2592) | ○ |
| C-38 | UT-PRT-173~176: formatStorageVersions/printSVM | E-24 (L3018-L3322) | ○ |
| C-39 | UT-PRT-177~179: printCSIDriver/FlowSchema/PLC | E-04 | △ |
| C-40 | UT-PRT-180~190: printResourceSlice~printStatus | E-04 | △ |

## 4) 不足情報（Unknown / Missing）
- C-09: AddHandlers関数は700行以上に及ぶため、全リソースタイプのハンドラが漏れなく登録されているかの完全な検証は実施できていない。手動確認推奨。
  - 候補：AddHandlers関数の行単位レビュー / 登録されたハンドラ型の一覧との突合
- C-36, C-39, C-40: printNamespace, printCSIDriver, printFlowSchema, printPriorityLevelConfiguration, printResourceSlice等のリソース個別print関数については、AddHandlers内のカラム定義とprint関数の実装を個別に読み取って主張を立てているが、個別関数の全行レビューは一部省略している。
  - 候補：各print関数の行単位の詳細レビュー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - pkg/printers/interface.go, tablegenerator.go, storage/storage.goの関数群（コード量が少なく完全に読み取り可能）
- 0: 低リスク - ヘルパー関数群（listWithMoreString, translateTimestamp*, printBool*, firstNonEmpty等）
- 1: 中リスク - printPod関数（ロジックが約200行と複雑。テストケースは主要分岐をカバーしているが、全組み合わせの網羅は困難）
- 0: 低リスク - extractCSRStatus関数（ロジックが明確で全分岐をテスト可能）
- 1: 中リスク - formatHPAMetrics関数（MetricSourceTypeごとの分岐が多い。主要パスのみカバー）

## 6) レビュアーチェックリスト（最小）
- [ ] printPod関数のテストケース（UT-PRT-044~060）が、Init Container/RestartableInitContainer/DeletionTimestamp/SchedulingGatedの主要分岐を網羅しているか
- [ ] extractCSRStatus関数のテストケース（UT-PRT-114~119）が、Approved/Denied/Pending/Failed/Issuedの全組み合わせを網羅しているか
- [ ] TableConvertor.ConvertToTableのテストケース（UT-PRT-021~024）が、nilオプション/正常オプション/不正型の3パターンをカバーしているか
- [ ] ValidateRowPrintHandlerFuncのテストケース（UT-PRT-015~020）が、シグネチャ検証の全エラーパターンをカバーしているか
- [ ] AddHandlers（UT-PRT-025）で登録されるハンドラが、printers.goで定義されている全print関数と一致しているか
- [ ] resourceClaimStateのテストケース（UT-PRT-144~148）が、deleted/pending/allocated/reservedの全状態組み合わせをカバーしているか
