---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 77
  claims_with_evidence: 74
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：pkg-probe 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：74 / 77、根拠なし：3
- 優先レビュー（高）
  1. **UT-PRB-022（ExitStatus=0でSuccess）**：ExitErrorでExitStatus()=0となるケースの実運用での発生シナリオの根拠が不足
  2. **UT-PRB-032（ボディ読み取りエラー）**：utilio.ReadAtMostがErrLimitReached以外のエラーを返す具体的条件の根拠が不足
  3. **UT-PRB-054（不正パスフォールバック）**：url.Parseが失敗する具体的なパス文字列パターンの根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/probe/probe.go` - Result型定義（Success, Warning, Failure, Unknown定数）
- E-02: `pkg/probe/util.go` - ResolveContainerPort関数（ポート解決ロジック、port > 0 && port < 65536の範囲チェック）、findPortByName関数
- E-03: `pkg/probe/util_test.go` - 既存テストケース（TestFindPortByName: 2ケース、TestResolveContainerPort: 5ケース）
- E-04: `pkg/probe/exec/exec.go` - execProber.Probe関数（Start/Wait/ExitError/ErrCommandTimedOut分岐）、maxReadLength=10*1<<10定数
- E-05: `pkg/probe/http/http.go` - DoHTTPProbe関数（StatusCode範囲判定）、RedirectChecker関数（ホスト比較、10回制限）、httpProber構造体、maxRespBodyLength=10*1<<10定数
- E-06: `pkg/probe/http/request.go` - NewProbeRequest, NewRequestForHTTPGetAction, formatURL, v1HeaderToHTTPHeader, newProbeRequest, userAgent関数
- E-07: `pkg/probe/tcp/tcp.go` - DoTCPProbe関数（ProbeDialer使用、Dial/Close）、tcpProber.Probe関数
- E-08: `pkg/probe/grpc/grpc.go` - grpcProber.Probe関数（gRPCヘルスチェック、接続タイムアウト、Unimplemented/DeadlineExceeded/その他エラー分岐、status.FromError判定）
- E-09: `pkg/probe/dialer_others.go` - ProbeDialer関数（非Windows版、SO_LINGER: Onoff=1, Linger=1）
- E-10: `pkg/probe/dialer_windows.go` - ProbeDialer関数（Windows版、syscall.Handle(fd)使用）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PRB-001: Int型パラメータで有効なポート番号が解決される | E-02, E-03 | ○ |
| C-02 | UT-PRB-002: String型パラメータでポート名から解決される | E-02, E-03 | ○ |
| C-03 | UT-PRB-003: 数値文字列からポート番号が解決される(Atoiフォールバック) | E-02 | ○ |
| C-04 | UT-PRB-004: 65536以上でエラー(port < 65536条件) | E-02, E-03 | ○ |
| C-05 | UT-PRB-005: ポート番号0でエラー(port > 0条件) | E-02 | ○ |
| C-06 | UT-PRB-006: 負のポート番号でエラー | E-02 | ○ |
| C-07 | UT-PRB-007: 存在しないポート名かつ非数値文字列でエラー | E-02, E-03 | ○ |
| C-08 | UT-PRB-008: 不正なType値でエラー(switchのdefault) | E-02, E-03 | ○ |
| C-09 | UT-PRB-009: ポート番号1で正常解決(最小有効値) | E-02 | ○ |
| C-10 | UT-PRB-010: ポート番号65535で正常解決(最大有効値) | E-02 | ○ |
| C-11 | UT-PRB-011: findPortByNameで存在するポート名で正しいポート | E-02, E-03 | ○ |
| C-12 | UT-PRB-012: findPortByNameで存在しないポート名でエラー | E-02, E-03 | ○ |
| C-13 | UT-PRB-013: Portsが空でエラー | E-02 | ○ |
| C-14 | UT-PRB-014: 同名ポート複数で最初が返る(range順) | E-02 | ○ |
| C-15 | UT-PRB-015: ProbeDialerが非nilのnet.Dialerを返す | E-09, E-10 | ○ |
| C-16 | UT-PRB-016: DialerにControl関数が設定されている | E-09 | ○ |
| C-17 | UT-PRB-017: exec.NewがProberを返す | E-04 | ○ |
| C-18 | UT-PRB-018: コマンド正常終了(err==nil)でSuccess | E-04, E-01 | ○ |
| C-19 | UT-PRB-019: 非ゼロ終了(ExitError)でFailure | E-04, E-01 | ○ |
| C-20 | UT-PRB-020: Start失敗でUnknown | E-04, E-01 | ○ |
| C-21 | UT-PRB-021: ErrCommandTimedOutでFailure | E-04, E-01 | ○ |
| C-22 | UT-PRB-022: ExitStatus=0でSuccess | E-04 | △ |
| C-23 | UT-PRB-023: 10KB超出力のLimitWriter切り詰め | E-04 | ○ |
| C-24 | UT-PRB-024: http.NewがProberを返す | E-05 | ○ |
| C-25 | UT-PRB-025: NewWithTLSConfigがProberを返す | E-05 | ○ |
| C-26 | UT-PRB-026: HTTP200でSuccess | E-05, E-01 | ○ |
| C-27 | UT-PRB-027: HTTP201でSuccess | E-05 | ○ |
| C-28 | UT-PRB-028: HTTP301でWarning | E-05, E-01 | ○ |
| C-29 | UT-PRB-029: HTTP400でFailure | E-05, E-01 | ○ |
| C-30 | UT-PRB-030: HTTP500でFailure | E-05 | ○ |
| C-31 | UT-PRB-031: HTTP通信エラーでFailure | E-05 | ○ |
| C-32 | UT-PRB-032: ボディ読み取りエラー(ErrLimitReached以外)でFailure | E-05 | △ |
| C-33 | UT-PRB-033: 10KB超レスポンスの非致命的切り詰め | E-05 | ○ |
| C-34 | UT-PRB-034: HTTP199でFailure | E-05 | ○ |
| C-35 | UT-PRB-035: HTTP399でWarning | E-05 | ○ |
| C-36 | UT-PRB-036: followNonLocalRedirects=trueでnil | E-05 | ○ |
| C-37 | UT-PRB-037: 同一ホストリダイレクト許可 | E-05 | ○ |
| C-38 | UT-PRB-038: 異なるホストリダイレクト拒否 | E-05 | ○ |
| C-39 | UT-PRB-039: 10回以上リダイレクトでエラー | E-05 | ○ |
| C-40 | UT-PRB-040: NewProbeRequestで有効URLリクエスト生成 | E-06 | ○ |
| C-41 | UT-PRB-041: User-Agent自動設定 | E-06 | ○ |
| C-42 | UT-PRB-042: Accept自動設定(*/*) | E-06 | ○ |
| C-43 | UT-PRB-043: カスタムUser-Agent保持 | E-06 | ○ |
| C-44 | UT-PRB-044: 空Accept削除 | E-06 | ○ |
| C-45 | UT-PRB-045: HostヘッダーがReq.Hostに設定 | E-06 | ○ |
| C-46 | UT-PRB-046: カスタムAcceptヘッダー保持 | E-06 | ○ |
| C-47 | UT-PRB-047: HTTPGetActionリクエスト生成 | E-06, E-02 | ○ |
| C-48 | UT-PRB-048: Host空でpodIP使用 | E-06 | ○ |
| C-49 | UT-PRB-049: Scheme空でhttp使用 | E-06 | ○ |
| C-50 | UT-PRB-050: SchemeがHTTPSでhttps使用 | E-06 | ○ |
| C-51 | UT-PRB-051: 無効ポートでエラー | E-06, E-02 | ○ |
| C-52 | UT-PRB-052: formatURLで正しいURL生成 | E-06 | ○ |
| C-53 | UT-PRB-053: クエリパラメータ付きパス | E-06 | ○ |
| C-54 | UT-PRB-054: 不正パスフォールバック | E-06 | △ |
| C-55 | UT-PRB-055: IPv6ホストの処理 | E-06 | ○ |
| C-56 | UT-PRB-056: v1HeaderToHTTPHeaderでヘッダー変換 | E-06 | ○ |
| C-57 | UT-PRB-057: 空ヘッダーリストで空Header | E-06 | ○ |
| C-58 | UT-PRB-058: 同名ヘッダー複数値(Add) | E-06 | ○ |
| C-59 | UT-PRB-059: userAgent文字列生成 | E-06 | ○ |
| C-60 | UT-PRB-060: httpProber.Probe統合テスト | E-05 | ○ |
| C-61 | UT-PRB-061: tcp.NewがProberを返す | E-07 | ○ |
| C-62 | UT-PRB-062: TCP接続成功でSuccess | E-07, E-01 | ○ |
| C-63 | UT-PRB-063: TCP接続失敗でFailure | E-07, E-01 | ○ |
| C-64 | UT-PRB-064: DoTCPProbe接続成功(Dial+Close) | E-07 | ○ |
| C-65 | UT-PRB-065: DoTCPProbe接続失敗 | E-07 | ○ |
| C-66 | UT-PRB-066: DoTCPProbeタイムアウト | E-07 | ○ |
| C-67 | UT-PRB-067: grpc.NewがProberを返す | E-08 | ○ |
| C-68 | UT-PRB-068: gRPC SERVINGでSuccess | E-08, E-01 | ○ |
| C-69 | UT-PRB-069: gRPC NOT_SERVINGでFailure | E-08, E-01 | ○ |
| C-70 | UT-PRB-070: gRPC接続DeadlineExceeded | E-08 | ○ |
| C-71 | UT-PRB-071: gRPC接続エラー(非タイムアウト) | E-08 | ○ |
| C-72 | UT-PRB-072: gRPC Unimplemented | E-08 | ○ |
| C-73 | UT-PRB-073: gRPC DeadlineExceeded(Check応答) | E-08 | ○ |
| C-74 | UT-PRB-074: gRPCその他ステータスコードエラー(default) | E-08 | ○ |
| C-75 | UT-PRB-075: gRPC非gRPCステータスエラー(FromError失敗) | E-08 | ○ |
| C-76 | UT-PRB-076: サービス名指定ヘルスチェック | E-08 | ○ |
| C-77 | UT-PRB-077: Result型定数値の確認 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-22（ExitStatus=0でSuccess）**: コード上、ExitErrorインターフェースでExitStatus()=0を返すケースが存在する（exec.go L66-68）が、実際のKubernetes運用でこの状態が発生する具体的なシナリオの文書化がない。コード上は分岐が明確に存在するためテストケースとしては妥当だが、発生条件の根拠が不足。
  - 候補：CRI実装の仕様書 / コンテナランタイムのドキュメント / k8s.io/cri-client/pkgの仕様
- **C-32（ボディ読み取りエラー）**: utilio.ReadAtMostがErrLimitReached以外のエラーを返す具体的条件（http.go L103-108の分岐）が明示されていない。io.Readerの一般的なエラーケース（接続切断等）が該当すると推測される。
  - 候補：k8s.io/utils/ioパッケージのReadAtMostソースコード / io.Readerインターフェースの仕様
- **C-54（不正パスフォールバック）**: url.Parse()がエラーを返す具体的なパス文字列パターン（request.go L97-105の分岐）の根拠が不足。コメントにも「Something is busted with the path, but it's too late to reject it」と記載されておりレガシー互換のフォールバック処理。
  - 候補：Go標準ライブラリurl.Parse()のドキュメント / テストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - probe.go（型定義のみ、ロジックなし）
- 0: 低リスク - doc.go（パッケージドキュメントのみ）
- 0: 低リスク - dialer_others.go / dialer_windows.go（OS固有のDialer生成、テストはビルドタグに依存）
- 1: 中リスク - exec/exec.go（外部コマンド実行のモック化が必要、ExitError/ErrCommandTimedOutの分岐検証が重要）
- 1: 中リスク - grpc/grpc.go（gRPCサーバーのモック化が必要、接続タイムアウト・ヘルスチェックの5つのエラー分岐の網羅が重要）
- 0: 低リスク - http/http.go（HTTPステータスコード範囲判定、httptest.Serverでテスト可能）
- 0: 低リスク - http/request.go（リクエスト生成ロジック、ヘッダー処理の条件分岐が多いが静的テスト可能）
- 0: 低リスク - tcp/tcp.go（TCP接続、net.Listenでテスト可能）
- 0: 低リスク - util.go（ポート解決ロジック、既存テストが充実、既存テスト7ケースで主要パスをカバー済み）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-PRB-001〜010: ResolveContainerPortの全分岐（Int/String/default, 有効範囲内外、Atoiフォールバック）がカバーされているか
- [ ] UT-PRB-011〜014: findPortByNameの正常系・異常系・境界値（空リスト、重複名）が網羅されているか
- [ ] UT-PRB-018〜023: execProber.Probeの全分岐（成功/ExitError(status=0, status!=0)/ErrCommandTimedOut/Start失敗/出力制限）がカバーされているか
- [ ] UT-PRB-026〜035: DoHTTPProbeのHTTPステータスコード範囲（200-299: Success, 300-399: Warning, 400+: Failure, <200: Failure）が正しいか
- [ ] UT-PRB-036〜039: RedirectCheckerのリダイレクト制御ロジック（followNonLocalRedirects分岐、ホスト比較、10回制限）が網羅されているか
- [ ] UT-PRB-040〜059: HTTPリクエスト生成関連の各関数（User-Agent/Accept/Hostヘッダー処理、URL生成、ヘッダー変換）が正しく検証されているか
- [ ] UT-PRB-062〜066: TCP Probeの接続成功/失敗/タイムアウトの各パスがカバーされているか
- [ ] UT-PRB-068〜076: gRPC Probeの各レスポンス分岐（SERVING/NOT_SERVING/接続タイムアウト/接続エラー/Unimplemented/DeadlineExceeded/その他エラー/FromError失敗/サービス名指定）がカバーされているか
- [ ] gRPCおよびexecプローバーのモック戦略が適切か（外部依存の分離、インターフェースベースのモック化）
