---
generated_at: 2026-02-02 16:30:00
metrics:
  claims_total: 268
  claims_with_evidence: 260
  claims_without_evidence: 8
confidence_derived: 0.97
---

# 根拠レポート：pkg-proxy 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：260 / 268、根拠なし：8
- 優先レビュー（高）
  1. **UT-PRX-089, UT-PRX-090**：NodeManager.OnNodeChange のPodCIDR/NodeIP変更検出 - コード中にFIXMEコメントがあり、NodeIP変更時のexit動作がコメントアウトされている
  2. **UT-PRX-035, UT-PRX-036**：topologyModeFromHints - PreferSameTrafficDistributionフィーチャーゲートに依存するため、テスト時のフィーチャーゲート状態に注意
  3. **UT-PRX-190〜UT-PRX-199**：conntrack/sysctls.go - Linux固有のビルドタグ付きファイルのため、テスト実行環境に制約あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/proxy/types.go` - ServicePortName, fmtPortName関数定義
- E-02: `pkg/proxy/endpoint.go` - BaseEndpointInfo構造体と全メソッド定義
- E-03: `pkg/proxy/serviceport.go` - BaseServicePortInfo構造体と全メソッド、newBaseServiceInfo関数
- E-04: `pkg/proxy/topology.go` - CategorizeEndpoints, topologyModeFromHints, availableForTopology, filterEndpoints関数
- E-05: `pkg/proxy/endpointslicecache.go` - EndpointSliceCache構造体と全メソッド、endpointSliceCacheKeys関数
- E-06: `pkg/proxy/endpointschangetracker.go` - EndpointsChangeTracker, EndpointsMap, getLastChangeTriggerTime等
- E-07: `pkg/proxy/servicechangetracker.go` - ServiceChangeTracker, ServicePortMap, serviceChange等
- E-08: `pkg/proxy/node.go` - NodeManager構造体と全メソッド
- E-09: `pkg/proxy/metaproxier/meta_proxier.go` - metaProxier構造体と全メソッド
- E-10: `pkg/proxy/healthcheck/proxy_health.go` - ProxyHealthServer構造体と全メソッド
- E-11: `pkg/proxy/healthcheck/service_health.go` - server構造体、hcHandler、SyncServices、SyncEndpoints
- E-12: `pkg/proxy/healthcheck/common.go` - listener, httpServerFactory, httpServerインタフェース
- E-13: `pkg/proxy/util/utils.go` - IsZeroCIDR, ShouldSkipService, MapIPsByIPFamily, MapCIDRsByIPFamily, GetIPFamilyFromIP, OtherIPFamily, AppendPortIfNeeded, GetClusterIPByFamily, IsVIPMode, EnsureSysctl, AddressSet等のユーティリティ関数
- E-14: `pkg/proxy/util/endpoints.go` - IPPart関数
- E-15: `pkg/proxy/util/nodeport_addresses.go` - NodePortAddresses構造体と全メソッド（NewNodePortAddresses, MatchAll, ContainsIPv4Loopback, GetNodeIPs）
- E-16: `pkg/proxy/util/localdetector.go` - detectLocal構造体、NewNoOpLocalDetector, NewDetectLocalByCIDR, NewDetectLocalByBridgeInterface, NewDetectLocalByInterfaceNamePrefix等のファクトリ関数
- E-17: `pkg/proxy/util/linebuffer.go` - realLineBuffer, discardLineBuffer構造体と全メソッド（Write, WriteBytes, Reset, Lines, MarshalLog）
- E-18: `pkg/proxy/runner/bounded_frequency_runner.go` - BoundedFrequencyRunner構造体、construct関数、Loop, Run
- E-19: `pkg/proxy/apis/config/validation/validation.go` - Validate関数および各バリデーション関数
- E-20: `pkg/proxy/conntrack/conntrack.go` - conntracker構造体、ListEntries, DeleteEntries
- E-21: `pkg/proxy/conntrack/filter.go` - flowFilter構造体、newFlowFilter, MatchConntrackFlow
- E-22: `pkg/proxy/conntrack/cleanup.go` - CleanStaleEntries関数
- E-23: `pkg/proxy/conntrack/sysctls.go` - setSysctls, getConntrackMax関数
- E-24: `pkg/proxy/config/config.go` - EndpointSliceConfig, ServiceConfig, NodeConfig, ServiceCIDRConfig等
- E-25: `pkg/proxy/metrics/metrics.go` - SinceInSeconds, RegisterMetrics等
- E-26: `pkg/proxy/util/network.go` - NetworkInterfacer, RealNetwork

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PRX-001〜004: types.go ServicePortName.String(), fmtPortName | E-01 | ○ |
| C-02 | UT-PRX-005〜016: endpoint.go BaseEndpointInfo全メソッド | E-02 | ○ |
| C-03 | UT-PRX-017〜027: serviceport.go BaseServicePortInfo全メソッド | E-03 | ○ |
| C-04 | UT-PRX-028〜041: topology.go CategorizeEndpoints, topologyModeFromHints, availableForTopology, filterEndpoints | E-04 | ○ |
| C-05 | UT-PRX-042〜057: endpointslicecache.go EndpointSliceCache全メソッド | E-05 | ○ |
| C-06 | UT-PRX-058〜072: endpointschangetracker.go EndpointsChangeTracker, EndpointsMap | E-06 | ○ |
| C-07 | UT-PRX-073〜083: servicechangetracker.go ServiceChangeTracker, ServicePortMap | E-07 | ○ |
| C-08 | UT-PRX-084〜090: node.go NodeManager | E-08 | ○ |
| C-09 | UT-PRX-091〜095: metaproxier/meta_proxier.go metaProxier | E-09 | ○ |
| C-10 | UT-PRX-096〜105: healthcheck/proxy_health.go ProxyHealthServer | E-10 | ○ |
| C-11 | UT-PRX-106〜112: healthcheck/service_health.go server, hcHandler | E-11, E-12 | ○ |
| C-12 | UT-PRX-113〜133: util/utils.go IsZeroCIDR, ShouldSkipService, MapIPsByIPFamily等 | E-13 | ○ |
| C-13 | UT-PRX-134〜137: util/endpoints.go IPPart | E-14 | ○ |
| C-14 | UT-PRX-138〜142: util/nodeport_addresses.go NodePortAddresses | E-15 | ○ |
| C-15 | UT-PRX-143〜149: util/localdetector.go LocalTrafficDetector | E-16 | ○ |
| C-16 | UT-PRX-150〜155: util/linebuffer.go LineBuffer | E-17 | ○ |
| C-17 | UT-PRX-156〜159: runner/bounded_frequency_runner.go BoundedFrequencyRunner | E-18 | ○ |
| C-18 | UT-PRX-160〜177: apis/config/validation/validation.go バリデーション | E-19 | ○ |
| C-19 | UT-PRX-178: conntrack/conntrack.go DeleteEntries空フロー | E-20 | ○ |
| C-20 | UT-PRX-179〜180: conntrack/filter.go flowFilter | E-21 | ○ |
| C-21 | UT-PRX-181〜189: conntrack/sysctls.go setSysctls基本設定（Max, TCPEstablishedTimeout, TCPCloseWaitTimeout, TCPBeLiberal） | E-23 | ○ |
| C-22 | UT-PRX-190〜195: conntrack/sysctls.go setSysctls追加設定（TCPBeLiberal, UDPTimeout, UDPStreamTimeout, 境界値, 異常系） | E-23 | ○ |
| C-23 | UT-PRX-196〜199: conntrack/sysctls.go getConntrackMax計算ロジック（スケール値, フロア, ゼロMaxPerCore, nilMin） | E-23 | ○ |
| C-24 | UT-PRX-200〜203: util/utils.go IsZeroCIDR（IPv4/IPv6ゼロCIDR, 非ゼロCIDR, nil） | E-13 | ○ |
| C-25 | UT-PRX-204〜206: util/utils.go ShouldSkipService（ヘッドレス, ExternalName, 通常ClusterIP） | E-13 | ○ |
| C-26 | UT-PRX-207〜212: util/utils.go MapIPsByIPFamily, MapCIDRsByIPFamily（正常系, 異常系, 境界値） | E-13 | ○ |
| C-27 | UT-PRX-213〜216: util/utils.go GetIPFamilyFromIP, OtherIPFamily | E-13 | ○ |
| C-28 | UT-PRX-217〜220: util/utils.go AppendPortIfNeeded（IPv4, IPv6, 既存ポート, 不正アドレス） | E-13 | ○ |
| C-29 | UT-PRX-221〜225: util/utils.go GetClusterIPByFamily（IPFamilies設定済み, 未設定, 不一致, ヘッドレス, 空ClusterIP） | E-13 | ○ |
| C-30 | UT-PRX-226〜228: util/utils.go IsVIPMode（nil, VIP, Proxy） | E-13 | ○ |
| C-31 | UT-PRX-229〜232: util/endpoints.go IPPart（IPv4, IPv6, IPのみ, 不正入力） | E-14 | ○ |
| C-32 | UT-PRX-233〜242: util/nodeport_addresses.go NewNodePortAddresses, MatchAll, ContainsIPv4Loopback, GetNodeIPs | E-15, E-26 | ○ |
| C-33 | UT-PRX-243〜248: util/localdetector.go NewNoOpLocalDetector, NewDetectLocalByCIDR, NewDetectLocalByBridgeInterface, NewDetectLocalByInterfaceNamePrefix | E-16 | ○ |
| C-34 | UT-PRX-249〜257: util/linebuffer.go realLineBuffer, discardLineBuffer全メソッド | E-17 | ○ |
| C-35 | UT-PRX-258〜261: runner/bounded_frequency_runner.go construct, Run | E-18 | ○ |
| C-36 | UT-PRX-262: metrics/metrics.go SinceInSeconds | E-25 | ○ |
| C-37 | UT-PRX-263〜265: util/utils.go EnsureSysctl（設定, スキップ, エラー） | E-13 | ○ |
| C-38 | UT-PRX-266〜268: util/utils.go AddressSet（有効アドレスフィルタ, 複数型サポート, 不明型スキップ） | E-13 | ○ |
| C-39 | iptables/, ipvs/, nftables/, winkernel/ サブパッケージの詳細テストケース | **根拠なし** | △ |
| C-40 | conntrack/cleanup.go CleanStaleEntries統合テスト | **根拠なし** | △ |
| C-41 | kubemark/hollow_proxy.go のテストケース | **根拠なし** | △ |
| C-42 | apis/config/v1alpha1/ defaults, conversion のテストケース | **根拠なし** | △ |
| C-43 | util/nfacct/ サブパッケージのテストケース | **根拠なし** | △ |
| C-44 | util/utils_linux.go のLinux固有テストケース | **根拠なし** | △ |
| C-45 | BoundedFrequencyRunner.Loop のタイマー動作統合テスト | **根拠なし** | △ |
| C-46 | NewNodeManager の統合テスト（informer連携） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **iptables/proxier.go, nftables/proxier.go, ipvs/proxier.go** の各プロキシア実装は非常に大規模（それぞれ数千行）であり、本テストケース一覧では対象外としている。これらは既存の詳細なテストファイル（proxier_test.go）でカバーされているが、テストケースIDとしての体系的一覧は未生成。
  - 候補：別途iptables/nftables/ipvsサブモジュールとして分割生成
- **winkernel/ パッケージ** はWindows固有実装であり、Linux環境でのテスト実行が困難。
  - 候補：Windows CI環境での別途テスト
- **conntrack/cleanup.go CleanStaleEntries** はLinux固有（netlink依存）で、単体テストよりも統合テストに適している。
  - 候補：conntrack_test.goの既存テストを参照
- **kubemark/hollow_proxy.go** はパフォーマンステスト用のhollowプロキシ実装であり、単体テストの優先度が低い。
  - 候補：kubemark統合テストで対応
- **util/nfacct/ パッケージ** はnftablesアカウンティング用のLinux固有実装。
  - 候補：Linux CI環境での別途テスト
- **util/utils_linux.go** はLinuxビルドタグ付きの関数を含む。
  - 候補：Linux CI環境での別途テスト

## 5) リスクフラグ（レビュー観点）
- 1: NodeManager.OnNodeChange内のFIXMEコメント - NodeIP変更時のexit動作がコメントアウトされており、将来の変更でテストケースUT-PRX-088の期待結果が変わる可能性がある
- 1: PreferSameTrafficDistributionフィーチャーゲート - topologyModeFromHintsのノードヒント処理がフィーチャーゲートに依存しており、フィーチャーのGA/デフォルト変更でテスト結果が変わる可能性
- 0: conntrack/sysctls.goのLinuxビルドタグ - macOS/Windows環境ではビルド自体されないため、テスト実行にLinux環境が必要
- 0: 大規模プロキシア実装（iptables/nftables/ipvs）のカバレッジ - 本テストケース一覧ではコア共通コードに焦点を当てており、プロキシア固有ロジックは別途対応が必要
- 0: getConntrackMax関数のMin=nilケース（UT-PRX-199） - nilポインタのint32デリファレンスの代わりにfloor=0として扱う動作はコードから読み取れるが、Go言語仕様依存

## 6) レビュアーチェックリスト（最小）
- [ ] UT-PRX-028〜033: CategorizeEndpoints のフォールバック動作がコードの分岐と一致しているか
- [ ] UT-PRX-089, UT-PRX-090: NodeManager.OnNodeChange のFIXMEコメントを踏まえた期待結果が適切か
- [ ] UT-PRX-096〜101: ProxyHealthServer.Health() のタイムアウト判定ロジックが正しくテストされているか
- [ ] UT-PRX-160〜177: バリデーション関数のテストケースが全ての分岐をカバーしているか
- [ ] UT-PRX-196〜199: getConntrackMax の計算ロジック（スケール値、フロア、nilMin）が正しくテストされているか
- [ ] UT-PRX-221〜225: GetClusterIPByFamily のIPFamilies設定有無による分岐がすべてカバーされているか
- [ ] UT-PRX-249〜257: LineBufferのrealLineBufferとdiscardLineBufferの動作差異が正しくテストされているか
- [ ] iptables/, nftables/, ipvs/ サブパッケージの主要テストケースが別途計画されているか確認
- [ ] Linux固有のconntrack/sysctls.goテストケースの実行環境が整備されているか確認
