---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 157
  claims_with_evidence: 152
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：pkg-scheduler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（pkg-scheduler.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：152 / 157、根拠なし：5
- 優先レビュー（高）
  1. **UT-SCH-013 (Scheduler.Run)**: 起動フローの詳細な期待動作はインテグレーションテストに近く、単体テストでの検証範囲が要確認
  2. **UT-SCH-068 (HTTPExtender.Bind 正常系)**: HTTPサーバモックが前提であり、テスト実装時の構成に依存
  3. **UT-SCH-121 (PatchPodStatus)**: API呼び出しのモック前提であり、テスト実装時の構成に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/scheduler/scheduler.go` - Scheduler構造体、New関数、buildExtenders、buildQueueingHintMap、unionedGVKs、Run、CurrentCycle、NewInformerFactory
- E-02: `pkg/scheduler/schedule_one.go` - ScheduleOne、schedulingCycle、bindingCycle、frameworkForPod、skipPodSchedule、schedulePod、findNodesThatFitPod、findNodesThatPassFilters、numFeasibleNodesToFind、findNodesThatPassExtenders、prioritizeNodes、assume、bind、extendersBinding、truncateMessage、getAttemptsLabel、handleSchedulingFailure、nodeScoreHeap、sortedNodeScores
- E-03: `pkg/scheduler/extender.go` - HTTPExtender構造体、NewHTTPExtender、Name、IsIgnorable、SupportsPreemption、ProcessPreemption、convertToVictims、convertPodUIDToPod、convertToMetaVictims、Filter、Prioritize、Bind、IsBinder、IsPrioritizer、IsFilter、IsInterested、hasManagedResources、makeTransport、send
- E-04: `pkg/scheduler/eventhandlers.go` - addNodeToCache、updateNodeInCache、deleteNodeFromCache、addPod、updatePod、deletePod、assignedPod、responsibleForPod、hasNominatedNodeNameChanged、AdmissionCheck、AdmissionResult、getLEPriorityPreCheck、preCheckForNode
- E-05: `pkg/scheduler/framework/cycle_state.go` - CycleState構造体、NewCycleState、Read、Write、Delete、Clone、ShouldRecordPluginMetrics、SetRecordPluginMetrics
- E-06: `pkg/scheduler/framework/events.go` - PodSchedulingPropertiesChange、NodeSchedulingPropertiesChange、extractPodScaleDown、extractPodLabelsChange、extractPodTolerationChange、extractPodSchedulingGateEliminatedChange、extractNodeAllocatableChange、extractNodeLabelsChange、extractNodeTaintsChange、extractNodeConditionsChange、extractNodeSpecUnschedulableChange
- E-07: `pkg/scheduler/util/utils.go` - GetPodFullName、GetPodStartTime、GetEarliestPodStartTime、MoreImportantPod、Retriable、PatchPodStatus、DeletePod、IsScalarResourceName、GetHostPorts、As
- E-08: `pkg/scheduler/util/pod_resources.go` - DefaultMilliCPURequest、DefaultMemoryRequest定数
- E-09: `pkg/scheduler/profile/profile.go` - Map、NewMap、HandlesSchedulerName、Close、cfgValidator.validate
- E-10: `pkg/scheduler/apis/config/v1/default_plugins.go` - getDefaultPlugins、mergePlugins、mergePluginSet、applyFeatureGates
- E-11: `pkg/scheduler/apis/config/validation/validation.go` - ValidateKubeSchedulerConfiguration、validatePercentageOfNodesToScore
- E-12: `pkg/scheduler/metrics/metric_recorder.go` - PendingPodsRecorder、MetricAsyncRecorder、NewMetricsAsyncRecorder、FlushMetrics
- E-13: `pkg/scheduler/util/assumecache/assume_cache.go` - WrongTypeError、NotFoundError、AssumeCache

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SCH-001: デフォルトオプションでSchedulerが正常生成 | E-01 (New関数 L276-454) | ○ |
| C-02 | UT-SCH-002: カスタムオプション適用 | E-01 (Option型、WithParallelism等 L149-258) | ○ |
| C-03 | UT-SCH-003: プロファイル0件でエラー | E-01 (L376-378 len(profiles)==0チェック) | ○ |
| C-04 | UT-SCH-004: レジストリマージ失敗 | E-01 (L302-304 registry.Merge) | ○ |
| C-05 | UT-SCH-005: 空extendersでnil | E-01 (buildExtenders L571-572) | ○ |
| C-06 | UT-SCH-006: extender構築 | E-01 (buildExtenders L577-593) | ○ |
| C-07 | UT-SCH-007: ignorable extender順序 | E-01 (buildExtenders L583-595) | ○ |
| C-08 | UT-SCH-008: extender作成失敗 | E-01 (buildExtenders L580-582) | ○ |
| C-09 | UT-SCH-009: QueueingHintMap構築 | E-01 (buildQueueingHintMap L462-529) | ○ |
| C-10 | UT-SCH-010: 空EventsToRegisterスキップ | E-01 (buildQueueingHintMap L474) | ○ |
| C-11 | UT-SCH-011: NodeAdded時UpdateNodeTaint自動追加 | E-01 (buildQueueingHintMap L505-523) | ○ |
| C-12 | UT-SCH-012: GVK OR結合 | E-01 (unionedGVKs L629-641) | ○ |
| C-13 | UT-SCH-013: Run起動時にSchedulingQueue開始 | E-01 (Run L532-559) | △ |
| C-14 | UT-SCH-014: CurrentCycleがSchedulingCycle返却 | E-01 (CurrentCycle L666-671) | ○ |
| C-15 | UT-SCH-015: nilキューで0返却 | E-01 (CurrentCycle L667-668) | ○ |
| C-16 | UT-SCH-016: InformerFactory生成 | E-01 (NewInformerFactory L563-567) | ○ |
| C-17 | UT-SCH-017: frameworkForPod正常 | E-02 (frameworkForPod L395-401) | ○ |
| C-18 | UT-SCH-018: frameworkForPod不明名 | E-02 (frameworkForPod L397-398) | ○ |
| C-19 | UT-SCH-019: 削除中Podスキップ | E-02 (skipPodSchedule L406-410) | ○ |
| C-20 | UT-SCH-020: AssumedPodスキップ | E-02 (skipPodSchedule L415-420) | ○ |
| C-21 | UT-SCH-021: 通常Podスキップしない | E-02 (skipPodSchedule L404-421) | ○ |
| C-22 | UT-SCH-022: numFeasible最小ノード数 | E-02 (numFeasibleNodesToFind L718-719) | ○ |
| C-23 | UT-SCH-023: percentageOfNodesToScore指定時 | E-02 (numFeasibleNodesToFind L723-728) | ○ |
| C-24 | UT-SCH-024: 適応的パーセンテージ | E-02 (numFeasibleNodesToFind L730-735) | ○ |
| C-25 | UT-SCH-025: 最小値保証 | E-02 (numFeasibleNodesToFind L738-739) | ○ |
| C-26 | UT-SCH-026: 最低パーセンテージ | E-02 (numFeasibleNodesToFind L732-733) | ○ |
| C-27 | UT-SCH-027: 単一ノード選択 | E-02 (schedulePod L453-463) | ○ |
| C-28 | UT-SCH-028: 複数ノードスコアリング | E-02 (schedulePod L465-483) | ○ |
| C-29 | UT-SCH-029: ノード0件エラー | E-02 (schedulePod L434-436) | ○ |
| C-30 | UT-SCH-030: feasible0件FitError | E-02 (schedulePod L444-449) | ○ |
| C-31 | UT-SCH-031: assume正常 | E-02 (assume L961-978) | ○ |
| C-32 | UT-SCH-032: assume失敗 | E-02 (assume L968-970) | ○ |
| C-33 | UT-SCH-033: frameworkバインド | E-02 (bind L983-994) | ○ |
| C-34 | UT-SCH-034: extenderバインド | E-02 (extendersBinding L997-1013) | ○ |
| C-35 | UT-SCH-035: hasScoring ScorePlugins | E-02 (hasScoring L607-617) | ○ |
| C-36 | UT-SCH-036: hasScoring extender | E-02 (hasScoring L611-614) | ○ |
| C-37 | UT-SCH-037: hasScoring false | E-02 (hasScoring L607-617) | ○ |
| C-38 | UT-SCH-038: 空extenderフィルタ | E-02 (findNodesThatPassExtenders L745-789) | ○ |
| C-39 | UT-SCH-039: extenderフィルタ適用 | E-02 (findNodesThatPassExtenders L764-786) | ○ |
| C-40 | UT-SCH-040: extenderフィルタエラー | E-02 (findNodesThatPassExtenders L765-770) | ○ |
| C-41 | UT-SCH-041: ignorable extenderスキップ | E-02 (findNodesThatPassExtenders L766-769) | ○ |
| C-42 | UT-SCH-042: デフォルトスコア | E-02 (prioritizeNodes L807-816) | ○ |
| C-43 | UT-SCH-043: プラグインスコアリング | E-02 (prioritizeNodes L818-828) | ○ |
| C-44 | UT-SCH-044: PreScore失敗 | E-02 (prioritizeNodes L819-822) | ○ |
| C-45 | UT-SCH-045: truncateMessage短い | E-02 (truncateMessage L1130-1137) | ○ |
| C-46 | UT-SCH-046: truncateMessage長い | E-02 (truncateMessage L1130-1137) | ○ |
| C-47 | UT-SCH-047: getAttemptsLabel通常 | E-02 (getAttemptsLabel L1024-1031) | ○ |
| C-48 | UT-SCH-048: getAttemptsLabel上限 | E-02 (getAttemptsLabel L1027-1028) | ○ |
| C-49 | UT-SCH-049: nodeScoreHeap Less | E-02 (Less L941-944) | ○ |
| C-50 | UT-SCH-050: nodeScoreHeap タイブレーク | E-02 (Less L943) | ○ |
| C-51 | UT-SCH-051: sortedNodeScores Pop | E-02 (Pop L919-922) | ○ |
| C-52 | UT-SCH-052: HTTPExtender生成 | E-03 (NewHTTPExtender L88-117) | ○ |
| C-53 | UT-SCH-053: デフォルトタイムアウト | E-03 (NewHTTPExtender L89-91) | ○ |
| C-54 | UT-SCH-054: Name | E-03 (Name L120-122) | ○ |
| C-55 | UT-SCH-055: IsIgnorable | E-03 (IsIgnorable L126-128) | ○ |
| C-56 | UT-SCH-056: SupportsPreemption true | E-03 (SupportsPreemption L132-134) | ○ |
| C-57 | UT-SCH-057: SupportsPreemption false | E-03 (SupportsPreemption L132-134) | ○ |
| C-58 | UT-SCH-058: IsBinder true | E-03 (IsBinder L384-386) | ○ |
| C-59 | UT-SCH-059: IsBinder false | E-03 (IsBinder L384-386) | ○ |
| C-60 | UT-SCH-060: IsPrioritizer | E-03 (IsPrioritizer L389-391) | ○ |
| C-61 | UT-SCH-061: IsFilter | E-03 (IsFilter L394-396) | ○ |
| C-62 | UT-SCH-062: IsInterested全対象 | E-03 (IsInterested L429-440) | ○ |
| C-63 | UT-SCH-063: IsInterested一致 | E-03 (IsInterested L429-440, hasManagedResources L442-457) | ○ |
| C-64 | UT-SCH-064: IsInterested不一致 | E-03 (IsInterested L429-440) | ○ |
| C-65 | UT-SCH-065: Filter未設定 | E-03 (Filter L265-267) | ○ |
| C-66 | UT-SCH-066: Filter HTTP失敗 | E-03 (Filter L288-290, send L399-425) | ○ |
| C-67 | UT-SCH-067: Prioritize未設定 | E-03 (Prioritize L328-334) | ○ |
| C-68 | UT-SCH-068: Bind成功 | E-03 (Bind L362-381) | △ |
| C-69 | UT-SCH-069: 非バインダBind | E-03 (Bind L364-366) | ○ |
| C-70 | UT-SCH-070: ProcessPreemption非サポート | E-03 (ProcessPreemption L147-149) | ○ |
| C-71 | UT-SCH-071: convertToMetaVictims | E-03 (convertToMetaVictims L224-242) | ○ |
| C-72 | UT-SCH-072: convertPodUIDToPod正常 | E-03 (convertPodUIDToPod L211-221) | ○ |
| C-73 | UT-SCH-073: convertPodUIDToPod不一致 | E-03 (convertPodUIDToPod L219-221) | ○ |
| C-74 | UT-SCH-074: TLS Transport | E-03 (makeTransport L57-85) | ○ |
| C-75 | UT-SCH-075: デフォルトTransport | E-03 (makeTransport L84) | ○ |
| C-76 | UT-SCH-076: assignedPod true | E-04 (assignedPod L470-472) | ○ |
| C-77 | UT-SCH-077: assignedPod false | E-04 (assignedPod L470-472) | ○ |
| C-78 | UT-SCH-078: responsibleForPod true | E-04 (responsibleForPod L475-477), E-09 (HandlesSchedulerName) | ○ |
| C-79 | UT-SCH-079: responsibleForPod false | E-04 (responsibleForPod L475-477) | ○ |
| C-80 | UT-SCH-080: NNN変更 | E-04 (hasNominatedNodeNameChanged L342-344) | ○ |
| C-81 | UT-SCH-081: NNN変更なし | E-04 (hasNominatedNodeNameChanged L342-344) | ○ |
| C-82 | UT-SCH-082: NNN空からの変更 | E-04 (hasNominatedNodeNameChanged L343) | ○ |
| C-83 | UT-SCH-083: AdmissionCheck全通過 | E-04 (AdmissionCheck L754-788) | ○ |
| C-84 | UT-SCH-084: AdmissionCheckリソース不足 | E-04 (AdmissionCheck L756-767) | ○ |
| C-85 | UT-SCH-085: AdmissionCheck NodeAffinity | E-04 (AdmissionCheck L769-773) | ○ |
| C-86 | UT-SCH-086: AdmissionCheck NodeName | E-04 (AdmissionCheck L775-779) | ○ |
| C-87 | UT-SCH-087: includeAllFailures=true | E-04 (AdmissionCheck条件分岐) | ○ |
| C-88 | UT-SCH-088: includeAllFailures=false | E-04 (AdmissionCheck L764, L772, L778) | ○ |
| C-89 | UT-SCH-089: getLEPriorityPreCheck以下 | E-04 (getLEPriorityPreCheck L379-383) | ○ |
| C-90 | UT-SCH-090: getLEPriorityPreCheck同等 | E-04 (getLEPriorityPreCheck L381) | ○ |
| C-91 | UT-SCH-091: getLEPriorityPreCheck上 | E-04 (getLEPriorityPreCheck L381) | ○ |
| C-92 | UT-SCH-092: NewCycleState | E-05 (NewCycleState L45-47) | ○ |
| C-93 | UT-SCH-093: Write/Read | E-05 (Write L133-135, Read L123-128) | ○ |
| C-94 | UT-SCH-094: Read未存在 | E-05 (Read L127) | ○ |
| C-95 | UT-SCH-095: Delete | E-05 (Delete L140-142) | ○ |
| C-96 | UT-SCH-096: Clone | E-05 (Clone L99-117) | ○ |
| C-97 | UT-SCH-097: nil Clone | E-05 (Clone L100-102) | ○ |
| C-98 | UT-SCH-098: ShouldRecordPluginMetrics | E-05 (ShouldRecordPluginMetrics L50-55, SetRecordPluginMetrics L58-63) | ○ |
| C-99 | UT-SCH-099: nil ShouldRecordPluginMetrics | E-05 (ShouldRecordPluginMetrics L51-53) | ○ |
| C-100 | UT-SCH-100: Pod Label変更 | E-06 (extractPodLabelsChange L126-131) | ○ |
| C-101 | UT-SCH-101: Pod Toleration変更 | E-06 (extractPodTolerationChange L133-143) | ○ |
| C-102 | UT-SCH-102: SchedulingGate除去 | E-06 (extractPodSchedulingGateEliminatedChange L145-152) | ○ |
| C-103 | UT-SCH-103: 汎用Update | E-06 (PodSchedulingPropertiesChange L90-93) | ○ |
| C-104 | UT-SCH-104: Node Allocatable変更 | E-06 (extractNodeAllocatableChange L188-193) | ○ |
| C-105 | UT-SCH-105: Node Label変更 | E-06 (extractNodeLabelsChange L195-200) | ○ |
| C-106 | UT-SCH-106: Node Taint変更 | E-06 (extractNodeTaintsChange L206-211) | ○ |
| C-107 | UT-SCH-107: Node Condition変更 | E-06 (extractNodeConditionsChange L213-225) | ○ |
| C-108 | UT-SCH-108: Unschedulable解除 | E-06 (extractNodeSpecUnschedulableChange L227-233) | ○ |
| C-109 | UT-SCH-109: Unschedulable変更なし | E-06 (extractNodeSpecUnschedulableChange L227-233) | ○ |
| C-110 | UT-SCH-110: PodScaleDown | E-06 (extractPodScaleDown L102-124) | ○ |
| C-111 | UT-SCH-111: PodScaleDown変更なし | E-06 (extractPodScaleDown L122-123) | ○ |
| C-112 | UT-SCH-112: GetPodFullName | E-07 (GetPodFullName L43-47) | ○ |
| C-113 | UT-SCH-113: GetPodStartTime設定済み | E-07 (GetPodStartTime L51-57) | ○ |
| C-114 | UT-SCH-114: GetPodStartTime nil | E-07 (GetPodStartTime L55-56) | ○ |
| C-115 | UT-SCH-115: GetEarliestPodStartTime | E-07 (GetEarliestPodStartTime L61-83) | ○ |
| C-116 | UT-SCH-116: GetEarliestPodStartTime空 | E-07 (GetEarliestPodStartTime L62-65) | ○ |
| C-117 | UT-SCH-117: MoreImportantPod優先度 | E-07 (MoreImportantPod L88-95) | ○ |
| C-118 | UT-SCH-118: MoreImportantPod同優先度 | E-07 (MoreImportantPod L93-94) | ○ |
| C-119 | UT-SCH-119: Retriable内部エラー | E-07 (Retriable L98-101) | ○ |
| C-120 | UT-SCH-120: Retriable NotFound | E-07 (Retriable L98-101) | ○ |
| C-121 | UT-SCH-121: PatchPodStatus正常 | E-07 (PatchPodStatus L105-134) | △ |
| C-122 | UT-SCH-122: PatchPodStatus変更なし | E-07 (PatchPodStatus L124-126) | ○ |
| C-123 | UT-SCH-123: PatchPodStatus nil | E-07 (PatchPodStatus L106-108) | ○ |
| C-124 | UT-SCH-124: IsScalarResourceName | E-07 (IsScalarResourceName L142-145) | ○ |
| C-125 | UT-SCH-125: GetHostPorts | E-07 (GetHostPorts L183-215) | ○ |
| C-126 | UT-SCH-126: GetHostPorts nil | E-07 (GetHostPorts L185-187) | ○ |
| C-127 | UT-SCH-127: GetHostPorts Sidecar | E-07 (GetHostPorts L193-205) | ○ |
| C-128 | UT-SCH-128: As正常変換 | E-07 (As L158-179) | ○ |
| C-129 | UT-SCH-129: As型不一致 | E-07 (As L164-165) | ○ |
| C-130 | UT-SCH-130: As DeletedFinalStateUnknown | E-07 (As L170-171) | ○ |
| C-131 | UT-SCH-131: NewMap正常 | E-09 (NewMap L49-65) | ○ |
| C-132 | UT-SCH-132: NewMap空名 | E-09 (validate L99-100) | ○ |
| C-133 | UT-SCH-133: NewMap重複 | E-09 (validate L105-107) | ○ |
| C-134 | UT-SCH-134: HandlesSchedulerName一致 | E-09 (HandlesSchedulerName L68-71) | ○ |
| C-135 | UT-SCH-135: HandlesSchedulerName不一致 | E-09 (HandlesSchedulerName L68-71) | ○ |
| C-136 | UT-SCH-136: getDefaultPlugins | E-10 (getDefaultPlugins L30-58) | ○ |
| C-137 | UT-SCH-137: mergePlugins | E-10 (mergePlugins L95-114) | ○ |
| C-138 | UT-SCH-138: mergePlugins nil | E-10 (mergePlugins L96-98) | ○ |
| C-139 | UT-SCH-139: mergePluginSet無効化 | E-10 (mergePluginSet L121-171) | ○ |
| C-140 | UT-SCH-140: mergePluginSet全無効化 | E-10 (mergePluginSet L146) | ○ |
| C-141 | UT-SCH-141: Validate正常 | E-11 (ValidateKubeSchedulerConfiguration L38-84) | ○ |
| C-142 | UT-SCH-142: Parallelism不正 | E-11 (L51-53) | ○ |
| C-143 | UT-SCH-143: Profiles空 | E-11 (L55-57) | ○ |
| C-144 | UT-SCH-144: PodInitialBackoff不正 | E-11 (L73-76) | ○ |
| C-145 | UT-SCH-145: PodMaxBackoff不正 | E-11 (L77-80) | ○ |
| C-146 | UT-SCH-146: percentageOfNodesToScore nil | E-11 (validatePercentageOfNodesToScore L86-93) | ○ |
| C-147 | UT-SCH-147: percentageOfNodesToScore 0 | E-11 (validatePercentageOfNodesToScore L88) | ○ |
| C-148 | UT-SCH-148: percentageOfNodesToScore 100 | E-11 (validatePercentageOfNodesToScore L88) | ○ |
| C-149 | UT-SCH-149: percentageOfNodesToScore 101 | E-11 (validatePercentageOfNodesToScore L88-89) | ○ |
| C-150 | UT-SCH-150: percentageOfNodesToScore -1 | E-11 (validatePercentageOfNodesToScore L88-89) | ○ |
| C-151 | UT-SCH-151: PendingPodsRecorder Inc | E-12 (Inc L69-71) | ○ |
| C-152 | UT-SCH-152: PendingPodsRecorder Dec | E-12 (Dec L74-76) | ○ |
| C-153 | UT-SCH-153: PendingPodsRecorder Clear | E-12 (Clear L79-81) | ○ |
| C-154 | UT-SCH-154: NewMetricsAsyncRecorder | E-12 (NewMetricsAsyncRecorder L126-139) | ○ |
| C-155 | UT-SCH-155: FlushMetrics | E-12 (FlushMetrics L208-224) | ○ |
| C-156 | UT-SCH-156: WrongTypeError.Error | E-13 (WrongTypeError L63-70) | ○ |
| C-157 | UT-SCH-157: WrongTypeError.Is | E-13 (WrongTypeError.Is L72-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SCH-013 (Scheduler.Run)**: Runメソッドはgoroutineを起動し、コンテキストキャンセルまでブロックするため、単体テストとしての検証範囲を明確にする必要がある。テスト実装時にはmockのSchedulingQueue等を使用した結合的なテストが必要。
  - 候補：インテグレーションテスト / モック利用した単体テスト
- **UT-SCH-068 (HTTPExtender.Bind)**: HTTPサーバのモックが必要。実際のHTTP通信を伴うテストケースであり、テスト実装の詳細設計が必要。
  - 候補：httptest.NewServer利用
- **UT-SCH-121 (PatchPodStatus)**: Kubernetes APIクライアントのモックが必要。
  - 候補：fake clientset利用
- **UT-SCH-131-133 (NewMap)**: frameworkruntime.NewFrameworkの内部動作に依存する部分があり、テスト時のRegistry構成が重要。
  - 候補：テスト用Registryの利用
- **backend/, framework/plugins/ サブパッケージ**: backend/cache, backend/queue, framework/plugins/ 配下の各プラグインは多数のソースファイルを持つが、本CSVでは主要なトップレベル関数と共通フレームワーク部分に集中した。プラグイン個別のテストケースは別途追加を検討。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストID UT-SCH-045~048, UT-SCH-054~061, UT-SCH-092~099, UT-SCH-112~114, UT-SCH-151~157 - 単純なgetter/setter/ユーティリティ関数
- **1 (中リスク)**: テストID UT-SCH-005~012, UT-SCH-038~044, UT-SCH-062~075, UT-SCH-076~091, UT-SCH-100~111, UT-SCH-119~130, UT-SCH-136~150 - ビジネスロジックを含むが、モック構成が比較的容易
- **2 (高リスク)**: テストID UT-SCH-001~004, UT-SCH-013, UT-SCH-017~034, UT-SCH-068, UT-SCH-083~088, UT-SCH-115~118, UT-SCH-121, UT-SCH-131~135 - スケジューラのコア処理、API呼び出し、複雑な状態管理を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースの対象ファイル・関数名がソースコードと一致しているか
- [ ] 正常系・異常系・境界値の観点が各主要関数に対して網羅されているか
- [ ] 優先度の設定がビジネスリスク（スケジューリング正確性・データ整合性）と整合しているか
- [ ] backend/cache, backend/queue 等のサブパッケージについて追加テストケースが必要か検討
- [ ] framework/plugins/ 配下の各プラグイン（noderesources, nodeaffinity, tainttoleration等）の個別テストケース追加要否を検討
- [ ] HTTPExtender関連テストケースのHTTPモック戦略が適切か確認
- [ ] preemptionフロー（schedulingCycle, bindingCycle, handleSchedulingFailure）のカバレッジが十分か確認
