---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 39
  claims_with_evidence: 37
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：pkg-security 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：37 / 39、根拠なし：2
- 優先レビュー（高）
  1. **UT-SEC-034 (NewValidator正常系)**：ホスト環境依存のため実行環境での検証が必要
  2. **UT-SEC-036 (validateHost正常系)**：apparmor.IsEnabled()の外部依存により単体テストでのモック化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/security/apparmor/helpers.go` - isRequired関数の実装（28-51行目）
- E-02: `pkg/security/apparmor/helpers.go` - GetProfile関数の実装（54-70行目）
- E-03: `pkg/security/apparmor/helpers.go` - getProfileFromPodAnnotations関数の実装（74-99行目）
- E-04: `pkg/security/apparmor/validate.go` - Validator interface定義（34-37行目）
- E-05: `pkg/security/apparmor/validate.go` - NewValidator関数の実装（40-45行目）
- E-06: `pkg/security/apparmor/validate.go` - validator.Validate メソッドの実装（51-79行目）
- E-07: `pkg/security/apparmor/validate.go` - validator.ValidateHost メソッドの実装（84-86行目）
- E-08: `pkg/security/apparmor/validate.go` - validateHost関数の実装（89-101行目）
- E-09: `pkg/security/apparmor/validate_disabled.go` - init関数の実装（21-24行目）
- E-10: `pkg/security/apparmor/helpers_test.go` - TestGetProfileテスト（既存テスト参考）
- E-11: `pkg/security/apparmor/validate_test.go` - TestValidateBadHost, TestValidateValidHostテスト（既存テスト参考）
- E-12: `pkg/security/doc.go` - パッケージドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SEC-001: Pod-levelでUnconfined以外のAppArmorProfileが設定時にisRequiredがtrueを返す | E-01 (29-32行目) | ○ |
| C-02 | UT-SEC-002: Container-levelでUnconfined以外のAppArmorProfileが設定時にisRequiredがtrueを返す | E-01 (34-43行目) | ○ |
| C-03 | UT-SEC-003: DeprecatedアノテーションでUnconfined以外のプロファイル指定時にtrueを返す | E-01 (45-49行目) | ○ |
| C-04 | UT-SEC-004: プロファイル未設定時にfalseを返す | E-01 (50行目) | ○ |
| C-05 | UT-SEC-005: Pod-levelでUnconfined設定時にfalseを返す | E-01 (30行目の条件分岐) | ○ |
| C-06 | UT-SEC-006: DeprecatedアノテーションでUnconfined設定時にfalseを返す | E-01 (47行目) | ○ |
| C-07 | UT-SEC-007: Pod.Spec.SecurityContextがnilの場合にfalseを返す | E-01 (29行目のnilチェック) | ○ |
| C-08 | UT-SEC-008: Annotationsが空mapの場合にfalseを返す | E-01 (45行目のrangeループ) | ○ |
| C-09 | UT-SEC-009: コンテナSecurityContextのAppArmorProfileを返す | E-02 (55-57行目), E-10 | ○ |
| C-10 | UT-SEC-010: PodSecurityContextのAppArmorProfileを返す | E-02 (65-67行目), E-10 | ○ |
| C-11 | UT-SEC-011: Deprecatedアノテーションからプロファイルを取得 | E-02 (61-63行目), E-10 | ○ |
| C-12 | UT-SEC-012: プロファイル未設定時にnilを返す | E-02 (69行目), E-10 | ○ |
| C-13 | UT-SEC-013: コンテナ > アノテーション > Podの優先順位 | E-02 (55-67行目), E-10 | ○ |
| C-14 | UT-SEC-014: アノテーション > Podの優先順位 | E-02 (61-67行目), E-10 | ○ |
| C-15 | UT-SEC-015: 不正アノテーションからPodレベルへのフォールバック | E-02, E-03 (95-97行目), E-10 | ○ |
| C-16 | UT-SEC-016: nilコンテナSecurityContextの安全性 | E-02 (55行目のnilチェック) | ○ |
| C-17 | UT-SEC-017: runtime/defaultアノテーション変換 | E-03 (81-82行目) | ○ |
| C-18 | UT-SEC-018: unconfinedアノテーション変換 | E-03 (84-85行目) | ○ |
| C-19 | UT-SEC-019: localhost/プレフィックスのアノテーション変換 | E-03 (87-93行目) | ○ |
| C-20 | UT-SEC-020: アノテーション不在時にnilを返す | E-03 (76-78行目) | ○ |
| C-21 | UT-SEC-021: 不正アノテーション値でnilを返す | E-03 (95-97行目) | ○ |
| C-22 | UT-SEC-022: localhost/プレフィックスのみで空プロファイル名 | E-03 (89行目のTrimPrefix) | ○ |
| C-23 | UT-SEC-023: AppArmor不要PodでValidateがnilを返す | E-06 (52-54行目), E-11 | ○ |
| C-24 | UT-SEC-024: 有効ホストで有効プロファイルのバリデーション成功 | E-06, E-11 | ○ |
| C-25 | UT-SEC-025: localhostプロファイルのバリデーション成功 | E-06, E-11 | ○ |
| C-26 | UT-SEC-026: 複数コンテナPodのバリデーション成功 | E-06 (61行目のVisitContainers), E-11 | ○ |
| C-27 | UT-SEC-027: ホストエラー時のエラー伝播 | E-06 (56-58行目), E-11 | ○ |
| C-28 | UT-SEC-028: ホストエラー時でもプロファイル不要ならnil | E-06 (52-54行目), E-11 | ○ |
| C-29 | UT-SEC-029: 空プロファイル名でエラーを返す | E-06 (70-73行目), E-11 | ○ |
| C-30 | UT-SEC-030: スペースのみプロファイル名でエラーを返す | E-06 (70行目のTrimSpace), E-11 | ○ |
| C-31 | UT-SEC-031: LocalhostProfileがnilの場合にエラーを返す | E-06 (70行目のnilチェック) | ○ |
| C-32 | UT-SEC-032: ValidateHostがnilを返す（正常時） | E-07 (85行目) | ○ |
| C-33 | UT-SEC-033: ValidateHostがエラーを返す（異常時） | E-07 (85行目) | ○ |
| C-34 | UT-SEC-034: NewValidatorが有効なValidatorを返す（正常環境） | E-05 | △ |
| C-35 | UT-SEC-035: NewValidatorがエラー付きValidatorを返す（非対応環境） | E-05, E-08 | ○ |
| C-36 | UT-SEC-036: validateHostがnilを返す（正常環境） | E-08 | △ |
| C-37 | UT-SEC-037: isDisabledBuild=trueでエラーを返す | E-08 (91-93行目) | ○ |
| C-38 | UT-SEC-038: AppArmor無効でエラーを返す | E-08 (96-98行目) | ○ |
| C-39 | UT-SEC-039: 非Linuxビルドでisディsabledが設定される | E-09 (22-23行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-34 (NewValidator正常系): validateHost関数内部でapparmor.IsEnabled()を呼び出しており、この外部ライブラリの実際の動作はLinux環境のAppArmorカーネルモジュールに依存する。単体テストではモック化またはビルドタグによる制御が必要。
  - 候補：統合テスト / Linux環境でのE2Eテスト / apparmor.IsEnabled()のモック
- C-36 (validateHost正常系): 同様にapparmor.IsEnabled()の外部依存あり。
  - 候補：Linux環境での実行テスト / third_party/forked/libcontainer/apparmor パッケージの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - helpers.goのGetProfile, getProfileFromPodAnnotations関数は純粋な変換ロジックであり、テストケースの根拠が明確
- 0: 低リスク - isRequired関数のテストケースは条件分岐を網羅
- 1: 中リスク - validate.goのValidate メソッドはvisitContainersのコールバック内でエラーを蓄積するパターンを使用しており、複数コンテナで複数エラーが発生するケースの検証が不足している可能性がある
- 1: 中リスク - NewValidator, validateHostは外部ライブラリ（libcontainer/apparmor）への依存があり、テスト環境でのモック化戦略が明示されていない
- 0: 低リスク - validate_disabled.goのinit関数はビルドタグで制御されるシンプルな設定

## 6) レビュアーチェックリスト（最小）
- [ ] isRequired関数の全条件分岐（Pod-level, Container-level, Annotations）がテストケースでカバーされているか
- [ ] GetProfile関数の優先順位（Container > Annotation > Pod）が正しくテストされているか
- [ ] getProfileFromPodAnnotationsの全switch-case分岐がテストケースに含まれているか
- [ ] validator.Validateのホストエラー時/正常時の両方のパスがカバーされているか
- [ ] localhostプロファイルの空名/nil/スペースのみケースが網羅されているか
- [ ] apparmor.IsEnabled()への外部依存のテスト戦略が妥当か確認
- [ ] 非Linuxビルド時のisDisabledBuild設定が正しく検証されているか
