---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 183
  claims_with_evidence: 178
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：pkg-securitycontext 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：178 / 183、根拠なし：5
- 優先レビュー（高）
  1. **UT-SCX-176 (possibleCPUs Linux正常系)**: /sys/devices/system/cpu/possible の実際のフォーマットはホスト依存であり、テスト環境で検証が困難
  2. **UT-SCX-177 (possibleCPUs Linuxフォールバック)**: runtime.NumCPU()の具体的な返り値はテスト環境依存
  3. **UT-SCX-178〜181 (possibleCPUsParsed)**: sync.OnceValueによるキャッシュのためテストでの再実行が困難
  4. **UT-SCX-137 (HasWindowsHostProcessRequest Pod継承)**: DetermineEffectiveSecurityContext経由のWindowsOptions継承パスの正確性は実装の間接参照に依存
  5. **UT-SCX-145 (DetermineEffectiveSecurityContext WindowsOptions片方のみ)**: effectiveSC.WindowsOptionsがnilの場合の初期化パスの正確な検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/securitycontext/accessors.go` - PodSecurityContextWrapper、ContainerSecurityContextWrapper、EffectiveContainerSecurityContextWrapperの実装（全548行）
- E-02: `pkg/securitycontext/util.go` - HasWindowsHostProcessRequest、DetermineEffectiveSecurityContext、DetermineEffectiveRunAsUser、AddNoNewPrivileges、ConvertToRuntimeMaskedPaths、ConvertToRuntimeReadonlyPaths、securityContextFromPodSecurityContextの実装（全253行）
- E-03: `pkg/securitycontext/fake.go` - ValidSecurityContextWithContainerDefaults、ValidInternalSecurityContextWithContainerDefaultsの実装（全47行）
- E-04: `pkg/securitycontext/util_linux.go` - possibleCPUs、possibleCPUsParsedの実装（Linux版、全75行）
- E-05: `pkg/securitycontext/util_darwin.go` - possibleCPUsの実装（Darwin版、nilを返すスタブ、全22行）
- E-06: `pkg/securitycontext/util_windows.go` - possibleCPUsの実装（Windows版、nilを返すスタブ、全22行）
- E-07: `pkg/securitycontext/doc.go` - パッケージドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SCX-001〜004: ファクトリ関数NewPodSecurityContext{Accessor,Mutator}がnil/非nilで正しく動作する | E-01 (L64-72) | ○ |
| C-02 | UT-SCX-005〜010: HostNetwork getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L88-100) | ○ |
| C-03 | UT-SCX-011〜014: HostPID getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L101-113) | ○ |
| C-04 | UT-SCX-015〜018: HostIPC getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L114-126) | ○ |
| C-05 | UT-SCX-019〜022: HostUsers getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L127-139) | ○ |
| C-06 | UT-SCX-023〜026: SELinuxOptions getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L140-152) | ○ |
| C-07 | UT-SCX-027〜030: RunAsUser getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L153-165) | ○ |
| C-08 | UT-SCX-031〜033: RunAsGroup getter/setterが正しく動作する | E-01 (L166-178) | ○ |
| C-09 | UT-SCX-034〜036: RunAsNonRoot getter/setterが正しく動作する | E-01 (L180-192) | ○ |
| C-10 | UT-SCX-037〜039: SeccompProfile getter/setterが正しく動作する | E-01 (L193-205) | ○ |
| C-11 | UT-SCX-040〜045: SupplementalGroups getter/setterがnilチェック・空スライスチェック・遅延初期化を含む | E-01 (L206-221) | ○ |
| C-12 | UT-SCX-046〜049: FSGroup getter/setterが正しく動作する | E-01 (L222-234) | ○ |
| C-13 | UT-SCX-050〜053: FSGroupChangePolicy getter/setterが正しく動作する | E-01 (L236-251) | ○ |
| C-14 | UT-SCX-054: PodSecurityContext()が元のオブジェクトを返す | E-01 (L78-80) | ○ |
| C-15 | UT-SCX-055〜056: ensurePodSCが遅延初期化と冪等性を持つ | E-01 (L82-86) | ○ |
| C-16 | UT-SCX-057〜060: ファクトリ関数NewContainerSecurityContext{Accessor,Mutator}がnil/非nilで正しく動作する | E-01 (L286-294) | ○ |
| C-17 | UT-SCX-061〜065: Capabilities getter/setterがnilチェック・遅延初期化を正しく行う | E-01 (L310-322) | ○ |
| C-18 | UT-SCX-066〜069: Privileged getter/setterが正しく動作する | E-01 (L323-335) | ○ |
| C-19 | UT-SCX-070〜072: ProcMount getterがnil時にDefaultProcMountを返す | E-01 (L336-344) | ○ |
| C-20 | UT-SCX-073〜076: Container SELinuxOptions getter/setterがnilチェックを行う | E-01 (L345-357) | ○ |
| C-21 | UT-SCX-077〜100: Container RunAsUser, RunAsGroup, RunAsNonRoot, ReadOnlyRootFilesystem, SeccompProfile, AllowPrivilegeEscalation getter/setterが正しく動作する | E-01 (L358-437) | ○ |
| C-22 | UT-SCX-101: ContainerSecurityContext()が元のオブジェクトを返す | E-01 (L300-302) | ○ |
| C-23 | UT-SCX-102: ensureContainerSCが遅延初期化を行う | E-01 (L304-308) | ○ |
| C-24 | UT-SCX-103〜104: EffectiveContainerSecurityContextのファクトリ関数が正しく動作する | E-01 (L441-449) | ○ |
| C-25 | UT-SCX-105: effectiveラッパーのContainerSecurityContext()がcontainerSCに委譲する | E-01 (L456-458) | ○ |
| C-26 | UT-SCX-106〜113: effectiveラッパーがコンテナ優先・Pod継承のロジックを正しく行う（SELinuxOptions, RunAsUser, RunAsGroup, RunAsNonRoot） | E-01 (L479-523) | ○ |
| C-27 | UT-SCX-114〜119: effectiveラッパーのcontainerSCへの直接委譲メソッドが正しく動作する（Capabilities, Privileged, ProcMount, ReadOnlyRootFilesystem, SeccompProfile, AllowPrivilegeEscalation） | E-01 (L460-547) | ○ |
| C-28 | UT-SCX-120〜132: effectiveラッパーのSet系メソッドがDeepEqual比較後に委譲する | E-01 (L463-547) | ○ |
| C-29 | UT-SCX-133〜136: HasWindowsHostProcessRequestがWindowsOptions/HostProcessのnil安全性を持つ | E-02 (L29-39) | ○ |
| C-30 | UT-SCX-137: HasWindowsHostProcessRequestがPodレベルのWindowsOptions.HostProcessを継承する | E-02 (L29-39, L44-122) | △ |
| C-31 | UT-SCX-138〜152: DetermineEffectiveSecurityContextがPod/Container間の優先度・マージを正しく行う | E-02 (L44-122) | ○ |
| C-32 | UT-SCX-153〜158: DetermineEffectiveRunAsUserがPod/Container間の優先度とnil/ゼロ値を正しく処理する | E-02 (L127-141) | ○ |
| C-33 | UT-SCX-159〜163: securityContextFromPodSecurityContextがPodのSCから正しくContainer SCを生成する | E-02 (L143-176) | ○ |
| C-34 | UT-SCX-164〜167: AddNoNewPrivilegesがAllowPrivilegeEscalationの各状態を正しく判定する | E-02 (L179-191) | ○ |
| C-35 | UT-SCX-168〜170: ConvertToRuntimeMaskedPathsがProcMountTypeに応じて正しいパスを返す | E-02 (L232-240) | ○ |
| C-36 | UT-SCX-171〜173: ConvertToRuntimeReadonlyPathsがProcMountTypeに応じて正しいパスを返す | E-02 (L244-252) | ○ |
| C-37 | UT-SCX-174〜175: テスト用ヘルパー関数がデフォルト値で正しくSecurityContextを生成する | E-03 (L26-46) | ○ |
| C-38 | UT-SCX-176〜177: Linux版possibleCPUsが/sys読み取りとruntime.NumCPUフォールバックを行う | E-04 (L28-38) | △ |
| C-39 | UT-SCX-178〜181: possibleCPUsParsedがカンマ区切り・範囲形式を正しくパースし、不正入力にnilを返す | E-04 (L42-74) | △ |
| C-40 | UT-SCX-182: Darwin版possibleCPUsがnilを返す | E-05 (L19-21) | ○ |
| C-41 | UT-SCX-183: Windows版possibleCPUsがnilを返す | E-06 (L19-21) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-30 (UT-SCX-137): HasWindowsHostProcessRequestはDetermineEffectiveSecurityContextを内部で呼び出しており、WindowsOptionsのPodレベル継承はsecurityContextFromPodSecurityContext内で処理される。間接的なパスのため、実際の動作は統合的なテストで確認が望ましい。
  - 候補：統合テスト / DetermineEffectiveSecurityContextの戻り値を直接検証するテスト
- C-38, C-39 (UT-SCX-176〜181): possibleCPUs/possibleCPUsParsedはsync.OnceValueでラップされており、テスト環境での再実行が困難。また/sys/devices/system/cpu/possibleの実際の内容はホストに依存するため、モック化や環境分離が必要。
  - 候補：テスト用のファイルシステムモック / ビルドタグによるテスト分離 / possibleCPUsParsedの内部ロジックを分離した関数のテスト

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): accessors.goの全getter/setterテストケース（UT-SCX-001〜132） - コードが単純で分岐が明確、ソースコードから直接根拠を確認可能
- 0 (低リスク): fake.goのテスト用ヘルパー関数テストケース（UT-SCX-174〜175）
- 0 (低リスク): util.goのDetermineEffectiveSecurityContext, DetermineEffectiveRunAsUser, AddNoNewPrivileges, ConvertToRuntime*Pathsのテストケース（UT-SCX-133〜173）
- 1 (中リスク): HasWindowsHostProcessRequestのPodレベル継承テスト（UT-SCX-137） - DetermineEffectiveSecurityContext経由の間接参照パス
- 1 (中リスク): util_linux.goのpossibleCPUs関連テストケース（UT-SCX-176〜181） - sync.OnceValueとファイルシステム依存によりテスト実行に制約がある
- 0 (低リスク): effectiveContainerSecurityContextWrapperのテストケース - reflect.DeepEqualの使用は標準的

## 6) レビュアーチェックリスト（最小）
- [ ] accessors.goの全getter/setterに対してnilラッパー時の挙動テストが網羅されているか
- [ ] containerSecurityContextWrapperの全Setメソッドに対してnilチェック（nil + nil → 早期リターン）と遅延初期化（nil + 非nil → 初期化後設定）の両方がテストされているか
- [ ] effectiveContainerSecurityContextWrapperのPod継承ロジック（SELinuxOptions, RunAsUser, RunAsGroup, RunAsNonRoot）が正しくカバーされているか
- [ ] effectiveContainerSecurityContextWrapperの全Setメソッドに対してDeepEqual一致時のスキップテストが含まれているか
- [ ] DetermineEffectiveSecurityContextの全フィールドの上書きテストが網羅されているか（SELinuxOptions, WindowsOptions, Capabilities, Privileged, RunAsUser, RunAsGroup, RunAsNonRoot, ReadOnlyRootFilesystem, AllowPrivilegeEscalation, ProcMount）
- [ ] WindowsOptionsのフィールド別マージ（GMSA, RunAsUserName, HostProcess）が正しくテストされているか
- [ ] possibleCPUs関連のテストケースがテスト環境で実行可能か（sync.OnceValue制約の確認）
- [ ] ConvertToRuntimeMaskedPaths/ReadonlyPathsのデフォルトパスリストが最新のmoby/mobyと同期しているか確認
