---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 147
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：pkg-serviceaccount 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：147 / 150、根拠なし：3
- 優先レビュー（高）
  1. **UT-SVC-053（レガシートークンのimplicitAuds処理）**：audit annotation動作の詳細な期待結果はコードの複数箇所にまたがるため要確認
  2. **UT-SVC-077（auto-generatedトークンのメトリクス）**：メトリクスカウンタの実際のインクリメント確認はテスト実行が必要
  3. **UT-SVC-078（手動作成トークンのメトリクス）**：メトリクスカウンタの実際のインクリメント確認はテスト実行が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/serviceaccount/claims.go` - Claims関数、validator.Validate関数の実装
- E-02: `pkg/serviceaccount/jwt.go` - JWTTokenGenerator, keyIDFromPublicKey, signerFrom*, jwtTokenAuthenticator, StaticPublicKeysGetter, GenerateToken等の実装
- E-03: `pkg/serviceaccount/legacy.go` - LegacyClaims, NewLegacyValidator, legacyValidator.Validate, patchSecretWithLastUsedDate等の実装
- E-04: `pkg/serviceaccount/openidmetadata.go` - NewOpenIDMetadataProvider, openIDConfigJSON, openIDKeysetJSON, algorithmFromPublicKey, publicJWKSFromKeys, getAlgs等の実装
- E-05: `pkg/serviceaccount/metrics.go` - RegisterMetrics関数、メトリクス変数定義
- E-06: `pkg/serviceaccount/externaljwt/metrics/metrics.go` - RecordFetchKeysAttempt, RecordTokenGenAttempt, getErrorCode, OuboundRequestMetricsInterceptor等の実装
- E-07: `pkg/serviceaccount/externaljwt/plugin/keycache.go` - newKeyCache, keyCache各メソッド, keysChanged, getTokenVerificationKeys等の実装
- E-08: `pkg/serviceaccount/externaljwt/plugin/plugin.go` - Plugin.GenerateToken, validateJWTHeader, mergeClaims, payloadGrabber等の実装
- E-09: `pkg/serviceaccount/claims_test.go` - 既存テストファイル（テスト観点の参考）
- E-10: `pkg/serviceaccount/jwt_test.go` - 既存テストファイル（テスト観点の参考）
- E-11: `pkg/serviceaccount/openidmetadata_test.go` - 既存テストファイル（テスト観点の参考）
- E-12: `pkg/serviceaccount/externaljwt/plugin/keycache_test.go` - 既存テストファイル（テスト観点の参考）
- E-13: `pkg/serviceaccount/externaljwt/plugin/plugin_test.go` - 既存テストファイル（テスト観点の参考）
- E-14: `pkg/serviceaccount/externaljwt/metrics/metrics_test.go` - 既存テストファイル（テスト観点の参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SVC-001: Podバインドのトークンクレーム生成 | E-01 (claims.go:70-130) | ○ |
| C-02 | UT-SVC-002: Secretバインドのトークンクレーム生成 | E-01 (claims.go:110-114) | ○ |
| C-03 | UT-SVC-003: Nodeバインドのトークンクレーム生成 | E-01 (claims.go:115-123) | ○ |
| C-04 | UT-SVC-004: SecretとPod両方指定でエラー | E-01 (claims.go:92-93) | ○ |
| C-05 | UT-SVC-005: SecretとNode両方指定でエラー | E-01 (claims.go:92-93) | ○ |
| C-06 | UT-SVC-006: Node feature gate無効時エラー | E-01 (claims.go:116-118) | ○ |
| C-07 | UT-SVC-007: warnafterフィールド設定 | E-01 (claims.go:125-127) | ○ |
| C-08 | UT-SVC-008: warnafter=0で未設定 | E-01 (claims.go:125) | ○ |
| C-09 | UT-SVC-009: JTI feature gate有効時ID設定 | E-01 (claims.go:79-81) | ○ |
| C-10 | UT-SVC-010: Pod+Node情報付きトークン | E-01 (claims.go:101-109) | ○ |
| C-11 | UT-SVC-011: 有効トークンの検証成功 | E-01 (claims.go:144-292) | ○ |
| C-12 | UT-SVC-012: 期限切れトークン拒否 | E-01 (claims.go:153-154) | ○ |
| C-13 | UT-SVC-013: NotBefore未来で拒否 | E-01 (claims.go:156-157) | ○ |
| C-14 | UT-SVC-014: IssuedAt未来で拒否 | E-01 (claims.go:159-160) | ○ |
| C-15 | UT-SVC-015: SA不存在でエラー | E-01 (claims.go:180-184) | ○ |
| C-16 | UT-SVC-016: SA UID不一致でエラー | E-01 (claims.go:186-189) | ○ |
| C-17 | UT-SVC-017: SA削除済みでエラー | E-01 (claims.go:190-193) | ○ |
| C-18 | UT-SVC-018: Secret不存在でエラー | E-01 (claims.go:197-201) | ○ |
| C-19 | UT-SVC-019: Secret UID不一致でエラー | E-01 (claims.go:202-205) | ○ |
| C-20 | UT-SVC-020: Secret削除済みでエラー | E-01 (claims.go:206-210) | ○ |
| C-21 | UT-SVC-021: Pod不存在でエラー | E-01 (claims.go:215-219) | ○ |
| C-22 | UT-SVC-022: Pod UID不一致でエラー | E-01 (claims.go:220-224) | ○ |
| C-23 | UT-SVC-023: Pod削除済みでエラー | E-01 (claims.go:224-228) | ○ |
| C-24 | UT-SVC-024: Node不存在でエラー | E-01 (claims.go:247-251) | ○ |
| C-25 | UT-SVC-025: Node UID不一致でエラー | E-01 (claims.go:252-255) | ○ |
| C-26 | UT-SVC-026: Node削除済みでエラー | E-01 (claims.go:256-259) | ○ |
| C-27 | UT-SVC-027: Node検証feature gate無効 | E-01 (claims.go:242-245) | ○ |
| C-28 | UT-SVC-028: warnafter超過メトリクス | E-01 (claims.go:268-272) | ○ |
| C-29 | UT-SVC-029: warnafter未超過メトリクス | E-01 (claims.go:273-275) | ○ |
| C-30 | UT-SVC-030: RSA鍵TokenGenerator生成 | E-02 (jwt.go:64-69) | ○ |
| C-31 | UT-SVC-031: ECDSA P256 TokenGenerator | E-02 (jwt.go:70-74) | ○ |
| C-32 | UT-SVC-032: ECDSA P384 TokenGenerator | E-02 (jwt.go:70-74, 155-160) | ○ |
| C-33 | UT-SVC-033: ECDSA P521 TokenGenerator | E-02 (jwt.go:70-74, 155-160) | ○ |
| C-34 | UT-SVC-034: 不正鍵型でエラー | E-02 (jwt.go:80-81) | ○ |
| C-35 | UT-SVC-035: RSA公開鍵からkeyID導出 | E-02 (jwt.go:99-112) | ○ |
| C-36 | UT-SVC-036: ECDSA公開鍵からkeyID導出 | E-02 (jwt.go:99-112) | ○ |
| C-37 | UT-SVC-037: keyID決定性確認 | E-02 (jwt.go:99-112) | ○ |
| C-38 | UT-SVC-038: 未知curve検出 | E-02 (jwt.go:162-163) | ○ |
| C-39 | UT-SVC-039: JWT生成基本動作 | E-02 (jwt.go:220-222, 443-452) | ○ |
| C-40 | UT-SVC-040: issuerクレーム設定 | E-02 (jwt.go:443-452) | ○ |
| C-41 | UT-SVC-041: PublicKeysGetter生成 | E-02 (jwt.go:277-298) | ○ |
| C-42 | UT-SVC-042: 秘密鍵から公開鍵抽出 | E-02 (jwt.go:281-284) | ○ |
| C-43 | UT-SVC-043: keyID空で全鍵取得 | E-02 (jwt.go:309-313) | ○ |
| C-44 | UT-SVC-044: keyIDフィルタ取得 | E-02 (jwt.go:309-313) | ○ |
| C-45 | UT-SVC-045: 存在しないkeyID | E-02 (jwt.go:309-313) | ○ |
| C-46 | UT-SVC-046: GetCacheAgeMaxSeconds=3600 | E-02 (jwt.go:304-307) | ○ |
| C-47 | UT-SVC-047: トークン認証基本機能 | E-02 (jwt.go:334-412) | ○ |
| C-48 | UT-SVC-048: 不正issuer拒否 | E-02 (jwt.go:335-337, 420-440) | ○ |
| C-49 | UT-SVC-049: 不正形式トークン拒否 | E-02 (jwt.go:339-342) | ○ |
| C-50 | UT-SVC-050: 無効署名トークン拒否 | E-02 (jwt.go:364-375) | ○ |
| C-51 | UT-SVC-051: 鍵なし時エラー | E-02 (jwt.go:361-363) | ○ |
| C-52 | UT-SVC-052: audience不一致エラー | E-02 (jwt.go:396-399) | ○ |
| C-53 | UT-SVC-053: レガシートークンimplicitAuds | E-02 (jwt.go:383-388) | △ |
| C-54 | UT-SVC-054: hasCorrectIssuer正常 | E-02 (jwt.go:420-440) | ○ |
| C-55 | UT-SVC-055: JSON入力拒否 | E-02 (jwt.go:421-423) | ○ |
| C-56 | UT-SVC-056: 不正パート数拒否 | E-02 (jwt.go:424-426) | ○ |
| C-57 | UT-SVC-057: base64デコード失敗 | E-02 (jwt.go:428-430) | ○ |
| C-58 | UT-SVC-058: レガシークレーム生成 | E-03 (legacy.go:42-51) | ○ |
| C-59 | UT-SVC-059: LegacyValidator生成（lookup=true） | E-03 (legacy.go:65-77) | ○ |
| C-60 | UT-SVC-060: LegacyValidator生成（lookup=false） | E-03 (legacy.go:65-77) | ○ |
| C-61 | UT-SVC-061: getter nil エラー | E-03 (legacy.go:66-68) | ○ |
| C-62 | UT-SVC-062: secretsWriter nil エラー | E-03 (legacy.go:69-71) | ○ |
| C-63 | UT-SVC-063: レガシー検証（lookupなし） | E-03 (legacy.go:87-181) | ○ |
| C-64 | UT-SVC-064: subject空エラー | E-03 (legacy.go:89-91) | ○ |
| C-65 | UT-SVC-065: namespace空エラー | E-03 (legacy.go:93-95) | ○ |
| C-66 | UT-SVC-066: secretName空エラー | E-03 (legacy.go:96-99) | ○ |
| C-67 | UT-SVC-067: serviceAccountName空エラー | E-03 (legacy.go:100-103) | ○ |
| C-68 | UT-SVC-068: serviceAccountUID空エラー | E-03 (legacy.go:104-107) | ○ |
| C-69 | UT-SVC-069: subject不一致エラー | E-03 (legacy.go:109-112) | ○ |
| C-70 | UT-SVC-070: Secret不存在エラー | E-03 (legacy.go:116-120) | ○ |
| C-71 | UT-SVC-071: Secret削除済みエラー | E-03 (legacy.go:121-124) | ○ |
| C-72 | UT-SVC-072: トークンデータ不一致 | E-03 (legacy.go:125-128) | ○ |
| C-73 | UT-SVC-073: SA不存在エラー | E-03 (legacy.go:131-135) | ○ |
| C-74 | UT-SVC-074: SA削除済みエラー | E-03 (legacy.go:136-139) | ○ |
| C-75 | UT-SVC-075: SA UID不一致エラー | E-03 (legacy.go:140-143) | ○ |
| C-76 | UT-SVC-076: InvalidSinceラベルで拒否 | E-03 (legacy.go:149-154) | ○ |
| C-77 | UT-SVC-077: auto-generatedメトリクス | E-03 (legacy.go:157-165) | △ |
| C-78 | UT-SVC-078: 手動作成メトリクス | E-03 (legacy.go:168-171) | △ |
| C-79 | UT-SVC-079: last-used更新 | E-03 (legacy.go:183-198) | ○ |
| C-80 | UT-SVC-080: last-used今日で更新なし | E-03 (legacy.go:188) | ○ |
| C-81 | UT-SVC-081: last-used明日で更新なし | E-03 (legacy.go:188) | ○ |
| C-82 | UT-SVC-082: OIDC Provider生成 | E-04 (openidmetadata.go:113-196) | ○ |
| C-83 | UT-SVC-083: 空issuerURLエラー | E-04 (openidmetadata.go:114-116) | ○ |
| C-84 | UT-SVC-084: HTTP issuerURLエラー | E-04 (openidmetadata.go:131-133) | ○ |
| C-85 | UT-SVC-085: クエリ付きissuerURL | E-04 (openidmetadata.go:134-136) | ○ |
| C-86 | UT-SVC-086: フラグメント付きissuerURL | E-04 (openidmetadata.go:137-139) | ○ |
| C-87 | UT-SVC-087: jwksURIとアドレス両方空 | E-04 (openidmetadata.go:117-119) | ○ |
| C-88 | UT-SVC-088: pubKeyGetter nilエラー | E-04 (openidmetadata.go:120-122) | ○ |
| C-89 | UT-SVC-089: jwksURI自動生成 | E-04 (openidmetadata.go:143-174) | ○ |
| C-90 | UT-SVC-090: jwksURI HTTPSチェック | E-04 (openidmetadata.go:177-181) | ○ |
| C-91 | UT-SVC-091: GetConfigJSON | E-04 (openidmetadata.go:66-68) | ○ |
| C-92 | UT-SVC-092: GetKeysetJSON | E-04 (openidmetadata.go:69-71) | ○ |
| C-93 | UT-SVC-093: OIDC Discovery JSON構造 | E-04 (openidmetadata.go:215-235) | ○ |
| C-94 | UT-SVC-094: JWKS JSON構造 | E-04 (openidmetadata.go:239-251) | ○ |
| C-95 | UT-SVC-095: 空鍵リストエラー | E-04 (openidmetadata.go:239-243) | ○ |
| C-96 | UT-SVC-096: RSA -> RS256 | E-04 (openidmetadata.go:312-317) | ○ |
| C-97 | UT-SVC-097: ECDSA P256 -> ES256 | E-04 (openidmetadata.go:319-321) | ○ |
| C-98 | UT-SVC-098: ECDSA P384 -> ES384 | E-04 (openidmetadata.go:322-323) | ○ |
| C-99 | UT-SVC-099: ECDSA P521 -> ES512 | E-04 (openidmetadata.go:324-325) | ○ |
| C-100 | UT-SVC-100: 不正鍵型エラー | E-04 (openidmetadata.go:331-333) | ○ |
| C-101 | UT-SVC-101: 未知curveエラー | E-04 (openidmetadata.go:326-328) | ○ |
| C-102 | UT-SVC-102: JWKS生成 | E-04 (openidmetadata.go:268-289) | ○ |
| C-103 | UT-SVC-103: 不正鍵検出 | E-04 (openidmetadata.go:273-287) | ○ |
| C-104 | UT-SVC-104: アルゴリズムソート | E-04 (openidmetadata.go:253-260) | ○ |
| C-105 | UT-SVC-105: 空JWKSで空スライス | E-04 (openidmetadata.go:253-260) | ○ |
| C-106 | UT-SVC-106: メトリクス登録成功 | E-05 (metrics.go:93-102) | ○ |
| C-107 | UT-SVC-107: メトリクス二重登録防止 | E-05 (metrics.go:91-102) | ○ |
| C-108 | UT-SVC-108: FetchKeys成功メトリクス | E-06 (metrics.go:108-113) | ○ |
| C-109 | UT-SVC-109: FetchKeysエラーメトリクス | E-06 (metrics.go:108-113) | ○ |
| C-110 | UT-SVC-110: TokenGen成功メトリクス | E-06 (metrics.go:115-117) | ○ |
| C-111 | UT-SVC-111: nilエラーでOK | E-06 (metrics.go:127-130) | ○ |
| C-112 | UT-SVC-112: gRPCエラーコード | E-06 (metrics.go:133-136) | ○ |
| C-113 | UT-SVC-113: 非gRPCエラーコード | E-06 (metrics.go:140-141) | ○ |
| C-114 | UT-SVC-114: インターセプタ成功 | E-06 (metrics.go:143-148) | ○ |
| C-115 | UT-SVC-115: インターセプタエラー | E-06 (metrics.go:143-148) | ○ |
| C-116 | UT-SVC-116: keyCache初期化 | E-07 (keycache.go:48-54) | ○ |
| C-117 | UT-SVC-117: GetCacheAgeMaxSeconds正 | E-07 (keycache.go:95-101) | ○ |
| C-118 | UT-SVC-118: GetCacheAgeMaxSeconds=0 | E-07 (keycache.go:97-99) | ○ |
| C-119 | UT-SVC-119: GetPublicKeys全鍵 | E-07 (keycache.go:105-125, 127-145) | ○ |
| C-120 | UT-SVC-120: GetPublicKeys keyID指定 | E-07 (keycache.go:137-144) | ○ |
| C-121 | UT-SVC-121: 存在しないkeyID | E-07 (keycache.go:105-125) | ○ |
| C-122 | UT-SVC-122: AddListener | E-07 (keycache.go:88-93) | ○ |
| C-123 | UT-SVC-123: DataTimestamp変更検出 | E-07 (keycache.go:171-175) | ○ |
| C-124 | UT-SVC-124: 鍵数変更検出 | E-07 (keycache.go:177-179) | ○ |
| C-125 | UT-SVC-125: keyID順序変更検出 | E-07 (keycache.go:182-184) | ○ |
| C-126 | UT-SVC-126: ExcludeFromOIDC変更検出 | E-07 (keycache.go:185-187) | ○ |
| C-127 | UT-SVC-127: 変更なし検出 | E-07 (keycache.go:171-191) | ○ |
| C-128 | UT-SVC-128: 鍵取得パース成功 | E-07 (keycache.go:205-252) | ○ |
| C-129 | UT-SVC-129: FetchKeys RPC失敗 | E-07 (keycache.go:207-210) | ○ |
| C-130 | UT-SVC-130: RefreshHint不正 | E-07 (keycache.go:212-214) | ○ |
| C-131 | UT-SVC-131: 鍵0件エラー | E-07 (keycache.go:216-218) | ○ |
| C-132 | UT-SVC-132: nil鍵検出 | E-07 (keycache.go:224-226) | ○ |
| C-133 | UT-SVC-133: 空KeyId検出 | E-07 (keycache.go:227-229) | ○ |
| C-134 | UT-SVC-134: 長KeyId検出 | E-07 (keycache.go:227-229) | ○ |
| C-135 | UT-SVC-135: 空Keyデータ検出 | E-07 (keycache.go:230-232) | ○ |
| C-136 | UT-SVC-136: 不正PKIX鍵パース | E-07 (keycache.go:233-236) | ○ |
| C-137 | UT-SVC-137: 外部署名トークン生成 | E-08 (plugin.go:107-111) | ○ |
| C-138 | UT-SVC-138: 署名失敗エラー | E-08 (plugin.go:107-111, 113-139) | ○ |
| C-139 | UT-SVC-139: ヘッダー検証成功 | E-08 (plugin.go:148-197) | ○ |
| C-140 | UT-SVC-140: base64ヘッダーデコード失敗 | E-08 (plugin.go:149-152) | ○ |
| C-141 | UT-SVC-141: 不正type | E-08 (plugin.go:167-169) | ○ |
| C-142 | UT-SVC-142: keyID欠落 | E-08 (plugin.go:170-172) | ○ |
| C-143 | UT-SVC-143: keyID長すぎ | E-08 (plugin.go:173-175) | ○ |
| C-144 | UT-SVC-144: 不正アルゴリズム | E-08 (plugin.go:176-184) | ○ |
| C-145 | UT-SVC-145: OIDC除外鍵禁止 | E-08 (plugin.go:186-194) | ○ |
| C-146 | UT-SVC-146: OIDC除外鍵許可 | E-08 (plugin.go:186) | ○ |
| C-147 | UT-SVC-147: 空署名検出 | E-08 (plugin.go:134-136) | ○ |
| C-148 | UT-SVC-148: クレームマージ | E-08 (plugin.go:199-207) | ○ |
| C-149 | UT-SVC-149: payloadGrabber Sign | E-08 (plugin.go:213-216) | ○ |
| C-150 | UT-SVC-150: payloadGrabber Options | E-08 (plugin.go:218) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-53: レガシートークンのimplicitAuds処理時のaudit annotation記録は、jwt.goの383-388行目に根拠があるが、期待結果の詳細（audit annotationの具体的な内容）は複数コンポーネントにまたがり、完全な検証にはインテグレーションテストが必要
  - 候補：audit パッケージの動作仕様 / authenticator パッケージのAudiencesFrom仕様
- C-77, C-78: メトリクスカウンタのインクリメント確認は、コード上は明確だが、テスト環境でのメトリクスレジストリのリセット方法に依存する
  - 候補：component-base/metrics パッケージのテストユーティリティ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの条件分岐・エラーハンドリングに直接対応しており、根拠が明確
- 1: 中リスク - メトリクス関連テスト（C-77, C-78, C-108〜C-115）はテスト実行環境でのメトリクスレジストリ初期化に依存
- 0: 低リスク - Feature gate関連テスト（C-06, C-09, C-10, C-27）はutilfeature.DefaultFeatureGateのモック設定が必要だが、Kubernetesの標準的なテストパターンで対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] claims.go の Claims 関数に対するテストケース（UT-SVC-001〜010）が全分岐をカバーしているか
- [ ] validator.Validate のセキュリティ関連テスト（UT-SVC-011〜029）が全リソース種別（SA, Pod, Secret, Node）の存在・UID・削除チェックを網羅しているか
- [ ] JWTTokenGenerator の鍵型テスト（UT-SVC-030〜034）がRSA, ECDSA全カーブ, OpaqueSigner, 不正型を網羅しているか
- [ ] legacyValidator.Validate の必須クレーム検証（UT-SVC-064〜069）が全5フィールドをカバーしているか
- [ ] NewOpenIDMetadataProvider のURL検証テスト（UT-SVC-082〜090）がOIDC仕様の要件を満たしているか
- [ ] externaljwt plugin の validateJWTHeader テスト（UT-SVC-139〜146）が許可されたアルゴリズム（RS256, ES256, ES384, ES512）と拒否ケースを網羅しているか
- [ ] keycache の getTokenVerificationKeys テスト（UT-SVC-128〜136）が全バリデーション条件をカバーしているか
