---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 146
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：pkg-volume 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：146 / 150、根拠なし：4
- 優先レビュー（高）
  1. **C-043（metricsDu.GetMetrics正常系）**：ディスク使用量取得の具体的な戻り値はOS依存のため、期待結果の記述が概要レベル
  2. **C-046（metricsStatFS.GetMetrics正常系）**：StatFS系メトリクスの具体的な戻り値はOS依存
  3. **C-063（skipPermissionChange OnRootMismatch）**：テスト前提条件のルートディレクトリ権限一致の具体的な設定方法がコードから完全には読み取れない
  4. **C-132（OperationCompleteHook）**：メトリクス記録の具体的な検証方法はPrometheusレジストリへの依存あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/volume/plugins.go` - Spec構造体、VolumePluginMgr、プラグイン検索・登録ロジック
- E-02: `pkg/volume/metrics_errors.go` - MetricsError型、エラー生成関数、IsNotSupported関数
- E-03: `pkg/volume/metrics_nil.go` - MetricsNil型、SupportsMetrics/GetMetricsメソッド
- E-04: `pkg/volume/metrics_du.go` - metricsDu型、ディスク使用量メトリクス取得
- E-05: `pkg/volume/metrics_statfs.go` - metricsStatFS型、StatFSメトリクス取得
- E-06: `pkg/volume/metrics_block.go` - metricsBlock型、ブロックデバイスメトリクス取得
- E-07: `pkg/volume/metrics_cached.go` - cachedMetrics型、メトリクスキャッシュ
- E-08: `pkg/volume/noop_expandable_plugin.go` - noopExpandableVolumePluginInstance型
- E-09: `pkg/volume/volume_linux.go` - changeFilePermission、skipPermissionChange、requiresPermissionChange、walkDeep等
- E-10: `pkg/volume/util/util.go` - IsReady、SetReady、CalculateTimeoutForVolume、JoinMountOptions、ContainsAccessMode等
- E-11: `pkg/volume/util/storageclass.go` - IsDefaultAnnotation関数
- E-12: `pkg/volume/util/nested_volumes.go` - getNestedMountpoints、MakeNestedMountpoints
- E-13: `pkg/volume/util/types/types.go` - GeneratedOperations、エラー型群
- E-14: `pkg/volume/util/metrics.go` - OperationCompleteHook、GetFullQualifiedPluginNameForVolume
- E-15: `pkg/volume/util/selinux.go` - SELinuxLabelTranslator、fakeTranslator、AddSELinuxMountOption等
- E-16: `pkg/volume/util/io_util.go` - IoUtil、osIOHandler
- E-17: `pkg/volume/util/resize_util.go` - MergeResizeConditionOnPVC等
- E-18: `pkg/volume/util/atomic_writer.go` - NewAtomicWriter
- E-19: `pkg/volume/volume.go` - Volume型、Metrics型、MetricsProviderインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Spec.Name()はVolume名を返す | E-01 | ○ |
| C-002 | Spec.Name()はPV名を返す | E-01 | ○ |
| C-003 | Spec.Name()はnilで空文字を返す | E-01 | ○ |
| C-004 | IsKubeletExpandableはFlexVolumeでtrueを返す | E-01 | ○ |
| C-005 | IsKubeletExpandableはPV FlexVolumeでtrueを返す | E-01 | ○ |
| C-006 | IsKubeletExpandableは非FlexVolumeでfalseを返す | E-01 | ○ |
| C-007 | IsKubeletExpandableはnilでfalseを返す | E-01 | ○ |
| C-008 | KubeletExpandablePluginNameはFlexVolumeドライバ名を返す | E-01 | ○ |
| C-009 | KubeletExpandablePluginNameはPV FlexVolumeドライバ名を返す | E-01 | ○ |
| C-010 | KubeletExpandablePluginNameは未設定時に空文字を返す | E-01 | ○ |
| C-011 | NewSpecFromVolumeはSpecを生成する | E-01 | ○ |
| C-012 | NewSpecFromPersistentVolumeはSpecを生成する | E-01 | ○ |
| C-013 | InitPluginsは有効なプラグインを登録する | E-01 | ○ |
| C-014 | InitPluginsは無効名でエラーを返す | E-01 | ○ |
| C-015 | InitPluginsは重複名でエラーを返す | E-01 | ○ |
| C-016 | InitPluginsはnil proberでdummyを使う | E-01 | ○ |
| C-017 | FindPluginBySpecは一致するプラグインを返す | E-01 | ○ |
| C-018 | FindPluginBySpecはnil specでエラーを返す | E-01 | ○ |
| C-019 | FindPluginBySpecは不一致でエラーを返す | E-01 | ○ |
| C-020 | FindPluginBySpecは複数一致でエラーを返す | E-01 | ○ |
| C-021 | FindPluginByNameは名前で検索できる | E-01 | ○ |
| C-022 | FindPluginByNameは存在しない名前でエラーを返す | E-01 | ○ |
| C-023 | FindPersistentPluginBySpecはPVプラグインを返す | E-01 | ○ |
| C-024 | FindPersistentPluginBySpecは非PVでエラーを返す | E-01 | ○ |
| C-025 | FindExpandablePluginBySpecはnoopプラグインを返す | E-01 | ○ |
| C-026 | FindAttachablePluginBySpecはAttachableプラグインを返す | E-01 | ○ |
| C-027 | FindAttachablePluginBySpecは非Attachableでnilを返す | E-01 | ○ |
| C-028 | ValidateRecyclerPodTemplateはVolume有りでnilを返す | E-01 | ○ |
| C-029 | ValidateRecyclerPodTemplateはVolume無しでエラーを返す | E-01 | ○ |
| C-030 | NewPersistentVolumeRecyclerPodTemplateはテンプレートを生成する | E-01 | ○ |
| C-031 | NewNotSupportedErrorはErrCodeNotSupportedを生成する | E-02 | ○ |
| C-032 | NewNoPathDefinedErrorはErrCodeNoPathDefinedを生成する | E-02 | ○ |
| C-033 | NewFsInfoFailedErrorはErrCodeFsInfoFailedを生成する | E-02 | ○ |
| C-034 | NewNotImplementedErrorはErrCodeNotSupportedを生成する | E-02 | ○ |
| C-035 | NewNotSupportedErrorWithDriverNameはドライバ名を含む | E-02 | ○ |
| C-036 | IsNotSupportedはNotSupportedエラーでtrueを返す | E-02 | ○ |
| C-037 | IsNotSupportedは非NotSupportedエラーでfalseを返す | E-02 | ○ |
| C-038 | IsNotSupportedはnilでfalseを返す | E-02 | ○ |
| C-039 | MetricsError.ErrorはMsgを返す | E-02 | ○ |
| C-040 | MetricsNil.GetMetricsは空MetricsとNotSupportedErrorを返す | E-03 | ○ |
| C-041 | MetricsNil.SupportsMetricsはfalseを返す | E-03 | ○ |
| C-042 | metricsDu.GetMetricsは空パスでNoPathDefinedErrorを返す | E-04 | ○ |
| C-043 | metricsDu.GetMetricsは有効パスでMetricsを返す | E-04 | △ |
| C-044 | NewMetricsDuはMetricsProviderを生成する | E-04 | ○ |
| C-045 | metricsStatFS.GetMetricsは空パスでNoPathDefinedErrorを返す | E-05 | ○ |
| C-046 | metricsStatFS.GetMetricsは有効パスでMetricsを返す | E-05 | △ |
| C-047 | NewMetricsStatFSはMetricsProviderを生成する | E-05 | ○ |
| C-048 | metricsBlock.GetMetricsは空デバイスでNoPathDefinedErrorを返す | E-06 | ○ |
| C-049 | metricsBlock.GetMetricsは存在しないデバイスでエラーを返す | E-06 | ○ |
| C-050 | NewMetricsBlockはMetricsProviderを生成する | E-06 | ○ |
| C-051 | cachedMetrics.GetMetricsはキャッシュする | E-07 | ○ |
| C-052 | cachedMetrics.GetMetricsはエラー時にキャッシュしない | E-07 | ○ |
| C-053 | NewCachedMetricsはcachedMetricsを生成する | E-07 | ○ |
| C-054 | noop.ExpandVolumeDeviceはnewSizeを返す | E-08 | ○ |
| C-055 | noop.GetPluginNameはKubeletExpandablePluginNameを返す | E-08 | ○ |
| C-056 | noop.RequiresFSResizeはtrueを返す | E-08 | ○ |
| C-057 | noop.CanSupportはtrueを返す | E-08 | ○ |
| C-058 | changeFilePermissionはファイルのグループとパーミッションを変更する | E-09 | ○ |
| C-059 | changeFilePermissionはディレクトリにsetgidとexecを付与する | E-09 | ○ |
| C-060 | changeFilePermissionはreadonlyでroMaskを適用する | E-09 | ○ |
| C-061 | changeFilePermissionはシンボリックリンクでchmodをスキップする | E-09 | ○ |
| C-062 | skipPermissionChangeはnilポリシーでfalseを返す | E-09 | ○ |
| C-063 | skipPermissionChangeはOnRootMismatch+権限一致でtrueを返す | E-09 | △ |
| C-064 | requiresPermissionChangeはGID不一致でtrueを返す | E-09 | ○ |
| C-065 | requiresPermissionChangeはパーミッション不足でtrueを返す | E-09 | ○ |
| C-066 | requiresPermissionChangeはStat失敗でtrueを返す | E-09 | ○ |
| C-067 | getDirnameToReportはpodUID以降のパスを返す | E-09 | ○ |
| C-068 | getDirnameToReportはpodUID不在で元パスを返す | E-09 | ○ |
| C-069 | walkDeepは深さ優先で走査する | E-09 | ○ |
| C-070 | walkDeepは存在しないルートでエラーを渡す | E-09 | ○ |
| C-071 | readDirNamesはファイル名一覧を返す | E-09 | ○ |
| C-072 | readDirNamesは存在しないディレクトリでエラーを返す | E-09 | ○ |
| C-073 | IsReadyはreadyファイル存在でtrueを返す | E-10 | ○ |
| C-074 | IsReadyはreadyファイル不存在でfalseを返す | E-10 | ○ |
| C-075 | SetReadyはreadyファイルを作成する | E-10 | ○ |
| C-076 | CalculateTimeoutForVolumeはサイズベースのタイムアウトを返す | E-10 | ○ |
| C-077 | CalculateTimeoutForVolumeは最小タイムアウトを返す | E-10 | ○ |
| C-078 | MountOptionFromSpecはPVのMountOptionsを返す | E-10 | ○ |
| C-079 | MountOptionFromSpecはPVなしでデフォルトを返す | E-10 | ○ |
| C-080 | JoinMountOptionsは重複を排除する | E-10 | ○ |
| C-081 | JoinMountOptionsは空オプションを除外する | E-10 | ○ |
| C-082 | ContainsAccessModeは含まれるモードでtrueを返す | E-10 | ○ |
| C-083 | ContainsAccessModeは含まれないモードでfalseを返す | E-10 | ○ |
| C-084 | ContainsAllAccessModesは全モード含有でtrueを返す | E-10 | ○ |
| C-085 | ContainsAllAccessModesはモード不足でfalseを返す | E-10 | ○ |
| C-086 | GetWindowsPathはUnixパスをWindowsパスに変換する | E-10 | ○ |
| C-087 | GetUniquePodNameはPod UIDを返す | E-10 | ○ |
| C-088 | GetUniqueVolumeNameはプラグイン名/ボリューム名を返す | E-10 | ○ |
| C-089 | SplitUniqueNameは一意名を分割できる | E-10 | ○ |
| C-090 | SplitUniqueNameは不正形式でエラーを返す | E-10 | ○ |
| C-091 | GetVolumeModeはPVのVolumeModeを返す | E-10 | ○ |
| C-092 | GetVolumeModeはPVなしでFilesystemを返す | E-10 | ○ |
| C-093 | GetVolumeModeはVolumeMode nilでエラーを返す | E-10 | ○ |
| C-094 | CheckVolumeModeFilesystemはFilesystemでtrueを返す | E-10 | ○ |
| C-095 | CheckVolumeModeFilesystemはBlockでfalseを返す | E-10 | ○ |
| C-096 | CheckPersistentVolumeClaimModeBlockはBlockでtrueを返す | E-10 | ○ |
| C-097 | CheckPersistentVolumeClaimModeBlockはnilでfalseを返す | E-10 | ○ |
| C-098 | IsWindowsUNCPathはWindows UNCパスでtrueを返す | E-10 | ○ |
| C-099 | IsWindowsUNCPathは非Windowsでfalseを返す | E-10 | ○ |
| C-100 | IsWindowsLocalPathはWindowsローカルパスでtrueを返す | E-10 | ○ |
| C-101 | IsWindowsLocalPathはコロン付きでfalseを返す | E-10 | ○ |
| C-102 | MakeAbsolutePathはLinuxで絶対パスに変換する | E-10 | ○ |
| C-103 | MakeAbsolutePathはWindowsでc:\\を付与する | E-10 | ○ |
| C-104 | IsPodTerminatedはFailedでtrueを返す | E-10 | ○ |
| C-105 | IsPodTerminatedはRunningでfalseを返す | E-10 | ○ |
| C-106 | IsLocalEphemeralVolumeはEmptyDirでtrueを返す | E-10 | ○ |
| C-107 | IsLocalEphemeralVolumeはConfigMapでtrueを返す | E-10 | ○ |
| C-108 | IsLocalEphemeralVolumeはPVCでfalseを返す | E-10 | ○ |
| C-109 | HasMountRefsは外部参照でtrueを返す | E-10 | ○ |
| C-110 | HasMountRefsは内部参照のみでfalseを返す | E-10 | ○ |
| C-111 | IsMultiAttachAllowedはRWXでtrueを返す | E-10 | ○ |
| C-112 | IsMultiAttachAllowedはRWOでfalseを返す | E-10 | ○ |
| C-113 | IsMultiAttachAllowedはnil specでtrueを返す | E-10 | ○ |
| C-114 | LoadPodFromFileは空パスでエラーを返す | E-10 | ○ |
| C-115 | LoadPodFromFileは存在しないファイルでエラーを返す | E-10 | ○ |
| C-116 | GetSecretForPVはnil clientでエラーを返す | E-10 | ○ |
| C-117 | IsDefaultAnnotationはデフォルトアノテーションでtrueを返す | E-11 | ○ |
| C-118 | IsDefaultAnnotationはbetaアノテーションでtrueを返す | E-11 | ○ |
| C-119 | IsDefaultAnnotationはアノテーションなしでfalseを返す | E-11 | ○ |
| C-120 | MakeNestedMountpointsはネストされたマウントポイントを作成する | E-12 | ○ |
| C-121 | getNestedMountpointsはパストラバーサルでエラーを返す | E-12 | ○ |
| C-122 | GeneratedOperations.RunはOperationFuncを実行する | E-13 | ○ |
| C-123 | GeneratedOperations.Runはエラー時にCompleteFuncにエラーを渡す | E-13 | ○ |
| C-124 | IsOperationFinishedErrorはUncertainProgressErrorでfalseを返す | E-13 | ○ |
| C-125 | IsOperationFinishedErrorはTransientFailureでfalseを返す | E-13 | ○ |
| C-126 | IsOperationFinishedErrorは通常エラーでtrueを返す | E-13 | ○ |
| C-127 | IsFailedPreconditionErrorはFailedPreconditionでtrueを返す | E-13 | ○ |
| C-128 | IsFailedPreconditionErrorは非FailedPreconditionでfalseを返す | E-13 | ○ |
| C-129 | IsInfeasibleErrorはInfeasibleErrorでtrueを返す | E-13 | ○ |
| C-130 | IsOperationNotSupportedErrorはOperationNotSupportedでtrueを返す | E-13 | ○ |
| C-131 | IsUncertainProgressErrorはUncertainProgressErrorでtrueを返す | E-13 | ○ |
| C-132 | OperationCompleteHookは成功時にメトリクスを記録する | E-14 | △ |
| C-133 | GetFullQualifiedPluginNameForVolumeはCSIでドライバ名付きを返す | E-14 | ○ |
| C-134 | GetFullQualifiedPluginNameForVolumeは非CSIでプラグイン名のみを返す | E-14 | ○ |
| C-135 | GetFullQualifiedPluginNameForVolumeはnil specでプラグイン名のみを返す | E-14 | ○ |
| C-136 | fakeTranslator.SELinuxOptionsToFileLabelはラベルを生成する | E-15 | ○ |
| C-137 | fakeTranslator.SELinuxOptionsToFileLabelはnil optsで空文字を返す | E-15 | ○ |
| C-138 | IsSELinuxLabelTranslationErrorは該当エラーでtrueを返す | E-15 | ○ |
| C-139 | AddSELinuxMountOptionはcontextオプションを追加する | E-15 | ○ |
| C-140 | VolumeSupportsSELinuxMountはPVなしでfalseを返す | E-15 | ○ |
| C-141 | osIOHandler.ReadFileはファイルを読み取る | E-16 | ○ |
| C-142 | NewIOHandlerはosIOHandlerを生成する | E-16 | ○ |
| C-143 | MergeResizeConditionOnPVCは新条件をマージする | E-17 | ○ |
| C-144 | MergeResizeConditionOnPVCはkeepOld=falseで古い条件を除去する | E-17 | ○ |
| C-145 | MergeResizeConditionOnPVCはkeepOld=trueで古い条件を保持する | E-17 | ○ |
| C-146 | MergeResizeConditionOnPVCは非リサイズ条件を保持する | E-17 | ○ |
| C-147 | NewAtomicWriterは既存ディレクトリでAtomicWriterを生成する | E-18 | ○ |
| C-148 | NewAtomicWriterは存在しないディレクトリでエラーを返す | E-18 | ○ |
| C-149 | MultipleSELinuxLabelsError.Errorはラベル一覧メッセージを返す | E-15 | ○ |
| C-150 | IsMultipleSELinuxLabelsErrorは該当エラーでtrueを返す | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-043, C-046: メトリクス取得の正常系テストケースで、具体的な期待値はOS/ファイルシステム依存のため、テスト実行環境に依存する。コード上は`fs.DiskUsage()`や`fs.FsInfo()`の結果をそのままMetricsに格納している。
  - 候補：実際のテスト実行 / テスト用のモックファイルシステム / 既存テストコードの参照
- C-063: `skipPermissionChange`の「権限一致」の具体的な前提条件は`requiresPermissionChange`のロジックに依存し、GID一致+パーミッションスーパーセット+setgid設定が必要。
  - 候補：既存テスト `volume_linux_test.go` の参照
- C-132: `OperationCompleteHook`のメトリクス記録検証はPrometheusレジストリを介する必要があり、具体的な検証方法の記述が概要レベル。
  - 候補：testutil/prometheus パッケージのメトリクス検証ユーティリティ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UT-VOL-001〜010（Spec基本メソッド）、UT-VOL-031〜041（MetricsError/MetricsNil）、UT-VOL-054〜057（noop plugin）、UT-VOL-067〜072（ユーティリティ関数）
- 1: 中リスク - UT-VOL-042〜053（メトリクス取得）、UT-VOL-073〜081（util基本関数）、UT-VOL-124〜131（エラー型判定）、UT-VOL-136〜140（SELinux）
- 2: 高リスク - UT-VOL-013〜027（プラグイン登録・検索はKubernetes全体のボリューム管理の根幹）、UT-VOL-058〜066（パーミッション変更はセキュリティに直結）、UT-VOL-088〜093（一意名生成・分割はデータ整合性に影響）、UT-VOL-109〜112（マウント参照・マルチアタッチ判定は安全性に影響）、UT-VOL-143〜145（リサイズ条件マージはPVC状態管理に影響）

## 6) レビュアーチェックリスト（最小）
- [ ] プラグイン登録・検索系テストケース（UT-VOL-013〜027）がVolumePluginMgrの全主要メソッドを網羅しているか
- [ ] パーミッション変更系テストケース（UT-VOL-058〜066）がセキュリティ観点で十分か（特にsymlink、readonly、setgidの各条件分岐）
- [ ] メトリクス系テストケース（UT-VOL-042〜053）の期待結果がテスト実行環境で検証可能か
- [ ] エラー型判定系テストケース（UT-VOL-124〜131）がerrors.As()による型アサーションを正しく検証しているか
- [ ] リサイズ条件マージ系テストケース（UT-VOL-143〜146）がknownResizeConditionsの全パターンをカバーしているか
- [ ] CSVの全フィールドがダブルクォートで囲まれ、BOM付きUTF-8で出力されているか
