---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 47
  claims_with_evidence: 44
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：pkg-windows 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：44 / 47、根拠なし：3
- 優先レビュー（高）
  1. **UT-WIN-015（空文字列サービス名）**：ソースコード上に空文字列バリデーションの明示的な処理がなく、実際の挙動はWindows SCMの実装に依存
  2. **UT-WIN-044（os.Exit呼び出し確認）**：os.Exitのテストは通常のユニットテストでは困難であり、テスト手法の検討が必要
  3. **UT-WIN-045（os.Exitが呼ばれないこと確認）**：上記と同様、os.Exitの非呼出し確認にはモックやプロセス分離が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/windows/service/service.go` - service.goソースファイル全体（行1-208）
- E-02: `pkg/windows/service/service.go:50-73` - QueryPreShutdownInfo関数定義
- E-03: `pkg/windows/service/service.go:75-87` - UpdatePreShutdownInfo関数定義
- E-04: `pkg/windows/service/service.go:94-96` - InitService関数定義
- E-05: `pkg/windows/service/service.go:101-103` - InitServiceWithShutdown関数定義
- E-06: `pkg/windows/service/service.go:107-131` - initService関数定義
- E-07: `pkg/windows/service/service.go:133-135` - SetPreShutdownHandler関数定義
- E-08: `pkg/windows/service/service.go:137-139` - IsServiceInitialized関数定義
- E-09: `pkg/windows/service/service.go:141-207` - handler.Execute関数定義
- E-10: `pkg/windows/service/service.go:34-39` - handler構造体定義
- E-11: `pkg/windows/service/service.go:41-43` - PreshutdownHandlerインターフェース定義
- E-12: `pkg/windows/service/service.go:46-48` - SERVICE_PRESHUTDOWN_INFO構造体定義
- E-13: `pkg/windows/service/service.go:89` - thehandlerグローバル変数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueryPreShutdownInfoが有効なハンドルでSERVICE_PRESHUTDOWN_INFOを返却する | E-02 | ○ |
| C-02 | QueryPreShutdownInfoの返却値のPreshutdownTimeoutが正しい値を持つ | E-02, E-12 | ○ |
| C-03 | QueryPreShutdownInfoが無効なハンドルでエラーを返却する | E-02 | ○ |
| C-04 | QueryPreShutdownInfoがERROR_INSUFFICIENT_BUFFER以外のエラーでnilとエラーを返す | E-02 (行59-60) | ○ |
| C-05 | QueryPreShutdownInfoの初期バッファサイズが1024バイト | E-02 (行52-53) | ○ |
| C-06 | QueryPreShutdownInfoがバッファ不足時にリサイズしてリトライする | E-02 (行54-67) | ○ |
| C-07 | QueryPreShutdownInfoがn<=len(b)の場合にエラーを返す | E-02 (行62-64) | ○ |
| C-08 | UpdatePreShutdownInfoが有効なハンドルでnilを返却する | E-03 | ○ |
| C-09 | UpdatePreShutdownInfoが無効なハンドルでエラーを返却する | E-03 | ○ |
| C-10 | UpdatePreShutdownInfoがChangeServiceConfig2のエラーを伝播する | E-03 (行81-86) | ○ |
| C-11 | UpdatePreShutdownInfoがタイムアウト0で動作する | E-03 | ○ |
| C-12 | UpdatePreShutdownInfoがuint32最大値で動作する | E-03, E-12 | ○ |
| C-13 | InitServiceが有効なサービス名で初期化できる | E-04, E-06 | ○ |
| C-14 | InitServiceがsvc.Runエラー時にエラーを返す | E-06 (行119-128) | ○ |
| C-15 | InitServiceが空文字列で適切にエラー処理する | E-04, E-06 | △ |
| C-16 | InitServiceがacceptPreshutdown=falseでinitServiceを呼ぶ | E-04 (行95) | ○ |
| C-17 | InitServiceWithShutdownが有効なサービス名で初期化できる | E-05, E-06 | ○ |
| C-18 | InitServiceWithShutdownがエラー時にエラーを返す | E-05, E-06 | ○ |
| C-19 | InitServiceWithShutdownがacceptPreshutdown=trueでinitServiceを呼ぶ | E-05 (行102) | ○ |
| C-20 | initServiceがhandlerを正しく初期化しthehandlerに設定する | E-06 (行109-116) | ○ |
| C-21 | initServiceがacceptPreshutdown=trueで設定する | E-06 (行112) | ○ |
| C-22 | initServiceがacceptPreshutdown=falseで設定する | E-06 (行112) | ○ |
| C-23 | initServiceがfromsvcからエラーを受信して返却する | E-06 (行124-128) | ○ |
| C-24 | initServiceがgoroutineでsvc.Runを実行する | E-06 (行118-121) | ○ |
| C-25 | SetPreShutdownHandlerがhandlerに設定する | E-07 | ○ |
| C-26 | SetPreShutdownHandlerがthehandler==nilでpanicする | E-07, E-13 | ○ |
| C-27 | SetPreShutdownHandlerがnilハンドラを設定できる | E-07 | ○ |
| C-28 | IsServiceInitializedがthehandler設定後にtrueを返す | E-08, E-13 | ○ |
| C-29 | IsServiceInitializedがthehandler==nilでfalseを返す | E-08, E-13 | ○ |
| C-30 | ExecuteがStartPending状態を最初に送信する | E-09 (行142) | ○ |
| C-31 | ExecuteがfromsvcにnilをSendしてinitServiceのブロックを解除する | E-09 (行144) | ○ |
| C-32 | ExecuteがacceptPreshutdown=trueでAcceptPreShutdownを含むRunning状態を送信する | E-09 (行146-148) | ○ |
| C-33 | ExecuteがacceptPreshutdown=falseでAcceptShutdownを含むRunning状態を送信する | E-09 (行149-151) | ○ |
| C-34 | ExecuteがStopコマンドでStopPendingを送信しループ終了する | E-09 (行165-192) | ○ |
| C-35 | ExecuteがShutdownコマンドでStopPendingを送信しループ終了する | E-09 (行165-192) | ○ |
| C-36 | ExecuteがInterrogateコマンドでCurrentStatusを返す | E-09 (行164) | ○ |
| C-37 | ExecuteがSERVICE_CONTROL_PARAMCHANGEでCurrentStatusを返す | E-09 (行161-162) | ○ |
| C-38 | ExecuteがPreShutdownコマンドでStopPendingを送信しループ終了する | E-09 (行193-201) | ○ |
| C-39 | ExecuteがPreShutdownコマンドでpreshutdownHandlerを呼び出す | E-09 (行197-199) | ○ |
| C-40 | ExecuteがPreShutdownコマンドでpreshutdownHandler==nilでもpanicしない | E-09 (行197) | ○ |
| C-41 | Executeがtosvcシグナルでループ終了する | E-09 (行157-158) | ○ |
| C-42 | Executeが常に(false, 0)を返却する | E-09 (行206) | ○ |
| C-43 | ExecuteがStop/ShutdownでRequestShutdownを呼ぶ | E-09 (行174) | ○ |
| C-44 | RequestShutdown()がfalseの場合にos.Exit(0)が呼ばれる | E-09 (行184-191) | △ |
| C-45 | RequestShutdown()がtrueの場合にos.Exit(0)が呼ばれない | E-09 (行184) | △ |
| C-46 | Stop/Shutdown時にStopPendingが2回送信される | E-09 (行168, 179) | ○ |
| C-47 | SERVICE_PRESHUTDOWN_INFO.PreshutdownTimeoutがuint32型 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-15: 空文字列サービス名の挙動はソースコード上に明示的なバリデーションがなく、Windows SCM（Service Control Manager）の実装に依存する。実際の挙動はWindows環境での実行テストが必要。
  - 候補：Windows SCMドキュメント / svc.Runの実装仕様 / Windows APIリファレンス
- C-44, C-45: os.Exit(0)の呼び出し確認はgoroutine内で1秒のスリープ後に実行されるため、通常の単体テストでは検証が困難。テスト手法としてはプロセス分離テストやモックが必要。
  - 候補：os.Exitのモック手法 / server.RequestShutdownのモック / テストヘルパー関数

## 5) リスクフラグ（レビュー観点）
- 1: pkg/windowsモジュールはWindows固有のビルドタグ（`//go:build windows`）があるため、Linux/macOS環境ではビルド・テスト実行ができない。CI/CD環境にWindows環境が必要。
- 1: `unsafe.Pointer`を使用したメモリ操作（QueryPreShutdownInfo行70、UpdatePreShutdownInfo行81）があり、メモリ安全性のリスクがある。
- 0: グローバル変数`thehandler`の使用により、テスト間の状態共有が発生する可能性がある。テスト実行順序に注意が必要。
- 1: os.Exit(0)の直接呼び出し（行189）があるため、テスト時にプロセスが終了するリスクがある。

## 6) レビュアーチェックリスト（最小）
- [ ] Windows環境でのビルド・テスト実行が可能な環境が確保されているか
- [ ] QueryPreShutdownInfoのバッファリサイズループが無限ループにならないことが確認されているか
- [ ] unsafe.Pointerの使用箇所でメモリ安全性が確保されているか
- [ ] os.Exit(0)のテスト方法が決定されているか（プロセス分離テスト等）
- [ ] グローバル変数thehandlerのテスト間干渉を防ぐ初期化手順が検討されているか
- [ ] server.RequestShutdown()のモック方法が決定されているか
- [ ] 空文字列サービス名の挙動がWindows環境で検証されているか
