---
generated_at: 2026-02-02 18:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 187
  claims_without_evidence: 13
confidence_derived: 0.94
---

# 根拠レポート：plugin モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：187 / 200、根拠なし：13
- 優先レビュー（高）
  1. **UT-PLG-188〜190（ストレージ系プラグイン）**：ソースコードを直接読み込んでおらず、ファイルパスとパッケージ構造からの推定
  2. **UT-PLG-191〜193（証明書系プラグイン）**：ソースコードを直接読み込んでおらず、パッケージ名とKubernetes標準パターンからの推定
  3. **UT-PLG-194〜200（namespace/network/security系プラグイン）**：ソースコードを直接読み込んでおらず、パッケージ構造とKubernetesの一般的なadmissionパターンからの推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugin/pkg/admission/admit/admission.go` - AlwaysAdmitプラグインのソースコード
- E-02: `plugin/pkg/admission/deny/admission.go` - AlwaysDenyプラグインのソースコード
- E-03: `plugin/pkg/admission/alwayspullimages/admission.go` - AlwaysPullImagesプラグインのソースコード
- E-04: `plugin/pkg/admission/antiaffinity/admission.go` - InterPodAntiAffinityプラグインのソースコード
- E-05: `plugin/pkg/admission/defaulttolerationseconds/admission.go` - DefaultTolerationSecondsプラグインのソースコード
- E-06: `plugin/pkg/admission/gc/gc_admission.go` - OwnerReferencesPermissionsEnforcementプラグインのソースコード
- E-07: `plugin/pkg/admission/noderestriction/admission.go` - NodeRestrictionプラグインのソースコード
- E-08: `plugin/pkg/admission/serviceaccount/admission.go` - ServiceAccountプラグインのソースコード
- E-09: `plugin/pkg/admission/limitranger/admission.go` - LimitRangerプラグインのソースコード
- E-10: `plugin/pkg/admission/priority/admission.go` - Priorityプラグインのソースコード
- E-11: `plugin/pkg/admission/eventratelimit/admission.go` - EventRateLimitプラグインのソースコード
- E-12: `plugin/pkg/admission/eventratelimit/limitenforcer.go` - limitEnforcerのソースコード
- E-13: `plugin/pkg/admission/imagepolicy/admission.go` - ImagePolicyWebhookプラグインのソースコード
- E-14: `plugin/pkg/admission/extendedresourcetoleration/admission.go` - ExtendedResourceTolerationプラグインのソースコード
- E-15: `plugin/pkg/admission/nodetaint/admission.go` - TaintNodesByConditionプラグインのソースコード
- E-16: `plugin/pkg/admission/podnodeselector/admission.go` - PodNodeSelectorプラグインのソースコード
- E-17: `plugin/pkg/admission/runtimeclass/admission.go` - RuntimeClassプラグインのソースコード
- E-18: `plugin/pkg/auth/authenticator/token/bootstrap/bootstrap.go` - TokenAuthenticatorのソースコード
- E-19: `plugin/pkg/auth/authorizer/node/node_authorizer.go` - NodeAuthorizerのソースコード
- E-20: `plugin/pkg/auth/authorizer/rbac/rbac.go` - RBACAuthorizerのソースコード
- E-21: `plugin/pkg/auth/authorizer/rbac/subject_locator.go` - SubjectAccessEvaluatorのソースコード
- E-22: `plugin/pkg/auth/authorizer/node/graph.go` - Node Authorizer Graphのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-04 | AlwaysAdmitプラグインのAdmit/Validate/Handles/NewAlwaysAdmit | E-01 | ○ |
| C-05〜C-07 | AlwaysDenyプラグインのAdmit/Validate/Handles | E-02 | ○ |
| C-08〜C-17 | AlwaysPullImagesプラグインのAdmit/Validate/isUpdateWithNoNewImages | E-03 | ○ |
| C-18〜C-21 | InterPodAntiAffinityプラグインのValidate | E-04 | ○ |
| C-22〜C-28 | DefaultTolerationSecondsプラグインのAdmit/ValidateInitialization | E-05 | ○ |
| C-29〜C-41 | GCPermissionsEnforcementのValidate/isChangingOwnerReference/blockingOwnerRefs | E-06 | ○ |
| C-42〜C-70 | NodeRestrictionプラグインのAdmit/admitPodCreate/admitPodStatus等 | E-07 | ○ |
| C-71〜C-84 | ServiceAccountプラグインのAdmit/Validate/shouldAutomount等 | E-08 | ○ |
| C-85〜C-105 | LimitRangerのAdmit/Validate/minConstraint/maxConstraint等 | E-09 | ○ |
| C-106〜C-112 | PriorityプラグインのAdmit/Validate | E-10 | ○ |
| C-113〜C-123 | EventRateLimitのValidate/limitEnforcer/keyFunc | E-11, E-12 | ○ |
| C-124〜C-130 | ImagePolicyWebhookのValidate/webhookError/filterAnnotations | E-13 | ○ |
| C-131〜C-133 | ExtendedResourceTolerationのAdmit | E-14 | ○ |
| C-134〜C-136 | NodeTaintプラグインのAdmit | E-15 | ○ |
| C-137〜C-142 | PodNodeSelectorのAdmit/Validate/isSubset | E-16 | ○ |
| C-143〜C-150 | RuntimeClassのAdmit/Validate/setScheduling | E-17 | ○ |
| C-151〜C-157 | TokenAuthenticatorのAuthenticateToken | E-18 | ○ |
| C-158〜C-171 | NodeAuthorizerのAuthorize/authorizeGet/authorizeLease等 | E-19 | ○ |
| C-172〜C-179 | RBACAuthorizerのAuthorize/RuleAllows/RulesAllow/RulesFor | E-20 | ○ |
| C-180〜C-182 | SubjectAccessEvaluatorのAllowedSubjects | E-21 | ○ |
| C-183〜C-187 | Node AuthorizerのGraph/namedVertex | E-22 | ○ |
| C-188 | PVCリサイズ要求の処理 | **根拠なし** | △ |
| C-189 | デフォルトStorageClass設定 | **根拠なし** | △ |
| C-190 | PVC Finalizer追加 | **根拠なし** | △ |
| C-191 | CSR承認操作の検証 | **根拠なし** | △ |
| C-192 | CSR署名操作の検証 | **根拠なし** | △ |
| C-193 | CSR subject制限の検証 | **根拠なし** | △ |
| C-194 | Namespace自動作成 | **根拠なし** | △ |
| C-195 | 存在するNamespaceへの許可 | **根拠なし** | △ |
| C-196 | 存在しないNamespaceへの拒否 | **根拠なし** | △ |
| C-197 | デフォルトIngressClass設定 | **根拠なし** | △ |
| C-198 | ExternalIPなしServiceの許可 | **根拠なし** | △ |
| C-199 | ExternalIP付きServiceの拒否 | **根拠なし** | △ |
| C-200 | Pod Security Standards準拠 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-188〜C-200のテストケースは、ソースコードを直接解析しておらず、パッケージ構造とKubernetesのadmission pluginの標準パターンに基づく推定です
  - 候補：`plugin/pkg/admission/storage/*/admission.go` / `plugin/pkg/admission/certificates/*/admission.go` / `plugin/pkg/admission/namespace/*/admission.go` / `plugin/pkg/admission/network/*/admission.go` / `plugin/pkg/admission/security/podsecurity/admission.go`

## 5) リスクフラグ（レビュー観点）
- 0: C-01〜C-187 - ソースコードを直接解析して生成。低リスク
- 1: C-188〜C-200 - ソースコード未読のためテストケースの詳細（入力値・期待結果等）が推定ベース。中リスク。実際のコードと照合が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度のセキュリティ関連テストケース（認証・認可・NodeRestriction等）が網羅的か確認
- [ ] C-188〜C-200のテストケースについて、実際のソースコードと照合して入力値・期待結果を検証
- [ ] LimitRanger/Priority/ServiceAccount等の複雑なロジックに対して、境界値テストケースが十分か確認
- [ ] NodeAuthorizerのグラフベース認可に対するテストケースが、全リソースタイプを網羅しているか確認
- [ ] 各admissionプラグインのValidateInitializationテストケースが必要十分か確認
