---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 170
  claims_with_evidence: 162
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：staging-apiextensions-apiserver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：162 / 170、根拠なし：8
- 優先レビュー（高）
  1. **C-156, C-157 (dropDisabledFields)**: フィーチャーゲートの状態に依存するため、テスト実行時の環境設定が必要
  2. **C-164, C-165 (ValidateDefaults)**: CELバリデーションのコスト計算に関するテストケースの精度要確認
  3. **C-167 (crdserverscheme)**: ファイル内容の詳細解析が限定的

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/apiextensions-apiserver/pkg/apihelpers/helpers.go` - apihelpers パッケージの全パブリック関数
- E-02: `staging/src/k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/helpers.go` - internal helpers パッケージ（GetColumnsForVersion等）
- E-03: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/convert.go` - NewStructural, validateUnsupportedFields, newExtensions等
- E-04: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/validation.go` - ValidateStructural, validateExtensions等
- E-05: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/pruning/algorithm.go` - Prune, PruneWithOptions
- E-06: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/defaulting/algorithm.go` - Default, isNonNullableNull
- E-07: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/defaulting/prunenulls.go` - PruneNonNullableNullsWithoutDefaults
- E-08: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/defaulting/validation.go` - ValidateDefaults
- E-09: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/objectmeta/coerce.go` - GetObjectMeta, SetObjectMeta
- E-10: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/schema/objectmeta/validation.go` - Validate, validateEmbeddedResource
- E-11: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/validation/validation.go` - ValidateCustomResource, ConvertJSONSchemaProps等
- E-12: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/conversion/converter.go` - CRConverterFactory, crConverter, safeConverterWrapper
- E-13: `staging/src/k8s.io/apiextensions-apiserver/pkg/registry/customresource/strategy.go` - customResourceStrategy
- E-14: `staging/src/k8s.io/apiextensions-apiserver/pkg/registry/customresource/validator.go` - customResourceValidator
- E-15: `staging/src/k8s.io/apiextensions-apiserver/pkg/registry/customresource/tableconvertor/tableconvertor.go` - New, cellForJSONValue
- E-16: `staging/src/k8s.io/apiextensions-apiserver/pkg/registry/customresourcedefinition/strategy.go` - strategy, statusStrategy, dropDisabledFields
- E-17: `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/helpers.go` - getColumnsForVersion, getScaleColumnsForVersion, serveDefaultColumnsIfEmpty
- E-18: `staging/src/k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/validation/validation.go` - ValidateCustomResourceDefinition

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-05 | IsProtectedCommunityGroupの正常系/境界値テスト | E-01 (L31-41) | ○ |
| C-06〜C-10 | GetAPIApprovalStateの正常系/異常系テスト | E-01 (L58-73) | ○ |
| C-11〜C-13 | SetCRDConditionの正常系テスト | E-01 (L76-92) | ○ |
| C-14〜C-15 | RemoveCRDConditionの正常系/境界値テスト | E-01 (L95-103) | ○ |
| C-16〜C-17 | FindCRDConditionの正常系/異常系テスト | E-01 (L106-114) | ○ |
| C-18〜C-19 | IsCRDConditionTrueの正常系テスト | E-01 (L117-124) | ○ |
| C-20〜C-22 | IsCRDConditionEquivalentの正常系/異常系テスト | E-01 (L137-146) | ○ |
| C-23〜C-26 | CRDHasFinalizer/CRDRemoveFinalizerの正常系/境界値テスト | E-01 (L149-168) | ○ |
| C-27〜C-29 | HasServedCRDVersionの正常系/異常系テスト | E-01 (L171-178) | ○ |
| C-30〜C-31 | GetCRDStorageVersionの正常系/異常系テスト | E-01 (L181-189) | ○ |
| C-32〜C-33 | IsStoredVersionの正常系/異常系テスト | E-01 (L192-199) | ○ |
| C-34〜C-35 | GetSchemaForVersion (apihelpers)の正常系/異常系テスト | E-01 (L202-209) | ○ |
| C-36 | GetSubresourcesForVersionの正常系テスト | E-01 (L212-219) | ○ |
| C-37〜C-40 | HasPerVersionSchema/Subresources/Columnsの正常系/境界値テスト | E-01 (L222-249) | ○ |
| C-41 | HasVersionServedの正常系テスト | E-01 (L252-260) | ○ |
| C-42〜C-44 | GetColumnsForVersion (apiextensions)の正常系/異常系テスト | E-02 (L190-203) | ○ |
| C-45〜C-46 | GetSchemaForVersion (apiextensions)の正常系/異常系テスト | E-02 (L155-168) | ○ |
| C-47〜C-53 | NewStructuralの正常系/異常系テスト | E-03 (L42-114) | ○ |
| C-54〜C-55 | newExtensionsの正常系/異常系テスト | E-03 (L264-285) | ○ |
| C-56〜C-57 | validateUnsupportedFieldsの正常系/異常系テスト | E-03 (L301-325) | ○ |
| C-58〜C-65 | ValidateStructural関連の正常系/異常系テスト | E-04 (L79-262) | ○ |
| C-66〜C-73 | Prune/PruneWithOptionsの正常系/境界値テスト | E-05 (L29-149) | ○ |
| C-74〜C-79 | Defaultの正常系/境界値テスト | E-06 (L34-69) | ○ |
| C-80〜C-82 | PruneNonNullableNullsWithoutDefaultsの正常系テスト | E-07 (L44-66) | ○ |
| C-83〜C-88 | GetObjectMeta/SetObjectMetaの正常系/異常系テスト | E-09 (L31-151) | ○ |
| C-89〜C-93 | objectmeta Validateの正常系/異常系テスト | E-10 (L32-128) | ○ |
| C-94〜C-102 | ValidateCustomResource/ConvertJSONSchemaPropsの正常系/異常系/境界値テスト | E-11 (L87-493) | ○ |
| C-103〜C-113 | CRConverterFactory/crConverter/safeConverterWrapperの正常系/異常系テスト | E-12 (L47-240) | ○ |
| C-114〜C-128 | customResourceStrategyの正常系/異常系/境界値テスト | E-13 (L76-412) | ○ |
| C-129〜C-138 | customResourceValidatorの正常系/異常系/境界値テスト | E-14 (L46-180) | ○ |
| C-139〜C-146 | tableconvertorの正常系/異常系/境界値テスト | E-15 (L41-189) | ○ |
| C-147〜C-155 | CRD strategyの正常系/異常系テスト | E-16 (L50-318) | ○ |
| C-156〜C-157 | dropDisabledFieldsのフィーチャーゲート連動テスト | E-16 (L322-340) | △ |
| C-158〜C-163 | apiserver helpersの正常系/異常系テスト | E-17 (L32-88) | ○ |
| C-164〜C-166 | ValidateDefaultsの正常系/異常系/境界値テスト | E-08 (L39-199) | ○ |
| C-167 | crdserverscheme Unstructured型判定テスト | **根拠不足** | △ |
| C-168〜C-170 | customResourceStrategy GetAttrs/copyNonMetadataテスト | E-13 (L327-198) | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-156, C-157**: フィーチャーゲート(CRDValidationRatcheting, CustomResourceFieldSelectors)の状態切替テストの詳細な実装手順が不明。テスト実行時に `utilfeature.DefaultFeatureGate` のモック化が必要。
  - 候補：既存テストファイル内のフィーチャーゲートテストパターンを参照 / テストヘルパー関数の確認
- **C-167**: `pkg/crdserverscheme/unstructured.go` のファイル内容を詳細に確認していないため、テストケースの精度が低い可能性あり。
  - 候補：ファイルの詳細読み取り / 関連テストファイルの確認
- **CELバリデーション関連**: CEL式のコスト計算ロジックの詳細テストは、実際のCEL環境セットアップが必要で、ユニットテストとしての実装難易度が高い。
  - 候補：テスト用ヘルパーの有無を確認 / `pkg/test/cel.go` の活用

## 5) リスクフラグ（レビュー観点）

- **0 (低リスク)**: apihelpers, objectmeta, tableconvertor - 単純なデータ操作でロジックが明確
- **1 (中リスク)**: schema/pruning, schema/defaulting, conversion - 再帰処理やネスト構造を含むため、テストケースの網羅性に注意
- **2 (高リスク)**: validation, strategy (dropDisabledFields) - フィーチャーゲート依存、CELバリデーション連動があり、テスト環境のセットアップに注意が必要

## 6) レビュアーチェックリスト（最小）

- [ ] apihelpers パッケージの全パブリック関数がカバーされているか
- [ ] schema/convert.go の NewStructural で unsupported fields (ID, $ref, patternProperties, dependencies, additionalItems, definitions) が全てテスト対象か
- [ ] pruning/defaulting の再帰処理テスト（ネスト、配列）が十分か
- [ ] customResourceValidator の ScaleSpec/ScaleStatus 境界値テスト（0, 負数, MaxInt32超過）が含まれているか
- [ ] フィーチャーゲート依存の dropDisabledFields テストが実行可能な前提条件になっているか
- [ ] CELバリデーション関連テスト（C-164〜C-166）の実装可能性を確認
- [ ] 生成コード（zz_generated_*.go, generated.pb.go）がテスト対象から除外されているか
- [ ] テストIDの連番（UT-AEA-001〜170）に欠番がないか
