---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 128
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：staging-cloud-provider 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：128 / 132、根拠なし：4
- 優先レビュー（高）
  1. **UT-CLP-030（GetNodeAddressesFromNodeIP 不正IP形式）**：nodeutil.ParseNodeIPAnnotationの内部パース挙動の詳細確認が必要
  2. **UT-CLP-047（AddOrUpdateLabelsOnNode API失敗時）**：RetryOnConflict内部のエラーハンドリングの確認が必要
  3. **UT-CLP-095（ChooseZonesForVolume 決定性）**：ハッシュベース選択の具体的な期待値は実行時依存
  4. **UT-CLP-132（NewWebhookServingOptions ProviderDefaults上書き）**：net.IPポインタ操作の挙動確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/cloud-provider/cloud.go` - DefaultLoadBalancerName関数（L89-98）、GetInstanceProviderID関数（L103-120）、エラー変数定義（L258-263）
- E-02: `staging/src/k8s.io/cloud-provider/plugins.go` - RegisterCloudProvider（L44-52）、IsCloudProvider（L56-61）、GetCloudProvider（L68-76）、IsExternal（L79-81）、ErrorForDisabledProvider（L94-96）、InitCloudProvider（L99-136）
- E-03: `staging/src/k8s.io/cloud-provider/api/retry_error.go` - RetryError構造体と各メソッド（L25-46）
- E-04: `staging/src/k8s.io/cloud-provider/node/helpers/address.go` - AddToNodeAddresses（L29-42）、GetNodeAddressesFromNodeIP（L53-94）
- E-05: `staging/src/k8s.io/cloud-provider/node/helpers/taints.go` - addOrUpdateTaint（L121-146）、removeTaint（L217-231）、deleteTaint（L234-245）、taintExists（L206-213）、PatchNodeTaints（L91-117）、AddOrUpdateTaintOnNode（L51-88）、RemoveTaintOffNode（L152-203）
- E-06: `staging/src/k8s.io/cloud-provider/node/helpers/labels.go` - AddOrUpdateLabelsOnNode（L44-58）、addOrUpdateLabelsOnNode（L60-103）
- E-07: `staging/src/k8s.io/cloud-provider/service/helpers/helper.go` - IsAllowAll（L49-56）、GetLoadBalancerSourceRanges（L61-85）、GetServiceHealthCheckPathPort（L88-97）、RequestsOnlyLocalTraffic（L100-106）、NeedsHealthCheck（L109-114）、HasLBFinalizer（L117-124）、LoadBalancerStatusEqual（L127-129）、PatchService（L133-144）
- E-08: `staging/src/k8s.io/cloud-provider/volume/helpers/rounding.go` - RoundUpToGiB等の各関数（L55-165）
- E-09: `staging/src/k8s.io/cloud-provider/volume/helpers/zones.go` - LabelZonesToSet、ZonesSetToLabelValue、ZonesToSet、LabelZonesToList、SelectZoneForVolume、SelectZonesForVolume、ZonesFromAllowedTopologies、ChooseZonesForVolume等（L33-313）
- E-10: `staging/src/k8s.io/cloud-provider/volume/errors/errors.go` - エラー型と判定関数（L25-77）
- E-11: `staging/src/k8s.io/cloud-provider/names/controller_names.go` - コントローラー名定数、CCMControllerAliases関数（L49-69）
- E-12: `staging/src/k8s.io/cloud-provider/options/cloudprovider.go` - CloudProviderOptions ApplyTo/Validate（L30-54）
- E-13: `staging/src/k8s.io/cloud-provider/options/kubecloudshared.go` - KubeCloudSharedOptions ApplyTo/Validate（L76-110）
- E-14: `staging/src/k8s.io/cloud-provider/options/nodecontroller.go` - NodeControllerOptions ApplyTo/Validate（L42-62）
- E-15: `staging/src/k8s.io/cloud-provider/options/servicecontroller.go` - ServiceControllerOptions ApplyTo（L39-47）
- E-16: `staging/src/k8s.io/cloud-provider/options/webhook.go` - WebhookOptions Validate（L56-73）、WebhookServingOptions Validate（L141-152）、NewWebhookServingOptions（L89-117）
- E-17: `staging/src/k8s.io/cloud-provider/options/options.go` - NewCloudControllerManagerOptions（L88-130）、Validate（L251-276）、NewDefaultComponentConfig（L133-143）
- E-18: `staging/src/k8s.io/cloud-provider/config/v1alpha1/defaults.go` - SetDefaults_CloudControllerManagerConfiguration（L34-55）、SetDefaults_KubeCloudSharedConfiguration（L57-71）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DefaultLoadBalancerName: "a"+UID、ハイフン除去 | E-01 | ○ |
| C-02 | DefaultLoadBalancerName: 32文字切り詰め | E-01 | ○ |
| C-03 | DefaultLoadBalancerName: 空UID時の挙動 | E-01 | ○ |
| C-04 | DefaultLoadBalancerName: ハイフン除去確認 | E-01 | ○ |
| C-05 | GetInstanceProviderID: providerName://instanceID形式 | E-01 | ○ |
| C-06 | GetInstanceProviderID: Instances非サポート時エラー | E-01 | ○ |
| C-07 | GetInstanceProviderID: InstanceNotFoundそのまま返却 | E-01 | ○ |
| C-08 | GetInstanceProviderID: NotImplementedそのまま返却 | E-01 | ○ |
| C-09 | RegisterCloudProvider: 新規プロバイダー登録 | E-02 | ○ |
| C-10 | IsCloudProvider: 登録済みでtrue | E-02 | ○ |
| C-11 | IsCloudProvider: 未登録でfalse | E-02 | ○ |
| C-12 | GetCloudProvider: 登録済みインスタンス返却 | E-02 | ○ |
| C-13 | GetCloudProvider: 未登録でnil,nil | E-02 | ○ |
| C-14 | IsExternal: "external"でtrue | E-02 | ○ |
| C-15 | IsExternal: 他名でfalse | E-02 | ○ |
| C-16 | ErrorForDisabledProvider: エラーメッセージ生成 | E-02 | ○ |
| C-17 | InitCloudProvider: 空名でnil,nil | E-02 | ○ |
| C-18 | InitCloudProvider: externalでnil,nil | E-02 | ○ |
| C-19 | InitCloudProvider: 未登録プロバイダーでエラー | E-02 | ○ |
| C-20 | NewRetryError: 正しく生成 | E-03 | ○ |
| C-21 | RetryError.Error(): メッセージ返却 | E-03 | ○ |
| C-22 | RetryError.RetryAfter(): Duration返却 | E-03 | ○ |
| C-23 | RetryError.RetryAfter(): 0s境界値 | E-03 | ○ |
| C-24 | AddToNodeAddresses: 新規追加 | E-04 | ○ |
| C-25 | AddToNodeAddresses: 重複排除 | E-04 | ○ |
| C-26 | AddToNodeAddresses: Type違い同一IP追加 | E-04 | ○ |
| C-27 | AddToNodeAddresses: 空追加リスト | E-04 | ○ |
| C-28 | GetNodeAddressesFromNodeIP: マッチIPフィルタリング | E-04 | ○ |
| C-29 | GetNodeAddressesFromNodeIP: 不一致IPエラー | E-04 | ○ |
| C-30 | GetNodeAddressesFromNodeIP: 不正IP形式エラー | E-04 | △ |
| C-31 | addOrUpdateTaint: 新規追加 | E-05 | ○ |
| C-32 | addOrUpdateTaint: 既存更新 | E-05 | ○ |
| C-33 | addOrUpdateTaint: 同一Taintスキップ | E-05 | ○ |
| C-34 | removeTaint: 削除 | E-05 | ○ |
| C-35 | removeTaint: 存在しないTaint | E-05 | ○ |
| C-36 | removeTaint: 空Taintsリスト | E-05 | ○ |
| C-37 | deleteTaint: 一致Taint削除 | E-05 | ○ |
| C-38 | taintExists: 存在true | E-05 | ○ |
| C-39 | taintExists: 不存在false | E-05 | ○ |
| C-40 | PatchNodeTaints: パッチ実行 | E-05 | ○ |
| C-41 | AddOrUpdateTaintOnNode: Taint追加 | E-05 | ○ |
| C-42 | AddOrUpdateTaintOnNode: 空Taintsリスト | E-05 | ○ |
| C-43 | RemoveTaintOffNode: Taint削除 | E-05 | ○ |
| C-44 | RemoveTaintOffNode: 空Taintsリスト | E-05 | ○ |
| C-45 | RemoveTaintOffNode: ショートサーキット | E-05 | ○ |
| C-46 | AddOrUpdateLabelsOnNode: ラベル追加 | E-06 | ○ |
| C-47 | AddOrUpdateLabelsOnNode: API失敗時false | E-06 | △ |
| C-48 | IsAllowAll: 0.0.0.0/0含むtrue | E-07 | ○ |
| C-49 | IsAllowAll: 0.0.0.0/0含まないfalse | E-07 | ○ |
| C-50 | GetLoadBalancerSourceRanges: Spec経由取得 | E-07 | ○ |
| C-51 | GetLoadBalancerSourceRanges: Annotation経由取得 | E-07 | ○ |
| C-52 | GetLoadBalancerSourceRanges: デフォルト値 | E-07 | ○ |
| C-53 | GetLoadBalancerSourceRanges: 不正CIDRエラー | E-07 | ○ |
| C-54 | GetServiceHealthCheckPathPort: path,port返却 | E-07 | ○ |
| C-55 | GetServiceHealthCheckPathPort: 不要時空値 | E-07 | ○ |
| C-56 | GetServiceHealthCheckPathPort: Port=0空値 | E-07 | ○ |
| C-57 | RequestsOnlyLocalTraffic: LB+Local true | E-07 | ○ |
| C-58 | RequestsOnlyLocalTraffic: ClusterIP false | E-07 | ○ |
| C-59 | NeedsHealthCheck: LB+Local true | E-07 | ○ |
| C-60 | NeedsHealthCheck: 非LB false | E-07 | ○ |
| C-61 | HasLBFinalizer: 存在true | E-07 | ○ |
| C-62 | HasLBFinalizer: 不存在false | E-07 | ○ |
| C-63 | LoadBalancerStatusEqual: 同一true | E-07 | ○ |
| C-64 | LoadBalancerStatusEqual: 異なるfalse | E-07 | ○ |
| C-65 | PatchService: Statusパッチ | E-07 | ○ |
| C-66 | PatchService: Spec変更無視 | E-07 | ○ |
| C-67 | RoundUpToGiB: 切り上げ | E-08 | ○ |
| C-68 | RoundUpToGiB: 境界値1GiB | E-08 | ○ |
| C-69 | RoundUpToGiB: 1GiB+1切り上げ | E-08 | ○ |
| C-70 | RoundUpToGiB: オーバーフロー | E-08 | ○ |
| C-71 | RoundUpToMB: 切り上げ | E-08 | ○ |
| C-72 | RoundUpToMiB: 切り上げ | E-08 | ○ |
| C-73 | RoundUpToKB: 切り上げ | E-08 | ○ |
| C-74 | RoundUpToKiB: 切り上げ | E-08 | ○ |
| C-75 | RoundUpToB: バイト単位 | E-08 | ○ |
| C-76 | RoundUpToGiBInt: int型変換 | E-08 | ○ |
| C-77 | RoundUpToGiBInt32: int32型変換 | E-08 | ○ |
| C-78 | RoundUpToGiBInt32: int32オーバーフロー | E-08 | ○ |
| C-79 | LabelZonesToSet: Set変換 | E-09 | ○ |
| C-80 | LabelZonesToSet: 空ゾーンエラー | E-09 | ○ |
| C-81 | ZonesSetToLabelValue: ラベル変換 | E-09 | ○ |
| C-82 | ZonesToSet: カンマ区切り変換 | E-09 | ○ |
| C-83 | ZonesToSet: 空要素エラー | E-09 | ○ |
| C-84 | LabelZonesToList: List変換 | E-09 | ○ |
| C-85 | SelectZoneForVolume: ゾーン選択 | E-09 | ○ |
| C-86 | SelectZoneForVolume: パラメータ競合エラー | E-09 | ○ |
| C-87 | SelectZonesForVolume: ノードゾーン選択 | E-09 | ○ |
| C-88 | SelectZonesForVolume: VolumeScheduling制約エラー | E-09 | ○ |
| C-89 | SelectZonesForVolume: ゾーン未検出エラー | E-09 | ○ |
| C-90 | ZonesFromAllowedTopologies: ゾーン抽出 | E-09 | ○ |
| C-91 | ZonesFromAllowedTopologies: 未サポートキーエラー | E-09 | ○ |
| C-92 | ZonesFromAllowedTopologies: 空トポロジ | E-09 | ○ |
| C-93 | ChooseZonesForVolume: マルチゾーン選択 | E-09 | ○ |
| C-94 | ChooseZonesForVolume: 空ゾーンセット | E-09 | ○ |
| C-95 | ChooseZonesForVolume: ハッシュ決定性 | E-09 | △ |
| C-96 | NewDeletedVolumeInUseError: エラー生成 | E-10 | ○ |
| C-97 | IsDeletedVolumeInUse: true判定 | E-10 | ○ |
| C-98 | IsDeletedVolumeInUse: false判定 | E-10 | ○ |
| C-99 | NewDanglingError: エラー生成 | E-10 | ○ |
| C-100 | IsDanglingError: true判定 | E-10 | ○ |
| C-101 | IsDanglingError: false判定 | E-10 | ○ |
| C-102 | CCMControllerAliases: エイリアス返却 | E-11 | ○ |
| C-103 | CCMControllerAliases: イミュータビリティ | E-11 | ○ |
| C-104 | CloudProviderOptions.ApplyTo: 設定反映 | E-12 | ○ |
| C-105 | CloudProviderOptions.ApplyTo: nilレシーバー | E-12 | ○ |
| C-106 | KubeCloudSharedOptions.ApplyTo: 設定反映 | E-13 | ○ |
| C-107 | KubeCloudSharedOptions.Validate: 正常系 | E-13 | ○ |
| C-108 | NodeControllerOptions.ApplyTo: 設定反映 | E-14 | ○ |
| C-109 | NodeControllerOptions.Validate: 正常系 | E-14 | ○ |
| C-110 | NodeControllerOptions.Validate: 0以下エラー | E-14 | ○ |
| C-111 | ServiceControllerOptions.ApplyTo: 設定反映 | E-15 | ○ |
| C-112 | WebhookOptions.Validate: 有効名 | E-16 | ○ |
| C-113 | WebhookOptions.Validate: 不明名エラー | E-16 | ○ |
| C-114 | WebhookServingOptions.Validate: 有効ポート | E-16 | ○ |
| C-115 | WebhookServingOptions.Validate: 範囲外エラー | E-16 | ○ |
| C-116 | WebhookServingOptions.Validate: ポート0 | E-16 | ○ |
| C-117 | WebhookServingOptions.Validate: ポート65535 | E-16 | ○ |
| C-118 | WebhookServingOptions.Validate: ポート65536エラー | E-16 | ○ |
| C-119 | NewCloudControllerManagerOptions: デフォルト生成 | E-17 | ○ |
| C-120 | NewDefaultComponentConfig: デフォルト設定 | E-17 | ○ |
| C-121 | CCMOptions.Validate: CloudProvider名空エラー | E-17 | ○ |
| C-122 | CCMOptions.Validate: ポート重複エラー | E-17 | ○ |
| C-123 | SetDefaults_CCM: NodeStatusUpdateFrequency=5m | E-18 | ○ |
| C-124 | SetDefaults_CCM: QPS=20 | E-18 | ○ |
| C-125 | SetDefaults_CCM: Burst=30 | E-18 | ○ |
| C-126 | SetDefaults_KubeCloudShared: NodeMonitorPeriod=5s | E-18 | ○ |
| C-127 | SetDefaults_KubeCloudShared: ClusterName=kubernetes | E-18 | ○ |
| C-128 | SetDefaults_KubeCloudShared: ConfigureCloudRoutes=true | E-18 | ○ |
| C-129 | SetDefaults_KubeCloudShared: RouteReconciliationPeriod=10s | E-18 | ○ |
| C-130 | NewWebhookServingOptions: デフォルトアドレス0.0.0.0 | E-16 | ○ |
| C-131 | NewWebhookServingOptions: デフォルトポート10260 | E-16 | ○ |
| C-132 | NewWebhookServingOptions: ProviderDefaults上書き | E-16 | △ |

## 4) 不足情報（Unknown / Missing）
- C-30: `GetNodeAddressesFromNodeIP`に不正IP形式を渡した場合の挙動は`nodeutil.ParseNodeIPAnnotation`の内部実装に依存する。cloud-providerモジュール外の`k8s.io/component-helpers/node/util/`パッケージの挙動確認が必要。
  - 候補：`staging/src/k8s.io/component-helpers/node/util/` / 既存テストコード `address_test.go`
- C-47: `AddOrUpdateLabelsOnNode`のAPI失敗時の挙動はmockクライアントの設定に依存。`utilruntime.HandleError`の呼び出し確認が必要。
  - 候補：`k8s.io/apimachinery/pkg/util/runtime` の HandleError仕様
- C-95: `ChooseZonesForVolume`のハッシュベース選択の決定性テストは、具体的なハッシュ値が実行時依存のため、期待結果は抽象的記述にとどまる。
  - 候補：既存テストファイル `zones_test.go` の具体的なテストケースを参照
- C-132: `NewWebhookServingOptions`のProviderDefaults上書きテストは、`*net.IP`ポインタの挙動に依存。
  - 候補：Goの`net.IP`型のポインタ操作仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接読み取れるテストケースが大半
- 1: 中リスク - node/helpers/taints.goのAPIサーバー連携テスト（UT-CLP-040〜045）はmockクライアント設定の正確性に依存
- 1: 中リスク - volume/helpers/zones.goのSelectZonesForVolume系テスト（UT-CLP-085〜089）は複雑な条件分岐があり、網羅性の確認が推奨される
- 0: 低リスク - options系のバリデーションテスト（UT-CLP-104〜132）はシンプルな値の比較が中心

## 6) レビュアーチェックリスト（最小）
- [ ] node/helpers/address.goのGetNodeAddressesFromNodeIPテストケースで、デュアルスタック（IPv4+IPv6）シナリオがカバーされているか確認
- [ ] volume/helpers/zones.goのSelectZonesForVolume系テストケースで、allowedTopologiesとnode/zones/zonesWithNodesの全組み合わせが網羅されているか確認
- [ ] options/options.goのValidateテストケースで、全サブコンポーネントのバリデーション連鎖が確認されているか確認
- [ ] node/helpers/taints.goのAddOrUpdateTaintOnNode/RemoveTaintOffNodeテストで、RetryOnConflictのリトライ挙動がテストされているか確認
- [ ] controllers/配下のコントローラー（route, nodelifecycle, node, service）は統合テスト向けであり、本一覧の対象外であることを確認
