---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 68
  claims_with_evidence: 65
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：staging-cluster-bootstrap 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：65 / 68、根拠なし：3
- 優先レビュー（高）
  1. **UT-CLB-004**：空のtokenSecretでComputeDetachedSignatureがエラーを返すかはgo-joseライブラリの挙動に依存し、ソースコードからは断定できない
  2. **UT-CLB-007**：stripContentに空文字列を渡した場合の挙動はstrings.Splitの結果が1要素となるためエラーだが、直接テストされていない
  3. **UT-CLB-014**：TokenFromIDAndSecretに空文字列を渡した場合の結果は自明だが、ドキュメントに明示的な仕様記述がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/cluster-bootstrap/token/jws/jws.go` - JWS署名の計算・検証ロジック（ComputeDetachedSignature, stripContent, DetachedTokenIsValid）
- E-02: `staging/src/k8s.io/cluster-bootstrap/token/util/helpers.go` - ブートストラップトークンの生成・検証ユーティリティ（GenerateBootstrapToken, IsValidBootstrapToken, IsValidBootstrapTokenID, TokenFromIDAndSecret, BootstrapTokenSecretName, ValidateBootstrapGroupName, ValidateUsages）
- E-03: `staging/src/k8s.io/cluster-bootstrap/token/api/types.go` - 定数定義（BootstrapTokenSecretPrefix, BootstrapTokenPattern, BootstrapTokenIDPattern, BootstrapGroupPattern, KnownTokenUsages, BootstrapTokenIDBytes, BootstrapTokenSecretBytes）
- E-04: `staging/src/k8s.io/cluster-bootstrap/util/secrets/secrets.go` - Secretデータ操作（GetData, HasExpired, GetExpiration, ParseName, GetGroups）
- E-05: `staging/src/k8s.io/cluster-bootstrap/util/tokens/tokens.go` - トークンパース（ParseToken）
- E-06: `staging/src/k8s.io/cluster-bootstrap/token/jws/jws_test.go` - 既存JWSテスト
- E-07: `staging/src/k8s.io/cluster-bootstrap/token/util/helpers_test.go` - 既存helpersテスト
- E-08: `staging/src/k8s.io/cluster-bootstrap/util/secrets/secrets_test.go` - 既存secretsテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ComputeDetachedSignature: 有効入力で署名生成 | E-01, E-06 | ○ |
| C-02 | ComputeDetachedSignature: detached形式の出力 | E-01（stripContent呼び出し） | ○ |
| C-03 | ComputeDetachedSignature: 同一入力で同一署名 | E-01（HMAC-SHA256は決定論的） | ○ |
| C-04 | ComputeDetachedSignature: 空tokenSecretでエラー | E-01 | △ |
| C-05 | stripContent: 3パートJWSからcontent除去 | E-01（L66-73） | ○ |
| C-06 | stripContent: 3パート未満でエラー | E-01（L68-69） | ○ |
| C-07 | stripContent: 空文字列でエラー | E-01 | △ |
| C-08 | DetachedTokenIsValid: 正しい署名でtrue | E-01（L76-82）, E-06 | ○ |
| C-09 | DetachedTokenIsValid: 不正署名でfalse | E-01（L76-82） | ○ |
| C-10 | DetachedTokenIsValid: content不一致でfalse | E-01（L76-82） | ○ |
| C-11 | GenerateBootstrapToken: 有効なトークン生成 | E-02（L45-57）, E-07 | ○ |
| C-12 | GenerateBootstrapToken: 生成トークンの妥当性 | E-02（L45-57, L90-117） | ○ |
| C-13 | TokenFromIDAndSecret: 正しい結合 | E-02（L83-85） | ○ |
| C-14 | TokenFromIDAndSecret: 空文字列結合 | E-02（L84） | △ |
| C-15 | IsValidBootstrapToken: 有効トークンでtrue | E-02（L90-117）, E-07 | ○ |
| C-16 | IsValidBootstrapToken: ドットなしでfalse | E-02（L92-95） | ○ |
| C-17 | IsValidBootstrapToken: 短いIDでfalse | E-02（L99-101） | ○ |
| C-18 | IsValidBootstrapToken: 短いSecretでfalse | E-02（L105-106） | ○ |
| C-19 | IsValidBootstrapToken: 大文字IDでfalse | E-02（L99, E-03 BootstrapTokenIDPattern） | ○ |
| C-20 | IsValidBootstrapToken: 大文字Secretでfalse | E-02（L108-114） | ○ |
| C-21 | IsValidBootstrapToken: 特殊文字Secretでfalse | E-02（L108-114） | ○ |
| C-22 | IsValidBootstrapToken: 空文字列でfalse | E-02（L92-95） | ○ |
| C-23 | IsValidBootstrapToken: 複数ドットでfalse | E-02（L105-106） | ○ |
| C-24 | IsValidBootstrapTokenID: 有効IDでtrue | E-02（L121-123）, E-03 | ○ |
| C-25 | IsValidBootstrapTokenID: 短いIDでfalse | E-02（L122）, E-03 BootstrapTokenIDPattern | ○ |
| C-26 | IsValidBootstrapTokenID: 長いIDでfalse | E-02（L122）, E-03 | ○ |
| C-27 | IsValidBootstrapTokenID: 不正文字でfalse | E-02（L122）, E-03 | ○ |
| C-28 | IsValidBootstrapTokenID: 空文字列でfalse | E-02（L122）, E-03 | ○ |
| C-29 | BootstrapTokenSecretName: 正しいSecret名 | E-02（L127-129）, E-03 | ○ |
| C-30 | BootstrapTokenSecretName: 空文字列 | E-02（L128） | ○ |
| C-31 | ValidateBootstrapGroupName: 有効グループ名でnil | E-02（L134-139）, E-03 BootstrapGroupPattern | ○ |
| C-32 | ValidateBootstrapGroupName: 不正プレフィックスでエラー | E-02（L135-138）, E-03 | ○ |
| C-33 | ValidateBootstrapGroupName: 大文字でエラー | E-02（L135）, E-03 BootstrapGroupPattern | ○ |
| C-34 | ValidateBootstrapGroupName: 空サフィックスでエラー | E-02（L135）, E-03 BootstrapGroupPattern（末尾[a-z0-9]必須） | ○ |
| C-35 | ValidateBootstrapGroupName: 1文字サフィックスでnil | E-02（L135）, E-03 BootstrapGroupPattern | ○ |
| C-36 | ValidateUsages: 有効usageでnil | E-02（L142-154）, E-03 KnownTokenUsages | ○ |
| C-37 | ValidateUsages: signingのみでnil | E-02（L142-154）, E-03 | ○ |
| C-38 | ValidateUsages: authenticationのみでnil | E-02（L142-154）, E-03 | ○ |
| C-39 | ValidateUsages: 不正usageでエラー | E-02（L146-151） | ○ |
| C-40 | ValidateUsages: 混在usageでエラー | E-02（L146-151） | ○ |
| C-41 | ValidateUsages: 空スライスでnil | E-02（L150: len(invalidUsages)==0） | ○ |
| C-42 | GetData: 存在キーの値返却 | E-04（L37-45）, E-08 | ○ |
| C-43 | GetData: 存在しないキーで空文字列 | E-04（L41-43） | ○ |
| C-44 | GetData: nilデータで空文字列 | E-04（L38-40） | ○ |
| C-45 | HasExpired: 有効期限内でfalse | E-04（L48-51）, E-08 | ○ |
| C-46 | HasExpired: 有効期限切れでtrue | E-04（L48-51）, E-08 | ○ |
| C-47 | HasExpired: expiration未設定でfalse | E-04（L61-63） | ○ |
| C-48 | GetExpiration: 有効期限内で残り時間正 | E-04（L59-78） | ○ |
| C-49 | GetExpiration: 期限切れで0, true | E-04（L71-76） | ○ |
| C-50 | GetExpiration: 空expirationで0, false | E-04（L61-63） | ○ |
| C-51 | GetExpiration: パース不可でtrue | E-04（L65-68） | ○ |
| C-52 | GetExpiration: 同一時刻で期限切れ | E-04（L72: timeRemaining<=0） | ○ |
| C-53 | ParseName: 有効Secret名からID抽出 | E-04（L81-87）, E-08 | ○ |
| C-54 | ParseName: 不正プレフィックスでfalse | E-04（L82-84） | ○ |
| C-55 | ParseName: 不正長IDでfalse | E-04（L32, L82-84） | ○ |
| C-56 | ParseName: 不正文字IDでfalse | E-04（L32） | ○ |
| C-57 | ParseName: 空文字列でfalse | E-04（L82-84） | ○ |
| C-58 | GetGroups: デフォルトグループのみ | E-04（L92-100） | ○ |
| C-59 | GetGroups: 追加グループ含む | E-04（L103-108） | ○ |
| C-60 | GetGroups: 複数グループカンマ区切り | E-04（L103） | ○ |
| C-61 | GetGroups: 不正グループ名でエラー | E-04（L104-106） | ○ |
| C-62 | GetGroups: 重複排除 | E-04（L94: sets.NewString使用） | ○ |
| C-63 | ParseToken: 有効トークンからID・Secret抽出 | E-05（L32-37） | ○ |
| C-64 | ParseToken: 不正形式でエラー | E-05（L34-36） | ○ |
| C-65 | ParseToken: 短いIDでエラー | E-05（L33-36, E-03 BootstrapTokenPattern） | ○ |
| C-66 | ParseToken: 短いSecretでエラー | E-05（L33-36, E-03） | ○ |
| C-67 | ParseToken: 空文字列でエラー | E-05（L33-36） | ○ |
| C-68 | ParseToken: 大文字でエラー | E-05（L33）, E-03 BootstrapTokenPattern | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CLB-004（C-04）**: ComputeDetachedSignatureに空のtokenSecretを渡した場合の挙動は、go-joseライブラリ（gopkg.in/go-jose/go-jose.v2）の内部実装に依存する。ソースコード上ではNewSignerまたはSign時にエラーになる可能性が高いが、ライブラリのドキュメントで確認が必要。
  - 候補：go-joseライブラリのドキュメント / go-joseのソースコード / 実行テスト
- **UT-CLB-007（C-07）**: stripContentに空文字列を渡した場合、strings.Split("", ".")は[""]を返し、len(parts)==1となるためエラーとなる。この推論はGoの標準ライブラリの仕様に基づくが、直接的なテストコードは存在しない。
  - 候補：Go標準ライブラリドキュメント / 実行テスト
- **UT-CLB-014（C-14）**: TokenFromIDAndSecretに空文字列を渡した場合、fmt.Sprintf("%s.%s", "", "")は"."を返す。これはGoの仕様から自明だが、関数の意図された使い方ではない。
  - 候補：関数の仕様ドキュメント / 開発者への確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの条件分岐・正規表現パターンに直接対応しており、信頼性が高い
- 1: 中リスク - JWS関連のテストケース（UT-CLB-001〜010）は外部ライブラリ（go-jose）に依存するため、ライブラリのバージョン変更により挙動が変わる可能性がある
- 0: 低リスク - トークン検証・Secret操作のテストケースは純粋な文字列操作と正規表現マッチングに基づいており、安定している

## 6) レビュアーチェックリスト（最小）
- [ ] JWS署名テスト（UT-CLB-001〜010）がgo-joseライブラリの現行バージョンと整合しているか確認
- [ ] IsValidBootstrapTokenの定数時間比較ロジックが全ての異常系パターンで正しくfalseを返すか確認
- [ ] GetExpirationの境界値テスト（UT-CLB-052）でtime.RFC3339のパース精度を考慮しているか確認
- [ ] ValidateBootstrapGroupNameの正規表現パターンがBootstrapGroupPatternと一致しているか確認
- [ ] 根拠なし（△）の3件（UT-CLB-004, UT-CLB-007, UT-CLB-014）について実際の動作テストで検証
