---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 165
  claims_with_evidence: 162
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：staging-code-generator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 165、根拠なし：3
- 優先レビュー（高）
  1. **C-038 (ToGroupVersionInfo)**: GroupVersionsとgroupGoNamesの組み合わせテストの具体的入力値が不十分
  2. **C-040 (ToGroupInstallPackages)**: defaultVersionの内部呼び出しを含む統合的な動作の検証が必要
  3. **C-100 (findReachableTypes循環参照)**: 循環参照のテストは実際のgengoのtypes構造に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/code-generator/pkg/namer/tag-override.go` - TagOverrideNamer, extractTag
- E-02: `staging/src/k8s.io/code-generator/pkg/util/plural_exceptions.go` - PluralExceptionListToMapOrDie
- E-03: `staging/src/k8s.io/code-generator/pkg/util/comments.go` - ExtractCommentTagsWithoutArguments
- E-04: `staging/src/k8s.io/code-generator/cmd/client-gen/types/types.go` - Version, Group, GroupVersion型定義
- E-05: `staging/src/k8s.io/code-generator/cmd/client-gen/types/helpers.go` - ToGroupVersion, sortableSliceOfVersions, ToGroupVersionInfo, ToGroupInstallPackages
- E-06: `staging/src/k8s.io/code-generator/cmd/client-gen/generators/util/tags.go` - Tags, ParseClientGenTags, parseClientExtensions, extension, validateClientGenTags
- E-07: `staging/src/k8s.io/code-generator/cmd/client-gen/generators/util/gvpackages.go` - ParsePathGroupVersion
- E-08: `staging/src/k8s.io/code-generator/cmd/client-gen/args/gvtype.go` - parseGroupVersionType, gvTypeValue
- E-09: `staging/src/k8s.io/code-generator/cmd/client-gen/args/gvpackages.go` - readAsCSV, writeAsCSV, groupVersionsBuilder
- E-10: `staging/src/k8s.io/code-generator/cmd/applyconfiguration-gen/generators/jsontagutil.go` - JSONTags, lookupJSONTags, parseTag, tagOptions
- E-11: `staging/src/k8s.io/code-generator/cmd/applyconfiguration-gen/generators/refgraph.go` - refGraph, applyConfigForType, isApplyConfig, requiresApplyConfiguration, findReachableTypes
- E-12: `staging/src/k8s.io/code-generator/cmd/applyconfiguration-gen/args/externaltypes.go` - parseExternalMapping, externalApplyConfigurationValue
- E-13: `staging/src/k8s.io/code-generator/cmd/go-to-protobuf/protobuf/namer.go` - localNamer, protobufNamer, protoSafePackage, isTypeApplicableToProtobuf, assignGoTypeToProtoPackage
- E-14: `staging/src/k8s.io/code-generator/cmd/go-to-protobuf/protobuf/import_tracker.go` - ImportTracker, NewImportTracker, AddNullable
- E-15: `staging/src/k8s.io/code-generator/cmd/go-to-protobuf/protobuf/tags.go` - extractBoolTagOrDie
- E-16: `staging/src/k8s.io/code-generator/cmd/validation-gen/lint.go` - linter, lintType, lintComments, conflictingTagsRule, newLinter, AddError
- E-17: `staging/src/k8s.io/code-generator/cmd/validation-gen/lint_rules.go` - ruleOptionalAndRequired, ruleRequiredAndDefault, defaultLintRules
- E-18: `staging/src/k8s.io/code-generator/cmd/validation-gen/util/util.go` - GetMemberByJSON, IsNilableType, NativeType, NonPointer, IsDirectComparable
- E-19: `staging/src/k8s.io/code-generator/cmd/validation-gen/validators/common.go` - rootTypeString
- E-20: `staging/src/k8s.io/code-generator/cmd/applyconfiguration-gen/generators/openapi.go` - newTypeModels, toValidatedModels, findReferenced
- E-21: `staging/src/k8s.io/code-generator/cmd/applyconfiguration-gen/generators/types.go` - 型参照定義（rawExtension, unknown等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | TagOverrideNamer.Nameでタグ値が返却される | E-01 | ○ |
| C-002 | タグ不在時にfallbackが使用される | E-01 | ○ |
| C-003 | NewTagOverrideNamerがNamerを返す | E-01 | ○ |
| C-004 | extractTagでタグ値が抽出される | E-01 | ○ |
| C-005 | extractTagでタグ不在時に空文字 | E-01 | ○ |
| C-006 | extractTagで空行リスト時に空文字 | E-01 | ○ |
| C-007 | PluralExceptionListToMapOrDieの正常変換 | E-02 | ○ |
| C-008 | PluralExceptionListToMapOrDieで不正形式panic | E-02 | ○ |
| C-009 | PluralExceptionListToMapOrDieで空スライス | E-02 | ○ |
| C-010 | PluralExceptionListToMapOrDieでコロン複数panic | E-02 | ○ |
| C-011 | ExtractCommentTagsWithoutArgumentsの基本動作 | E-03 | ○ |
| C-012 | 引数付きタグでエラー | E-03 | ○ |
| C-013 | 空引数形式の処理 | E-03 | ○ |
| C-014 | 空行リストで空マップ | E-03 | ○ |
| C-015 | Version.Stringの動作 | E-04 | ○ |
| C-016 | Version.NonEmptyの非空動作 | E-04 | ○ |
| C-017 | Version.NonEmptyの空時デフォルト | E-04 | ○ |
| C-018 | Version.PackageNameの小文字変換 | E-04 | ○ |
| C-019 | Version.PackageNameの空時動作 | E-04 | ○ |
| C-020 | Group.Stringの動作 | E-04 | ○ |
| C-021 | Group.NonEmptyの非空動作 | E-04 | ○ |
| C-022 | Group.NonEmptyの空時core返却 | E-04 | ○ |
| C-023 | Group.PackageNameのドット区切り | E-04 | ○ |
| C-024 | Group.PackageNameのinternal処理 | E-04 | ○ |
| C-025 | Group.PackageNameの空時core | E-04 | ○ |
| C-026 | ToAPIVersionのgroup/version形式 | E-04 | ○ |
| C-027 | ToAPIVersionの空Group時 | E-04 | ○ |
| C-028 | WithKindのGVK生成 | E-04 | ○ |
| C-029 | ToGroupVersionのgroup/version形式パース | E-05 | ○ |
| C-030 | ToGroupVersionのグループのみパース | E-05 | ○ |
| C-031 | ToGroupVersionの空文字列 | E-05 | ○ |
| C-032 | ToGroupVersionのスラッシュのみ | E-05 | ○ |
| C-033 | ToGroupVersionのスラッシュ複数エラー | E-05 | ○ |
| C-034 | sortableSliceOfVersionsの安定版>不安定版 | E-05 | ○ |
| C-035 | alpha < beta | E-05 | ○ |
| C-036 | メジャーバージョン比較 | E-05 | ○ |
| C-037 | 同一バージョンの比較 | E-05 | ○ |
| C-038 | ToGroupVersionInfoの変換 | E-05 | △ |
| C-039 | ToGroupVersionInfoの空入力 | E-05 | ○ |
| C-040 | ToGroupInstallPackagesの生成 | E-05 | △ |
| C-041 | Tags.HasVerbのSkipVerbs空時 | E-06 | ○ |
| C-042 | Tags.HasVerbのスキップverb | E-06 | ○ |
| C-043 | Tags.HasVerbの非スキップverb | E-06 | ○ |
| C-044 | ParseClientGenTagsの+genclientパース | E-06 | ○ |
| C-045 | nonNamespacedタグのパース | E-06 | ○ |
| C-046 | readonlyタグの処理 | E-06 | ○ |
| C-047 | skipVerbsタグのパース | E-06 | ○ |
| C-048 | onlyVerbsタグのパース | E-06 | ○ |
| C-049 | 旧形式タグのエラー | E-06 | ○ |
| C-050 | 未知タグのエラー | E-06 | ○ |
| C-051 | noVerbsタグのパース | E-06 | ○ |
| C-052 | noStatusタグのパース | E-06 | ○ |
| C-053 | methodタグのパース | E-06 | ○ |
| C-054 | verb未指定時エラー | E-06 | ○ |
| C-055 | 非対応verbのエラー | E-06 | ○ |
| C-056 | 未知拡張キーのエラー | E-06 | ○ |
| C-057 | result型のverb制限 | E-06 | ○ |
| C-058 | input型のverb制限 | E-06 | ○ |
| C-059 | IsSubresourceのtrue判定 | E-06 | ○ |
| C-060 | IsSubresourceのfalse判定 | E-06 | ○ |
| C-061 | HasVerbの一致判定 | E-06 | ○ |
| C-062 | Input()の分割 | E-06 | ○ |
| C-063 | Result()の分割 | E-06 | ○ |
| C-064 | MustParseClientGenTagsのpanic | E-06 | ○ |
| C-065 | ParsePathGroupVersionのパス付き分割 | E-07 | ○ |
| C-066 | ParsePathGroupVersionのパスなし | E-07 | ○ |
| C-067 | ParsePathGroupVersionの単一セグメント | E-07 | ○ |
| C-068 | ParsePathGroupVersionの空文字列 | E-07 | ○ |
| C-069 | parseGroupVersionTypeの3セグメント | E-08 | ○ |
| C-070 | parseGroupVersionTypeの2セグメント | E-08 | ○ |
| C-071 | parseGroupVersionTypeの1セグメントエラー | E-08 | ○ |
| C-072 | parseGroupVersionTypeの4セグメントエラー | E-08 | ○ |
| C-073 | readAsCSVの正常分割 | E-09 | ○ |
| C-074 | readAsCSVの空文字列 | E-09 | ○ |
| C-075 | writeAsCSVの変換 | E-09 | ○ |
| C-076 | JSONTags.Stringの名前のみ | E-10 | ○ |
| C-077 | JSONTags.Stringのomitempty付き | E-10 | ○ |
| C-078 | JSONTags.Stringのinline付き | E-10 | ○ |
| C-079 | lookupJSONTagsの正常抽出 | E-10 | ○ |
| C-080 | lookupJSONTagsの"-"タグ | E-10 | ○ |
| C-081 | lookupJSONTagsの空タグ | E-10 | ○ |
| C-082 | lookupJSONTagsの名前なしタグ | E-10 | ○ |
| C-083 | parseTagのカンマ分割 | E-10 | ○ |
| C-084 | parseTagのカンマなし | E-10 | ○ |
| C-085 | tagOptions.Containsのtrue | E-10 | ○ |
| C-086 | tagOptions.Containsのfalse | E-10 | ○ |
| C-087 | tagOptions.Containsの空 | E-10 | ○ |
| C-088 | applyConfigForTypeのStruct登録済み | E-11 | ○ |
| C-089 | applyConfigForTypeのStruct未登録 | E-11 | ○ |
| C-090 | applyConfigForTypeのMap型再帰 | E-11 | ○ |
| C-091 | applyConfigForTypeのSlice型再帰 | E-11 | ○ |
| C-092 | applyConfigForTypeのPointer型再帰 | E-11 | ○ |
| C-093 | isApplyConfigのtrue判定 | E-11 | ○ |
| C-094 | isApplyConfigのfalse判定 | E-11 | ○ |
| C-095 | requiresApplyConfigurationのtrue | E-11, E-10 | ○ |
| C-096 | requiresApplyConfigurationの非Struct | E-11 | ○ |
| C-097 | requiresApplyConfigurationの除外型 | E-11, E-21 | ○ |
| C-098 | requiresApplyConfigurationのJSONタグなし | E-11, E-10 | ○ |
| C-099 | findReachableTypesの探索 | E-11 | ○ |
| C-100 | findReachableTypesの循環参照 | E-11 | △ |
| C-101 | parseExternalMappingの正常パース | E-12 | ○ |
| C-102 | parseExternalMappingのコロンなしエラー | E-12 | ○ |
| C-103 | parseExternalMappingのドットなしエラー | E-12 | ○ |
| C-104 | externalApplyConfigurationValue.Setの正常 | E-12 | ○ |
| C-105 | 重複型のエラー | E-12 | ○ |
| C-106 | localNamer.Nameのローカル型 | E-13 | ○ |
| C-107 | localNamer.Nameの外部型 | E-13 | ○ |
| C-108 | localNamer.NameのMap型 | E-13 | ○ |
| C-109 | localNamer.Nameのドット含むパッケージ | E-13 | ○ |
| C-110 | protobufNamer.NameのMap型 | E-13 | ○ |
| C-111 | protobufNamer.Addの新規追加 | E-13 | ○ |
| C-112 | protobufNamer.Addの重複回避 | E-13 | ○ |
| C-113 | GoNameToProtoNameのpackagesByPath | E-13 | ○ |
| C-114 | GoNameToProtoNameのFilterTypes | E-13 | ○ |
| C-115 | GoNameToProtoNameの未登録 | E-13 | ○ |
| C-116 | protoSafePackageの変換 | E-13 | ○ |
| C-117 | isTypeApplicableToProtobufのFunc除外 | E-13 | ○ |
| C-118 | isTypeApplicableToProtobufのプライベート除外 | E-13 | ○ |
| C-119 | isTypeApplicableToProtobufのパブリック許可 | E-13 | ○ |
| C-120 | NewImportTrackerの生成 | E-14 | ○ |
| C-121 | AddNullableの追加 | E-14 | ○ |
| C-122 | extractBoolTagOrDieのtrue | E-15 | ○ |
| C-123 | extractBoolTagOrDieのデフォルト | E-15 | ○ |
| C-124 | lintTypeのStruct型lint | E-16 | ○ |
| C-125 | lintTypeのAlias再帰 | E-16 | ○ |
| C-126 | lintTypeの重複防止 | E-16 | ○ |
| C-127 | lintTypeのSlice再帰 | E-16 | ○ |
| C-128 | lintTypeのMap再帰 | E-16 | ○ |
| C-129 | lintCommentsの全ルール通過 | E-16 | ○ |
| C-130 | lintCommentsのルール違反 | E-16 | ○ |
| C-131 | AddErrorのフィールド付き | E-16 | ○ |
| C-132 | AddErrorのフィールドなし | E-16 | ○ |
| C-133 | newLinterのカスタムルール | E-16 | ○ |
| C-134 | newLinterのデフォルトルール | E-16, E-17 | ○ |
| C-135 | conflictingTagsRuleの競合検出 | E-16 | ○ |
| C-136 | conflictingTagsRuleの競合なし | E-16 | ○ |
| C-137 | conflictingTagsRuleのタグ不足panic | E-16 | ○ |
| C-138 | optional/required競合検出 | E-17 | ○ |
| C-139 | required/default競合検出 | E-17 | ○ |
| C-140 | GetMemberByJSONの正常検索 | E-18 | ○ |
| C-141 | GetMemberByJSONの不在nil | E-18 | ○ |
| C-142 | IsNilableTypeのPointer | E-18 | ○ |
| C-143 | IsNilableTypeのMap | E-18 | ○ |
| C-144 | IsNilableTypeのSlice | E-18 | ○ |
| C-145 | IsNilableTypeのInterface | E-18 | ○ |
| C-146 | IsNilableTypeのBuiltin | E-18 | ○ |
| C-147 | IsNilableTypeのArray | E-18 | ○ |
| C-148 | NativeTypeのAlias解決 | E-18 | ○ |
| C-149 | NativeTypeのPointer保持 | E-18 | ○ |
| C-150 | NativeTypeのAlias+Pointer | E-18 | ○ |
| C-151 | NativeTypeのAliasチェーン | E-18 | ○ |
| C-152 | NonPointerのPointer剥がし | E-18 | ○ |
| C-153 | NonPointerの非Pointer透過 | E-18 | ○ |
| C-154 | NonPointerの二重Pointer | E-18 | ○ |
| C-155 | IsDirectComparableのBuiltin | E-18 | ○ |
| C-156 | IsDirectComparableのStruct | E-18 | ○ |
| C-157 | IsDirectComparableのSliceメンバー | E-18 | ○ |
| C-158 | IsDirectComparableのPointer | E-18 | ○ |
| C-159 | IsDirectComparableのArray | E-18 | ○ |
| C-160 | IsDirectComparableのAlias | E-18 | ○ |
| C-161 | rootTypeStringの同一型 | E-19 | ○ |
| C-162 | rootTypeStringの異型 | E-19 | ○ |
| C-163 | newTypeModelsの空パスデフォルト | E-20 | ○ |
| C-164 | newTypeModelsの不正パスエラー | E-20 | ○ |
| C-165 | newTypeModelsの不正JSONエラー | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-038, C-040: ToGroupVersionInfo/ToGroupInstallPackagesの具体的な入出力の検証は、GroupVersions構造体の具体的な値をモック構築して実施する必要がある。namer.IC/namer.ILの挙動に依存するため、gengoライブラリの内部動作の確認が望ましい。
  - 候補：gengo/v2/namer パッケージのIC/IL関数のドキュメント
- C-100: findReachableTypesの循環参照テストは、types.Type構造体で自己参照するMembers配列を構築する必要がある。gengoのtypes.Type構造の制約確認が必要。
  - 候補：k8s.io/gengo/v2/types パッケージのType構造体定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - pkg/namer, pkg/util の関数群は独立性が高く、テスト容易
- 0: 低リスク - client-gen/types の型定義とヘルパーは純粋関数的で副作用なし
- 1: 中リスク - applyconfiguration-gen/generators のrefGraphはgengoのtypes.Universeに依存するため、テストフィクスチャの構築が複雑
- 1: 中リスク - validation-gen/lintのルール検証はgengoのtypes.Typeオブジェクトのモック構築が必要
- 0: 低リスク - go-to-protobuf/protobufのnamer群は文字列操作が中心でテスト容易
- 1: 中リスク - openapi.goのnewTypeModelsはファイルI/Oと外部JSONスキーマに依存するため、テストデータの準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値と期待結果がソースコードのロジックと整合しているか
- [ ] ParseClientGenTagsの各タグ組み合わせ（readonly + onlyVerbsなど）の競合ケースが十分か
- [ ] sortableSliceOfVersionsのLessメソッドが正規表現ベースであることを踏まえた境界値テストが十分か
- [ ] requiresApplyConfigurationのAlias型チェーン（Alias -> Alias -> Struct）のケースが必要か検討
- [ ] protobuf namingの特殊文字処理（ドット、ハイフン、スラッシュ）のエッジケースが十分か
- [ ] validation-genのlinter.lintTypeで、Pointer型の再帰lint（Elem経由）が対象ケースに含まれているか確認
