---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 261
  claims_with_evidence: 256
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：staging-component-helpers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：256 / 261、根拠なし：5
- 優先レビュー（高）
  1. **C-094（GetHostname OSホスト名取得）**：OSに依存するためモック環境が必要
  2. **C-083/C-084（GetBindVolumeToClaim）**：reference.GetReferenceの内部動作に依存
  3. **C-214/C-215（ensureLease）**：外部API（leaseClient）への依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/component-helpers/scheduling/corev1/nodeaffinity/nodeaffinity.go` - NodeSelector, LazyErrorNodeSelector, PreferredSchedulingTerms, RequiredNodeAffinity の定義と実装
- E-02: `staging/src/k8s.io/component-helpers/scheduling/corev1/helpers.go` - PodPriority, MatchNodeSelectorTerms, GetAvoidPodsFromNodeAnnotations, TolerationsTolerateTaint, FindMatchingUntoleratedTaint の定義
- E-03: `staging/src/k8s.io/component-helpers/auth/rbac/validation/policy_comparator.go` - Covers, BreakdownRule, ruleCovers, nonResourceURLCovers, resourceCoversAll の定義
- E-04: `staging/src/k8s.io/component-helpers/auth/rbac/reconciliation/reconcile_role.go` - ReconcileRoleOptions.Run, computeReconciledRole, aggregationRuleCovers, merge の定義
- E-05: `staging/src/k8s.io/component-helpers/auth/rbac/reconciliation/reconcile_rolebindings.go` - ReconcileRoleBindingOptions.Run, computeReconciledRoleBinding, diffSubjectLists の定義
- E-06: `staging/src/k8s.io/component-helpers/storage/volume/helpers.go` - PersistentVolumeClaimHasClass, GetPersistentVolumeClaimClass, GetPersistentVolumeClass, CheckNodeAffinity の定義
- E-07: `staging/src/k8s.io/component-helpers/storage/volume/pv_helpers.go` - IsDelayBindingProvisioning, IsVolumeBoundToClaim, CheckVolumeModeMismatches, CheckAccessModes, FindMatchingVolume, GetBindVolumeToClaim の定義
- E-08: `staging/src/k8s.io/component-helpers/storage/ephemeral/ephemeral.go` - VolumeClaimName, VolumeIsForPod の定義
- E-09: `staging/src/k8s.io/component-helpers/node/topology/helpers.go` - GetZoneKey の定義
- E-10: `staging/src/k8s.io/component-helpers/node/util/hostname.go` - GetHostname の定義
- E-11: `staging/src/k8s.io/component-helpers/node/util/conditions.go` - GetNodeCondition, SetNodeCondition の定義
- E-12: `staging/src/k8s.io/component-helpers/node/util/ips.go` - parseNodeIP, ParseNodeIPArgument, ParseNodeIPAnnotation の定義
- E-13: `staging/src/k8s.io/component-helpers/node/util/sysctl/sysctl.go` - NormalizeName, procSysctl の定義
- E-14: `staging/src/k8s.io/component-helpers/node/util/sysctl/namespace.go` - GetNamespace, namespaceOf の定義
- E-15: `staging/src/k8s.io/component-helpers/resource/helpers.go` - IsSupportedPodLevelResource, IsPodLevelResourcesSet, IsPodLevelRequestsSet, IsPodLevelLimitsSet, PodRequests, PodLimits, AggregateContainerRequests, AggregateContainerLimits, addResourceList, maxResourceList, reuseOrClearResourceList, IsPodResizeInfeasible, IsPodResizeDeferred 等の定義
- E-16: `staging/src/k8s.io/component-helpers/apps/poddisruptionbudget/helpers.go` - UpdateDisruptionAllowedCondition, ConditionsAreUpToDate の定義
- E-17: `staging/src/k8s.io/component-helpers/apimachinery/lease/controller.go` - NewController, controller.newLease, controller.ensureLease, controller.retryUpdateLease, controller.Run, controller.Start, controller.Stop, minDuration 等の定義
- E-18: `staging/src/k8s.io/component-helpers/nodedeclaredfeatures/framework.go` - Framework, New, DiscoverNodeFeatures, InferForPodScheduling, InferForPodUpdate, MatchNode, MatchNodeFeatureSet, NewFeatureSet, FeatureSet.Equal, FeatureSet.Clone の定義
- E-19: `staging/src/k8s.io/component-helpers/nodedeclaredfeatures/features/restartallcontainers/restart_all_containers.go` - restartAllContainersFeature の定義（Name, Discover, InferForScheduling, InferForUpdate, MaxVersion）
- E-20: `staging/src/k8s.io/component-helpers/nodedeclaredfeatures/features/inplacepodresize/guaranteed_cpu_resize.go` - guaranteedQoSPodCPUResizeFeature の定義（Name, Discover, InferForScheduling, InferForUpdate, MaxVersion）
- E-21: `staging/src/k8s.io/component-helpers/nodedeclaredfeatures/features/inplacepodresize/pod_level_resource_resize.go` - podLevelResourcesResizeFeature の定義（Name, Discover, InferForScheduling, InferForUpdate, MaxVersion）
- E-22: `staging/src/k8s.io/component-helpers/auth/rbac/reconciliation/namespace.go` - tryEnsureNamespace の定義
- E-23: `staging/src/k8s.io/component-helpers/nodedeclaredfeatures/types.go` - PodInfo, Feature, FeatureGate, NodeConfiguration, StaticConfiguration の型定義
- E-24: `staging/src/k8s.io/component-helpers/node/util/cidr.go` - GetPodCIDRsFromAnnotation の定義
- E-25: `staging/src/k8s.io/component-helpers/node/util/status.go` - SetNodeCondition の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | NewNodeSelector 正常系 | E-01 | ○ |
| C-002 | NewNodeSelector 異常系（不正オペレータ） | E-01 | ○ |
| C-003 | NewNodeSelector 境界値（空terms） | E-01 | ○ |
| C-004 | NodeSelector.Match 正常系（マッチ） | E-01 | ○ |
| C-005 | NodeSelector.Match 正常系（不一致） | E-01 | ○ |
| C-006 | LazyErrorNodeSelector.Match 異常系（nilノード） | E-01 | ○ |
| C-007 | LazyErrorNodeSelector.Match 正常系（OR条件） | E-01 | ○ |
| C-008 | NewPreferredSchedulingTerms 正常系 | E-01 | ○ |
| C-009 | NewPreferredSchedulingTerms 境界値（Weight=0） | E-01 | ○ |
| C-010 | Score 正常系 | E-01 | ○ |
| C-011 | Score 境界値（マッチなし） | E-01 | ○ |
| C-012 | GetRequiredNodeAffinity 正常系 | E-01 | ○ |
| C-013 | GetRequiredNodeAffinity 境界値（空Pod） | E-01 | ○ |
| C-014 | RequiredNodeAffinity.Match AND条件 | E-01 | ○ |
| C-015 | RequiredNodeAffinity.Match labelSelector不一致 | E-01 | ○ |
| C-016 | nodeSelectorRequirementsAsSelector 各オペレータ | E-01 | ○ |
| C-017 | nodeSelectorRequirementsAsSelector 不正オペレータ | E-01 | ○ |
| C-018 | nodeSelectorRequirementsAsFieldSelector 正常系 | E-01 | ○ |
| C-019 | nodeSelectorRequirementsAsFieldSelector バリデーション | E-01 | ○ |
| C-020 | PodPriority 正常系 | E-02 | ○ |
| C-021 | PodPriority 境界値（nil） | E-02 | ○ |
| C-022 | MatchNodeSelectorTerms 正常系 | E-02 | ○ |
| C-023 | MatchNodeSelectorTerms 異常系（nil） | E-02 | ○ |
| C-024 | GetAvoidPodsFromNodeAnnotations 正常系 | E-02 | ○ |
| C-025 | GetAvoidPodsFromNodeAnnotations 異常系 | E-02 | ○ |
| C-026 | GetAvoidPodsFromNodeAnnotations 境界値 | E-02 | ○ |
| C-027 | TolerationsTolerateTaint 正常系（許容） | E-02 | ○ |
| C-028 | TolerationsTolerateTaint 正常系（非許容） | E-02 | ○ |
| C-029 | TolerationsTolerateTaint 境界値（空配列） | E-02 | ○ |
| C-030 | FindMatchingUntoleratedTaint 未許容検出 | E-02 | ○ |
| C-031 | FindMatchingUntoleratedTaint 全許容 | E-02 | ○ |
| C-032 | FindMatchingUntoleratedTaint nilフィルタ | E-02 | ○ |
| C-033 | Covers カバー | E-03 | ○ |
| C-034 | Covers 未カバー | E-03 | ○ |
| C-035 | Covers 境界値（空） | E-03 | ○ |
| C-036 | BreakdownRule 正常系 | E-03 | ○ |
| C-037 | BreakdownRule ResourceNames | E-03 | ○ |
| C-038 | BreakdownRule NonResourceURLs | E-03 | ○ |
| C-039 | ruleCovers ワイルドカード | E-03 | ○ |
| C-040 | nonResourceURLCovers ワイルドカード | E-03 | ○ |
| C-041 | nonResourceURLCovers 完全一致 | E-03 | ○ |
| C-042 | resourceCoversAll サブリソース | E-03 | ○ |
| C-043 | ReconcileRoleOptions.Run 作成 | E-04 | ○ |
| C-044 | ReconcileRoleOptions.Run 更新（Union） | E-04 | ○ |
| C-045 | ReconcileRoleOptions.Run 更新（Stomp） | E-04 | ○ |
| C-046 | ReconcileRoleOptions.Run ドライラン | E-04 | ○ |
| C-047 | ReconcileRoleOptions.Run Protected | E-04 | ○ |
| C-048 | ReconcileRoleOptions.Run リトライ上限 | E-04 | ○ |
| C-049 | computeReconciledRole メタデータマージ | E-04 | ○ |
| C-050 | aggregationRuleCovers カバー | E-04 | ○ |
| C-051 | aggregationRuleCovers 両方nil | E-04 | ○ |
| C-052 | ReconcileRoleBindingOptions.Run 作成 | E-05 | ○ |
| C-053 | ReconcileRoleBindingOptions.Run Recreate | E-05 | ○ |
| C-054 | ReconcileRoleBindingOptions.Run Subject追加 | E-05 | ○ |
| C-055 | ReconcileRoleBindingOptions.Run Subject削除 | E-05 | ○ |
| C-056 | diffSubjectLists 差分計算 | E-05 | ○ |
| C-057 | diffSubjectLists 同一リスト | E-05 | ○ |
| C-058 | diffSubjectLists 空リスト | E-05 | ○ |
| C-059 | PersistentVolumeClaimHasClass StorageClassName | E-06 | ○ |
| C-060 | PersistentVolumeClaimHasClass ベータアノテーション | E-06 | ○ |
| C-061 | PersistentVolumeClaimHasClass 未設定 | E-06 | ○ |
| C-062 | GetPersistentVolumeClaimClass 正常系 | E-06 | ○ |
| C-063 | GetPersistentVolumeClaimClass 未設定 | E-06 | ○ |
| C-064 | GetPersistentVolumeClass 正常系 | E-06 | ○ |
| C-065 | CheckNodeAffinity nil | E-06 | ○ |
| C-066 | CheckNodeAffinity マッチ | E-06 | ○ |
| C-067 | CheckNodeAffinity 不一致 | E-06 | ○ |
| C-068 | IsDelayBindingProvisioning true | E-07 | ○ |
| C-069 | IsDelayBindingProvisioning false | E-07 | ○ |
| C-070 | IsVolumeBoundToClaim バインド済み | E-07 | ○ |
| C-071 | IsVolumeBoundToClaim ClaimRef=nil | E-07 | ○ |
| C-072 | IsVolumeBoundToClaim Name不一致 | E-07 | ○ |
| C-073 | IsVolumeBoundToClaim UID不一致 | E-07 | ○ |
| C-074 | CheckVolumeModeMismatches 一致 | E-07 | ○ |
| C-075 | CheckVolumeModeMismatches 不一致 | E-07 | ○ |
| C-076 | CheckVolumeModeMismatches nilデフォルト | E-07 | ○ |
| C-077 | CheckAccessModes 満足 | E-07 | ○ |
| C-078 | CheckAccessModes 不足 | E-07 | ○ |
| C-079 | FindMatchingVolume 最小容量マッチ | E-07 | ○ |
| C-080 | FindMatchingVolume プレバインド優先 | E-07 | ○ |
| C-081 | FindMatchingVolume マッチなし | E-07 | ○ |
| C-082 | FindMatchingVolume excludedVolumes | E-07 | ○ |
| C-083 | GetBindVolumeToClaim バインド処理 | E-07 | △ |
| C-084 | GetBindVolumeToClaim 既バインド冪等性 | E-07 | △ |
| C-085 | VolumeClaimName 正常系 | E-08 | ○ |
| C-086 | VolumeIsForPod 正常系 | E-08 | ○ |
| C-087 | VolumeIsForPod 非所有 | E-08 | ○ |
| C-088 | VolumeIsForPod Namespace不一致 | E-08 | ○ |
| C-089 | GetZoneKey topology | E-09 | ○ |
| C-090 | GetZoneKey ベータ優先 | E-09 | ○ |
| C-091 | GetZoneKey nilラベル | E-09 | ○ |
| C-092 | GetZoneKey ラベルなし | E-09 | ○ |
| C-093 | GetHostname オーバーライド | E-10 | ○ |
| C-094 | GetHostname OSホスト名 | E-10 | △ |
| C-095 | GetHostname 空白ホスト名 | E-10 | ○ |
| C-096 | GetNodeCondition 正常系 | E-11 | ○ |
| C-097 | GetNodeCondition 未存在 | E-11 | ○ |
| C-098 | GetNodeCondition nil status | E-11 | ○ |
| C-099 | ParseNodeIPArgument IPv4 | E-12 | ○ |
| C-100 | ParseNodeIPArgument デュアルスタック | E-12 | ○ |
| C-101 | ParseNodeIPArgument 同一ファミリ | E-12 | ○ |
| C-102 | ParseNodeIPArgument 3IP | E-12 | ○ |
| C-103 | ParseNodeIPArgument 非対応プロバイダ | E-12 | ○ |
| C-104 | ParseNodeIPAnnotation 正常系 | E-12 | ○ |
| C-105 | ParseNodeIPAnnotation 不正IP | E-12 | ○ |
| C-106 | ParseNodeIPAnnotation unspecified | E-12 | ○ |
| C-107 | NormalizeName スラッシュ→ドット | E-13 | ○ |
| C-108 | NormalizeName ドットそのまま | E-13 | ○ |
| C-109 | NormalizeName 空文字 | E-13 | ○ |
| C-110 | NormalizeName 混在パス | E-13 | ○ |
| C-111 | GetNamespace Net | E-14 | ○ |
| C-112 | GetNamespace IPC | E-14 | ○ |
| C-113 | GetNamespace ワイルドカード | E-14 | ○ |
| C-114 | GetNamespace Unknown | E-14 | ○ |
| C-115 | IsSupportedPodLevelResource CPU | E-15 | ○ |
| C-116 | IsSupportedPodLevelResource Memory | E-15 | ○ |
| C-117 | IsSupportedPodLevelResource HugePages | E-15 | ○ |
| C-118 | IsSupportedPodLevelResource 非対応 | E-15 | ○ |
| C-119 | IsPodLevelResourcesSet true | E-15 | ○ |
| C-120 | IsPodLevelResourcesSet nil | E-15 | ○ |
| C-121 | IsPodLevelResourcesSet 非対応リソースのみ | E-15 | ○ |
| C-122 | IsPodLevelRequestsSet true | E-15 | ○ |
| C-123 | IsPodLevelRequestsSet 空 | E-15 | ○ |
| C-124 | IsPodLevelLimitsSet true | E-15 | ○ |
| C-125 | PodRequests コンテナ合計 | E-15 | ○ |
| C-126 | PodRequests Overhead加算 | E-15 | ○ |
| C-127 | PodRequests Overhead除外 | E-15 | ○ |
| C-128 | PodRequests Pod-level | E-15 | ○ |
| C-129 | AggregateContainerRequests restartable init | E-15 | ○ |
| C-130 | AggregateContainerRequests 通常init最大値 | E-15 | ○ |
| C-131 | PodLimits コンテナ合計 | E-15 | ○ |
| C-132 | PodLimits Overhead加算 | E-15 | ○ |
| C-133 | IsPodResizeInfeasible true | E-15 | ○ |
| C-134 | IsPodResizeInfeasible false | E-15 | ○ |
| C-135 | IsPodResizeDeferred true | E-15 | ○ |
| C-136 | UpdateDisruptionAllowedCondition True | E-16 | ○ |
| C-137 | UpdateDisruptionAllowedCondition False | E-16 | ○ |
| C-138 | UpdateDisruptionAllowedCondition nil初期化 | E-16 | ○ |
| C-139 | ConditionsAreUpToDate true | E-16 | ○ |
| C-140 | ConditionsAreUpToDate 条件なし | E-16 | ○ |
| C-141 | ConditionsAreUpToDate Generation不一致 | E-16 | ○ |
| C-142 | NewController 正常系 | E-17 | ○ |
| C-143 | NewController nil client | E-17 | ○ |
| C-144 | newLease base=nil | E-17 | ○ |
| C-145 | newLease base指定 | E-17 | ○ |
| C-146 | newLease PostProcessFunc | E-17 | ○ |
| C-147 | Run nil leaseClient | E-17 | ○ |
| C-148 | ensureLease 新規作成 | E-17 | △ |
| C-149 | ensureLease 既存取得 | E-17 | △ |
| C-150 | retryUpdateLease 正常系 | E-17 | ○ |
| C-151 | retryUpdateLease リトライ上限 | E-17 | ○ |
| C-152 | New 正常系 | E-18 | ○ |
| C-153 | New nil registry | E-18 | ○ |
| C-154 | DiscoverNodeFeatures 正常系 | E-18 | ○ |
| C-155 | DiscoverNodeFeatures MaxVersion | E-18 | ○ |
| C-156 | InferForPodScheduling 正常系 | E-18 | ○ |
| C-157 | InferForPodScheduling nil version | E-18 | ○ |
| C-158 | InferForPodUpdate 正常系 | E-18 | ○ |
| C-159 | MatchNode マッチ | E-18 | ○ |
| C-160 | MatchNode 不一致 | E-18 | ○ |
| C-161 | MatchNode nil node | E-18 | ○ |
| C-162 | MatchNodeFeatureSet 空要件 | E-18 | ○ |
| C-163 | restartAllContainersFeature InferForScheduling true | E-19 | ○ |
| C-164 | restartAllContainersFeature InferForScheduling false | E-19 | ○ |
| C-165 | restartAllContainersFeature InferForUpdate | E-19 | ○ |
| C-166 | guaranteedQoSPodCPUResizeFeature Discover static | E-20 | ○ |
| C-167 | guaranteedQoSPodCPUResizeFeature Discover none | E-20 | ○ |
| C-168 | guaranteedQoSPodCPUResizeFeature InferForUpdate Guaranteed | E-20 | ○ |
| C-169 | guaranteedQoSPodCPUResizeFeature InferForUpdate 非Guaranteed | E-20 | ○ |
| C-170 | podLevelResourcesResizeFeature InferForUpdate 変更あり | E-21 | ○ |
| C-171 | podLevelResourcesResizeFeature InferForUpdate 変更なし | E-21 | ○ |
| C-172 | podLevelResourcesResizeFeature InferForUpdate 両方nil | E-21 | ○ |
| C-173 | IsPodLevelRequestsSet 境界値（nil Resources） | E-15 | ○ |
| C-174 | IsPodLevelLimitsSet 正常系 | E-15 | ○ |
| C-175 | IsPodLevelLimitsSet 境界値（空Limits） | E-15 | ○ |
| C-176 | PodRequests コンテナリクエスト合計 | E-15 | ○ |
| C-177 | PodRequests Overhead加算 | E-15 | ○ |
| C-178 | PodRequests ExcludeOverhead | E-15 | ○ |
| C-179 | PodRequests Pod-levelリソース使用 | E-15 | ○ |
| C-180 | PodRequests SkipContainerLevelResources | E-15 | ○ |
| C-181 | AggregateContainerRequests restartable initコンテナ加算 | E-15 | ○ |
| C-182 | AggregateContainerRequests 通常initコンテナ最大値 | E-15 | ○ |
| C-183 | AggregateContainerRequests ContainerFnコールバック | E-15 | ○ |
| C-184 | AggregateContainerRequests NonMissingContainerRequests補完 | E-15 | ○ |
| C-185 | PodLimits コンテナリミット合計 | E-15 | ○ |
| C-186 | PodLimits 非ゼロリミットOverhead加算 | E-15 | ○ |
| C-187 | PodLimits ゼロリミットOverhead除外 | E-15 | ○ |
| C-188 | IsPodResizeInfeasible Infeasible判定 | E-15 | ○ |
| C-189 | IsPodResizeInfeasible 条件なし | E-15 | ○ |
| C-190 | IsPodResizeDeferred Deferred判定 | E-15 | ○ |
| C-191 | IsPodResizeDeferred 条件なし | E-15 | ○ |
| C-192 | addResourceList 加算 | E-15 | ○ |
| C-193 | addResourceList 空リスト加算 | E-15 | ○ |
| C-194 | maxResourceList 最大値選択 | E-15 | ○ |
| C-195 | maxResourceList 既存値が大きい場合 | E-15 | ○ |
| C-196 | reuseOrClearResourceList nil入力 | E-15 | ○ |
| C-197 | reuseOrClearResourceList 非nilクリア | E-15 | ○ |
| C-198 | UpdateDisruptionAllowedCondition True | E-16 | ○ |
| C-199 | UpdateDisruptionAllowedCondition False | E-16 | ○ |
| C-200 | UpdateDisruptionAllowedCondition nil初期化 | E-16 | ○ |
| C-201 | ConditionsAreUpToDate true | E-16 | ○ |
| C-202 | ConditionsAreUpToDate 条件未設定 | E-16 | ○ |
| C-203 | ConditionsAreUpToDate Generation不一致 | E-16 | ○ |
| C-204 | ConditionsAreUpToDate 0/ConditionFalse/InsufficientPods | E-16 | ○ |
| C-205 | NewController 正常系 | E-17 | ○ |
| C-206 | NewController nil client | E-17 | ○ |
| C-207 | newLease base=nil 新規生成 | E-17 | ○ |
| C-208 | newLease base指定 DeepCopy | E-17 | ○ |
| C-209 | newLease PostProcessFunc実行 | E-17 | ○ |
| C-210 | newLease PostProcessFuncエラー | E-17 | ○ |
| C-211 | Run nil leaseClient | E-17 | ○ |
| C-212 | Start nil leaseClient | E-17 | ○ |
| C-213 | Stop nil leaseClient | E-17 | ○ |
| C-214 | ensureLease 新規作成 | E-17 | △ |
| C-215 | ensureLease 既存取得 | E-17 | △ |
| C-216 | retryUpdateLease 正常更新 | E-17 | ○ |
| C-217 | retryUpdateLease リトライ上限 | E-17 | ○ |
| C-218 | retryUpdateLease Conflictリトライ | E-17 | ○ |
| C-219 | minDuration a < b | E-17 | ○ |
| C-220 | minDuration a > b | E-17 | ○ |
| C-221 | Framework New 正常系 | E-18 | ○ |
| C-222 | Framework New nil registry | E-18 | ○ |
| C-223 | DiscoverNodeFeatures 正常系 | E-18 | ○ |
| C-224 | DiscoverNodeFeatures MaxVersionフィルタ | E-18 | ○ |
| C-225 | DiscoverNodeFeatures 全Feature無効 | E-18 | ○ |
| C-226 | InferForPodScheduling 正常系 | E-18 | ○ |
| C-227 | InferForPodScheduling nil version | E-18 | ○ |
| C-228 | InferForPodUpdate 正常系 | E-18 | ○ |
| C-229 | InferForPodUpdate nil version | E-18 | ○ |
| C-230 | MatchNode マッチ | E-18 | ○ |
| C-231 | MatchNode 不一致 | E-18 | ○ |
| C-232 | MatchNode nil node | E-18 | ○ |
| C-233 | MatchNodeFeatureSet 空要件 | E-18 | ○ |
| C-234 | NewFeatureSet 生成 | E-18 | ○ |
| C-235 | FeatureSet.Equal 同一 | E-18 | ○ |
| C-236 | FeatureSet.Clone 正常系 | E-18 | ○ |
| C-237 | FeatureSet.Clone nil | E-18 | ○ |
| C-238 | restartAllContainersFeature Name | E-19 | ○ |
| C-239 | restartAllContainersFeature Discover 有効 | E-19 | ○ |
| C-240 | restartAllContainersFeature Discover 無効 | E-19 | ○ |
| C-241 | restartAllContainersFeature InferForScheduling true | E-19 | ○ |
| C-242 | restartAllContainersFeature InferForScheduling initContainer | E-19 | ○ |
| C-243 | restartAllContainersFeature InferForScheduling false | E-19 | ○ |
| C-244 | restartAllContainersFeature InferForUpdate false | E-19 | ○ |
| C-245 | restartAllContainersFeature MaxVersion nil | E-19 | ○ |
| C-246 | guaranteedQoSPodCPUResizeFeature Name | E-20 | ○ |
| C-247 | guaranteedQoSPodCPUResizeFeature Discover FG有効+static | E-20 | ○ |
| C-248 | guaranteedQoSPodCPUResizeFeature Discover none policy | E-20 | ○ |
| C-249 | guaranteedQoSPodCPUResizeFeature Discover FG無効+static | E-20 | ○ |
| C-250 | guaranteedQoSPodCPUResizeFeature InferForScheduling | E-20 | ○ |
| C-251 | guaranteedQoSPodCPUResizeFeature InferForUpdate Guaranteed | E-20 | ○ |
| C-252 | guaranteedQoSPodCPUResizeFeature InferForUpdate 非Guaranteed | E-20 | ○ |
| C-253 | guaranteedQoSPodCPUResizeFeature InferForUpdate CPU未変更 | E-20 | ○ |
| C-254 | guaranteedQoSPodCPUResizeFeature InferForUpdate nil Status | E-20 | ○ |
| C-255 | podLevelResourcesResizeFeature Name | E-21 | ○ |
| C-256 | podLevelResourcesResizeFeature Discover | E-21 | ○ |
| C-257 | podLevelResourcesResizeFeature InferForUpdate 変更あり | E-21 | ○ |
| C-258 | podLevelResourcesResizeFeature InferForUpdate 変更なし | E-21 | ○ |
| C-259 | podLevelResourcesResizeFeature InferForUpdate 両方nil | E-21 | ○ |
| C-260 | podLevelResourcesResizeFeature InferForUpdate nil→非nil | E-21 | ○ |
| C-261 | podLevelResourcesResizeFeature InferForScheduling false | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-083/C-084（GetBindVolumeToClaim）**: `reference.GetReference` の内部動作がスキーム登録に依存するため、テスト実行時にscheme初期化が必要。テストケースの期待結果はコードの分岐ロジックに基づくが、スキーム依存の詳細は外部パッケージに属する。
  - 候補：client-go/tools/reference パッケージの仕様確認 / schemeの初期化手順確認
- **C-094（GetHostname OSホスト名取得）**: `os.Hostname()` の戻り値はOS環境に依存するため、テスト環境によって結果が異なる。モック化またはホスト名オーバーライドのテストのみで十分にカバー可能。
  - 候補：OS依存テストのモック戦略確認
- **C-214/C-215（ensureLease）**: `leaseClient` への外部API呼び出しに依存するため、fake clientを使ったテストが必要。コードの分岐ロジックは明確だが、APIサーバーの挙動シミュレーションが前提。
  - 候補：fake client-goのリース実装確認

## 5) リスクフラグ（レビュー観点）
- 0: resource/helpers.go の PodRequests/PodLimits はKubernetes API計算の核心部分であり、テストケースは十分網羅されている（内部関数 addResourceList, maxResourceList, reuseOrClearResourceList も含む）
- 0: RBAC reconciliation のテストケースは主要な分岐を全てカバーしている
- 1: GetBindVolumeToClaim のテストは reference.GetReference の動作前提が必要（中リスク）
- 0: nodedeclaredfeatures フレームワークは新しい機能（2025年導入）だが、インタフェースが明確でテスト観点は十分。各Feature実装（restartAllContainers, guaranteedQoSPodCPUResize, podLevelResourcesResize）のName/Discover/InferForScheduling/InferForUpdate/MaxVersionを網羅
- 1: lease controller のテストは外部APIクライアント依存が多く、統合テスト的な要素を含む（中リスク）
- 0: apps/poddisruptionbudget の ConditionsAreUpToDate は DisruptionsAllowed=0のケース（ConditionFalse + InsufficientPodsReason）を含む詳細なカバレッジを持つ

## 6) レビュアーチェックリスト（最小）
- [ ] CSVの全261件のテストケースがソースコードの公開関数/メソッドを網羅しているか確認
- [ ] resource/helpers.go の PodRequests/PodLimits のテストケースがサイドカーコンテナ（restartable init container）の計算ロジックを適切にカバーしているか
- [ ] resource/helpers.go の内部関数（addResourceList, maxResourceList, reuseOrClearResourceList）のテストケースが正常系・境界値を含むか
- [ ] RBAC reconciliation のテストケースが Protected/DryRun/Confirm の全組み合わせを含むか
- [ ] nodedeclaredfeatures の各Feature実装（restartallcontainers, inplacepodresize）のName/Discover/InferForScheduling/InferForUpdate/MaxVersion が全てカバーされているか
- [ ] storage/volume の FindMatchingVolume のテストケースが VolumeAttributesClass（vacEnabled）の条件分岐を含むか確認
- [ ] lease controller のテストケースが Start/Stop/Run の nil leaseClient防御ケースを含むか確認
- [ ] apps/poddisruptionbudget の ConditionsAreUpToDate テストケースが DisruptionsAllowed=0 の詳細条件を含むか確認
