---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 104
  claims_with_evidence: 99
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：staging-controller-manager 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：99 / 104、根拠なし：5
- 優先レビュー（高）
  1. **UT-CTM-013/014（NewBaseHandler）**：muxに登録されるパスの完全な一覧はソースコードから直接確認が必要
  2. **UT-CTM-015（BlockProfileRate）**：runtime.SetBlockProfileRateの呼び出し確認はインテグレーションテストに近い
  3. **UT-CTM-092/093（Token境界値・nil）**：トークン有効期間の境界値テストは外部依存（時刻）に関わる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/controller-manager/app/helper.go` - IsControllerEnabled関数の実装
- E-02: `staging/src/k8s.io/controller-manager/app/serve.go` - BuildHandlerChain, NewBaseHandler関数の実装
- E-03: `staging/src/k8s.io/controller-manager/app/controllercontext.go` - ControllerContext構造体定義
- E-04: `staging/src/k8s.io/controller-manager/options/debugging.go` - DebuggingOptions構造体と各メソッド
- E-05: `staging/src/k8s.io/controller-manager/options/generic.go` - GenericControllerManagerConfigurationOptions構造体と各メソッド
- E-06: `staging/src/k8s.io/controller-manager/controller/interfaces.go` - Interface, Debuggable, HealthCheckableインターフェース定義
- E-07: `staging/src/k8s.io/controller-manager/pkg/leadermigration/migrator.go` - LeaderMigrator構造体とNewLeaderMigrator関数
- E-08: `staging/src/k8s.io/controller-manager/pkg/leadermigration/filter.go` - FilterResult型とFilterFunc型定義
- E-09: `staging/src/k8s.io/controller-manager/pkg/leadermigration/util.go` - Enabled関数
- E-10: `staging/src/k8s.io/controller-manager/pkg/leadermigration/config/config.go` - ReadLeaderMigrationConfiguration, ValidateLeaderMigrationConfiguration関数
- E-11: `staging/src/k8s.io/controller-manager/pkg/leadermigration/config/default.go` - DefaultLeaderMigrationConfiguration関数
- E-12: `staging/src/k8s.io/controller-manager/pkg/leadermigration/options/options.go` - LeaderMigrationOptions構造体と各メソッド
- E-13: `staging/src/k8s.io/controller-manager/pkg/healthz/healthz.go` - NamedPingChecker, NamedHealthChecker関数
- E-14: `staging/src/k8s.io/controller-manager/pkg/healthz/handler.go` - MutableHealthzHandler構造体と各メソッド
- E-15: `staging/src/k8s.io/controller-manager/pkg/clientbuilder/client_builder.go` - SimpleControllerClientBuilder構造体と各メソッド
- E-16: `staging/src/k8s.io/controller-manager/pkg/clientbuilder/client_builder_dynamic.go` - DynamicControllerClientBuilder, tokenSourceImpl, getOrCreateServiceAccount, constructClient
- E-17: `staging/src/k8s.io/controller-manager/pkg/informerfactory/informer_factory.go` - informerFactory構造体と各メソッド
- E-18: `staging/src/k8s.io/controller-manager/pkg/features/kube_features.go` - SetupCurrentKubernetesSpecificFeatureGates関数
- E-19: `staging/src/k8s.io/controller-manager/config/types.go` - GenericControllerManagerConfiguration, LeaderMigrationConfiguration型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsControllerEnabled: 明示的有効化でtrue返却 | E-01 (L62-65) | ○ |
| C-02 | IsControllerEnabled: 明示的無効化でfalse返却 | E-01 (L66-68) | ○ |
| C-03 | IsControllerEnabled: ワイルドカードでデフォルト有効はtrue | E-01 (L69-70, L79) | ○ |
| C-04 | IsControllerEnabled: ワイルドカードでデフォルト無効はfalse | E-01 (L79) | ○ |
| C-05 | IsControllerEnabled: 空リストでfalse | E-01 (L74-77) | ○ |
| C-06 | IsControllerEnabled: 明示的指定がワイルドカードより優先 | E-01 (L62-65, for loop順序) | ○ |
| C-07 | IsControllerEnabled: 重複時先勝ち | E-01 (for loop順序, early return) | ○ |
| C-08 | BuildHandlerChain: 認証・認可ありでハンドラチェーン構築 | E-02 (L43-48) | ○ |
| C-09 | BuildHandlerChain: nil安全なハンドラチェーン構築 | E-02 (L43, L46 nil check) | ○ |
| C-10 | NewBaseHandler: プロファイリング有効時のエンドポイント登録 | E-02 (L61-67) | ○ |
| C-11 | NewBaseHandler: プロファイリング無効時のエンドポイント非登録 | E-02 (L61 if文) | ○ |
| C-12 | NewBaseHandler: コンテンションプロファイリングのBlockProfileRate設定 | E-02 (L64-65) | △ |
| C-13 | DebuggingOptions: デフォルト値 | E-04 (L32-38) | ○ |
| C-14 | DebuggingOptions.ApplyTo: 設定値の反映 | E-04 (L53-62) | ○ |
| C-15 | DebuggingOptions.ApplyTo: nilレシーバの安全性 | E-04 (L54-56) | ○ |
| C-16 | DebuggingOptions.Validate: 正常系 | E-04 (L65-72) | ○ |
| C-17 | DebuggingOptions.AddFlags: フラグ登録 | E-04 (L41-50) | ○ |
| C-18 | GenericOptions: ファクトリ関数 | E-05 (L41-49) | ○ |
| C-19 | GenericOptions.ApplyTo: 設定値反映 | E-05 (L74-107) | ○ |
| C-20 | GenericOptions.ApplyTo: エイリアス解決 | E-05 (L94-104) | ○ |
| C-21 | GenericOptions.ApplyTo: 無効化プレフィックス付きエイリアス | E-05 (L95, L100-101) | ○ |
| C-22 | GenericOptions.Validate: 正常系 | E-05 (L110-140) | ○ |
| C-23 | GenericOptions.Validate: ResourceLockバリデーション | E-05 (L120-122) | ○ |
| C-24 | GenericOptions.Validate: 不明コントローラ名エラー | E-05 (L124-137) | ○ |
| C-25 | GenericOptions.Validate: ワイルドカード特別処理 | E-05 (L126-128) | ○ |
| C-26 | NewLeaderMigrator: 同一コンポーネントでControllerMigrated | E-07 (L39, L48-50) | ○ |
| C-27 | NewLeaderMigrator: 異コンポーネントでControllerUnowned | E-07 (L39, L53-54) | ○ |
| C-28 | NewLeaderMigrator: 非対象でControllerNonMigrated | E-07 (L44-45, L57-58) | ○ |
| C-29 | NewLeaderMigrator: ワイルドカードComponent | E-07 (L39 "||" condition) | ○ |
| C-30 | NewLeaderMigrator: MigrationReadyチャネル初期化 | E-07 (L42) | ○ |
| C-31 | Enabled: 両方trueでtrue | E-09 (L24) | ○ |
| C-32 | Enabled: LeaderElect=falseでfalse | E-09 (L24) | ○ |
| C-33 | Enabled: LeaderMigrationEnabled=falseでfalse | E-09 (L24) | ○ |
| C-34 | ValidateLeaderMigrationConfiguration: 正常系 | E-10 (L80-96) | ○ |
| C-35 | ValidateLeaderMigrationConfiguration: LeaderName空でエラー | E-10 (L81-83) | ○ |
| C-36 | ValidateLeaderMigrationConfiguration: ResourceLock不正でエラー | E-10 (L85-87) | ○ |
| C-37 | ValidateLeaderMigrationConfiguration: endpoints許可 | E-10 (L85, L37) | ○ |
| C-38 | ValidateLeaderMigrationConfiguration: Component空でエラー | E-10 (L102-103) | ○ |
| C-39 | ValidateLeaderMigrationConfiguration: Name空でエラー | E-10 (L105-107) | ○ |
| C-40 | ReadLeaderMigrationConfiguration: ファイル不在エラー | E-10 (L62-65) | ○ |
| C-41 | ReadLeaderMigrationConfiguration: 有効YAML読み込み | E-10 (L61-75) | ○ |
| C-42 | ReadLeaderMigrationConfiguration: 不正YAMLエラー | E-10 (L66-69) | ○ |
| C-43 | DefaultLeaderMigrationConfiguration: デフォルト値 | E-11 (L23-40) | ○ |
| C-44 | LeaderMigrationOptions.ApplyTo: Enabled=false | E-12 (L60-70) | ○ |
| C-45 | LeaderMigrationOptions.ApplyTo: Enabled=true, 空パス | E-12 (L71-73) | ○ |
| C-46 | LeaderMigrationOptions.ApplyTo: 不正ファイルパスエラー | E-12 (L75-77) | ○ |
| C-47 | LeaderMigrationOptions.ApplyTo: nilレシーバ | E-12 (L62-65) | ○ |
| C-48 | MutableHealthzHandler: NewMutableHealthzHandler生成 | E-14 (L63-68) | ○ |
| C-49 | MutableHealthzHandler.AddHealthChecker: チェック追加 | E-14 (L53-61) | ○ |
| C-50 | MutableHealthzHandler.ServeHTTP: HTTPレスポンス | E-14 (L42-47) | ○ |
| C-51 | NamedPingChecker: 名前付きPingチェッカー生成 | E-13 (L27-29) | ○ |
| C-52 | NamedHealthChecker: 名前付きカスタムチェッカー生成 | E-13 (L33-35) | ○ |
| C-53 | SimpleControllerClientBuilder.Config: UserAgent付与 | E-15 (L45-48) | ○ |
| C-54 | SimpleControllerClientBuilder.Config: イミュータビリティ | E-15 (L46 値コピー) | ○ |
| C-55 | SimpleControllerClientBuilder.DiscoveryClient: Burst/QPS設定 | E-15 (L88-89) | ○ |
| C-56 | NewDynamicClientBuilder: 初期化 | E-16 (L79-90) | ○ |
| C-57 | getOrCreateServiceAccount: 既存SA取得 | E-16 (L248-251) | ○ |
| C-58 | getOrCreateServiceAccount: 新規SA作成 | E-16 (L264-265) | ○ |
| C-59 | getOrCreateServiceAccount: 名前空間自動作成 | E-16 (L258-262) | ○ |
| C-60 | getOrCreateServiceAccount: エラー伝播 | E-16 (L252-254) | ○ |
| C-61 | getOrCreateServiceAccount: AlreadyExists再取得 | E-16 (L266-268) | ○ |
| C-62 | tokenSourceImpl.Token: 正常系トークン取得 | E-16 (L187-234) | ○ |
| C-63 | tokenSourceImpl.Token: リトライ失敗エラー | E-16 (L190-213) | ○ |
| C-64 | tokenSourceImpl.Token: 10分最小有効期間 | E-16 (L221-224) | ○ |
| C-65 | tokenSourceImpl.Token: ExpirationSeconds nil | E-16 (L216-218) | △ |
| C-66 | constructClient: UserAgent設定 | E-16 (L236-245) | ○ |
| C-67 | constructClient: シャローコピー | E-16 (L242-243) | ○ |
| C-68 | informerFactory.ForResource: typed取得 | E-17 (L36-42) | ○ |
| C-69 | informerFactory.ForResource: metadataフォールバック | E-17 (L38-39) | ○ |
| C-70 | NewInformerFactory: ファクトリ生成 | E-17 (L51-56) | ○ |
| C-71 | informerFactory.Start: 両方開始 | E-17 (L44-47) | ○ |
| C-72 | SetupCurrentKubernetesSpecificFeatureGates: 登録 | E-18 (L45-47) | ○ |
| C-73 | DynamicControllerClientBuilder.Config: RoundTripperキャッシュ | E-16 (L117-130) | ○ |
| C-74 | MutableHealthzHandler: チェック追加後ハンドラ更新 | E-14 (L58-60) | △ |
| C-75 | NewBaseHandler: muxに登録される正確なパス一覧 | E-02 | △ |
| C-76 | tokenSourceImpl.Token: leewayPercent計算の正確性 | E-16 (L226-227) | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: runtime.SetBlockProfileRateの呼び出し確認はGoランタイムの状態変更であり、単体テストでの検証が困難
  - 候補：インテグレーションテスト / E2Eテスト / ランタイム状態のモック
- C-65: ExpirationSecondsがnilとなるケースは、TokenRequestのレスポンスがAPI仕様に反する場合に限定されるため、実際の発生頻度が不明
  - 候補：Kubernetes API仕様書 / TokenRequest APIのドキュメント
- C-74: MutableHealthzHandlerのハンドラ動的更新は、ServeHTTPの呼び出しタイミングとAddHealthCheckerの並行性に依存
  - 候補：既存テスト handler_test.go の内容確認
- C-75: NewBaseHandlerが登録する正確なパス一覧は、routes.Profiling{}.Install, configz.InstallHandler等の内部実装に依存
  - 候補：各Install関数の実装確認
- C-76: leewayPercentの計算ロジック（整数除算の精度）についてはコード上は正しいが、エッジケースの確認が必要
  - 候補：既存テスト / leewayPercent=0, 100のケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IsControllerEnabled, Enabled, Validate系のテストケースはソースコードとの直接的な対応が明確
- 0: 低リスク - DebuggingOptions, LeaderMigrationOptions のnilレシーバテストはコード上のnilチェックと完全に対応
- 1: 中リスク - DynamicControllerClientBuilder関連のテストは外部依存（Kubernetes API）が大きく、モック設計が重要
- 1: 中リスク - tokenSourceImpl.Tokenのバックオフ・リトライテストはタイミング依存の可能性あり
- 0: 低リスク - healthz, informerfactory関連のテストは構造がシンプルで信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] IsControllerEnabled（UT-CTM-001〜009）のテストケースがソースコードの全分岐をカバーしているか
- [ ] GenericOptions.Validate（UT-CTM-029〜036）のResourceLock/Controllersバリデーションが漏れなくテストされているか
- [ ] NewLeaderMigrator（UT-CTM-038〜043）のFilterFuncが3種類のFilterResult全てをカバーしているか
- [ ] ValidateLeaderMigrationConfiguration（UT-CTM-048〜055）がネストされたControllerLeaderConfigurationのバリデーションを網羅しているか
- [ ] DynamicControllerClientBuilder関連（UT-CTM-083〜104）のモック設計が実運用シナリオを適切に再現するか
- [ ] tokenSourceImpl.Token（UT-CTM-090〜093）の時刻依存テストが安定して実行可能か
- [ ] MutableHealthzHandler（UT-CTM-069〜075）の並行安全性テストが含まれているか確認
