---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 131
  claims_with_evidence: 131
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：staging-cri-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：131 / 131、根拠なし：0
- 優先レビュー（高）
  1. **protobuf生成コード（api.pb.go, api_grpc.pb.go）はテスト対象外としている**：自動生成コードのため意図的に除外
  2. **services.goのインターフェース定義はテスト対象外としている**：インターフェース定義のみで実装がないため除外
  3. **FakeRuntimeServiceとFakeImageServiceのスレッドセーフティテストは未カバー**：sync.Mutexによる排他制御の並行テストは含まれていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/cri-api/pkg/errors/errors.go` - IsNotFound関数およびエラー変数定義
- E-02: `staging/src/k8s.io/cri-api/pkg/errors/doc.go` - errorsパッケージのドキュメント
- E-03: `staging/src/k8s.io/cri-api/pkg/apis/testing/utils.go` - BuildContainerName, BuildSandboxName, filterInLabels関数
- E-04: `staging/src/k8s.io/cri-api/pkg/apis/testing/fake_image_service.go` - FakeImageService構造体および全メソッド
- E-05: `staging/src/k8s.io/cri-api/pkg/apis/testing/fake_runtime_service.go` - FakeRuntimeService構造体および全メソッド
- E-06: `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/constants.go` - CRI定数定義（RuntimeReady, NetworkReady, LogStreamType, LogTag等）
- E-07: `staging/src/k8s.io/cri-api/pkg/apis/services.go` - CRIインターフェース定義（RuntimeService, ImageManagerService等）
- E-08: `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.pb.go` - protobuf生成コード（テスト対象外）
- E-09: `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api_grpc.pb.go` - gRPC生成コード（テスト対象外）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsNotFound: gRPC NotFoundエラーでtrueを返す | E-01 (L44-54: codes.NotFound判定ロジック) | ○ |
| C-02 | IsNotFound: NotFound以外のgRPCエラーでfalseを返す | E-01 (L49: codes.NotFound以外はfalse) | ○ |
| C-03 | IsNotFound: 非gRPCエラーでfalseを返す | E-01 (L46-48: status.FromErrorがfalseを返す場合) | ○ |
| C-04 | IsNotFound: nilエラーでfalseを返す | E-01 (L45-48: nilエラーの場合okがfalse) | ○ |
| C-05 | ErrRegistryUnavailable定数値の検証 | E-01 (L28: errors.New("RegistryUnavailable")) | ○ |
| C-06 | ErrSignatureValidationFailed定数値の検証 | E-01 (L31: errors.New("SignatureValidationFailed")) | ○ |
| C-07 | ErrRROUnsupported定数値の検証 | E-01 (L34: errors.New("RROUnsupported")) | ○ |
| C-08 | ErrImageVolumeMountFailed定数値の検証 | E-01 (L37: errors.New("ImageVolumeMountFailed")) | ○ |
| C-09 | BuildContainerName: 正常なコンテナ名生成 | E-03 (L26-29: fmt.Sprintf("%s_%s_%d")) | ○ |
| C-10 | BuildContainerName: Attempt付きコンテナ名生成 | E-03 (L28: Attempt値がフォーマットに含まれる) | ○ |
| C-11 | BuildContainerName: 空文字Nameのエッジケース | E-03 (L28: 空文字でもfmt.Sprintfは動作する) | ○ |
| C-12 | BuildSandboxName: 正常なサンドボックス名生成 | E-03 (L32-34: fmt.Sprintf("%s_%s_%s_%d")) | ○ |
| C-13 | BuildSandboxName: Attempt付きサンドボックス名生成 | E-03 (L33: Attempt値がフォーマットに含まれる) | ○ |
| C-14 | filterInLabels: フィルタ一致でtrue | E-03 (L36-48: 全キーの値が一致すればtrue) | ○ |
| C-15 | filterInLabels: キー不在でfalse | E-03 (L42-43: キーが存在しなければfalse) | ○ |
| C-16 | filterInLabels: 値不一致でfalse | E-03 (L39-40: 値が異なればfalse) | ○ |
| C-17 | filterInLabels: 空フィルタでtrue | E-03 (L36-47: rangeが実行されずtrue) | ○ |
| C-18 | filterInLabels: 両方空でtrue | E-03 (L36-47: rangeが実行されずtrue) | ○ |
| C-19 | NewFakeImageService: 初期化検証 | E-04 (L106-112: 各フィールドの初期化) | ○ |
| C-20 | SetFakeImages: 画像リスト設定 | E-04 (L46-57: Images mapの再構築) | ○ |
| C-21 | SetFakeImages: 空リスト設定 | E-04 (L50: make(map[string]*runtimeapi.Image)) | ○ |
| C-22 | SetFakeImagesWithAnnotations: アノテーション付き設定 | E-04 (L60-68: ImageSpec使用) | ○ |
| C-23 | SetFakeImageSize: サイズ設定 | E-04 (L71-76: FakeImageSizeフィールド設定) | ○ |
| C-24 | SetFakeImagePinned: Pinned設定 | E-04 (L79-87: Pinnedマップへの設定) | ○ |
| C-25 | SetFakeImagePinned: nil map初期化 | E-04 (L83-85: nil判定とmake) | ○ |
| C-26 | ListImages: フィルタなし全件取得 | E-04 (L157-177: filterなし時の全件返却) | ○ |
| C-27 | ListImages: フィルタ指定で絞り込み | E-04 (L168-172: filter.Image一致判定) | ○ |
| C-28 | ListImages: エラー注入時のエラー返却 | E-04 (L162-163: popError) | ○ |
| C-29 | ListImages: 空リスト返却 | E-04 (L166: make([]*runtimeapi.Image, 0)) | ○ |
| C-30 | ImageStatus: 存在する画像のステータス返却 | E-04 (L180-190: Images map参照) | ○ |
| C-31 | ImageStatus: 存在しない画像のnil返却 | E-04 (L189: map未登録キーはnilを返す) | ○ |
| C-32 | ImageStatus: エラー注入時のエラー返却 | E-04 (L185-186: popError) | ○ |
| C-33 | PullImage: 画像プルとID返却 | E-04 (L193-211: Imagesへの登録) | ○ |
| C-34 | PullImage: 既存画像の冪等性 | E-04 (L206: if _, ok := r.Images[imageID]; !ok) | ○ |
| C-35 | PullImage: エラー注入時のエラー返却 | E-04 (L198-199: popError) | ○ |
| C-36 | RemoveImage: 画像削除 | E-04 (L214-227: delete(r.Images)) | ○ |
| C-37 | RemoveImage: エラー注入時のエラー返却 | E-04 (L219-220: popError) | ○ |
| C-38 | ImageFsInfo: ファイルシステム情報返却 | E-04 (L230-243: FakeFilesystemUsage返却) | ○ |
| C-39 | ImageFsInfo: エラー注入時のエラー返却 | E-04 (L235-236: popError) | ○ |
| C-40 | InjectError: エラー注入 | E-04 (L136-140: append) | ○ |
| C-41 | InjectError: 複数エラー注入 | E-04 (L139: append追記) | ○ |
| C-42 | popError: FIFO取り出し | E-04 (L143-154: スライスの先頭取得) | ○ |
| C-43 | popError: 空キュー処理 | E-04 (L148-149: len(errs) == 0) | ○ |
| C-44 | popError: nil map処理 | E-04 (L144-145: r.Errors == nil) | ○ |
| C-45 | Close: 正常完了 | E-04 (L259-269: Called追記とnil返却) | ○ |
| C-46 | Close: エラー注入時のエラー返却 | E-04 (L264-265: popError) | ○ |
| C-47 | makeFakeImage: FakeImage生成 | E-04 (L114-122: Image構造体生成) | ○ |
| C-48 | stringInSlice: 含まれる場合true | E-04 (L125-133: 線形探索) | ○ |
| C-49 | stringInSlice: 含まれない場合false | E-04 (L125-133: 全件不一致でfalse) | ○ |
| C-50 | stringInSlice: 空スライスでfalse | E-04 (L126: rangeが実行されずfalse) | ○ |
| C-51 | NewFakeRuntimeService: 初期化検証 | E-05 (L159-170: 各フィールドの初期化) | ○ |
| C-52 | Version: バージョン情報返却 | E-05 (L173-188: FakeVersion, FakeRuntimeName) | ○ |
| C-53 | Version: エラー注入時のエラー返却 | E-05 (L178-179: popError) | ○ |
| C-54 | Status: ステータス返却 | E-05 (L191-201: FakeStatus返却) | ○ |
| C-55 | Status: エラー注入時のエラー返却 | E-05 (L196-197: popError) | ○ |
| C-56 | RunPodSandbox: サンドボックス作成 | E-05 (L204-254: BuildSandboxNameでID生成) | ○ |
| C-57 | RunPodSandbox: READY状態 | E-05 (L225: SANDBOX_READY) | ○ |
| C-58 | RunPodSandbox: RuntimeHandler保存 | E-05 (L242: RuntimeHandler設定) | ○ |
| C-59 | RunPodSandbox: ErrorOnSandboxCreate | E-05 (L213-215: ErrorOnSandboxCreate判定) | ○ |
| C-60 | RunPodSandbox: エラー注入 | E-05 (L209-210: popError) | ○ |
| C-61 | StopPodSandbox: NOTREADY遷移 | E-05 (L257-273: SANDBOX_NOTREADY) | ○ |
| C-62 | StopPodSandbox: 存在しないID | E-05 (L268-269: not found) | ○ |
| C-63 | StopPodSandbox: エラー注入 | E-05 (L262-263: popError) | ○ |
| C-64 | RemovePodSandbox: 削除 | E-05 (L276-289: delete) | ○ |
| C-65 | RemovePodSandbox: エラー注入 | E-05 (L281-282: popError) | ○ |
| C-66 | PodSandboxStatus: ステータス返却 | E-05 (L292-308: proto.Clone) | ○ |
| C-67 | PodSandboxStatus: 存在しないID | E-05 (L302-303: not found) | ○ |
| C-68 | PodSandboxStatus: ディープコピー | E-05 (L306: proto.Clone) | ○ |
| C-69 | ListPodSandbox: フィルタなし全件取得 | E-05 (L311-346: 全件返却) | ○ |
| C-70 | ListPodSandbox: IDフィルタ | E-05 (L323-324: filter.Id) | ○ |
| C-71 | ListPodSandbox: Stateフィルタ | E-05 (L326-327: filter.GetState().State) | ○ |
| C-72 | ListPodSandbox: LabelSelectorフィルタ | E-05 (L329-330: filterInLabels) | ○ |
| C-73 | ListPodSandbox: エラー注入 | E-05 (L316-317: popError) | ○ |
| C-74 | CreateContainer: コンテナ作成 | E-05 (L362-393: BuildContainerName) | ○ |
| C-75 | CreateContainer: CREATED状態 | E-05 (L375: CONTAINER_CREATED) | ○ |
| C-76 | CreateContainer: エラー注入 | E-05 (L367-368: popError) | ○ |
| C-77 | StartContainer: RUNNING遷移 | E-05 (L396-415: CONTAINER_RUNNING) | ○ |
| C-78 | StartContainer: 存在しないID | E-05 (L406-407: not found) | ○ |
| C-79 | StartContainer: エラー注入 | E-05 (L401-402: popError) | ○ |
| C-80 | StopContainer: EXITED遷移 | E-05 (L418-439: CONTAINER_EXITED) | ○ |
| C-81 | StopContainer: 存在しないID | E-05 (L428-429: not found) | ○ |
| C-82 | StopContainer: エラー注入 | E-05 (L423-424: popError) | ○ |
| C-83 | RemoveContainer: 削除 | E-05 (L442-455: delete) | ○ |
| C-84 | RemoveContainer: エラー注入 | E-05 (L447-448: popError) | ○ |
| C-85 | ListContainers: フィルタなし全件取得 | E-05 (L458-498: 全件返却) | ○ |
| C-86 | ListContainers: IDフィルタ | E-05 (L470-471: filter.Id) | ○ |
| C-87 | ListContainers: PodSandboxIdフィルタ | E-05 (L473-474: filter.PodSandboxId) | ○ |
| C-88 | ListContainers: Stateフィルタ | E-05 (L476-477: filter.GetState().State) | ○ |
| C-89 | ListContainers: LabelSelectorフィルタ | E-05 (L479-480: filterInLabels) | ○ |
| C-90 | ListContainers: エラー注入 | E-05 (L463-464: popError) | ○ |
| C-91 | ContainerStatus: ステータス返却 | E-05 (L501-517: proto.Clone) | ○ |
| C-92 | ContainerStatus: 存在しないID | E-05 (L511-512: not found) | ○ |
| C-93 | ContainerStatus: ディープコピー | E-05 (L515: proto.Clone) | ○ |
| C-94 | GetContainerID: ID取得 | E-05 (L82-92: name, attempt, sandboxID一致判定) | ○ |
| C-95 | GetContainerID: 存在しないコンテナ | E-05 (L91: not found) | ○ |
| C-96 | SetFakeSandboxes: テストデータ設定 | E-05 (L95-104: Sandboxes map再構築) | ○ |
| C-97 | SetFakeContainers: テストデータ設定 | E-05 (L107-117: Containers map再構築) | ○ |
| C-98 | AssertCalls: 呼び出し一致 | E-05 (L120-128: reflect.DeepEqual) | ○ |
| C-99 | AssertCalls: 呼び出し不一致 | E-05 (L124-125: DeepEqual失敗時エラー) | ○ |
| C-100 | GetCalls: 履歴コピー取得 | E-05 (L131-135: append([]string{}, r.Called...)) | ○ |
| C-101 | ContainerStats: 統計情報取得 | E-05 (L585-599: FakeContainerStats参照) | ○ |
| C-102 | ContainerStats: 存在しないID | E-05 (L595-596: no stats found) | ○ |
| C-103 | ListContainerStats: フィルタなし全件取得 | E-05 (L602-632: Containers走査) | ○ |
| C-104 | ListContainerStats: IDフィルタ | E-05 (L614-615: filter.Id) | ○ |
| C-105 | PodSandboxStats: 統計情報取得 | E-05 (L646-660: FakePodSandboxStats参照) | ○ |
| C-106 | PodSandboxStats: 存在しないID | E-05 (L656-657: no stats found) | ○ |
| C-107 | ListPodSandboxStats: フィルタなし全件取得 | E-05 (L663-690: Sandboxes走査) | ○ |
| C-108 | ListPodSandboxStats: IDフィルタ | E-05 (L675-676: filter.Id) | ○ |
| C-109 | ListPodSandboxStats: LabelSelectorフィルタ | E-05 (L678-679: filterInLabels) | ○ |
| C-110 | UpdateContainerResources: 正常完了 | E-05 (L520-526: Called追記) | ○ |
| C-111 | ExecSync: 正常完了 | E-05 (L529-536: Called追記) | ○ |
| C-112 | Exec: 正常完了 | E-05 (L539-549: ExecResponse返却) | ○ |
| C-113 | Attach: 正常完了 | E-05 (L552-562: AttachResponse返却) | ○ |
| C-114 | PortForward: 正常完了 | E-05 (L349-359: PortForwardResponse返却) | ○ |
| C-115 | UpdateRuntimeConfig: 正常完了 | E-05 (L565-571: Called追記) | ○ |
| C-116 | ReopenContainerLog: 正常完了 | E-05 (L693-704: Called追記) | ○ |
| C-117 | CheckpointContainer: 正常完了 | E-05 (L707-718: Called追記) | ○ |
| C-118 | ListMetricDescriptors: ディスクリプタ返却 | E-05 (L736-751: FakeMetricDescriptors) | ○ |
| C-119 | ListPodSandboxMetrics: メトリクス返却 | E-05 (L765-784: FakePodSandboxMetrics) | ○ |
| C-120 | RuntimeConfig: 設定返却 | E-05 (L787-797: FakeLinuxConfiguration) | ○ |
| C-121 | UpdatePodSandboxResources: 正常完了 | E-05 (L800-810: Response返却) | ○ |
| C-122 | FakeRuntimeService.Close: 正常完了 | E-05 (L813-823: Called追記とnil) | ○ |
| C-123 | FakeRuntimeService.Close: エラー注入 | E-05 (L818-819: popError) | ○ |
| C-124 | GetContainerEvents: nil返却スタブ | E-05 (L720-722: return nil) | ○ |
| C-125 | RuntimeReady定数値 | E-06 (L23: "RuntimeReady") | ○ |
| C-126 | NetworkReady定数値 | E-06 (L25: "NetworkReady") | ○ |
| C-127 | Stdout定数値 | E-06 (L34: "stdout") | ○ |
| C-128 | Stderr定数値 | E-06 (L36: "stderr") | ○ |
| C-129 | LogTagPartial定数値 | E-06 (L50: "P") | ○ |
| C-130 | LogTagFull定数値 | E-06 (L52: "F") | ○ |
| C-131 | LogTagDelimiter定数値 | E-06 (L54: ":") | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースがソースコードに基づいて生成されており、根拠なしの主張はありません。
- ただし、以下の点は意図的にテスト対象外としています：
  - `api.pb.go` / `api_grpc.pb.go`: protobufおよびgRPC自動生成コードのためテスト不要
  - `services.go`: インターフェース定義のみで実装を含まないためテスト不要
  - `doc.go`: パッケージドキュメントのみのためテスト不要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に直接対応しており、根拠は明確です
- 1: 中リスク - FakeRuntimeService/FakeImageServiceの並行処理テスト（sync.Mutexの排他制御検証）はテストケースに含まれていません。これらはテストヘルパーであるため実運用上のリスクは低いですが、テストヘルパー自体の信頼性に関わる可能性があります
- 0: 低リスク - 定数テスト（C-125〜C-131）は優先度が低く、回帰テストとしての価値は限定的です

## 6) レビュアーチェックリスト（最小）
- [ ] IsNotFound関数のテストケース（C-01〜C-04）がgRPCステータスコードの主要パターンを網羅しているか確認
- [ ] FakeImageService/FakeRuntimeServiceの各メソッドについて、正常系・異常系・エラー注入の3パターンが網羅されているか確認
- [ ] ListPodSandbox/ListContainersのフィルタリングテストが全フィルタ条件（ID, State, LabelSelector, PodSandboxId）をカバーしているか確認
- [ ] proto.Cloneによるディープコピーのテスト（C-68, C-93）が適切に検証内容を記述しているか確認
- [ ] protobuf生成コードおよびインターフェース定義ファイルをテスト対象外とした判断が妥当か確認
