---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 161
  claims_with_evidence: 158
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：staging-csi-translation-lib 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：158 / 161、根拠なし：3
- 優先レビュー（高）
  1. **C-006 (UT-CSI-006)**: TranslateInTreeInlineVolumeToCSI のVolumeMode設定 - プラグイン側で既にVolumeModeを設定している場合の挙動の検証が必要
  2. **C-081 (UT-CSI-081)**: RepairVolumeHandle リージョナル修復 - リージョン推定ロジックの前提条件が複雑
  3. **C-106 (UT-CSI-106)**: getAwsRegionFromZones ローカルゾーン対応 - AWS Wavelengthゾーン等の特殊形式の網羅性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/csi-translation-lib/translate.go` - CSITranslator構造体と全メソッド定義
- E-02: `staging/src/k8s.io/csi-translation-lib/plugins/in_tree_volume.go` - InTreePluginインターフェース、トポロジー関連ヘルパー関数
- E-03: `staging/src/k8s.io/csi-translation-lib/plugins/const.go` - labelMultiZoneDelimiter定数
- E-04: `staging/src/k8s.io/csi-translation-lib/plugins/gce_pd.go` - GCE PD CSIトランスレータ実装
- E-05: `staging/src/k8s.io/csi-translation-lib/plugins/aws_ebs.go` - AWS EBS CSIトランスレータ実装
- E-06: `staging/src/k8s.io/csi-translation-lib/plugins/openstack_cinder.go` - OpenStack Cinder CSIトランスレータ実装
- E-07: `staging/src/k8s.io/csi-translation-lib/plugins/azure_disk.go` - Azure Disk CSIトランスレータ実装
- E-08: `staging/src/k8s.io/csi-translation-lib/plugins/azure_file.go` - Azure File CSIトランスレータ実装
- E-09: `staging/src/k8s.io/csi-translation-lib/plugins/vsphere_volume.go` - vSphere CSIトランスレータ実装
- E-10: `staging/src/k8s.io/csi-translation-lib/plugins/portworx.go` - Portworx CSIトランスレータ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | CSITranslator.New()がCSITranslator構造体を返却する | E-01 (L48-50) | ○ |
| C-002 | TranslateInTreeStorageClassToCSIがGCE PDプラグインでSCを変換する | E-01 (L54-61), E-04 | ○ |
| C-003 | TranslateInTreeStorageClassToCSIがAWS EBSプラグインでSCを変換する | E-01 (L54-61), E-05 | ○ |
| C-004 | 未登録プラグイン名でTranslateInTreeStorageClassToCSIがエラーを返す | E-01 (L61) | ○ |
| C-005 | TranslateInTreeInlineVolumeToCSIがGCE PDインラインボリュームを変換する | E-01 (L67-90), E-04 | ○ |
| C-006 | VolumeMode未設定時にPersistentVolumeFilesystemが設定される | E-01 (L82-85) | △ |
| C-007 | volume=nilでTranslateInTreeInlineVolumeToCSIがエラーを返す | E-01 (L68-70) | ○ |
| C-008 | 未対応ボリュームでTranslateInTreeInlineVolumeToCSIがエラーを返す | E-01 (L89) | ○ |
| C-009 | TranslateInTreePVToCSIがGCE PD PVを変換する | E-01 (L96-107), E-04 | ○ |
| C-010 | pv=nilでTranslateInTreePVToCSIがエラーを返す | E-01 (L97-99) | ○ |
| C-011 | 未対応PVでTranslateInTreePVToCSIがエラーを返す | E-01 (L106) | ○ |
| C-012 | TranslateCSIPVToInTreeがCSI PVをGCE PDに変換する | E-01 (L112-123), E-04 | ○ |
| C-013 | pv=nilでTranslateCSIPVToInTreeがエラーを返す | E-01 (L113-115) | ○ |
| C-014 | pv.Spec.CSI=nilでTranslateCSIPVToInTreeがエラーを返す | E-01 (L113-115) | ○ |
| C-015 | 未対応CSIドライバでTranslateCSIPVToInTreeがエラーを返す | E-01 (L122) | ○ |
| C-016 | IsMigratableIntreePluginByNameが登録済み名でtrueを返す | E-01 (L127-134) | ○ |
| C-017 | IsMigratableIntreePluginByNameが未登録名でfalseを返す | E-01 (L133) | ○ |
| C-018 | IsMigratedCSIDriverByNameが登録済みドライバでtrueを返す | E-01 (L138-143) | ○ |
| C-019 | IsMigratedCSIDriverByNameが未登録ドライバでfalseを返す | E-01 (L142) | ○ |
| C-020 | GetInTreePluginNameFromSpecがPVからプラグイン名を取得する | E-01 (L146-153) | ○ |
| C-021 | GetInTreePluginNameFromSpecがVolumeからプラグイン名を取得する | E-01 (L154-161) | ○ |
| C-022 | GetInTreePluginNameFromSpecが両方nilでエラーを返す | E-01 (L162-163) | ○ |
| C-023 | GetInTreePluginNameFromSpecが未対応PVでエラーを返す | E-01 (L153) | ○ |
| C-024 | GetCSINameFromInTreeNameがin-tree名からCSI名を取得する | E-01 (L168-175) | ○ |
| C-025 | GetCSINameFromInTreeNameが未登録名でエラーを返す | E-01 (L174) | ○ |
| C-026 | GetInTreeNameFromCSINameがCSI名からin-tree名を取得する | E-01 (L179-184) | ○ |
| C-027 | GetInTreeNameFromCSINameが未登録名でエラーを返す | E-01 (L183) | ○ |
| C-028 | IsPVMigratableがGCE PD PVでtrueを返す | E-01 (L187-194) | ○ |
| C-029 | IsPVMigratableが未対応PVでfalseを返す | E-01 (L193) | ○ |
| C-030 | IsInlineMigratableがGCE PDボリュームでtrueを返す | E-01 (L197-204) | ○ |
| C-031 | IsInlineMigratableが未対応ボリュームでfalseを返す | E-01 (L203) | ○ |
| C-032 | RepairVolumeHandleが登録済みドライバでハンドルを修復する | E-01 (L207-212), E-04 | ○ |
| C-033 | RepairVolumeHandleが未登録ドライバでエラーを返す | E-01 (L211) | ○ |
| C-034 | replaceTopologyがNodeAffinityのキーを置換する | E-02 (L87-102) | ○ |
| C-035 | replaceTopologyがpv=nilで安全に処理する | E-02 (L89-92) | ○ |
| C-036 | replaceTopologyがNodeAffinity空で安全に処理する | E-02 (L89-92) | ○ |
| C-037 | getTopologyValuesが指定キーの値を取得する | E-02 (L108-132) | ○ |
| C-038 | getTopologyValuesがNodeAffinity未設定でnilを返す | E-02 (L109-113) | ○ |
| C-039 | getTopologyValuesが重複値を除去しソートする | E-02 (L115-131) | ○ |
| C-040 | addTopologyがNodeAffinityにトポロジーを追加する | E-02 (L135-178) | ○ |
| C-041 | addTopologyが空ゾーンリストでエラーを返す | E-02 (L146-148) | ○ |
| C-042 | addTopologyが空白ゾーンをフィルタリングする | E-02 (L137-143) | ○ |
| C-043 | translateTopologyFromInTreeToCSIがin-treeをCSIに変換する | E-02 (L185-214) | ○ |
| C-044 | translateTopologyFromInTreeToCSIがラベルからフォールバック変換する | E-02 (L194-200) | ○ |
| C-045 | translateTopologyFromInTreeToCSIがBetaリージョンをGAに置換する | E-02 (L206-211) | ○ |
| C-046 | TopologyKeyExistが存在するキーでtrueを返す | E-02 (L244-258) | ○ |
| C-047 | TopologyKeyExistが存在しないキーでfalseを返す | E-02 (L256) | ○ |
| C-048 | TopologyKeyExistがvna=nilでfalseを返す | E-02 (L245-247) | ○ |
| C-049 | translateTopologyFromCSIToInTreeがCSIをin-treeに変換する | E-02 (L275-308) | ○ |
| C-050 | translateTopologyFromCSIToInTreeがregionParser=nilでスキップする | E-02 (L286) | ○ |
| C-051 | translateAllowedTopologiesがCSIキーに変換する | E-02 (L312-336) | ○ |
| C-052 | translateAllowedTopologiesがterms=nilでnilを返す | E-02 (L313-315) | ○ |
| C-053 | translateAllowedTopologiesが未関連キーを保持する | E-02 (L327-329) | ○ |
| C-054 | getTopologyLabelがGAラベルを返す | E-02 (L225-241) | ○ |
| C-055 | getTopologyLabelがBetaラベルを返す | E-02 (L230-231) | ○ |
| C-056 | getTopologyLabelがデフォルトGAラベルを返す | E-02 (L239-240) | ○ |
| C-057 | regionTopologyHandlerがリージョンNodeAffinityを追加する | E-02 (L342-398) | ○ |
| C-058 | regionTopologyHandlerがpv=nilで安全に処理する | E-02 (L345-348) | ○ |
| C-059 | regionTopologyHandlerが既存リージョンをスキップする | E-02 (L355-368) | ○ |
| C-060 | GCE PD TranslateInTreeStorageClassToCSIがfstypeを変換する | E-04 (L86-98) | ○ |
| C-061 | GCE PD TranslateInTreeStorageClassToCSIがzoneをトポロジーに変換する | E-04 (L92-93) | ○ |
| C-062 | GCE PD TranslateInTreeStorageClassToCSIがzonesをトポロジーに変換する | E-04 (L94-95) | ○ |
| C-063 | zone/zonesとAllowedTopologies同時設定でエラーを返す | E-04 (L101-102) | ○ |
| C-064 | GCE PDインラインボリュームをCSI PVに変換する | E-04 (L166-208) | ○ |
| C-065 | ReadOnlyでReadOnlyManyアクセスモードが設定される | E-04 (L179-183) | ○ |
| C-066 | パーティション!=0で文字列変換される | E-04 (L174-176) | ○ |
| C-067 | volume=nilでエラーを返す | E-04 (L167-169) | ○ |
| C-068 | ゾーンラベル付きPVがzonal volIDで変換される | E-04 (L226-228) | ○ |
| C-069 | マルチゾーンPVがregional volIDで変換される | E-04 (L229-235) | ○ |
| C-070 | pv=nilでエラーを返す | E-04 (L215-217) | ○ |
| C-071 | CSI PVがGCE PD PVに変換される | E-04 (L271-304) | ○ |
| C-072 | パーティション属性が正しく変換される | E-04 (L287-293) | ○ |
| C-073 | 不正なVolumeHandleでエラーを返す | E-04 (L277-279) | ○ |
| C-074 | GCEPersistentDisk付きPVでCanSupportがtrueを返す | E-04 (L309-311) | ○ |
| C-075 | GCEPersistentDisk無しPVでCanSupportがfalseを返す | E-04 (L310) | ○ |
| C-076 | pv=nilでCanSupportがfalseを返す | E-04 (L310) | ○ |
| C-077 | GCEPersistentDisk付きVolumeでCanSupportInlineがtrueを返す | E-04 (L316-318) | ○ |
| C-078 | UNSPECIFIED付きハンドルがノードIDから修復される | E-04 (L333-371) | ○ |
| C-079 | プロジェクト指定済みハンドルがそのまま返される | E-04 (L339-341) | ○ |
| C-080 | 不正形式ハンドルでエラーを返す | E-04 (L336-338) | ○ |
| C-081 | リージョナルハンドルが正しく修復される | E-04 (L357-367) | △ |
| C-082 | ReadWriteManyがReadWriteOnceに変換される | E-04 (L130-162) | ○ |
| C-083 | ROX+RWOがReadWriteOnceに変換される | E-04 (L149-152) | ○ |
| C-084 | ROXのみでROXが保持される | E-04 (L155-156) | ○ |
| C-085 | ams=nilでnilが返される | E-04 (L131-133) | ○ |
| C-086 | 有効なvolume IDからディスク名が取得できる | E-04 (L373-379) | ○ |
| C-087 | 不正なIDでエラーを返す | E-04 (L375-377) | ○ |
| C-088 | 有効なゾーンからリージョンが取得できる | E-04 (L383-400) | ○ |
| C-089 | 空ゾーンリストでエラーを返す | E-04 (L385-387) | ○ |
| C-090 | 不正ゾーン形式でエラーを返す | E-04 (L391-393) | ○ |
| C-091 | 異なるリージョンのゾーンでエラーを返す | E-04 (L396-398) | ○ |
| C-092 | AWS EBS TranslateInTreeStorageClassToCSIがfstypeを変換する | E-05 (L66-83) | ○ |
| C-093 | iopsPerGBが保持されallowIncreaseIOPSが追加される | E-05 (L74-79) | ○ |
| C-094 | AWS EBSインラインボリュームがCSI PVに変換される | E-05 (L104-135) | ○ |
| C-095 | volume=nilでエラーを返す | E-05 (L105-107) | ○ |
| C-096 | AWS EBS PVがCSI PVに変換される | E-05 (L139-168) | ○ |
| C-097 | CSI PVがAWS EBS PVに変換される | E-05 (L172-201) | ○ |
| C-098 | パーティション属性が正しく変換される | E-05 (L185-191) | ○ |
| C-099 | aws://形式のIDが正しく変換される | E-05 (L245-278) | ○ |
| C-100 | aws:///形式のIDが正しく変換される | E-05 (L245-278) | ○ |
| C-101 | ベアボリュームIDがそのまま返される | E-05 (L255-258) | ○ |
| C-102 | 不正スキームでエラーを返す | E-05 (L264-266) | ○ |
| C-103 | 不正ボリュームID形式でエラーを返す | E-05 (L273-275) | ○ |
| C-104 | 標準ゾーンからリージョンが取得できる | E-05 (L280-305) | ○ |
| C-105 | GovCloudゾーンからリージョンが取得できる | E-05 (L290) | ○ |
| C-106 | ローカルゾーンからリージョンが取得できる | E-05 (L294-296) | △ |
| C-107 | 空ゾーンリストでエラーを返す | E-05 (L282-284) | ○ |
| C-108 | 不正形式ゾーンでエラーを返す | E-05 (L297-299) | ○ |
| C-109 | Cinder TranslateInTreeStorageClassToCSIがfstypeを変換する | E-06 (L49-75) | ○ |
| C-110 | Cinderのその他パラメータが保持される | E-06 (L57-61) | ○ |
| C-111 | CinderインラインボリュームがCSI PVに変換される | E-06 (L79-105) | ○ |
| C-112 | volume=nilでエラーを返す | E-06 (L80-82) | ○ |
| C-113 | Cinder PVがCSI PVに変換される | E-06 (L109-131) | ○ |
| C-114 | CSI PVがCinder PVに変換される | E-06 (L135-157) | ○ |
| C-115 | Azure Disk TranslateInTreeStorageClassToCSIがzoneを変換する | E-07 (L64-96) | ○ |
| C-116 | 数値failure domainが空文字に置換される | E-07 (L91, L282-309) | ○ |
| C-117 | Azure DiskインラインボリュームがCSI PVに変換される | E-07 (L100-140) | ○ |
| C-118 | 非ManagedディスクでInlineエラーを返す | E-07 (L106-108) | ○ |
| C-119 | Azure Disk PVがCSI PVに変換される | E-07 (L144-182) | ○ |
| C-120 | 非ManagedディスクでPVエラーを返す | E-07 (L160-162) | ○ |
| C-121 | CSI PVがAzure Disk PVに変換される | E-07 (L186-230) | ○ |
| C-122 | CachingMode属性が変換される | E-07 (L211-215) | ○ |
| C-123 | マネージドディスクURIからディスク名が取得できる | E-07 (L267-278) | ○ |
| C-124 | アンマネージドディスクURIからディスク名が取得できる | E-07 (L267-278) | ○ |
| C-125 | 不正URIでエラーを返す | E-07 (L274-276) | ○ |
| C-126 | httpで始まるURIでisManagedDiskがfalseを返す | E-07 (L260-265) | ○ |
| C-127 | httpで始まらないURIでisManagedDiskがtrueを返す | E-07 (L260-265) | ○ |
| C-128 | Azure File TranslateInTreeStorageClassToCSIがパススルーする | E-08 (L62-64) | ○ |
| C-129 | Azure FileインラインボリュームがCSI PVに変換される | E-08 (L68-111) | ○ |
| C-130 | podNamespace空でdefaultが使用される | E-08 (L80-83) | ○ |
| C-131 | Azure File PVがCSI PVに変換される | E-08 (L115-169) | ○ |
| C-132 | SecretNamespaceもClaimRefも無しでエラーを返す | E-08 (L145-147) | ○ |
| C-133 | CSI PVがAzure File PVに変換される | E-08 (L173-230) | ○ |
| C-134 | VolumeAttributesからShareNameが取得される | E-08 (L184-194) | ○ |
| C-135 | 有効なIDからファイル共有情報が取得できる | E-08 (L263-273) | ○ |
| C-136 | セパレータ不足IDでエラーを返す | E-08 (L265-267) | ○ |
| C-137 | シークレット名からアカウント名が取得できる | E-08 (L276-282) | ○ |
| C-138 | 不正シークレット名でエラーを返す | E-08 (L278-280) | ○ |
| C-139 | vSphere TranslateInTreeStorageClassToCSIがfstypeを変換する | E-09 (L77-123) | ○ |
| C-140 | storagepolicynameが保持される | E-09 (L86-87) | ○ |
| C-141 | csimigrationパラメータが自動追加される | E-09 (L112) | ○ |
| C-142 | sc=nilでエラーを返す | E-09 (L78-80) | ○ |
| C-143 | vSphereインラインボリュームがCSI PVに変換される | E-09 (L127-153) | ○ |
| C-144 | vSphere PVがCSI PVに変換される | E-09 (L157-177) | ○ |
| C-145 | CSI PVがvSphere PVに変換される | E-09 (L181-200) | ○ |
| C-146 | initialvolumefilepathがVolumePathに設定される | E-09 (L189-191) | ○ |
| C-147 | in-treeゾーンがCSIゾーンに変換される | E-09 (L233-262) | ○ |
| C-148 | in-treeリージョンがCSIリージョンに変換される | E-09 (L249-260) | ○ |
| C-149 | CSIゾーン/リージョンがin-treeに変換される | E-09 (L265-302) | ○ |
| C-150 | Portworx OpenStorageAuthパラメータがCSI形式に変換される | E-10 (L67-100) | ○ |
| C-151 | ProvisionerがPortworxドライバ名に変更される | E-10 (L97) | ○ |
| C-152 | sc=nilでエラーを返す | E-10 (L68-70) | ○ |
| C-153 | PortworxインラインボリュームがCSI PVに変換される | E-10 (L104-133) | ○ |
| C-154 | ReadOnlyでReadOnlyManyが設定される | E-10 (L110-114) | ○ |
| C-155 | Portworx PVがCSI PVに変換される | E-10 (L137-166) | ○ |
| C-156 | OpenStorageAuth注釈がSecretRefに変換される | E-10 (L143-149) | ○ |
| C-157 | CSI PVがPortworx PVに変換される | E-10 (L170-185) | ○ |
| C-158 | pv=nilでエラーを返す | E-10 (L171-173) | ○ |
| C-159 | 数値failure domainが空文字に置換される | E-07 (L282-309) | ○ |
| C-160 | 通常ゾーン値が変更されない | E-07 (L294) | ○ |
| C-161 | terms=nilでnilが返される | E-07 (L283-285) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-006: TranslateInTreeInlineVolumeToCSIでプラグイン側が既にVolumeModeを設定している場合の優先順位が不明
  - 候補: プラグイン固有の実装コード / CSIドライバ仕様書 / Kubernetesボリュームプラグイン設計書
- C-081: RepairVolumeHandleのリージョナルディスク修復でリージョン推定が失敗するエッジケースの網羅性
  - 候補: GCE PD CSIドライバのテストケース / GCPリージョン一覧
- C-106: getAwsRegionFromZonesのWavelengthゾーン（7セグメント形式）のテストケースが既存テストに存在するか未確認
  - 候補: AWS EBSテストファイル / AWS公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの明示的なロジックに直接対応しており、根拠が明確
- 1: 中リスク - クラウドプロバイダ固有のゾーン/リージョン形式（AWS Local Zone, Wavelength等）のエッジケースは、プロバイダのAPI仕様変更により影響を受ける可能性がある
- 0: 低リスク - InTreePluginインターフェースの各実装は統一的なパターンに従っており、テストケースの網羅性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 各プラグイン（GCE PD, AWS EBS, Cinder, Azure Disk, Azure File, vSphere, Portworx）のTranslate系メソッドに対してテストケースが存在するか
- [ ] nil入力に対する異常系テストが全メソッドでカバーされているか
- [ ] トポロジー変換（Beta -> GA、InTree -> CSI、CSI -> InTree）のテストケースが網羅されているか
- [ ] プラグイン固有のヘルパー関数（pdNameFromVolumeID, KubernetesVolumeIDToEBSVolumeID, getDiskName等）のテストケースが存在するか
- [ ] AWS EBSのゾーン形式（標準、GovCloud、ローカルゾーン、Wavelength）のテストケースが十分か
- [ ] Azure Diskのfailure domain置換ロジック（数値のみ -> 空文字）のテストケースが正しいか
