---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 103
  claims_with_evidence: 103
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：staging-externaljwt 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：103 / 103、根拠なし：0
- 優先レビュー（高）
  1. **自動生成コードの網羅性**: 全ファイルがprotoc-gen-go / protoc-gen-go-grpc による自動生成コードであり、テスト対象範囲が適切か確認推奨
  2. **v1 / v1alpha1 の差異**: 両バージョンはほぼ同一構造だが、gRPCメソッド名のプレフィックスが異なる点（v1 vs v1alpha1）の確認
  3. **境界値テストの仕様根拠**: KeyId <=1024、MaxTokenExpirationSeconds >= 600、RefreshHintSeconds <= 0 は設定ミスの制約はprotoファイルのコメントに基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/externaljwt/apis/v1/api.pb.go` - protobufメッセージ定義（SignJWTRequest, SignJWTResponse, FetchKeysRequest, FetchKeysResponse, Key, MetadataRequest, MetadataResponse）
- E-02: `staging/src/k8s.io/externaljwt/apis/v1/api_grpc.pb.go` - gRPCサービス定義（ExternalJWTSignerClient, ExternalJWTSignerServer, UnimplementedExternalJWTSignerServer, RegisterExternalJWTSignerServer, ハンドラ関数, 定数, ServiceDesc）
- E-03: `staging/src/k8s.io/externaljwt/apis/v1alpha1/api.pb.go` - v1alpha1版protobufメッセージ定義（v1と同一構造）
- E-04: `staging/src/k8s.io/externaljwt/apis/v1alpha1/api_grpc.pb.go` - v1alpha1版gRPCサービス定義（v1と同一構造、メソッド名プレフィックスが異なる）
- E-05: `staging/src/k8s.io/externaljwt/docs.go` - パッケージドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SignJWTRequest.GetClaims正常系（v1） | E-01 (L97-102) | ○ |
| C-02 | SignJWTRequest.GetClaims異常系nil（v1） | E-01 (L97-102: nilチェックロジック) | ○ |
| C-03 | SignJWTRequest.GetClaims境界値空文字（v1） | E-01 (L101: return "") | ○ |
| C-04 | SignJWTRequest.Reset（v1） | E-01 (L67-72) | ○ |
| C-05 | SignJWTRequest.String（v1） | E-01 (L74-76) | ○ |
| C-06 | SignJWTRequest.ProtoReflect正常系（v1） | E-01 (L80-90) | ○ |
| C-07 | SignJWTRequest.ProtoReflect nil（v1） | E-01 (L80-90: nil分岐あり) | ○ |
| C-08 | SignJWTRequest.Descriptor（v1） | E-01 (L93-95) | ○ |
| C-09 | SignJWTResponse.GetHeader正常系（v1） | E-01 (L150-155) | ○ |
| C-10 | SignJWTResponse.GetHeader nil（v1） | E-01 (L150-155) | ○ |
| C-11 | SignJWTResponse.GetSignature正常系（v1） | E-01 (L157-162) | ○ |
| C-12 | SignJWTResponse.GetSignature nil（v1） | E-01 (L157-162) | ○ |
| C-13 | SignJWTResponse.Reset（v1） | E-01 (L120-125) | ○ |
| C-14 | FetchKeysResponse.GetKeys正常系（v1） | E-01 (L244-249) | ○ |
| C-15 | FetchKeysResponse.GetKeys nil（v1） | E-01 (L244-249) | ○ |
| C-16 | FetchKeysResponse.GetKeys空スライス（v1） | E-01 (L244-249) | ○ |
| C-17 | FetchKeysResponse.GetKeys 1件（v1） | E-01 (L244-249) | ○ |
| C-18 | FetchKeysResponse.GetDataTimestamp正常系（v1） | E-01 (L251-256) | ○ |
| C-19 | FetchKeysResponse.GetDataTimestamp nil（v1） | E-01 (L251-256) | ○ |
| C-20 | FetchKeysResponse.GetRefreshHintSeconds正常系（v1） | E-01 (L258-263) | ○ |
| C-21 | FetchKeysResponse.GetRefreshHintSeconds nil（v1） | E-01 (L258-263) | ○ |
| C-22 | FetchKeysResponse.GetRefreshHintSeconds境界値0（v1） | E-01 (L208-209: コメント "any value <= 0 is considered a misconfiguration") | ○ |
| C-23 | FetchKeysResponse.GetRefreshHintSeconds境界値負値（v1） | E-01 (L208-209: コメント) | ○ |
| C-24 | Key.GetKeyId正常系（v1） | E-01 (L312-317) | ○ |
| C-25 | Key.GetKeyId nil（v1） | E-01 (L312-317) | ○ |
| C-26 | Key.GetKeyId境界値1024文字（v1） | E-01 (L268: コメント "Length must be <=1024") | ○ |
| C-27 | Key.GetKeyId境界値空文字（v1） | E-01 (L312-317) | ○ |
| C-28 | Key.GetKey正常系（v1） | E-01 (L319-324) | ○ |
| C-29 | Key.GetKey nil（v1） | E-01 (L319-324) | ○ |
| C-30 | Key.GetKey境界値空バイト（v1） | E-01 (L319-324) | ○ |
| C-31 | Key.GetExcludeFromOidcDiscovery true（v1） | E-01 (L326-331) | ○ |
| C-32 | Key.GetExcludeFromOidcDiscovery false（v1） | E-01 (L326-331) | ○ |
| C-33 | Key.GetExcludeFromOidcDiscovery nil（v1） | E-01 (L326-331) | ○ |
| C-34 | MetadataResponse.GetMaxTokenExpirationSeconds正常系（v1） | E-01 (L415-420) | ○ |
| C-35 | MetadataResponse.GetMaxTokenExpirationSeconds nil（v1） | E-01 (L415-420) | ○ |
| C-36 | MetadataResponse.GetMaxTokenExpirationSeconds境界値600（v1） | E-01 (L379: コメント "must be at least 600s") | ○ |
| C-37 | MetadataResponse.GetMaxTokenExpirationSeconds境界値599（v1） | E-01 (L379: コメント) | ○ |
| C-38 | FetchKeysRequest.Reset（v1） | E-01 (L170-175) | ○ |
| C-39 | MetadataRequest.Reset（v1） | E-01 (L339-344) | ○ |
| C-40 | 定数ExternalJWTSigner_Sign_FullMethodName（v1） | E-02 (L55) | ○ |
| C-41 | 定数ExternalJWTSigner_FetchKeys_FullMethodName（v1） | E-02 (L56) | ○ |
| C-42 | 定数ExternalJWTSigner_Metadata_FullMethodName（v1） | E-02 (L57) | ○ |
| C-43 | NewExternalJWTSignerClient（v1） | E-02 (L90-92) | ○ |
| C-44 | externalJWTSignerClient.Sign正常系（v1） | E-02 (L94-102) | ○ |
| C-45 | externalJWTSignerClient.Sign異常系（v1） | E-02 (L94-102: errチェック) | ○ |
| C-46 | externalJWTSignerClient.FetchKeys正常系（v1） | E-02 (L104-112) | ○ |
| C-47 | externalJWTSignerClient.FetchKeys異常系（v1） | E-02 (L104-112) | ○ |
| C-48 | externalJWTSignerClient.Metadata正常系（v1） | E-02 (L114-122) | ○ |
| C-49 | externalJWTSignerClient.Metadata異常系（v1） | E-02 (L114-122) | ○ |
| C-50 | UnimplementedExternalJWTSignerServer.Sign（v1） | E-02 (L158-159) | ○ |
| C-51 | UnimplementedExternalJWTSignerServer.FetchKeys（v1） | E-02 (L161-162) | ○ |
| C-52 | UnimplementedExternalJWTSignerServer.Metadata（v1） | E-02 (L164-165) | ○ |
| C-53 | RegisterExternalJWTSignerServer正常系（v1） | E-02 (L177-186) | ○ |
| C-54 | RegisterExternalJWTSignerServer値埋め込み（v1） | E-02 (L177-186: testEmbeddedByValue) | ○ |
| C-55 | RegisterExternalJWTSignerServerポインタ埋め込みパニック（v1） | E-02 (L178-184: コメント "If the following call panics") | ○ |
| C-56 | _ExternalJWTSigner_Sign_Handlerインターセプタなし（v1） | E-02 (L188-204) | ○ |
| C-57 | _ExternalJWTSigner_Sign_Handlerインターセプタあり（v1） | E-02 (L188-204) | ○ |
| C-58 | _ExternalJWTSigner_Sign_Handlerデコードエラー（v1） | E-02 (L190-191) | ○ |
| C-59 | _ExternalJWTSigner_FetchKeys_Handlerインターセプタなし（v1） | E-02 (L206-222) | ○ |
| C-60 | _ExternalJWTSigner_FetchKeys_Handlerデコードエラー（v1） | E-02 (L208-209) | ○ |
| C-61 | _ExternalJWTSigner_Metadata_Handlerインターセプタなし（v1） | E-02 (L224-240) | ○ |
| C-62 | _ExternalJWTSigner_Metadata_Handlerデコードエラー（v1） | E-02 (L226-227) | ○ |
| C-63 | ExternalJWTSigner_ServiceDescサービス名（v1） | E-02 (L245-246: ServiceName: "v1.ExternalJWTSigner") | ○ |
| C-64 | ExternalJWTSigner_ServiceDescメソッド数（v1） | E-02 (L248-261: 3メソッド定義) | ○ |
| C-65 | ExternalJWTSigner_ServiceDesc Streams空（v1） | E-02 (L262: Streams: []grpc.StreamDesc{}) | ○ |
| C-66 | SignJWTRequest.GetClaims正常系（v1alpha1） | E-03 (L97-102) | ○ |
| C-67 | SignJWTRequest.GetClaims nil（v1alpha1） | E-03 (L97-102) | ○ |
| C-68 | SignJWTRequest.Reset（v1alpha1） | E-03 (L67-72) | ○ |
| C-69 | SignJWTResponse.GetHeader正常系（v1alpha1） | E-03 (L150-155) | ○ |
| C-70 | SignJWTResponse.GetHeader nil（v1alpha1） | E-03 (L150-155) | ○ |
| C-71 | SignJWTResponse.GetSignature正常系（v1alpha1） | E-03 (L157-162) | ○ |
| C-72 | SignJWTResponse.GetSignature nil（v1alpha1） | E-03 (L157-162) | ○ |
| C-73 | FetchKeysResponse.GetKeys正常系（v1alpha1） | E-03 (L244-249) | ○ |
| C-74 | FetchKeysResponse.GetKeys nil（v1alpha1） | E-03 (L244-249) | ○ |
| C-75 | FetchKeysResponse.GetDataTimestamp正常系（v1alpha1） | E-03 (L251-256) | ○ |
| C-76 | FetchKeysResponse.GetDataTimestamp nil（v1alpha1） | E-03 (L251-256) | ○ |
| C-77 | FetchKeysResponse.GetRefreshHintSeconds正常系（v1alpha1） | E-03 (L258-263) | ○ |
| C-78 | FetchKeysResponse.GetRefreshHintSeconds nil（v1alpha1） | E-03 (L258-263) | ○ |
| C-79 | Key.GetKeyId正常系（v1alpha1） | E-03 (L312-317) | ○ |
| C-80 | Key.GetKeyId nil（v1alpha1） | E-03 (L312-317) | ○ |
| C-81 | Key.GetKey正常系（v1alpha1） | E-03 (L319-324) | ○ |
| C-82 | Key.GetKey nil（v1alpha1） | E-03 (L319-324) | ○ |
| C-83 | Key.GetExcludeFromOidcDiscovery true（v1alpha1） | E-03 (L326-331) | ○ |
| C-84 | Key.GetExcludeFromOidcDiscovery nil（v1alpha1） | E-03 (L326-331) | ○ |
| C-85 | MetadataResponse.GetMaxTokenExpirationSeconds正常系（v1alpha1） | E-03 (L415-420) | ○ |
| C-86 | MetadataResponse.GetMaxTokenExpirationSeconds nil（v1alpha1） | E-03 (L415-420) | ○ |
| C-87 | MetadataResponse.GetMaxTokenExpirationSeconds境界値600（v1alpha1） | E-03 (L379: コメント "must be at least 600s") | ○ |
| C-88 | 定数ExternalJWTSigner_Sign_FullMethodName（v1alpha1） | E-04 (L55) | ○ |
| C-89 | 定数ExternalJWTSigner_FetchKeys_FullMethodName（v1alpha1） | E-04 (L56) | ○ |
| C-90 | 定数ExternalJWTSigner_Metadata_FullMethodName（v1alpha1） | E-04 (L57) | ○ |
| C-91 | NewExternalJWTSignerClient（v1alpha1） | E-04 (L90-92) | ○ |
| C-92 | externalJWTSignerClient.Sign正常系（v1alpha1） | E-04 (L94-102) | ○ |
| C-93 | externalJWTSignerClient.Sign異常系（v1alpha1） | E-04 (L94-102) | ○ |
| C-94 | externalJWTSignerClient.FetchKeys正常系（v1alpha1） | E-04 (L104-112) | ○ |
| C-95 | externalJWTSignerClient.FetchKeys異常系（v1alpha1） | E-04 (L104-112) | ○ |
| C-96 | externalJWTSignerClient.Metadata正常系（v1alpha1） | E-04 (L114-122) | ○ |
| C-97 | externalJWTSignerClient.Metadata異常系（v1alpha1） | E-04 (L114-122) | ○ |
| C-98 | UnimplementedExternalJWTSignerServer.Sign（v1alpha1） | E-04 (L158-159) | ○ |
| C-99 | UnimplementedExternalJWTSignerServer.FetchKeys（v1alpha1） | E-04 (L161-162) | ○ |
| C-100 | UnimplementedExternalJWTSignerServer.Metadata（v1alpha1） | E-04 (L164-165) | ○ |
| C-101 | RegisterExternalJWTSignerServer（v1alpha1） | E-04 (L177-186) | ○ |
| C-102 | ExternalJWTSigner_ServiceDescサービス名（v1alpha1） | E-04 (L245-246: ServiceName: "v1alpha1.ExternalJWTSigner") | ○ |
| C-103 | ExternalJWTSigner_ServiceDescメソッド数（v1alpha1） | E-04 (L248-261: 3メソッド定義) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本モジュールのすべてのソースコードはprotocによる自動生成コード（api.pb.go, api_grpc.pb.go）であり、手書きコードはdocs.goのパッケージコメントのみである。そのため、テストケースはすべてソースコードから直接根拠を特定できた。
- .protoファイル自体はこのディレクトリに存在しないが、生成されたGoコードのコメントに仕様制約（KeyId <= 1024文字、MaxTokenExpirationSeconds >= 600秒、RefreshHintSeconds <= 0は設定ミス等）が記載されており、これを根拠として使用した。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実際のメソッド定義に基づいており、根拠が明確
- 0: 低リスク - protobuf自動生成コードのため、メソッドの振る舞いはprotobufランタイムの仕様に準拠しており予測可能
- 1: 中リスク - v1とv1alpha1が同一構造のため、将来のバージョン差異が発生した場合にテストケースの更新が必要になる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] protobuf自動生成コードに対するテストの必要性・方針がプロジェクトポリシーと整合しているか確認
- [ ] v1とv1alpha1の両バージョンでテストケースが対称的に定義されているか確認
- [ ] 境界値テスト（KeyId 1024文字、MaxTokenExpirationSeconds 600秒、RefreshHintSeconds <= 0）の仕様根拠が.protoファイルのコメントと整合しているか確認
- [ ] gRPCクライアント/サーバーのテストにおいて、モック戦略が実装時に適切に反映されるか確認
- [ ] RegisterExternalJWTSignerServerのnilポインタ埋め込み検出テスト（C-55）の実装方針を確認
