---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 44
  claims_with_evidence: 42
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：staging-kms 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：42 / 44、根拠なし：2
- 優先レビュー（高）
  1. **UT-KMS-022（ListenAndServeの不正パステスト）**：実行環境依存でエラーメッセージの詳細が異なる可能性
  2. **UT-KMS-042（暗号化・復号ラウンドトリップ）**：PKCS11/SoftHSMの外部依存があり、テスト実行にはモック環境が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kms/pkg/util/util.go` - ParseEndpoint関数の実装（L31-54）
- E-02: `staging/src/k8s.io/kms/pkg/service/grpc_service.go` - GRPCService構造体と全メソッド（L30-133）
- E-03: `staging/src/k8s.io/kms/pkg/service/interface.go` - Service interface、EncryptResponse、DecryptRequest、StatusResponse型定義（L22-50）
- E-04: `staging/src/k8s.io/kms/apis/v1beta1/v1beta1.go` - IsVersionCheckMethod関数（L22-24）
- E-05: `staging/src/k8s.io/kms/internal/plugins/_mock/pkcs11/pkcs11.go` - pkcs11RemoteService構造体と全メソッド（L36-118）
- E-06: `staging/src/k8s.io/kms/apis/v2/api_grpc.pb.go` - KeyManagementServiceServer gRPCインターフェース定義
- E-07: `staging/src/k8s.io/kms/apis/v1beta1/api_grpc.pb.go` - v1beta1 gRPCインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ParseEndpointが有効なUnixソケットパスを正しくパースする | E-01 (L36-53) | ○ |
| C-02 | ParseEndpointがLinux抽象名前空間ソケットを処理する | E-01 (L49-51) | ○ |
| C-03 | ParseEndpointが空文字列を拒否する | E-01 (L32-34) | ○ |
| C-04 | ParseEndpointが不正なURLを拒否する | E-01 (L36-39) | ○ |
| C-05 | ParseEndpointがunix以外のスキームを拒否する | E-01 (L41-43) | ○ |
| C-06 | ParseEndpointがhttpスキームを拒否する | E-01 (L41-43) | ○ |
| C-07 | ParseEndpointがパス/のみのケースを処理する | E-01 (L53) | ○ |
| C-08 | NewGRPCServiceが有効なパラメータでインスタンスを生成する | E-02 (L42-53) | ○ |
| C-09 | NewGRPCServiceがフィールドを正しく初期化する | E-02 (L48-52) | ○ |
| C-10 | GRPCService.StatusがkmsServiceに委譲する | E-02 (L91-102), E-03 | ○ |
| C-11 | GRPCService.Statusのエラー伝播 | E-02 (L93-95) | ○ |
| C-12 | GRPCService.Decryptが正しく委譲する | E-02 (L105-118) | ○ |
| C-13 | GRPCService.Decryptのリクエストマッピング | E-02 (L106-110), E-03 | ○ |
| C-14 | GRPCService.Decryptのエラー伝播 | E-02 (L112-113) | ○ |
| C-15 | GRPCService.Encryptが正しく委譲する | E-02 (L121-132) | ○ |
| C-16 | GRPCService.Encryptのリクエストパラメータ | E-02 (L122) | ○ |
| C-17 | GRPCService.Encryptのエラー伝播 | E-02 (L123-124) | ○ |
| C-18 | GRPCService.ShutdownがGracefulStopを呼ぶ | E-02 (L76-80) | ○ |
| C-19 | GRPCService.Shutdownがサーバーnil時にpanicしない | E-02 (L77) | ○ |
| C-20 | GRPCService.CloseがStopを呼ぶ | E-02 (L84-88) | ○ |
| C-21 | GRPCService.Closeがサーバーnil時にpanicしない | E-02 (L85) | ○ |
| C-22 | GRPCService.ListenAndServeが不正パスでエラーを返す | E-02 (L58-61) | △ |
| C-23 | IsVersionCheckMethodが正しいパスでtrueを返す | E-04 (L23) | ○ |
| C-24 | IsVersionCheckMethodが異なるパスでfalseを返す | E-04 (L23) | ○ |
| C-25 | IsVersionCheckMethodが空文字列でfalseを返す | E-04 (L23) | ○ |
| C-26 | IsVersionCheckMethodが部分一致でfalseを返す | E-04 (L23) | ○ |
| C-27 | NewPKCS11RemoteServiceが空keyIDを拒否する | E-05 (L48-49) | ○ |
| C-28 | NewPKCS11RemoteServiceが不正設定ファイルを拒否する | E-05 (L43-45) | ○ |
| C-29 | pkcs11RemoteService.Encryptが正しく暗号化する | E-05 (L70-89) | ○ |
| C-30 | Encrypt結果のAnnotationsにバージョン情報が含まれる | E-05 (L85-87) | ○ |
| C-31 | 暗号文の長さがnonceSize+overhead+plaintext | E-05 (L72, L83) | ○ |
| C-32 | pkcs11RemoteService.Decryptが正しく復号する | E-05 (L91-110) | ○ |
| C-33 | Decryptがアノテーション件数を検証する | E-05 (L92-94) | ○ |
| C-34 | Decryptが空アノテーションを拒否する | E-05 (L92-94) | ○ |
| C-35 | Decryptが不正アノテーションキーを拒否する | E-05 (L95-97) | ○ |
| C-36 | Decryptが不正バージョン値を拒否する | E-05 (L95-97) | ○ |
| C-37 | Decryptが不正keyIDを拒否する | E-05 (L99-101) | ○ |
| C-38 | Decryptが短すぎる暗号文を拒否する | E-05 (L105-107) | ○ |
| C-39 | Decryptが空暗号文を拒否する | E-05 (L105-107) | ○ |
| C-40 | pkcs11RemoteService.Statusが正しい値を返す | E-05 (L112-118) | ○ |
| C-41 | Statusがエラーを返さない | E-05 (L112-118) | ○ |
| C-42 | 暗号化・復号のラウンドトリップが成功する | E-05 (L70-110) | △ |
| C-43 | GRPCServiceがKeyManagementServiceServerインターフェースを満たす | E-02 (L39), E-06 | ○ |
| C-44 | pkcs11RemoteServiceがServiceインターフェースを満たす | E-05 (L34), E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-22: ListenAndServeの不正パステストは、OS依存のエラーメッセージとなるため、具体的なエラー文言の検証が困難
  - 候補：実行環境でのnet.Listen挙動確認 / OS固有のエラーコード調査
- C-42: 暗号化・復号ラウンドトリップはPKCS11/SoftHSMの外部依存があり、単体テストとしてはcipher.AEADのモックが必要
  - 候補：cipher.AEADインターフェースをモック化 / テスト用のin-memory AEAD実装

## 5) リスクフラグ（レビュー観点）
- 0: ParseEndpoint関数のテストケース（純粋関数で外部依存なし）
- 0: IsVersionCheckMethod関数のテストケース（純粋関数で外部依存なし）
- 0: GRPCServiceのStatus/Decrypt/Encryptメソッド（mockServiceで制御可能）
- 1: GRPCServiceのListenAndServe/Shutdown/Close（gRPCサーバーの起動が必要）
- 1: pkcs11RemoteServiceのEncrypt/Decrypt（cipher.AEAD依存、外部HSM不要だがモック必要）
- 2: NewPKCS11RemoteServiceのコンストラクタ（crypto11外部ライブラリ依存）

## 6) レビュアーチェックリスト（最小）
- [ ] ParseEndpoint関数の全分岐（空文字列、不正URL、非unixスキーム、抽象ソケット、通常パス）がカバーされているか
- [ ] GRPCServiceの各gRPCメソッド（Status, Decrypt, Encrypt）の正常系・異常系が網羅されているか
- [ ] GRPCServiceのライフサイクル（ListenAndServe, Shutdown, Close）のテストケースが実行可能か
- [ ] pkcs11RemoteServiceのDecryptにおける全バリデーション（annotations件数、キー名、バージョン値、keyID、暗号文長）がカバーされているか
- [ ] インターフェース準拠チェック（コンパイル時検証）が含まれているか
- [ ] 外部依存（crypto11, SoftHSM）を持つテストケースにモック戦略が明記されているか
