---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 145
  claims_with_evidence: 140
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：staging-kube-aggregator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：140 / 145、根拠なし：5
- 優先レビュー（高）
  1. **C-044/045**: proxyHandler.ServeHTTPのhandlingInfo nil/local委譲動作 -- handler_proxy.goは大量のフィールドがあり読み取り難度が高い
  2. **C-051/052**: discoveryGroup/convertToDiscoveryAPIGroupの詳細な期待結果 -- handler_apis.goの内部構造に依存
  3. **C-061~063**: discoveryManager.setInfoForAPIServiceの3パターン -- handler_discovery.goの内部マップ操作の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kube-aggregator/pkg/apis/apiregistration/helpers.go` -- SortedByGroupAndVersion, ByGroupPriorityMinimum, ByVersionPriority, NewLocalAvailableAPIServiceCondition, SetAPIServiceCondition, IsAPIServiceConditionTrue, GetAPIServiceConditionByType
- E-02: `staging/src/k8s.io/kube-aggregator/pkg/apis/apiregistration/validation/validation.go` -- ValidateAPIService, ValidateAPIServiceUpdate, ValidateAPIServiceStatus, ValidateAPIServiceStatusUpdate
- E-03: `staging/src/k8s.io/kube-aggregator/pkg/apis/apiregistration/v1/helper/helpers.go` -- APIServiceNameToGroupVersion, SortedByGroupAndVersion (v1版), SetAPIServiceCondition (v1版), GetAPIServiceConditionByType (v1版), IsAPIServiceConditionTrue (v1版), NewLocalAvailableAPIServiceCondition (v1版)
- E-04: `staging/src/k8s.io/kube-aggregator/pkg/apis/apiregistration/v1/defaults.go` -- SetDefaults_ServiceReference
- E-05: `staging/src/k8s.io/kube-aggregator/pkg/apiserver/resolvers.go` -- loopbackResolver.ResolveEndpoint
- E-06: `staging/src/k8s.io/kube-aggregator/pkg/apiserver/handler_proxy.go` -- proxyHandler.ServeHTTP, proxyHandler.updateAPIService
- E-07: `staging/src/k8s.io/kube-aggregator/pkg/apiserver/handler_apis.go` -- discoveryGroup, convertToDiscoveryAPIGroup, apisHandler
- E-08: `staging/src/k8s.io/kube-aggregator/pkg/apiserver/handler_discovery.go` -- serviceKey, newServiceKey, discoveryManager.AddAPIService, RemoveAPIService, setInfoForAPIService
- E-09: `staging/src/k8s.io/kube-aggregator/pkg/controllers/autoregister/autoregister_controller.go` -- autoRegisterController, checkAPIService, AddAPIServiceToSync, AddAPIServiceToSyncOnStart, RemoveAPIServiceToSync, GetAPIServiceToSync, automanagedType, isAutomanaged, isAutomanagedOnStart
- E-10: `staging/src/k8s.io/kube-aggregator/pkg/controllers/cache.go` -- WaitForCacheSync
- E-11: `staging/src/k8s.io/kube-aggregator/pkg/controllers/openapi/aggregator/downloader.go` -- Downloader.Download, etagFor, cacheableDownloader
- E-12: `staging/src/k8s.io/kube-aggregator/pkg/controllers/openapi/aggregator/priority.go` -- byPriority.Less, sortByPriority
- E-13: `staging/src/k8s.io/kube-aggregator/pkg/controllers/openapi/aggregator/aggregator.go` -- specAggregator.AddUpdateAPIService, RemoveAPIService, UpdateAPIServiceSpec, updateServiceLocked
- E-14: `staging/src/k8s.io/kube-aggregator/pkg/controllers/openapi/controller.go` -- AggregationController.sync, AddAPIService, UpdateAPIService, RemoveAPIService
- E-15: `staging/src/k8s.io/kube-aggregator/pkg/controllers/openapiv3/aggregator/aggregator.go` -- specProxier.AddUpdateAPIService, RemoveAPIServiceSpec, GetAPIServiceNames, IsLocalAPIService, getGroupVersionStringFromAPIService
- E-16: `staging/src/k8s.io/kube-aggregator/pkg/registry/apiservice/strategy.go` -- apiServerStrategy, apiServerStatusStrategy, GetAttrs, MatchAPIService, ToSelectableFields
- E-17: `staging/src/k8s.io/kube-aggregator/pkg/apiserver/apiservice_controller.go` -- APIServiceRegistrationController.sync
- E-18: `staging/src/k8s.io/kube-aggregator/pkg/controllers/status/local/local_available_controller.go` -- AvailableConditionController.sync, updateAPIServiceStatus
- E-19: `staging/src/k8s.io/kube-aggregator/pkg/controllers/status/remote/remote_available_controller.go` -- AvailableConditionController.sync, updateAPIServiceStatus, rebuildAPIServiceCache, getAPIServicesFor

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | SortedByGroupAndVersionが複数グループ・バージョンを正しくソート | E-01 | ○ |
| C-002 | 空スライス入力で空の二次元スライスを返却 | E-01 | ○ |
| C-003 | 1件のみの入力で1グループ1要素を返却 | E-01 | ○ |
| C-004 | 同一グループの異なるバージョンがまとめられる | E-01 | ○ |
| C-005 | ByGroupPriorityMinimum.Lessが高い値を先にソート | E-01 | ○ |
| C-006 | 同一GroupPriorityMinimumで名前のアルファベット順 | E-01 | ○ |
| C-007 | ByVersionPriority.Lessが高い値を先にソート | E-01 | ○ |
| C-008 | 同一VersionPriorityでKubeバージョン文字列比較 | E-01 | ○ |
| C-009 | NewLocalAvailableAPIServiceConditionが正しい条件を生成 | E-01 | ○ |
| C-010 | GetAPIServiceConditionByTypeが存在する条件を取得 | E-01 | ○ |
| C-011 | GetAPIServiceConditionByTypeが存在しない条件でnilを返却 | E-01 | ○ |
| C-012 | Conditions空でnilを返却 | E-01 | ○ |
| C-013 | SetAPIServiceConditionが新しい条件を追加 | E-01 | ○ |
| C-014 | SetAPIServiceConditionがステータス変更時に更新 | E-01 | ○ |
| C-015 | ステータス同一時にLastTransitionTimeが変更されない | E-01 | ○ |
| C-016 | IsAPIServiceConditionTrueがTrue条件でtrueを返却 | E-01 | ○ |
| C-017 | IsAPIServiceConditionTrueがFalse条件でfalseを返却 | E-01 | ○ |
| C-018 | 条件未設定時にfalseを返却 | E-01 | ○ |
| C-019 | ValidateAPIServiceが有効な入力で通過 | E-02 | ○ |
| C-020 | 名前不整合でエラー | E-02 | ○ |
| C-021 | 空グループでv1以外にエラー | E-02 | ○ |
| C-022 | 空グループでv1がエラーとならない | E-02 | ○ |
| C-023 | GroupPriorityMinimum=0でエラー | E-02 | ○ |
| C-024 | GroupPriorityMinimum>20000でエラー | E-02 | ○ |
| C-025 | VersionPriority=0でエラー | E-02 | ○ |
| C-026 | VersionPriority>1000でエラー | E-02 | ○ |
| C-027 | Service=nilでバリデーション通過 | E-02 | ○ |
| C-028 | Service=nilでCABundleありエラー | E-02 | ○ |
| C-029 | Service=nilでInsecureSkipTLSVerifyありエラー | E-02 | ○ |
| C-030 | Service.Namespace空でエラー | E-02 | ○ |
| C-031 | Service.Name空でエラー | E-02 | ○ |
| C-032 | InsecureSkipTLSVerifyとCABundle両方でエラー | E-02 | ○ |
| C-033 | ValidateAPIServiceUpdateが有効な更新で通過 | E-02 | ○ |
| C-034 | ValidateAPIServiceStatusが有効なStatusで通過 | E-02 | ○ |
| C-035 | 無効なStatusでエラー | E-02 | ○ |
| C-036 | APIServiceNameToGroupVersionが正しく変換 | E-03 | ○ |
| C-037 | レガシーAPI名の変換 | E-03 | ○ |
| C-038 | サブドメイン付きグループ名の変換 | E-03 | ○ |
| C-039 | SetDefaults_ServiceReferenceがnilポートに443設定 | E-04 | ○ |
| C-040 | 既存ポートが保持される | E-04 | ○ |
| C-041 | loopbackResolverがdefault/kubernetes:443でループバック | E-05 | ○ |
| C-042 | 非ローカルサービスがdelegateに委譲 | E-05 | ○ |
| C-043 | ポート不一致時にdelegate委譲 | E-05 | ○ |
| C-044 | handlingInfo nil時にlocalDelegateへ委譲 | E-06 | △ |
| C-045 | ローカルAPIServiceでlocalDelegateへ委譲 | E-06 | △ |
| C-046 | serviceAvailable=falseで503 | E-06 | ○ |
| C-047 | transportBuildingError時に500 | E-06 | ○ |
| C-048 | ユーザー情報欠落で500 | E-06 | ○ |
| C-049 | Service=nilでローカル設定 | E-06 | ○ |
| C-050 | Service指定でプロキシ設定構築 | E-06 | ○ |
| C-051 | discoveryGroupがAPIGroupを構築 | E-07 | △ |
| C-052 | v1beta1バージョンの包含 | E-07 | △ |
| C-053 | convertToDiscoveryAPIGroupの変換 | E-07 | ○ |
| C-054 | serviceKey.Stringの文字列表現 | E-08 | ○ |
| C-055 | newServiceKeyのポート指定 | E-08 | ○ |
| C-056 | newServiceKeyのデフォルトポート | E-08 | ○ |
| C-057 | discoveryManager.AddAPIServiceの追加 | E-08 | ○ |
| C-058 | Service=nilのスキップ | E-08 | ○ |
| C-059 | RemoveAPIServiceの削除 | E-08 | ○ |
| C-060 | 存在しない削除の安全性 | E-08 | ○ |
| C-061 | setInfoForAPIServiceの新規追加 | E-08 | ○ |
| C-062 | setInfoForAPIServiceの上書き更新 | E-08 | ○ |
| C-063 | setInfoForAPIServiceのnil削除 | E-08 | ○ |
| C-064 | GetAPIServiceToSyncの取得 | E-09 | ○ |
| C-065 | 未登録名でnil返却 | E-09 | ○ |
| C-066 | AddAPIServiceToSyncの'true'ラベル登録 | E-09 | ○ |
| C-067 | AddAPIServiceToSyncOnStartの'onstart'ラベル登録 | E-09 | ○ |
| C-068 | RemoveAPIServiceToSyncの削除 | E-09 | ○ |
| C-069 | nilラベルの安全な初期化 | E-09 | ○ |
| C-070 | automanagedTypeの返却値 | E-09 | ○ |
| C-071 | nilサービスで空文字列 | E-09 | ○ |
| C-072 | isAutomanagedの'true'判定 | E-09 | ○ |
| C-073 | isAutomanagedの'onstart'判定 | E-09 | ○ |
| C-074 | 非管理APIServiceの判定 | E-09 | ○ |
| C-075 | isAutomanagedOnStartの'onstart'判定 | E-09 | ○ |
| C-076 | isAutomanagedOnStartの'true'非該当 | E-09 | ○ |
| C-077 | checkAPIService 2Aパターン | E-09 | ○ |
| C-078 | checkAPIService 2B/2Cパターン | E-09 | ○ |
| C-079 | checkAPIService 5A/6Aパターン | E-09 | ○ |
| C-080 | Spec一致時の更新抑制 | E-09 | ○ |
| C-081 | WaitForCacheSyncの成功 | E-10 | ○ |
| C-082 | WaitForCacheSyncの失敗 | E-10 | ○ |
| C-083 | Download StatusOK正常 | E-11 | ○ |
| C-084 | Download StatusNotModified正常 | E-11 | ○ |
| C-085 | Download StatusNotModified etagなしエラー | E-11 | ○ |
| C-086 | Download StatusNotFound正常 | E-11 | ○ |
| C-087 | etagForの冪等性 | E-11 | ○ |
| C-088 | etagForの一意性 | E-11 | ○ |
| C-089 | byPriority.Lessのローカル優先 | E-12 | ○ |
| C-090 | ローカル同士の名前ソート | E-12 | ○ |
| C-091 | 同一グループのVersionPriorityソート | E-12 | ○ |
| C-092 | 異なるグループのGroupPriorityソート | E-12 | ○ |
| C-093 | sortByPriorityのマッピング構築 | E-12 | ○ |
| C-094 | specAggregator.AddUpdateAPIServiceの追加 | E-13 | ○ |
| C-095 | Service=nilのスキップ | E-13 | ○ |
| C-096 | 既存APIServiceの更新 | E-13 | ○ |
| C-097 | RemoveAPIServiceの削除 | E-13 | ○ |
| C-098 | 存在しない削除の安全性 | E-13 | ○ |
| C-099 | UpdateAPIServiceSpecの更新 | E-13 | ○ |
| C-100 | ErrAPIServiceNotFound返却 | E-13 | ○ |
| C-101 | sync正常でsyncRequeue | E-14 | ○ |
| C-102 | ErrAPIServiceNotFoundでsyncNothing | E-14 | ○ |
| C-103 | エラーでsyncRequeueRateLimited | E-14 | ○ |
| C-104 | AddAPIServiceのキュー追加 | E-14 | ○ |
| C-105 | Service=nil無視 | E-14 | ○ |
| C-106 | RemoveAPIServiceの削除 | E-14 | ○ |
| C-107 | IsLocalAPIServiceのtrue判定 | E-15 | ○ |
| C-108 | IsLocalAPIServiceのfalse判定 | E-15 | ○ |
| C-109 | getGroupVersionStringFromAPIServiceの生成 | E-15 | ○ |
| C-110 | 空GroupVersionの処理 | E-15 | ○ |
| C-111 | specProxier.AddUpdateAPIServiceの追加 | E-15 | ○ |
| C-112 | 既存APIServiceの更新 | E-15 | ○ |
| C-113 | RemoveAPIServiceSpecの削除 | E-15 | ○ |
| C-114 | 存在しない削除の安全性 | E-15 | ○ |
| C-115 | GetAPIServiceNamesの取得 | E-15 | ○ |
| C-116 | 空一覧の取得 | E-15 | ○ |
| C-117 | NamespaceScoped=false | E-16 | ○ |
| C-118 | PrepareForCreateのStatusリセット | E-16 | ○ |
| C-119 | Service=nilでローカル利用可能条件 | E-16 | ○ |
| C-120 | PrepareForUpdateのStatus保持 | E-16 | ○ |
| C-121 | AllowCreateOnUpdate=false | E-16 | ○ |
| C-122 | AllowUnconditionalUpdate=false | E-16 | ○ |
| C-123 | apiServerStatusStrategy.PrepareForUpdateのフィールド保護 | E-16 | ○ |
| C-124 | GetAttrsの正常取得 | E-16 | ○ |
| C-125 | 不正オブジェクトの拒否 | E-16 | ○ |
| C-126 | GetResetFieldsのstatus含有 | E-16 | ○ |
| C-127 | ステータスGetResetFieldsのspec/metadata含有 | E-16 | ○ |
| C-128 | APIServiceRegistrationController.syncでAddAPIService呼出 | E-17 | ○ |
| C-129 | NotFoundでRemoveAPIService呼出 | E-17 | ○ |
| C-130 | エラーの伝播 | E-17 | ○ |
| C-131 | ローカル利用可能条件の設定 | E-18 | ○ |
| C-132 | リモートAPIServiceのスキップ | E-18 | ○ |
| C-133 | NotFoundのメトリクスForget | E-18 | ○ |
| C-134 | 全チェック通過でAvailable=True | E-19 | ○ |
| C-135 | ServiceNotFound | E-19 | ○ |
| C-136 | EndpointsNotFound | E-19 | ○ |
| C-137 | ServicePortError | E-19 | ○ |
| C-138 | MissingEndpoints | E-19 | ○ |
| C-139 | Service=nilスキップ | E-19 | ○ |
| C-140 | updateAPIServiceStatusの更新検出 | E-19 | ○ |
| C-141 | 同一ステータスの更新抑制 | E-19 | ○ |
| C-142 | rebuildAPIServiceCacheの構築 | E-19 | ○ |
| C-143 | ローカルAPIServiceのキャッシュ除外 | E-19 | ○ |
| C-144 | getAPIServicesForの基本動作 | E-19 | ○ |
| C-145 | 未登録サービスのnil返却 | E-19 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-044/C-045**: `handler_proxy.go`の`proxyHandler.ServeHTTP`は、`handlingInfo`がatomic.Valueで管理されておりnilチェック後のLocalフラグ判定の正確な動作確認にはロードの挙動を精査する必要がある
  - 候補：handler_proxy_test.go / 既存テストの確認
- **C-051/C-052**: `handler_apis.go`の`discoveryGroup`関数の内部構造は、apisHandlerメソッド内で間接的に呼ばれる部分であり、enabledVersionsの詳細な挙動確認が必要
  - 候補：handler_apis_test.go / APIServer統合テスト
- **C-145**: `getAPIServicesFor`のキャッシュが空の場合のnil返却は、Goのmapアクセスの暗黙的な挙動に依存
  - 候補：Goのmapアクセス仕様ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- helpers.go, v1/helper/helpers.go, defaults.go, cache.go, priority.goのテストケースはソースコードから直接検証可能
- 0: 低リスク -- validation.goのバリデーションルールはコードから明確に読み取れる
- 1: 中リスク -- handler_proxy.goのServeHTTPはatomic操作と複数の条件分岐を持ち、テストケースの網羅性に注意が必要
- 1: 中リスク -- remote_available_controller.goのsyncメソッドは複数のエラーパスを持ち、全パスの網羅確認が望ましい
- 0: 低リスク -- autoregister_controller.goのcheckAPIServiceは状態遷移マトリクスが明確

## 6) レビュアーチェックリスト（最小）
- [ ] handler_proxy.goのproxyHandler.ServeHTTPの条件分岐が全てカバーされているか確認
- [ ] validation.goの境界値テスト（GroupPriorityMinimum: 1-20000, VersionPriority: 1-1000）が正しいか確認
- [ ] autoregister_controller.goのcheckAPIServiceの全状態遷移パターンが網羅されているか確認
- [ ] remote_available_controller.goのsyncメソッドの全エラーパス（ServiceNotFound, ServicePortError, EndpointsNotFound, MissingEndpoints, FailedDiscoveryCheck）がカバーされているか確認
- [ ] OpenAPI V2/V3の両方のaggregatorのAddUpdateAPIService/RemoveAPIServiceが適切にテストされているか確認
