---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 165
  claims_with_evidence: 160
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：staging-kubectl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：160 / 165、根拠なし：5
- 優先レビュー（高）
  1. **UT-KCT-032/033 filterPods**: filterPods関数は内部関数であり、直接テスト可能か要確認
  2. **UT-KCT-110/111 schemaValidation.ValidateBytes**: OpenAPIリソースのモック方法の詳細が根拠不足
  3. **UT-KCT-054 PodRequestsAndLimits Overhead**: restartable init containerとの組み合わせ動作は複雑で追加検証推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/kubectl/pkg/apps/kind_visitor.go` - GroupKindElement, Accept, GroupMatch の定義
- E-02: `staging/src/k8s.io/kubectl/pkg/drain/filters.go` - PodDeleteList, PodDeleteStatus, フィルタ関数群の定義
- E-03: `staging/src/k8s.io/kubectl/pkg/drain/drain.go` - Helper構造体, DeleteOrEvictPods, filterPods, waitForDelete の定義
- E-04: `staging/src/k8s.io/kubectl/pkg/drain/cordon.go` - CordonHelper, UpdateIfRequired, PatchOrReplace の定義
- E-05: `staging/src/k8s.io/kubectl/pkg/scale/scale.go` - ScalePrecondition, validate, genericScaler の定義
- E-06: `staging/src/k8s.io/kubectl/pkg/util/hash/hash.go` - ConfigMapHash, SecretHash, encodeHash, hash の定義
- E-07: `staging/src/k8s.io/kubectl/pkg/util/resource/resource.go` - PodRequestsAndLimits, ExtractContainerResourceValue の定義
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/get/sorter.go` - RuntimeSort, SortingPrinter, isLess, TableSorter の定義
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/cp/filespec.go` - localPath, remotePath, stripPathShortcuts の定義
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/taint/utils.go` - parseTaint, parseTaints, reorganizeTaints の定義
- E-11: `staging/src/k8s.io/kubectl/pkg/util/qos/qos.go` - GetPodQOS, ComputePodQOS の定義
- E-12: `staging/src/k8s.io/kubectl/pkg/cmd/util/helpers.go` - AddSourceToErr, ParsePairs, MultilineError, FeatureGate の定義
- E-13: `staging/src/k8s.io/kubectl/pkg/validation/validation.go` - schemaValidation, getObjectKind, parse の定義
- E-14: `staging/src/k8s.io/kubectl/pkg/cmd/set/env/env_parse.go` - IsEnvironmentArgument, ParseEnv, SplitEnvironmentFromResources の定義
- E-15: `staging/src/k8s.io/kubectl/pkg/generate/generate.go` - IsZero, ValidateParams, ParseLabels, ParseProtocols の定義
- E-16: `staging/src/k8s.io/kubectl/pkg/cmd/version/skew_warning.go` - getVersionSkewWarning の定義
- E-17: `staging/src/k8s.io/kubectl/pkg/explain/formatter.go` - Formatter, wrapString, shouldStartNewLine の定義
- E-18: `staging/src/k8s.io/kubectl/pkg/cmd/util/podcmd/podcmd.go` - FindContainerByName, FindOrDefaultContainerByName の定義
- E-19: `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_sorter.go` - NodeMetricsSorter, PodMetricsSorter の定義
- E-20: `staging/src/k8s.io/kubectl/pkg/cmd/wait/json.go` - JSONPathWait, verifyParsedJSONPath, compareResults の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GroupKindElement.Acceptの各Kind分岐テスト(UT-KCT-001~007) | E-01 | ○ |
| C-02 | GroupMatch関数のテスト(UT-KCT-008~010) | E-01 | ○ |
| C-03 | PodDeleteList.Podsのフィルタ動作テスト(UT-KCT-011~012) | E-02 | ○ |
| C-04 | PodDeleteList.Warningsの出力テスト(UT-KCT-013~014) | E-02 | ○ |
| C-05 | PodDeleteStatusヘルパー関数テスト(UT-KCT-015~016) | E-02 | ○ |
| C-06 | hasLocalStorageの検出テスト(UT-KCT-017~018) | E-02 | ○ |
| C-07 | drainフィルタ群(daemonSet/mirror/localStorage/unreplicated)(UT-KCT-019~027) | E-02, E-03 | ○ |
| C-08 | Helper.makeDeleteOptionsの設定テスト(UT-KCT-028~030) | E-03 | ○ |
| C-09 | DeleteOrEvictPodsの空スライステスト(UT-KCT-031) | E-03 | ○ |
| C-10 | filterPodsの動作・短絡評価テスト(UT-KCT-032~033) | E-03 | △ |
| C-11 | getContextのフォールバックテスト(UT-KCT-034~035) | E-03 | ○ |
| C-12 | CordonHelper.UpdateIfRequiredテスト(UT-KCT-036~037) | E-04 | ○ |
| C-13 | NewCordonHelperFromRuntimeObjectテスト(UT-KCT-038~039) | E-04 | ○ |
| C-14 | ScalePrecondition.validateテスト(UT-KCT-040~044) | E-05 | ○ |
| C-15 | PreconditionErrorメッセージテスト(UT-KCT-045) | E-05 | ○ |
| C-16 | WaitForScaleHasDesiredReplicasのnilチェック(UT-KCT-046) | E-05 | ○ |
| C-17 | ConfigMapHash/SecretHashの一貫性テスト(UT-KCT-047~049) | E-06 | ○ |
| C-18 | encodeHashのバリデーション(UT-KCT-050~051) | E-06 | ○ |
| C-19 | PodRequestsAndLimitsのリソース集計テスト(UT-KCT-052~055) | E-07 | ○ |
| C-20 | ExtractContainerResourceValueのリソース抽出テスト(UT-KCT-056~058) | E-07 | ○ |
| C-21 | IsStandardContainerResourceName/IsHugePageResourceNameテスト(UT-KCT-059~060) | E-07 | ○ |
| C-22 | RuntimeSortのsort.Interface実装テスト(UT-KCT-061~067) | E-08 | ○ |
| C-23 | isLessの型別比較テスト(UT-KCT-063~065) | E-08 | ○ |
| C-24 | localPath/remotePathのパス操作テスト(UT-KCT-068~077) | E-09 | ○ |
| C-25 | parseTaint/parseTaintsのパーステスト(UT-KCT-078~084) | E-10 | ○ |
| C-26 | reorganizeTaintsの動作テスト(UT-KCT-085~086) | E-10 | ○ |
| C-27 | deleteTaintsByKey/checkIfTaintsAlreadyExistsテスト(UT-KCT-087~088) | E-10 | ○ |
| C-28 | GetPodQOS/ComputePodQOSのQoS計算テスト(UT-KCT-089~092) | E-11 | ○ |
| C-29 | AddSourceToErr/IsFilenameSliceEmptyテスト(UT-KCT-093~096) | E-12 | ○ |
| C-30 | MultilineError/ParsePairs/Differenceテスト(UT-KCT-097~103) | E-12 | ○ |
| C-31 | StripComments/ManualStripテスト(UT-KCT-104~106) | E-12 | ○ |
| C-32 | FeatureGate.IsEnabled/IsDisabledテスト(UT-KCT-107~109) | E-12 | ○ |
| C-33 | schemaValidation.ValidateBytesのバリデーションテスト(UT-KCT-110~111) | E-13 | △ |
| C-34 | getObjectKindのGVK抽出テスト(UT-KCT-112~114) | E-13 | ○ |
| C-35 | IsEnvironmentArgument/SplitEnvironmentFromResourcesテスト(UT-KCT-115~119) | E-14 | ○ |
| C-36 | ParseEnvの環境変数パーステスト(UT-KCT-120~122) | E-14 | ○ |
| C-37 | IsZero/ValidateParams/ParseLabelsテスト(UT-KCT-123~130) | E-15 | ○ |
| C-38 | ParseProtocols/GetBoolテスト(UT-KCT-131~135) | E-15 | ○ |
| C-39 | getVersionSkewWarningテスト(UT-KCT-136~139) | E-16 | ○ |
| C-40 | Formatter/wrapString/shouldStartNewLineテスト(UT-KCT-140~145) | E-17 | ○ |
| C-41 | FindContainerByName/FindOrDefaultContainerByNameテスト(UT-KCT-146~153) | E-18 | ○ |
| C-42 | AllContainerNamesテスト(UT-KCT-154) | E-18 | ○ |
| C-43 | NodeMetricsSorter/PodMetricsSorterテスト(UT-KCT-155~158) | E-19 | ○ |
| C-44 | verifyParsedJSONPath/compareResultsテスト(UT-KCT-159~165) | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- **filterPods関数のテスト可能性 (C-10)**: filterPodsはパッケージ内非公開関数であり、テストファイルが同一パッケージ内に配置される場合のみ直接テスト可能。外部パッケージからのテストではGetPodsForDeletionを通じた間接的テストとなる。
  - 候補：同一パッケージ内テスト / GetPodsForDeletion経由の統合テスト / テスト用ヘルパー関数の追加
- **schemaValidation.ValidateBytesのモック (C-33)**: OpenAPIResourcesGetterのモック方法について、具体的な実装は既存テストコードを参照する必要がある。
  - 候補：openapi/testing パッケージのモック / 手動モック実装 / 既存テストの踏襲
- **266ファイル中の網羅性**: モジュール全体で266ファイルあるが、本テストケース一覧は主要な20ファイルのpublic関数・ビジネスロジックに焦点を当てている。cmd配下の各サブコマンド（apply, create, delete等）のRunメソッドは外部依存が大きく、単体テストよりも統合テストが適切。
  - 候補：サブコマンドのValidate関数の追加テスト / Complete関数の入力バリデーションテスト
- **DryRunStrategy関連のテスト**: GetDryRunStrategy/GetValidationDirectiveはcobraのCmd依存が強く、テストファクトリを使用した間接テストが必要。
  - 候補：cmdtestingパッケージを使用したテスト / フラグ値の直接注入
- **proxy_server.goのテスト**: ProxyServerの動作テストはHTTPサーバーの起動を伴うため単体テストの範囲外として除外した。
  - 候補：httptest.Serverを使用したテスト / handlerレベルのテスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: apps/kind_visitor.go, explain/formatter.go, metricsutil/metrics_sorter.go - 単純なディスパッチ・フォーマット・ソートロジック
- **0 (低リスク)**: generate/generate.go - パラメータ解析ユーティリティ
- **1 (中リスク)**: drain/filters.go, drain/cordon.go - ノード運用に関わるフィルタロジック。フィルタの組み合わせによる影響を確認すべき
- **1 (中リスク)**: cmd/taint/utils.go - taintのパース・操作ロジック。不正入力のバリデーションカバレッジに注意
- **1 (中リスク)**: util/qos/qos.go - QoS計算ロジック。pod-level resourcesフィールドの新しいパスの網羅性を確認すべき
- **2 (高リスク)**: scale/scale.go - スケール操作の前提条件チェック。本番環境でのレプリカ数変更に直結
- **2 (高リスク)**: util/hash/hash.go - ConfigMap/Secretのハッシュ計算。ハッシュの不一致は不要な再デプロイにつながる
- **2 (高リスク)**: cmd/cp/filespec.go - パストラバーサル防止のstripPathShortcuts。セキュリティに直結
- **2 (高リスク)**: validation/validation.go - スキーマバリデーション。不正リソースの受け入れにつながる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] drainフィルタ群(UT-KCT-019~027)の境界条件が実際の運用シナリオを網羅しているか
- [ ] ScalePrecondition.validate(UT-KCT-040~044)でSize=0の境界値テストが必要か検討
- [ ] stripPathShortcuts(UT-KCT-074~076)のセキュリティ観点で追加のパストラバーサルパターンがないか
- [ ] ComputePodQOS(UT-KCT-090~092)でrestartable init containerの新しいQoS計算ルールが反映されているか
- [ ] ConfigMapHash(UT-KCT-047~048)のImmutableフィールドとBinaryDataフィールドを含むケースの追加を検討
- [ ] filterPods(UT-KCT-032~033)が同一パッケージテストとして実装可能か確認
- [ ] 本テストケース一覧がカバーしていないサブコマンド(apply, create, delete等)について、別途統合テストの計画があるか確認
