---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 129
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：staging-kubelet 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：129 / 132、根拠なし：3
- 優先レビュー（高）
  1. **C-117**：nilマップに対するGoのmap参照動作の確認が必要
  2. **C-021**：SetVersionPriorityの呼び出し順序からの優先度推定
  3. **C-062**：Start(stayUp=false)の未実装動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kubelet/pkg/apis/well_known_labels.go` - KubeletLabels, KubeletLabelNamespaces, IsKubeletLabel, getLabelNamespace関数定義
- E-02: `staging/src/k8s.io/kubelet/config/v1/register.go` - addKnownTypes, SchemeBuilder, AddToScheme定義
- E-03: `staging/src/k8s.io/kubelet/config/v1alpha1/register.go` - v1alpha1 addKnownTypes定義
- E-04: `staging/src/k8s.io/kubelet/config/v1beta1/register.go` - v1beta1 addKnownTypes定義
- E-05: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/register.go` - 内部版register定義
- E-06: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/v1/register.go` - v1 register定義
- E-07: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/v1alpha1/register.go` - v1alpha1 register定義
- E-08: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/v1beta1/register.go` - v1beta1 register定義
- E-09: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/install/install.go` - Install関数定義
- E-10: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/v1alpha1/conversion.go` - v1alpha1変換関数
- E-11: `staging/src/k8s.io/kubelet/pkg/apis/credentialprovider/v1beta1/conversion.go` - v1beta1変換関数
- E-12: `staging/src/k8s.io/kubelet/pkg/cri/streaming/request_cache.go` - requestCache構造体、newRequestCache, Insert, Consume, uniqueToken, gc定義
- E-13: `staging/src/k8s.io/kubelet/pkg/cri/streaming/errors.go` - NewErrorTooManyInFlight, WriteError定義
- E-14: `staging/src/k8s.io/kubelet/pkg/cri/streaming/server.go` - NewServer, validateExecRequest, validateAttachRequest, GetExec, GetAttach, GetPortForward, buildURL, Start, criAdapter定義
- E-15: `staging/src/k8s.io/kubelet/pkg/cri/streaming/remotecommand/httpstream.go` - NewOptions, v1WriteStatusFunc, v4WriteStatusFunc, protocolHandler, waitForStreams定義
- E-16: `staging/src/k8s.io/kubelet/pkg/cri/streaming/remotecommand/websocket.go` - createChannels, readChannel, writeChannel, createWebSocketStreams定義
- E-17: `staging/src/k8s.io/kubelet/pkg/cri/streaming/portforward/websocket.go` - NewV4Options, BuildV4Options, handleWebSocketStreams定義
- E-18: `staging/src/k8s.io/kubelet/pkg/cri/streaming/portforward/httpstream.go` - httpStreamPair, httpStreamHandler, add, getStreamPair, hasStreamPair, removeStreamPair, printError, newPortForwardPair, requestID, httpStreamReceived定義
- E-19: `staging/src/k8s.io/kubelet/pkg/types/labels.go` - GetContainerName, GetPodName, GetPodUID, GetPodNamespace定義
- E-20: `staging/src/k8s.io/kubelet/pkg/apis/dra/v1beta1/conversion.go` - V1ServerWrapper, V1Beta1ServerWrapper, V1ClientWrapper, V1Beta1ClientWrapper定義
- E-21: `staging/src/k8s.io/kubelet/pkg/cri/streaming/portforward/constants.go` - ProtocolV1Name, SupportedProtocols定義
- E-22: `staging/src/k8s.io/kubelet/pkg/apis/dra/v1beta1/conversion_internal.go` - DRA v1beta1/v1間の変換関数定義
- E-23: `staging/src/k8s.io/kubelet/pkg/cri/streaming/remotecommand/exec.go` - ServeExec, Executor interface定義
- E-24: `staging/src/k8s.io/kubelet/pkg/cri/streaming/remotecommand/attach.go` - ServeAttach, Attacher interface定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | KubeletLabelsがソート済みスライスを返す | E-01 | ○ |
| C-002 | KubeletLabelNamespacesがソート済みスライスを返す | E-01 | ○ |
| C-003 | IsKubeletLabelが既知ラベルでtrueを返す | E-01 | ○ |
| C-004 | IsKubeletLabelがnamespace suffixマッチでtrueを返す | E-01 | ○ |
| C-005 | IsKubeletLabelがサブドメイン付きnamespaceでtrueを返す | E-01 | ○ |
| C-006 | IsKubeletLabelが不許可ラベルでfalseを返す | E-01 | ○ |
| C-007 | IsKubeletLabelが未登録キーでfalseを返す | E-01 | ○ |
| C-008 | IsKubeletLabelが空文字列でfalseを返す | E-01 | ○ |
| C-009 | getLabelNamespaceがスラッシュ付きキーから名前空間を抽出する | E-01 | ○ |
| C-010 | getLabelNamespaceがスラッシュなしキーで空文字列を返す | E-01 | ○ |
| C-011 | getLabelNamespaceが複数スラッシュで最初のスラッシュまでを返す | E-01 | ○ |
| C-012 | config/v1 addKnownTypesがCredentialProviderConfigを登録する | E-02 | ○ |
| C-013 | config/v1 AddToSchemeでスキームにグループが追加される | E-02 | ○ |
| C-014 | config/v1alpha1 addKnownTypesが3型を登録する | E-03 | ○ |
| C-015 | config/v1beta1 addKnownTypesが5型を登録する | E-04 | ○ |
| C-016 | credentialprovider内部版addKnownTypesが2型を登録する | E-05 | ○ |
| C-017 | credentialprovider/v1 addKnownTypesが2型を登録しmetav1を追加する | E-06 | ○ |
| C-018 | credentialprovider/v1alpha1 addKnownTypesが2型を登録する | E-07 | ○ |
| C-019 | credentialprovider/v1beta1 addKnownTypesが2型を登録する | E-08 | ○ |
| C-020 | Install関数が全バージョンを登録する | E-09 | ○ |
| C-021 | バージョン優先度がv1最優先で設定される | E-09 | △ |
| C-022 | v1alpha1変換でserviceAccountToken/Annotationsが省略される | E-10 | ○ |
| C-023 | v1beta1変換でserviceAccountToken/Annotationsが省略される | E-11 | ○ |
| C-024 | newRequestCacheが正しく初期化される | E-12 | ○ |
| C-025 | requestCache.Insertがトークンを返す | E-12 | ○ |
| C-026 | requestCache.Insertが一意のトークンを生成する | E-12 | ○ |
| C-027 | requestCache.Insertがキャッシュ満杯時にエラーを返す | E-12, E-13 | ○ |
| C-028 | requestCache.InsertがGC後に挿入成功する | E-12 | ○ |
| C-029 | requestCache.Consumeが有効トークンでリクエストを返す | E-12 | ○ |
| C-030 | requestCache.Consumeが無効トークンでfalseを返す | E-12 | ○ |
| C-031 | requestCache.Consumeが期限切れトークンでfalseを返す | E-12 | ○ |
| C-032 | requestCache.Consumeがシングルユースである | E-12 | ○ |
| C-033 | uniqueTokenが一意なトークンを生成する | E-12 | ○ |
| C-034 | gcが期限切れエントリを削除する | E-12 | ○ |
| C-035 | gcが空キャッシュで安全に動作する | E-12 | ○ |
| C-036 | gcが有効エントリを保持する | E-12 | ○ |
| C-037 | NewErrorTooManyInFlightがResourceExhaustedエラーを返す | E-13 | ○ |
| C-038 | WriteErrorがNotFoundで404を返す | E-13 | ○ |
| C-039 | WriteErrorがResourceExhaustedで429+Retry-Afterを返す | E-13 | ○ |
| C-040 | WriteErrorがその他で500を返す | E-13 | ○ |
| C-041 | WriteErrorのRetry-Afterが60秒である | E-13 | ○ |
| C-042 | NewServerがServerインターフェースを返す | E-14 | ○ |
| C-043 | NewServerがBaseURL=nilでhttpスキームを設定する | E-14 | ○ |
| C-044 | NewServerがTLS時にhttpsスキームを設定する | E-14 | ○ |
| C-045 | NewServerが明示的BaseURLをそのまま使用する | E-14 | ○ |
| C-046 | validateExecRequestが有効リクエストでnilを返す | E-14 | ○ |
| C-047 | validateExecRequestがContainerId空でエラーを返す | E-14 | ○ |
| C-048 | validateExecRequestがTTY+Stderrでエラーを返す | E-14 | ○ |
| C-049 | validateExecRequestが全ストリームfalseでエラーを返す | E-14 | ○ |
| C-050 | validateExecRequestがTTY+Stdoutで成功する | E-14 | ○ |
| C-051 | validateAttachRequestが有効リクエストでnilを返す | E-14 | ○ |
| C-052 | validateAttachRequestがContainerId空でエラーを返す | E-14 | ○ |
| C-053 | validateAttachRequestがTTY+Stderrでエラーを返す | E-14 | ○ |
| C-054 | validateAttachRequestが全ストリームfalseでエラーを返す | E-14 | ○ |
| C-055 | GetExecがURL付きレスポンスを返す | E-14 | ○ |
| C-056 | GetExecが無効リクエストでエラーを返す | E-14 | ○ |
| C-057 | GetAttachがURL付きレスポンスを返す | E-14 | ○ |
| C-058 | GetAttachが無効リクエストでエラーを返す | E-14 | ○ |
| C-059 | GetPortForwardがURL付きレスポンスを返す | E-14 | ○ |
| C-060 | GetPortForwardがPodSandboxId空でエラーを返す | E-14 | ○ |
| C-061 | buildURLがmethod+tokenからURLを構築する | E-14 | ○ |
| C-062 | Start(stayUp=false)が未実装エラーを返す | E-14 | △ |
| C-063 | criAdapter.ExecInContainerがRuntime.Execにデリゲートする | E-14 | ○ |
| C-064 | criAdapter.AttachContainerがRuntime.Attachにデリゲートする | E-14 | ○ |
| C-065 | criAdapter.PortForwardがRuntime.PortForwardにデリゲートする | E-14 | ○ |
| C-066 | NewOptionsが有効リクエストからOptionsを生成する | E-15 | ○ |
| C-067 | NewOptionsがTTY時にstderrをfalseにする | E-15 | ○ |
| C-068 | NewOptionsが全ストリーム未指定でエラーを返す | E-15 | ○ |
| C-069 | v1WriteStatusFuncが成功時にnilを返す | E-15 | ○ |
| C-070 | v1WriteStatusFuncが失敗時にエラーメッセージを書き込む | E-15 | ○ |
| C-071 | v4WriteStatusFuncがJSON形式で書き込む | E-15 | ○ |
| C-072 | v4WriteStatusFuncが失敗ステータスをJSON形式で書き込む | E-15 | ○ |
| C-073 | v4ProtocolHandlerがリサイズをサポートする | E-15 | ○ |
| C-074 | v3ProtocolHandlerがリサイズをサポートする | E-15 | ○ |
| C-075 | v2ProtocolHandlerがリサイズをサポートしない | E-15 | ○ |
| C-076 | v1ProtocolHandlerがリサイズをサポートしない | E-15 | ○ |
| C-077 | createChannelsが全オプションtrueで適切なチャネルを設定する | E-16 | ○ |
| C-078 | createChannelsがStdinのみで適切なチャネルを設定する | E-16 | ○ |
| C-079 | readChannelがtrueでReadChannelを返す | E-16 | ○ |
| C-080 | readChannelがfalseでIgnoreChannelを返す | E-16 | ○ |
| C-081 | writeChannelがtrueでWriteChannelを返す | E-16 | ○ |
| C-082 | writeChannelがfalseでIgnoreChannelを返す | E-16 | ○ |
| C-083 | NewV4OptionsがWebSocketリクエストからポートをパースする | E-17 | ○ |
| C-084 | NewV4Optionsがカンマ区切りポートをパースする | E-17 | ○ |
| C-085 | NewV4Optionsが複数portクエリパラメータを処理する | E-17 | ○ |
| C-086 | NewV4Optionsが非WebSocketで空V4Optionsを返す | E-17 | ○ |
| C-087 | NewV4Optionsがportパラメータ未指定でエラーを返す | E-17 | ○ |
| C-088 | NewV4Optionsが空portでエラーを返す | E-17 | ○ |
| C-089 | NewV4Optionsが不正ポートでエラーを返す | E-17 | ○ |
| C-090 | NewV4Optionsがポート0でエラーを返す | E-17 | ○ |
| C-091 | NewV4Optionsがポート65535で成功する | E-17 | ○ |
| C-092 | BuildV4OptionsがポートスライスからV4Optionsを生成する | E-17 | ○ |
| C-093 | httpStreamPair.addがerrorストリームを追加する | E-18 | ○ |
| C-094 | httpStreamPair.addがdataストリームを追加する | E-18 | ○ |
| C-095 | httpStreamPair.addが両ストリームでcomplete=trueを返す | E-18 | ○ |
| C-096 | httpStreamPair.addが重複errorストリームでエラーを返す | E-18 | ○ |
| C-097 | httpStreamPair.addが重複dataストリームでエラーを返す | E-18 | ○ |
| C-098 | httpStreamPair.printErrorがerrorStreamにメッセージを書き込む | E-18 | ○ |
| C-099 | httpStreamPair.printErrorがnilストリームで安全に動作する | E-18 | ○ |
| C-100 | newPortForwardPairがrequestID付きペアを生成する | E-18 | ○ |
| C-101 | getStreamPairが新規IDでペアを作成する | E-18 | ○ |
| C-102 | getStreamPairが既存IDで既存ペアを返す | E-18 | ○ |
| C-103 | hasStreamPairが存在するIDでtrueを返す | E-18 | ○ |
| C-104 | hasStreamPairが不在IDでfalseを返す | E-18 | ○ |
| C-105 | removeStreamPairが指定IDのペアを削除する | E-18 | ○ |
| C-106 | requestIDがPortForwardRequestIDHeaderから取得する | E-18 | ○ |
| C-107 | requestIDがヘッダなしdataストリームでID-2を返す | E-18 | ○ |
| C-108 | requestIDがヘッダなしerrorストリームでIDをそのまま返す | E-18 | ○ |
| C-109 | httpStreamReceivedが有効なストリームを受理する | E-18 | ○ |
| C-110 | httpStreamReceivedがportヘッダ空でエラーを返す | E-18 | ○ |
| C-111 | httpStreamReceivedが不正portヘッダでエラーを返す | E-18 | ○ |
| C-112 | httpStreamReceivedがport=0でエラーを返す | E-18 | ○ |
| C-113 | httpStreamReceivedがstreamTypeヘッダ空でエラーを返す | E-18 | ○ |
| C-114 | httpStreamReceivedが不正streamTypeでエラーを返す | E-18 | ○ |
| C-115 | GetContainerNameがラベルからコンテナ名を取得する | E-19 | ○ |
| C-116 | GetContainerNameがラベル未設定時に空文字列を返す | E-19 | ○ |
| C-117 | GetContainerNameがnilマップで安全に空文字列を返す | **根拠なし** | △ |
| C-118 | GetPodNameがラベルからPod名を取得する | E-19 | ○ |
| C-119 | GetPodNameがラベル未設定時に空文字列を返す | E-19 | ○ |
| C-120 | GetPodUIDがラベルからUIDを取得する | E-19 | ○ |
| C-121 | GetPodUIDがラベル未設定時に空文字列を返す | E-19 | ○ |
| C-122 | GetPodNamespaceがラベルからnamespaceを取得する | E-19 | ○ |
| C-123 | GetPodNamespaceがラベル未設定時に空文字列を返す | E-19 | ○ |
| C-124 | V1ServerWrapper.NodePrepareResourcesがv1beta1→v1変換してデリゲートする | E-20 | ○ |
| C-125 | V1ServerWrapper.NodePrepareResourcesが内部エラーを伝播する | E-20 | ○ |
| C-126 | V1ServerWrapper.NodeUnprepareResourcesがv1beta1→v1変換してデリゲートする | E-20 | ○ |
| C-127 | V1Beta1ServerWrapper.NodePrepareResourcesがv1→v1beta1変換してデリゲートする | E-20 | ○ |
| C-128 | V1Beta1ServerWrapper.NodeUnprepareResourcesがv1→v1beta1変換してデリゲートする | E-20 | ○ |
| C-129 | V1ClientWrapper.NodePrepareResourcesがv1beta1→v1変換してデリゲートする | E-20 | ○ |
| C-130 | V1ClientWrapper.NodeUnprepareResourcesがv1beta1→v1変換してデリゲートする | E-20 | ○ |
| C-131 | V1Beta1ClientWrapper.NodePrepareResourcesがv1→v1beta1変換してデリゲートする | E-20 | ○ |
| C-132 | V1Beta1ClientWrapper.NodeUnprepareResourcesがv1→v1beta1変換してデリゲートする | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-117: Goの仕様上、nilマップに対するread操作はpanicしないが、明示的なテストによる確認が望ましい
  - 候補：Go言語仕様書 / Goランタイム動作確認
- C-021: Install関数内のSetVersionPriority呼び出し順序からv1が最優先と推定しているが、Kubernetes内部のScheme.SetVersionPriority実装の詳細な動作確認が必要
  - 候補：k8s.io/apimachinery/pkg/runtime/scheme.go
- C-062: Start(stayUp=false)はTODOコメントとerrors.Newで実装されているが、将来変更される可能性がある
  - 候補：将来のKubernetesリリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 自動生成コード（zz_generated.*.go, *.pb.go）はテスト対象外として妥当
- 0: 低リスク - protobuf生成ファイルのgRPCサービス実装はテスト対象外として妥当
- 1: 中リスク - DRA v1beta1 conversion.goのWrapper型テスト（C-124〜C-132）はモック依存度が高く、実装の変更に敏感
- 0: 低リスク - httpStreamReceived関数（C-109〜C-114）はポートフォワードの入口部分でヘッダ検証ロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] IsKubeletLabel関連テストケース（C-003〜C-008）が全条件分岐をカバーしているか確認
- [ ] requestCacheのテストケース（C-024〜C-036）がスレッドセーフな動作を十分に検証しているか確認
- [ ] validateExecRequest/validateAttachRequestのテストケース（C-046〜C-054）がすべてのgRPCエラーコードを網羅しているか確認
- [ ] DRA Wrapper型のテストケース（C-124〜C-132）が変換エラー時の動作を十分にカバーしているか確認
- [ ] ポートフォワードのNewV4Optionsテストケース（C-083〜C-091）が境界値を十分に網羅しているか確認
- [ ] httpStreamReceivedのテストケース（C-109〜C-114）がポートフォワードストリーム受理の全パスをカバーしているか確認
