---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 157
  claims_with_evidence: 152
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：staging-mount-utils 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：152 / 157、根拠なし：5
- 優先レビュー（高）
  1. **C-091 checkUmountError errNoChildProcesses処理**：ProcessStateのモック検証が必要
  2. **C-080 PathExists 破損マウント検出**：syscall.Access呼び出しの挙動はOS依存
  3. **C-083 hasSystemd detectSystemd連携**：detectSystemdの実際の呼び出しは環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/mount-utils/mount.go` - Interface定義、MountError、SafeFormatAndMount、ユーティリティ関数
- E-02: `staging/src/k8s.io/mount-utils/mount_helper_common.go` - CleanupMountPoint、doCleanupMountPoint、removePathIfNotMountPoint、removePath
- E-03: `staging/src/k8s.io/mount-utils/mount_helper_unix.go` - IsCorruptedMnt(Unix)、ParseMountInfo、splitMountOptions、isMountPointMatch、PathExists(Unix)
- E-04: `staging/src/k8s.io/mount-utils/mount_helper_windows.go` - IsCorruptedMnt(Windows)、NormalizeWindowsPath、ValidateDiskNumber、PathExists(Windows)
- E-05: `staging/src/k8s.io/mount-utils/mount_linux.go` - Mounter(Linux)、MakeMountArgs系、AddSystemdScope系、checkUmountError、parseProcMounts、SearchMountPoints、getDiskFormat、formatAndMountSensitive、checkAndRepairFilesystem
- E-06: `staging/src/k8s.io/mount-utils/mount_windows.go` - Mounter(Windows)、SMBマウント関連
- E-07: `staging/src/k8s.io/mount-utils/mount_unsupported.go` - Mounter(unsupported)
- E-08: `staging/src/k8s.io/mount-utils/resizefs_linux.go` - ResizeFs、Resize、NeedResize、getDeviceSize、getDeviceRO、parseBtrfsInfoOutput
- E-09: `staging/src/k8s.io/mount-utils/resizefs_unsupported.go` - ResizeFs(unsupported)
- E-10: `staging/src/k8s.io/mount-utils/fake_mounter.go` - FakeMounter実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | MountError.String()がMessageを返す | E-01 (L128-130) | ○ |
| C-002 | MountError.Error()がMessageを返す | E-01 (L132-134) | ○ |
| C-003 | NewMountErrorがfmt.Sprintfでメッセージ生成 | E-01 (L136-142) | ○ |
| C-004 | NewMountError引数なしフォーマット | E-01 (L136-142) | ○ |
| C-005 | NewSafeFormatAndMount初期化 | E-01 (L155-164) | ○ |
| C-006 | WithMaxConcurrentFormatオプション適用 | E-01 (L174-181) | ○ |
| C-007 | WithMaxConcurrentFormat n>0でsem設定 | E-01 (L174-181) | ○ |
| C-008 | WithMaxConcurrentFormat n=0で無制限 | E-01 (L177: if n > 0) | ○ |
| C-009 | WithMaxConcurrentFormat n<0で無制限 | E-01 (L177: if n > 0) | ○ |
| C-010 | FormatAndMountがFormatAndMountSensitiveに委譲 | E-01 (L189-191) | ○ |
| C-011 | FormatAndMountSensitiveがWithFormatOptionsに委譲 | E-01 (L198-199) | ○ |
| C-012 | getMountRefsByDevがデバイス参照返却 | E-01 (L213-238) | ○ |
| C-013 | getMountRefsByDev Listエラー処理 | E-01 (L215-216) | ○ |
| C-014 | getMountRefsByDev空マウントリスト | E-01 (L220-237) | ○ |
| C-015 | IsNotMountPointマウントポイント判定 | E-01 (L250-256) | ○ |
| C-016 | IsNotMountPoint非マウントポイント | E-01 (L250-256) | ○ |
| C-017 | IsNotMountPointエラー時 | E-01 (L252-253) | ○ |
| C-018 | GetDeviceNameFromMount正常系 | E-01 (L260-289) | ○ |
| C-019 | GetDeviceNameFromMount Listエラー | E-01 (L262-264) | ○ |
| C-020 | GetDeviceNameFromMountパス未発見 | E-01 (L268-278) | ○ |
| C-021 | MakeBindOpts bindオプション検出 | E-01 (L296-299) | ○ |
| C-022 | MakeBindOpts bindなし | E-01 (L296-299) | ○ |
| C-023 | MakeBindOptsSensitive機密bind処理 | E-01 (L306-345) | ○ |
| C-024 | MakeBindOptsSensitive _netdev引き継ぎ | E-01 (L319-322) | ○ |
| C-025 | MakeBindOptsSensitive remount重複排除 | E-01 (L328-329) | ○ |
| C-026 | MakeBindOptsSensitive空オプション | E-01 (L306-345) | ○ |
| C-027 | checkForNetDev options内検出 | E-01 (L347-359) | ○ |
| C-028 | checkForNetDev sensitiveOptions内検出 | E-01 (L347-359) | ○ |
| C-029 | checkForNetDev未検出 | E-01 (L347-359) | ○ |
| C-030 | PathWithinBaseパス内判定 | E-01 (L362-372) | ○ |
| C-031 | PathWithinBaseパス外判定 | E-01 (L362-372) | ○ |
| C-032 | PathWithinBaseパストラバーサル防止 | E-01 (L367-369) | ○ |
| C-033 | PathWithinBase同一パス | E-01 (L363-365) | ○ |
| C-034 | StartsWithBackstep ../ 検出 | E-01 (L375-378) | ○ |
| C-035 | StartsWithBackstep .. 検出 | E-01 (L377) | ○ |
| C-036 | StartsWithBackstep通常パス | E-01 (L375-378) | ○ |
| C-037 | sanitizedOptionsForLogging通常 | E-01 (L384-401) | ○ |
| C-038 | sanitizedOptionsForLoggingマスク | E-01 (L384-401) | ○ |
| C-039 | sanitizedOptionsForLogging空 | E-01 (L384-401) | ○ |
| C-040 | sanitizedOptionsForLogging機密のみ | E-01 (L384-401) | ○ |
| C-041 | CleanupMountPointパス不在 | E-02 (L31-42) | ○ |
| C-042 | CleanupMountPoint正常クリーンアップ | E-02 (L31-42) | ○ |
| C-043 | CleanupMountPoint破損マウント | E-02 (L37-41) | ○ |
| C-044 | CleanupMountPoint予期しないエラー | E-02 (L38-39) | ○ |
| C-045 | CleanupMountWithForceパス不在 | E-02 (L44-82) | ○ |
| C-046 | CleanupMountWithForce破損マウント | E-02 (L55-62) | ○ |
| C-047 | doCleanupMountPoint破損マウント | E-02 (L91-99) | ○ |
| C-048 | doCleanupMountPoint非マウントポイント | E-02 (L101-105) | ○ |
| C-049 | doCleanupMountPointアンマウント失敗 | E-02 (L112-118) | ○ |
| C-050 | removePathIfNotMountPoint正常削除 | E-02 (L123-146) | ○ |
| C-051 | removePathIfNotMountPointパス不在 | E-02 (L133-137) | ○ |
| C-052 | removePathIfNotMountPoint詳細チェック | E-02 (L127-131) | ○ |
| C-053 | removePath正常削除 | E-02 (L149-157) | ○ |
| C-054 | removePathパス不在 | E-02 (L152-155) | ○ |
| C-055 | IsCorruptedMnt nil判定 | E-03 (L45-47) | ○ |
| C-056 | IsCorruptedMnt ENOTCONN | E-03 (L63) | ○ |
| C-057 | IsCorruptedMnt ESTALE | E-03 (L64) | ○ |
| C-058 | IsCorruptedMnt EIO | E-03 (L65) | ○ |
| C-059 | IsCorruptedMnt EACCES | E-03 (L66) | ○ |
| C-060 | IsCorruptedMnt EHOSTDOWN | E-03 (L67) | ○ |
| C-061 | IsCorruptedMnt ENODEV | E-03 (L69) | ○ |
| C-062 | IsCorruptedMnt LinkError | E-03 (L55-56) | ○ |
| C-063 | IsCorruptedMnt SyscallError | E-03 (L57-58) | ○ |
| C-064 | IsCorruptedMnt Errno直接 | E-03 (L59-60) | ○ |
| C-065 | IsCorruptedMnt非破損エラー | E-03 (L45-70) | ○ |
| C-066 | ParseMountInfo正常パース | E-03 (L101-165) | ○ |
| C-067 | ParseMountInfoフィールド不足 | E-03 (L116-117) | ○ |
| C-068 | ParseMountInfo非数値ID | E-03 (L119-121) | ○ |
| C-069 | ParseMountInfo不正major:minor | E-03 (L128-129) | ○ |
| C-070 | ParseMountInfo空ファイル | E-03 (L107-109) | ○ |
| C-071 | ParseMountInfoファイル不在 | E-03 (L102-104) | ○ |
| C-072 | splitMountOptionsカンマ分割 | E-03 (L169-179) | ○ |
| C-073 | splitMountOptionsクォート内カンマ | E-03 (L170-178) | ○ |
| C-074 | splitMountOptions空文字列 | E-03 (L169-179) | ○ |
| C-075 | isMountPointMatch完全一致 | E-03 (L183-185) | ○ |
| C-076 | isMountPointMatch NFSステイル | E-03 (L184) | ○ |
| C-077 | isMountPointMatch不一致 | E-03 (L183-185) | ○ |
| C-078 | PathExists存在確認 | E-03 (L189-208) | ○ |
| C-079 | PathExists不在確認 | E-03 (L193-203) | ○ |
| C-080 | PathExists破損マウント | E-03 (L194-201) | △ |
| C-081 | New Linux Mounter初期化 | E-05 (L78-84) | ○ |
| C-082 | NewWithoutSystemd初期化 | E-05 (L90-96) | ○ |
| C-083 | hasSystemd trySystemd=false | E-05 (L100-111) | △ |
| C-084 | MakeMountArgs正常生成 | E-05 (L334-337) | ○ |
| C-085 | MakeMountArgs空fstype | E-05 (L358-361) | ○ |
| C-086 | MakeMountArgs空source | E-05 (L370-373) | ○ |
| C-087 | MakeMountArgsSensitive機密分離 | E-05 (L341-343, L367-368) | ○ |
| C-088 | MakeMountArgsSensitiveWithMountFlags | E-05 (L349-378) | ○ |
| C-089 | AddSystemdScope構築 | E-05 (L383-387) | ○ |
| C-090 | AddSystemdScopeSensitive構築 | E-05 (L392-396) | ○ |
| C-091 | checkUmountError errNoChildProcesses成功 | E-05 (L909-914) | △ |
| C-092 | checkUmountError safe not mounted | E-05 (L918-921) | ○ |
| C-093 | checkUmountError通常エラー | E-05 (L922) | ○ |
| C-094 | ListProcMounts正常パース | E-05 (L725-731) | ○ |
| C-095 | parseProcMounts正常パース | E-05 (L733-769) | ○ |
| C-096 | parseProcMounts不正フィールド | E-05 (L742-744) | ○ |
| C-097 | parseProcMounts非数値freq | E-05 (L754-757) | ○ |
| C-098 | parseProcMounts空入力 | E-05 (L733-769) | ○ |
| C-099 | SearchMountPoints正常検索 | E-05 (L778-819) | ○ |
| C-100 | SearchMountPointsパス未検出 | E-05 (L803-805) | ○ |
| C-101 | getDiskFormat ext4取得 | E-05 (L667-717) | ○ |
| C-102 | getDiskFormat未フォーマット | E-05 (L675-683) | ○ |
| C-103 | getDiskFormatパーティション検出 | E-05 (L709-714) | ○ |
| C-104 | getDiskFormatエラー | E-05 (L674-686) | ○ |
| C-105 | formatAndMountSensitive未フォーマットFM | E-05 (L553-642) | ○ |
| C-106 | formatAndMountSensitiveフォーマット済み | E-05 (L619-633) | ○ |
| C-107 | formatAndMountSensitive RO未フォーマット | E-05 (L587-589) | ○ |
| C-108 | formatAndMountSensitive FS不一致 | E-05 (L620-623) | ○ |
| C-109 | formatAndMountSensitiveデフォルトfstype | E-05 (L581-583) | ○ |
| C-110 | checkAndRepairFilesystem正常 | E-05 (L530-550) | ○ |
| C-111 | checkAndRepairFilesystem修正済み | E-05 (L539-540) | ○ |
| C-112 | checkAndRepairFilesystem未修正エラー | E-05 (L541-542) | ○ |
| C-113 | checkAndRepairFilesystem fsck不在 | E-05 (L537-538) | ○ |
| C-114 | NewResizeFs初期化 | E-08 (L40-42) | ○ |
| C-115 | Resize ext4 | E-08 (L60-61, L70-79) | ○ |
| C-116 | Resize xfs | E-08 (L62-63, L81-92) | ○ |
| C-117 | Resize btrfs | E-08 (L64-65, L94-105) | ○ |
| C-118 | Resize未フォーマット | E-08 (L53-56) | ○ |
| C-119 | Resize非サポートFS | E-08 (L67) | ○ |
| C-120 | ResizeフォーマットエラーGetDiskFormat | E-08 (L46-50) | ○ |
| C-121 | NeedResize ext4 | E-08 (L132-135) | ○ |
| C-122 | NeedResize RO | E-08 (L109-117) | ○ |
| C-123 | NeedResize未フォーマット | E-08 (L127-129) | ○ |
| C-124 | NeedResize btrfsリサイズ不要 | E-08 (L137-148) | ○ |
| C-125 | NeedResize btrfsリサイズ必要 | E-08 (L146-149) | ○ |
| C-126 | NeedResize非サポートFS | E-08 (L151) | ○ |
| C-127 | getDeviceSize正常 | E-08 (L155-166) | ○ |
| C-128 | getDeviceSizeエラー | E-08 (L158-159) | ○ |
| C-129 | getDeviceRO RW | E-08 (L220-221) | ○ |
| C-130 | getDeviceRO RO | E-08 (L222-223) | ○ |
| C-131 | getDeviceROエラー | E-08 (L217-218) | ○ |
| C-132 | getDeviceRO不正出力 | E-08 (L224-225) | ○ |
| C-133 | parseBtrfsInfoOutput正常 | E-08 (L185-211) | ○ |
| C-134 | parseBtrfsInfoOutputキー未検出 | E-08 (L185-211) | ○ |
| C-135 | parseBtrfsInfoOutput非数値 | E-08 (L198-200) | ○ |
| C-136 | NewFakeMounter初期化 | E-10 (L62-66) | ○ |
| C-137 | FakeMounter Mount記録 | E-10 (L90-92) | ○ |
| C-138 | FakeMounter bindマウント解決 | E-10 (L106-125) | ○ |
| C-139 | FakeMounter Unmount削除 | E-10 (L150-179) | ○ |
| C-140 | FakeMounter UnmountFunc呼び出し | E-10 (L163-168) | ○ |
| C-141 | FakeMounter List返却 | E-10 (L182-187) | ○ |
| C-142 | FakeMounter IsLikelyNotMountPoint | E-10 (L191-219) | ○ |
| C-143 | FakeMounter MountCheckErrors | E-10 (L195-198) | ○ |
| C-144 | FakeMounter GetMountRefs | E-10 (L235-242) | ○ |
| C-145 | FakeMounter ResetLog | E-10 (L74-79) | ○ |
| C-146 | FakeMounter GetLog | E-10 (L82-87) | ○ |
| C-147 | FakeMounter WithSkipMountPointCheck | E-10 (L68-71) | ○ |
| C-148 | IsCorruptedMnt Windows nil | E-04 (L45-48) | ○ |
| C-149 | IsCorruptedMnt Windowsエラーコード | E-04 (L42, L62-69) | ○ |
| C-150 | IsCorruptedMnt Windows非破損 | E-04 (L45-72) | ○ |
| C-151 | NormalizeWindowsPathスラッシュ変換 | E-04 (L77-83) | ○ |
| C-152 | NormalizeWindowsPath既正規化 | E-04 (L77-83) | ○ |
| C-153 | NormalizeWindowsPathドライブレター | E-04 (L79-81) | ○ |
| C-154 | ValidateDiskNumber正常 | E-04 (L86-91) | ○ |
| C-155 | ValidateDiskNumber 2桁 | E-04 (L86-91) | ○ |
| C-156 | ValidateDiskNumber非数値 | E-04 (L87-89) | ○ |
| C-157 | ValidateDiskNumber空文字列 | E-04 (L87-89) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-080: PathExists(Unix)のステイルファイルハンドル検出（syscall.Access呼び出し）はOS依存のため、テスト環境での再現が難しい
  - 候補：統合テスト / OSモック / テスト用ファイルシステム
- C-083: hasSystemdメソッドのdetectSystemd連携は実行時にsystemd-runの存在チェックを行うため、テスト環境に依存
  - 候補：FakeExecによるモック / 環境変数での制御
- C-091: checkUmountErrorのerrNoChildProcesses処理はProcessStateのモックが必要
  - 候補：exec.Cmdのモック / テスト用プロセス
- C-073: splitMountOptionsのダブルクォート内カンマ処理の正確な挙動（エッジケース多数）
  - 候補：既存テストコードの確認
- C-076: isMountPointMatchの\\040(deleted)サフィックス処理の実際の挙動確認
  - 候補：NFS環境での検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - mount.go内のユーティリティ関数（PathWithinBase, StartsWithBackstep, sanitizedOptionsForLogging等）は純粋関数でテスト容易
- 0: 低リスク - fake_mounter.goのテストケースはインメモリ操作のみ
- 1: 中リスク - mount_linux.goのOS依存関数（doMount, detectSystemd, detectSafeNotMountedBehavior）はモックが必要
- 1: 中リスク - resizefs_linux.goの外部コマンド呼び出し（resize2fs, xfs_growfs, btrfs, blockdev）はFakeExecでテスト可能だが網羅性の確認が必要
- 1: 中リスク - mount_helper_unix.goのParseMountInfoはファイルI/Oに依存するため、テスト用ファイルの準備が必要
- 2: 高リスク - formatAndMountSensitiveは複数の外部コマンド呼び出しと条件分岐が複雑で、テストの網羅性確保が重要

## 6) レビュアーチェックリスト（最小）
- [ ] テストIDの連番(UT-MUT-001~157)が正しく付番されているか
- [ ] 全ソースファイル(mount.go, mount_helper_common.go, mount_helper_unix.go, mount_helper_windows.go, mount_linux.go, mount_windows.go, resizefs_linux.go, fake_mounter.go)が網羅されているか
- [ ] 正常系・異常系・境界値の観点が各関数に対して適切に設定されているか
- [ ] 高優先度テストケース（セキュリティ関連: PathWithinBase, sanitizedOptionsForLogging, IsCorruptedMnt）が網羅されているか
- [ ] OS依存関数（Linux/Windows/Unsupported）のテストケースがプラットフォームごとに分離されているか
- [ ] 外部コマンド依存（fsck, blkid, mkfs, resize2fs, xfs_growfs, btrfs, blockdev, umount）の正常系・異常系がカバーされているか
